

package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Location;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ExtendElement extends ExtendElement {

  private final Location location;

  private final String name;

  private final String documentation;

  private final ImmutableList<FieldElement> fields;

  private AutoValue_ExtendElement(
      Location location,
      String name,
      String documentation,
      ImmutableList<FieldElement> fields) {
    this.location = location;
    this.name = name;
    this.documentation = documentation;
    this.fields = fields;
  }

  @Override
  public Location location() {
    return location;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public String documentation() {
    return documentation;
  }

  @Override
  public ImmutableList<FieldElement> fields() {
    return fields;
  }

  @Override
  public String toString() {
    return "ExtendElement{"
         + "location=" + location + ", "
         + "name=" + name + ", "
         + "documentation=" + documentation + ", "
         + "fields=" + fields
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ExtendElement) {
      ExtendElement that = (ExtendElement) o;
      return (this.location.equals(that.location()))
           && (this.name.equals(that.name()))
           && (this.documentation.equals(that.documentation()))
           && (this.fields.equals(that.fields()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= location.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= documentation.hashCode();
    h$ *= 1000003;
    h$ ^= fields.hashCode();
    return h$;
  }

  static final class Builder implements ExtendElement.Builder {
    private Location location;
    private String name;
    private String documentation;
    private ImmutableList<FieldElement> fields;
    Builder() {
    }
    @Override
    public ExtendElement.Builder location(Location location) {
      if (location == null) {
        throw new NullPointerException("Null location");
      }
      this.location = location;
      return this;
    }
    @Override
    public ExtendElement.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public ExtendElement.Builder documentation(String documentation) {
      if (documentation == null) {
        throw new NullPointerException("Null documentation");
      }
      this.documentation = documentation;
      return this;
    }
    @Override
    public ExtendElement.Builder fields(ImmutableList<FieldElement> fields) {
      if (fields == null) {
        throw new NullPointerException("Null fields");
      }
      this.fields = fields;
      return this;
    }
    @Override
    public ExtendElement build() {
      String missing = "";
      if (this.location == null) {
        missing += " location";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.documentation == null) {
        missing += " documentation";
      }
      if (this.fields == null) {
        missing += " fields";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ExtendElement(
          this.location,
          this.name,
          this.documentation,
          this.fields);
    }
  }

}
