/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.squareup.wire.schema.Location;

public final class SyntaxReader {
    private final Location location;
    private final char[] data;
    private int pos;
    private int line;
    private int lineStart;

    public SyntaxReader(char[] data, Location location) {
        this.data = data;
        this.location = location;
    }

    public boolean exhausted() {
        return this.pos == this.data.length;
    }

    public char readChar() {
        char result = this.peekChar();
        ++this.pos;
        return result;
    }

    public void require(char c) {
        if (this.readChar() != c) {
            throw this.unexpected("expected '" + c + "'");
        }
    }

    public char peekChar() {
        this.skipWhitespace(true);
        if (this.pos == this.data.length) {
            throw this.unexpected("unexpected end of file");
        }
        return this.data[this.pos];
    }

    public boolean peekChar(char c) {
        if (this.peekChar() == c) {
            ++this.pos;
            return true;
        }
        return false;
    }

    public void pushBack(char c) {
        if (this.data[this.pos - 1] != c) {
            throw new IllegalArgumentException();
        }
        --this.pos;
    }

    public String readString() {
        this.skipWhitespace(true);
        char c = this.peekChar();
        return c == '\"' || c == '\'' ? this.readQuotedString() : this.readWord();
    }

    public String readQuotedString() {
        char startQuote = this.readChar();
        if (startQuote != '\"' && startQuote != '\'') {
            throw new AssertionError();
        }
        StringBuilder result = new StringBuilder();
        while (this.pos < this.data.length) {
            char c;
            if ((c = this.data[this.pos++]) == startQuote) {
                if (this.peekChar() == '\"' || this.peekChar() == '\'') {
                    startQuote = this.readChar();
                    continue;
                }
                return result.toString();
            }
            if (c == '\\') {
                if (this.pos == this.data.length) {
                    throw this.unexpected("unexpected end of file");
                }
                c = this.data[this.pos++];
                switch (c) {
                    case 'a': {
                        c = '\u0007';
                        break;
                    }
                    case 'b': {
                        c = '\b';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'v': {
                        c = '\u000b';
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        c = this.readNumericEscape(16, 2);
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        --this.pos;
                        c = this.readNumericEscape(8, 3);
                        break;
                    }
                }
            }
            result.append(c);
            if (c != '\n') continue;
            this.newline();
        }
        throw this.unexpected("unterminated string");
    }

    private char readNumericEscape(int radix, int len) {
        int digit;
        int value = -1;
        int endPos = Math.min(this.pos + len, this.data.length);
        while (this.pos < endPos && (digit = this.hexDigit(this.data[this.pos])) != -1 && digit < radix) {
            value = value < 0 ? digit : value * radix + digit;
            ++this.pos;
        }
        if (value < 0) {
            throw this.unexpected("expected a digit after \\x or \\X");
        }
        return (char)value;
    }

    private int hexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    public String readName() {
        String optionName;
        char c = this.peekChar();
        if (c == '(') {
            ++this.pos;
            optionName = this.readWord();
            if (this.readChar() != ')') {
                throw this.unexpected("expected ')'");
            }
        } else if (c == '[') {
            ++this.pos;
            optionName = this.readWord();
            if (this.readChar() != ']') {
                throw this.unexpected("expected ']'");
            }
        } else {
            optionName = this.readWord();
        }
        return optionName;
    }

    public String readDataType() {
        String name = this.readWord();
        return this.readDataType(name);
    }

    public String readDataType(String name) {
        if (name.equals("map")) {
            if (this.readChar() != '<') {
                throw this.unexpected("expected '<'");
            }
            String keyType = this.readDataType();
            if (this.readChar() != ',') {
                throw this.unexpected("expected ','");
            }
            String valueType = this.readDataType();
            if (this.readChar() != '>') {
                throw this.unexpected("expected '>'");
            }
            return String.format("map<%s, %s>", keyType, valueType);
        }
        return name;
    }

    public String readWord() {
        char c;
        this.skipWhitespace(true);
        int start = this.pos;
        while (this.pos < this.data.length && ((c = this.data[this.pos]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == '.')) {
            ++this.pos;
        }
        if (start == this.pos) {
            throw this.unexpected("expected a word");
        }
        return new String(this.data, start, this.pos - start);
    }

    public int readInt() {
        String tag = this.readWord();
        try {
            int radix = 10;
            if (tag.startsWith("0x") || tag.startsWith("0X")) {
                tag = tag.substring("0x".length());
                radix = 16;
            }
            return Integer.valueOf(tag, radix);
        }
        catch (Exception e) {
            throw this.unexpected("expected an integer but was " + tag);
        }
    }

    public String readDocumentation() {
        String result = null;
        while (true) {
            this.skipWhitespace(false);
            if (this.pos == this.data.length || this.data[this.pos] != '/') {
                return result != null ? result : "";
            }
            String comment = this.readComment();
            result = result == null ? comment : result + "\n" + comment;
        }
    }

    private String readComment() {
        int commentType;
        if (this.pos == this.data.length || this.data[this.pos] != '/') {
            throw new AssertionError();
        }
        ++this.pos;
        int n = commentType = this.pos < this.data.length ? this.data[this.pos++] : -1;
        if (commentType == 42) {
            StringBuilder result = new StringBuilder();
            boolean startOfLine = true;
            while (this.pos + 1 < this.data.length) {
                char c = this.data[this.pos];
                if (c == '*' && this.data[this.pos + 1] == '/') {
                    this.pos += 2;
                    return result.toString().trim();
                }
                if (c == '\n') {
                    result.append('\n');
                    this.newline();
                    startOfLine = true;
                } else if (!startOfLine) {
                    result.append(c);
                } else if (c == '*') {
                    if (this.data[this.pos + 1] == ' ') {
                        ++this.pos;
                    }
                    startOfLine = false;
                } else if (!Character.isWhitespace(c)) {
                    result.append(c);
                    startOfLine = false;
                }
                ++this.pos;
            }
            throw this.unexpected("unterminated comment");
        }
        if (commentType == 47) {
            if (this.pos < this.data.length && this.data[this.pos] == ' ') {
                ++this.pos;
            }
            int start = this.pos;
            while (this.pos < this.data.length) {
                char c;
                if ((c = this.data[this.pos++]) != '\n') continue;
                this.newline();
                break;
            }
            return new String(this.data, start, this.pos - 1 - start);
        }
        throw this.unexpected("unexpected '/'");
    }

    public String tryAppendTrailingDocumentation(String documentation) {
        int end;
        int start;
        block15: {
            char c;
            while (this.pos < this.data.length) {
                char c2 = this.data[this.pos];
                if (c2 == ' ' || c2 == '\t') {
                    ++this.pos;
                    continue;
                }
                if (c2 == '/') {
                    ++this.pos;
                    break;
                }
                return documentation;
            }
            if (this.pos == this.data.length || this.data[this.pos] != '/' && this.data[this.pos] != '*') {
                --this.pos;
                throw this.unexpected("expected '//' or '/*'");
            }
            boolean isStar = this.data[this.pos] == '*';
            ++this.pos;
            if (this.pos < this.data.length && this.data[this.pos] == ' ') {
                ++this.pos;
            }
            start = this.pos;
            if (isStar) {
                while (true) {
                    if (this.pos == this.data.length || this.data[this.pos] == '\n') {
                        throw this.unexpected("trailing comment must be closed on the same line");
                    }
                    if (this.data[this.pos] == '*' && this.pos + 1 < this.data.length && this.data[this.pos + 1] == '/') {
                        end = this.pos - 1;
                        this.pos += 2;
                        break;
                    }
                    ++this.pos;
                }
                while (this.pos < this.data.length) {
                    if ((c = this.data[this.pos++]) == '\n') {
                        this.newline();
                        break;
                    }
                    if (c == ' ' || c == '\t') continue;
                    throw this.unexpected("no syntax may follow trailing comment");
                }
            } else {
                do {
                    if (this.pos != this.data.length) continue;
                    end = this.pos - 1;
                    break block15;
                } while ((c = this.data[this.pos++]) != '\n');
                this.newline();
                end = this.pos - 2;
            }
        }
        while (end > start && (this.data[end] == ' ' || this.data[end] == '\t')) {
            --end;
        }
        if (end == start) {
            return documentation;
        }
        String trailingDocumentation = new String(this.data, start, end - start + 1);
        return documentation.isEmpty() ? trailingDocumentation : documentation + '\n' + trailingDocumentation;
    }

    private void skipWhitespace(boolean skipComments) {
        while (this.pos < this.data.length) {
            char c = this.data[this.pos];
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                ++this.pos;
                if (c != '\n') continue;
                this.newline();
                continue;
            }
            if (!skipComments || c != '/') break;
            this.readComment();
        }
    }

    private void newline() {
        ++this.line;
        this.lineStart = this.pos;
    }

    public Location location() {
        return this.location.at(this.line + 1, this.pos - this.lineStart + 1);
    }

    public RuntimeException unexpected(String message) {
        return this.unexpected(this.location(), message);
    }

    public RuntimeException unexpected(Location location, String message) {
        throw new IllegalStateException(String.format("Syntax error in %s: %s", location, message));
    }
}

