/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.internal.parser.AutoValue_ProtoParser_OptionKindAndValue;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.ExtendElement;
import com.squareup.wire.schema.internal.parser.ExtensionsElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.GroupElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ReservedElement;
import com.squareup.wire.schema.internal.parser.RpcElement;
import com.squareup.wire.schema.internal.parser.ServiceElement;
import com.squareup.wire.schema.internal.parser.SyntaxReader;
import com.squareup.wire.schema.internal.parser.TypeElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ProtoParser {
    private final SyntaxReader reader;
    private final ProtoFileElement.Builder fileBuilder;
    private final ImmutableList.Builder<String> publicImports = ImmutableList.builder();
    private final ImmutableList.Builder<String> imports = ImmutableList.builder();
    private final ImmutableList.Builder<TypeElement> nestedTypes = ImmutableList.builder();
    private final ImmutableList.Builder<ServiceElement> services = ImmutableList.builder();
    private final ImmutableList.Builder<ExtendElement> extendsList = ImmutableList.builder();
    private final ImmutableList.Builder<OptionElement> options = ImmutableList.builder();
    private int declarationCount = 0;
    private ProtoFile.Syntax syntax;
    private String packageName;
    private String prefix = "";

    public static ProtoFileElement parse(Location location, String data) {
        return new ProtoParser(location, data.toCharArray()).readProtoFile();
    }

    ProtoParser(Location location, char[] data) {
        this.reader = new SyntaxReader(data, location);
        this.fileBuilder = ProtoFileElement.builder(location);
    }

    ProtoFileElement readProtoFile() {
        while (true) {
            String documentation = this.reader.readDocumentation();
            if (this.reader.exhausted()) {
                return this.fileBuilder.syntax(this.syntax).publicImports((ImmutableList<String>)this.publicImports.build()).imports((ImmutableList<String>)this.imports.build()).types((ImmutableList<TypeElement>)this.nestedTypes.build()).services((ImmutableList<ServiceElement>)this.services.build()).extendDeclarations((ImmutableList<ExtendElement>)this.extendsList.build()).options((Collection<OptionElement>)this.options.build()).build();
            }
            Object declaration = this.readDeclaration(documentation, Context.FILE);
            if (declaration instanceof TypeElement) {
                this.nestedTypes.add((Object)((TypeElement)declaration));
                continue;
            }
            if (declaration instanceof ServiceElement) {
                this.services.add((Object)((ServiceElement)declaration));
                continue;
            }
            if (declaration instanceof OptionElement) {
                this.options.add((Object)((OptionElement)declaration));
                continue;
            }
            if (!(declaration instanceof ExtendElement)) continue;
            this.extendsList.add((Object)((ExtendElement)declaration));
        }
    }

    private Object readDeclaration(String documentation, Context context) {
        int index = this.declarationCount++;
        if (this.reader.peekChar(';')) {
            return null;
        }
        Location location = this.reader.location();
        String label = this.reader.readWord();
        if (label.equals("package")) {
            if (!context.permitsPackage()) {
                throw this.reader.unexpected(location, "'package' in " + (Object)((Object)context));
            }
            if (this.packageName != null) {
                throw this.reader.unexpected(location, "too many package names");
            }
            this.packageName = this.reader.readName();
            this.fileBuilder.packageName(this.packageName);
            this.prefix = this.packageName + ".";
            this.reader.require(';');
            return null;
        }
        if (label.equals("import")) {
            if (!context.permitsImport()) {
                throw this.reader.unexpected(location, "'import' in " + (Object)((Object)context));
            }
            String importString = this.reader.readString();
            if ("public".equals(importString)) {
                this.publicImports.add((Object)this.reader.readString());
            } else {
                this.imports.add((Object)importString);
            }
            this.reader.require(';');
            return null;
        }
        if (label.equals("syntax")) {
            if (!context.permitsSyntax()) {
                throw this.reader.unexpected(location, "'syntax' in " + (Object)((Object)context));
            }
            this.reader.require('=');
            if (index != 0) {
                throw this.reader.unexpected(location, "'syntax' element must be the first declaration in a file");
            }
            String syntaxString = this.reader.readQuotedString();
            try {
                this.syntax = ProtoFile.Syntax.get(syntaxString);
            }
            catch (IllegalArgumentException e) {
                throw this.reader.unexpected(location, e.getMessage());
            }
            this.reader.require(';');
            return null;
        }
        if (label.equals("option")) {
            OptionElement result = this.readOption('=');
            this.reader.require(';');
            return result;
        }
        if (label.equals("reserved")) {
            return this.readReserved(location, documentation);
        }
        if (label.equals("message")) {
            return this.readMessage(location, documentation);
        }
        if (label.equals("enum")) {
            return this.readEnumElement(location, documentation);
        }
        if (label.equals("service")) {
            return this.readService(location, documentation);
        }
        if (label.equals("extend")) {
            return this.readExtend(location, documentation);
        }
        if (label.equals("rpc")) {
            if (!context.permitsRpc()) {
                throw this.reader.unexpected(location, "'rpc' in " + (Object)((Object)context));
            }
            return this.readRpc(location, documentation);
        }
        if (label.equals("oneof")) {
            if (!context.permitsOneOf()) {
                throw this.reader.unexpected(location, "'oneof' must be nested in message");
            }
            return this.readOneOf(documentation);
        }
        if (label.equals("extensions")) {
            if (!context.permitsExtensions()) {
                throw this.reader.unexpected(location, "'extensions' must be nested");
            }
            return this.readExtensions(location, documentation);
        }
        if (context == Context.MESSAGE || context == Context.EXTEND) {
            return this.readField(documentation, location, label);
        }
        if (context == Context.ENUM) {
            return this.readEnumConstant(documentation, location, label);
        }
        throw this.reader.unexpected(location, "unexpected label: " + label);
    }

    private MessageElement readMessage(Location location, String documentation) {
        String name = this.reader.readName();
        MessageElement.Builder builder = MessageElement.builder(location).name(name).documentation(documentation);
        String previousPrefix = this.prefix;
        this.prefix = this.prefix + name + ".";
        ImmutableList.Builder fields = ImmutableList.builder();
        ImmutableList.Builder oneOfs = ImmutableList.builder();
        ImmutableList.Builder nestedTypes = ImmutableList.builder();
        ImmutableList.Builder extensions = ImmutableList.builder();
        ImmutableList.Builder options = ImmutableList.builder();
        ImmutableList.Builder reserveds = ImmutableList.builder();
        ImmutableList.Builder groups = ImmutableList.builder();
        this.reader.require('{');
        while (true) {
            String nestedDocumentation = this.reader.readDocumentation();
            if (this.reader.peekChar('}')) break;
            Object declared = this.readDeclaration(nestedDocumentation, Context.MESSAGE);
            if (declared instanceof FieldElement) {
                fields.add((Object)((FieldElement)declared));
                continue;
            }
            if (declared instanceof OneOfElement) {
                oneOfs.add((Object)((OneOfElement)declared));
                continue;
            }
            if (declared instanceof GroupElement) {
                groups.add((Object)((GroupElement)declared));
                continue;
            }
            if (declared instanceof TypeElement) {
                nestedTypes.add((Object)((TypeElement)declared));
                continue;
            }
            if (declared instanceof ExtensionsElement) {
                extensions.add((Object)((ExtensionsElement)declared));
                continue;
            }
            if (declared instanceof OptionElement) {
                options.add((Object)((OptionElement)declared));
                continue;
            }
            if (declared instanceof ExtendElement) {
                this.extendsList.add((Object)((ExtendElement)declared));
                continue;
            }
            if (!(declared instanceof ReservedElement)) continue;
            reserveds.add((Object)((ReservedElement)declared));
        }
        this.prefix = previousPrefix;
        return builder.fields((ImmutableList<FieldElement>)fields.build()).oneOfs((ImmutableList<OneOfElement>)oneOfs.build()).nestedTypes((ImmutableList<TypeElement>)nestedTypes.build()).extensions((ImmutableList<ExtensionsElement>)extensions.build()).options((ImmutableList<OptionElement>)options.build()).reserveds((ImmutableList<ReservedElement>)reserveds.build()).groups((ImmutableList<GroupElement>)groups.build()).build();
    }

    private ExtendElement readExtend(Location location, String documentation) {
        String name = this.reader.readName();
        ExtendElement.Builder builder = ExtendElement.builder(location).name(name).documentation(documentation);
        this.reader.require('{');
        ImmutableList.Builder fields = ImmutableList.builder();
        while (true) {
            String nestedDocumentation = this.reader.readDocumentation();
            if (this.reader.peekChar('}')) break;
            Object declared = this.readDeclaration(nestedDocumentation, Context.EXTEND);
            if (!(declared instanceof FieldElement)) continue;
            fields.add((Object)((FieldElement)declared));
        }
        return builder.fields((ImmutableList<FieldElement>)fields.build()).build();
    }

    private ServiceElement readService(Location location, String documentation) {
        String name = this.reader.readName();
        ServiceElement.Builder builder = ServiceElement.builder(location).name(name).documentation(documentation);
        this.reader.require('{');
        ImmutableList.Builder rpcs = ImmutableList.builder();
        ImmutableList.Builder options = ImmutableList.builder();
        while (true) {
            String rpcDocumentation = this.reader.readDocumentation();
            if (this.reader.peekChar('}')) break;
            Object declared = this.readDeclaration(rpcDocumentation, Context.SERVICE);
            if (declared instanceof RpcElement) {
                rpcs.add((Object)((RpcElement)declared));
                continue;
            }
            if (!(declared instanceof OptionElement)) continue;
            options.add((Object)((OptionElement)declared));
        }
        return builder.options((ImmutableList<OptionElement>)options.build()).rpcs((ImmutableList<RpcElement>)rpcs.build()).build();
    }

    private EnumElement readEnumElement(Location location, String documentation) {
        String name = this.reader.readName();
        EnumElement.Builder builder = EnumElement.builder(location).name(name).documentation(documentation);
        ImmutableList.Builder constants = ImmutableList.builder();
        ImmutableList.Builder options = ImmutableList.builder();
        this.reader.require('{');
        while (true) {
            String valueDocumentation = this.reader.readDocumentation();
            if (this.reader.peekChar('}')) break;
            Object declared = this.readDeclaration(valueDocumentation, Context.ENUM);
            if (declared instanceof EnumConstantElement) {
                constants.add((Object)((EnumConstantElement)declared));
                continue;
            }
            if (!(declared instanceof OptionElement)) continue;
            options.add((Object)((OptionElement)declared));
        }
        return builder.options((ImmutableList<OptionElement>)options.build()).constants((ImmutableList<EnumConstantElement>)constants.build()).build();
    }

    private Object readField(String documentation, Location location, String word) {
        String type;
        Field.Label label;
        switch (word) {
            case "required": {
                if (this.syntax == ProtoFile.Syntax.PROTO_3) {
                    throw this.reader.unexpected(location, "'required' label forbidden in proto3 field declarations");
                }
                label = Field.Label.REQUIRED;
                type = this.reader.readDataType();
                break;
            }
            case "optional": {
                if (this.syntax == ProtoFile.Syntax.PROTO_3) {
                    throw this.reader.unexpected(location, "'optional' label forbidden in proto3 field declarations");
                }
                label = Field.Label.OPTIONAL;
                type = this.reader.readDataType();
                break;
            }
            case "repeated": {
                label = Field.Label.REPEATED;
                type = this.reader.readDataType();
                break;
            }
            default: {
                if (!(this.syntax == ProtoFile.Syntax.PROTO_3 || word.equals("map") && this.reader.peekChar() == '<')) {
                    throw this.reader.unexpected(location, "unexpected label: " + word);
                }
                label = null;
                type = this.reader.readDataType(word);
            }
        }
        if (type.startsWith("map<") && label != null) {
            throw this.reader.unexpected(location, "'map' type cannot have label");
        }
        if (type.equals("group")) {
            return this.readGroup(documentation, label);
        }
        return this.readField(location, documentation, label, type);
    }

    private FieldElement readField(Location location, String documentation, Field.Label label, String type) {
        String name = this.reader.readName();
        this.reader.require('=');
        int tag = this.reader.readInt();
        FieldElement.Builder builder = FieldElement.builder(location).label(label).type(type).name(name).tag(tag);
        ImmutableList.Builder options = ImmutableList.builder();
        if (this.reader.peekChar('[')) {
            while (true) {
                OptionElement option;
                if ((option = this.readOption('=')).name().equals("default")) {
                    builder.defaultValue(String.valueOf(option.value()));
                } else {
                    options.add((Object)option);
                }
                if (this.reader.peekChar(']')) break;
                this.reader.peekChar(',');
            }
        }
        this.reader.require(';');
        documentation = this.reader.tryAppendTrailingDocumentation(documentation);
        return builder.documentation(documentation).options((ImmutableList<OptionElement>)options.build()).build();
    }

    private OneOfElement readOneOf(String documentation) {
        OneOfElement.Builder builder = OneOfElement.builder().name(this.reader.readName()).documentation(documentation);
        ImmutableList.Builder fields = ImmutableList.builder();
        ImmutableList.Builder groups = ImmutableList.builder();
        this.reader.require('{');
        while (true) {
            String nestedDocumentation = this.reader.readDocumentation();
            if (this.reader.peekChar('}')) break;
            Location location = this.reader.location();
            String type = this.reader.readDataType();
            if (type.equals("group")) {
                groups.add((Object)this.readGroup(nestedDocumentation, null));
                continue;
            }
            fields.add((Object)this.readField(location, nestedDocumentation, null, type));
        }
        return builder.fields((ImmutableList<FieldElement>)fields.build()).groups((ImmutableList<GroupElement>)groups.build()).build();
    }

    private GroupElement readGroup(String documentation, Field.Label label) {
        String name = this.reader.readWord();
        this.reader.require('=');
        int tag = this.reader.readInt();
        GroupElement.Builder builder = GroupElement.builder().label(label).name(name).tag(tag).documentation(documentation);
        ImmutableList.Builder fields = ImmutableList.builder();
        this.reader.require('{');
        while (true) {
            String fieldLabel;
            String nestedDocumentation = this.reader.readDocumentation();
            if (this.reader.peekChar('}')) break;
            Location location = this.reader.location();
            Object field = this.readField(nestedDocumentation, location, fieldLabel = this.reader.readWord());
            if (!(field instanceof FieldElement)) {
                throw this.reader.unexpected("expected field declaration, was " + field);
            }
            fields.add((Object)((FieldElement)field));
        }
        return builder.fields((ImmutableList<FieldElement>)fields.build()).build();
    }

    private ReservedElement readReserved(Location location, String documentation) {
        ImmutableList.Builder valuesBuilder;
        block7: {
            char c;
            valuesBuilder = ImmutableList.builder();
            do {
                if ((c = this.reader.peekChar()) == '\"' || c == '\'') {
                    valuesBuilder.add((Object)this.reader.readQuotedString());
                } else {
                    int tagStart = this.reader.readInt();
                    c = this.reader.peekChar();
                    if (c != ',' && c != ';') {
                        if (!this.reader.readWord().equals("to")) {
                            throw this.reader.unexpected("expected ',', ';', or 'to'");
                        }
                        int tagEnd = this.reader.readInt();
                        valuesBuilder.add((Object)Range.closed((Comparable)Integer.valueOf(tagStart), (Comparable)Integer.valueOf(tagEnd)));
                    } else {
                        valuesBuilder.add((Object)tagStart);
                    }
                }
                c = this.reader.readChar();
                if (c == ';') break block7;
            } while (c == ',');
            throw this.reader.unexpected("expected ',' or ';'");
        }
        ImmutableList values = valuesBuilder.build();
        if (values.isEmpty()) {
            throw this.reader.unexpected("'reserved' must have at least one field name or tag");
        }
        return ReservedElement.create(location, documentation, (ImmutableList<Object>)values);
    }

    private ExtensionsElement readExtensions(Location location, String documentation) {
        int start;
        int end = start = this.reader.readInt();
        if (this.reader.peekChar() != ';') {
            if (!"to".equals(this.reader.readWord())) {
                throw this.reader.unexpected("expected ';' or 'to'");
            }
            String s = this.reader.readWord();
            end = s.equals("max") ? 0x1FFFFFFF : Integer.parseInt(s);
        }
        this.reader.require(';');
        return ExtensionsElement.create(location, start, end, documentation);
    }

    private OptionElement readOption(char keyValueSeparator) {
        boolean isExtension = this.reader.peekChar() == '[';
        boolean isParenthesized = this.reader.peekChar() == '(';
        String name = this.reader.readName();
        if (isExtension) {
            name = "[" + name + "]";
        }
        String subName = null;
        char c = this.reader.readChar();
        if (c == '.') {
            subName = this.reader.readName();
            c = this.reader.readChar();
        }
        if (keyValueSeparator == ':' && c == '{') {
            this.reader.pushBack('{');
        } else if (c != keyValueSeparator) {
            throw this.reader.unexpected("expected '" + keyValueSeparator + "' in option");
        }
        OptionKindAndValue kindAndValue = this.readKindAndValue();
        OptionElement.Kind kind = kindAndValue.kind();
        Object value = kindAndValue.value();
        if (subName != null) {
            value = OptionElement.create(subName, kind, value);
            kind = OptionElement.Kind.OPTION;
        }
        return OptionElement.create(name, kind, value, isParenthesized);
    }

    private EnumConstantElement readEnumConstant(String documentation, Location location, String label) {
        ImmutableList.Builder options;
        int tag;
        block2: {
            this.reader.require('=');
            tag = this.reader.readInt();
            options = ImmutableList.builder();
            if (this.reader.peekChar() == '[') {
                char c;
                this.reader.readChar();
                do {
                    options.add((Object)this.readOption('='));
                    c = this.reader.readChar();
                    if (c == ']') break block2;
                } while (c == ',');
                throw this.reader.unexpected("Expected ',' or ']");
            }
        }
        this.reader.require(';');
        documentation = this.reader.tryAppendTrailingDocumentation(documentation);
        return EnumConstantElement.builder(location).name(label).tag(tag).documentation(documentation).options((ImmutableList<OptionElement>)options.build()).build();
    }

    private OptionKindAndValue readKindAndValue() {
        String word;
        char peeked = this.reader.peekChar();
        switch (peeked) {
            case '{': {
                return OptionKindAndValue.of(OptionElement.Kind.MAP, this.readMap('{', '}', ':'));
            }
            case '[': {
                return OptionKindAndValue.of(OptionElement.Kind.LIST, this.readList());
            }
            case '\"': 
            case '\'': {
                return OptionKindAndValue.of(OptionElement.Kind.STRING, this.reader.readString());
            }
        }
        if (Character.isDigit(peeked) || peeked == '-') {
            return OptionKindAndValue.of(OptionElement.Kind.NUMBER, this.reader.readWord());
        }
        switch (word = this.reader.readWord()) {
            case "true": {
                return OptionKindAndValue.of(OptionElement.Kind.BOOLEAN, "true");
            }
            case "false": {
                return OptionKindAndValue.of(OptionElement.Kind.BOOLEAN, "false");
            }
        }
        return OptionKindAndValue.of(OptionElement.Kind.ENUM, word);
    }

    private Map<String, Object> readMap(char openBrace, char closeBrace, char keyValueSeparator) {
        if (this.reader.readChar() != openBrace) {
            throw new AssertionError();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        while (!this.reader.peekChar(closeBrace)) {
            OptionElement option = this.readOption(keyValueSeparator);
            String name = option.name();
            Object value = option.value();
            if (value instanceof OptionElement) {
                LinkedHashMap<String, Object> nested = (LinkedHashMap<String, Object>)result.get(name);
                if (nested == null) {
                    nested = new LinkedHashMap<String, Object>();
                    result.put(name, nested);
                }
                OptionElement valueOption = (OptionElement)value;
                nested.put(valueOption.name(), valueOption.value());
            } else {
                Object previous = result.get(name);
                if (previous == null) {
                    result.put(name, value);
                } else if (previous instanceof List) {
                    this.addToList((List)previous, value);
                } else {
                    ArrayList<Object> newList = new ArrayList<Object>();
                    newList.add(previous);
                    this.addToList(newList, value);
                    result.put(name, newList);
                }
            }
            this.reader.peekChar(',');
        }
        return result;
    }

    private void addToList(List<Object> list, Object value) {
        if (value instanceof List) {
            list.addAll((List)value);
        } else {
            list.add(value);
        }
    }

    private List<Object> readList() {
        this.reader.require('[');
        ArrayList<Object> result = new ArrayList<Object>();
        do {
            if (this.reader.peekChar(']')) {
                return result;
            }
            result.add(this.readKindAndValue().value());
        } while (this.reader.peekChar(',') || this.reader.peekChar() == ']');
        throw this.reader.unexpected("expected ',' or ']'");
    }

    private RpcElement readRpc(Location location, String documentation) {
        String type;
        RpcElement.Builder builder = RpcElement.builder(location).name(this.reader.readName()).documentation(documentation);
        this.reader.require('(');
        String word = this.reader.readWord();
        if (word.equals("stream")) {
            builder.requestStreaming(true);
            type = this.reader.readDataType();
        } else {
            type = this.reader.readDataType(word);
        }
        builder.requestType(type);
        this.reader.require(')');
        if (!this.reader.readWord().equals("returns")) {
            throw this.reader.unexpected("expected 'returns'");
        }
        this.reader.require('(');
        word = this.reader.readWord();
        if (word.equals("stream")) {
            builder.responseStreaming(true);
            type = this.reader.readDataType();
        } else {
            type = this.reader.readDataType(word);
        }
        builder.responseType(type);
        this.reader.require(')');
        if (this.reader.peekChar('{')) {
            ImmutableList.Builder options = ImmutableList.builder();
            while (true) {
                String rpcDocumentation = this.reader.readDocumentation();
                if (this.reader.peekChar('}')) break;
                Object declared = this.readDeclaration(rpcDocumentation, Context.RPC);
                if (!(declared instanceof OptionElement)) continue;
                options.add((Object)((OptionElement)declared));
            }
            builder.options((ImmutableList<OptionElement>)options.build());
        } else {
            this.reader.require(';');
        }
        return builder.build();
    }

    static enum Context {
        FILE,
        MESSAGE,
        ENUM,
        RPC,
        EXTEND,
        SERVICE;


        public boolean permitsPackage() {
            return this == FILE;
        }

        public boolean permitsSyntax() {
            return this == FILE;
        }

        public boolean permitsImport() {
            return this == FILE;
        }

        public boolean permitsExtensions() {
            return this != FILE;
        }

        public boolean permitsRpc() {
            return this == SERVICE;
        }

        public boolean permitsOneOf() {
            return this == MESSAGE;
        }
    }

    static abstract class OptionKindAndValue {
        OptionKindAndValue() {
        }

        static OptionKindAndValue of(OptionElement.Kind kind, Object value) {
            return new AutoValue_ProtoParser_OptionKindAndValue(kind, value);
        }

        abstract OptionElement.Kind kind();

        abstract Object value();
    }
}

