/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.Util;
import com.squareup.wire.schema.internal.parser.AutoValue_EnumElement;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.TypeElement;

public abstract class EnumElement
implements TypeElement {
    public static Builder builder(Location location) {
        return new AutoValue_EnumElement.Builder().location(location).documentation("").constants((ImmutableList<EnumConstantElement>)ImmutableList.of()).options((ImmutableList<OptionElement>)ImmutableList.of());
    }

    @Override
    public abstract Location location();

    @Override
    public abstract String name();

    @Override
    public abstract String documentation();

    @Override
    public abstract ImmutableList<OptionElement> options();

    @Override
    public final ImmutableList<TypeElement> nestedTypes() {
        return ImmutableList.of();
    }

    public abstract ImmutableList<EnumConstantElement> constants();

    @Override
    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        Util.appendDocumentation(builder, this.documentation());
        builder.append("enum ").append(this.name()).append(" {");
        if (!this.options().isEmpty()) {
            builder.append('\n');
            for (OptionElement option : this.options()) {
                Util.appendIndented(builder, option.toSchemaDeclaration());
            }
        }
        if (!this.constants().isEmpty()) {
            builder.append('\n');
            for (EnumConstantElement constant : this.constants()) {
                Util.appendIndented(builder, constant.toSchema());
            }
        }
        return builder.append("}\n").toString();
    }

    public static interface Builder {
        public Builder location(Location var1);

        public Builder name(String var1);

        public Builder documentation(String var1);

        public Builder constants(ImmutableList<EnumConstantElement> var1);

        public Builder options(ImmutableList<OptionElement> var1);

        public EnumElement build();
    }
}

