/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.ExtendElement;

final class Extend {
    private final Location location;
    private final String documentation;
    private final String name;
    private final ImmutableList<Field> fields;
    private ProtoType protoType;

    private Extend(Location location, String documentation, String name, ImmutableList<Field> fields) {
        this.location = location;
        this.documentation = documentation;
        this.name = name;
        this.fields = fields;
    }

    static ImmutableList<Extend> fromElements(String packageName, ImmutableList<ExtendElement> extendElements) {
        ImmutableList.Builder extendBuilder = new ImmutableList.Builder();
        for (ExtendElement extendElement : extendElements) {
            extendBuilder.add((Object)new Extend(extendElement.location(), extendElement.documentation(), extendElement.name(), Field.fromElements(packageName, extendElement.fields(), true)));
        }
        return extendBuilder.build();
    }

    static ImmutableList<ExtendElement> toElements(ImmutableList<Extend> extendList) {
        ImmutableList.Builder elements = new ImmutableList.Builder();
        for (Extend extend : extendList) {
            elements.add((Object)ExtendElement.builder(extend.location).documentation(extend.documentation).name(extend.name).fields(Field.toElements(extend.fields)).build());
        }
        return elements.build();
    }

    public Location location() {
        return this.location;
    }

    public ProtoType type() {
        return this.protoType;
    }

    public String documentation() {
        return this.documentation;
    }

    public ImmutableList<Field> fields() {
        return this.fields;
    }

    void link(Linker linker) {
        linker = linker.withContext(this);
        this.protoType = linker.resolveMessageType(this.name);
        Type type = linker.get(this.protoType);
        if (type != null) {
            ((MessageType)type).addExtensionFields(this.fields);
        }
    }

    void validate(Linker linker) {
        linker = linker.withContext(this);
        linker.validateImport(this.location(), this.type());
    }
}

