/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.NavigableSet;
import java.util.TreeSet;

final class Pruner {
    final NavigableSet<String> marks = new TreeSet<String>();
    final Deque<String> queue = new ArrayDeque<String>();

    Pruner() {
    }

    public Schema retainRoots(Schema schema, Collection<String> roots) {
        String root;
        if (roots.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (!this.marks.isEmpty()) {
            throw new IllegalStateException();
        }
        for (String s : roots) {
            this.mark(s);
        }
        for (ProtoFile protoFile : schema.protoFiles()) {
            for (Extend extend : protoFile.extendList()) {
                this.markExtend(extend);
            }
            this.markOptions(protoFile.options());
        }
        while ((root = this.queue.poll()) != null) {
            int hash = root.indexOf(35);
            if (hash != -1) {
                Rpc rpc;
                Service service;
                EnumConstant constant;
                String typeOrServiceName = root.substring(0, hash);
                String member = root.substring(hash + 1);
                Type type = schema.getType(typeOrServiceName);
                if (type instanceof MessageType) {
                    Field field = ((MessageType)type).field(member);
                    if (field != null) {
                        this.markOptions(type.options());
                        this.markField(field);
                        this.mark(type.name());
                        continue;
                    }
                } else if (type instanceof EnumType && (constant = ((EnumType)type).constant(member)) != null) {
                    this.markOptions(type.options());
                    this.markOptions(constant.options());
                    this.mark(type.name());
                    continue;
                }
                if ((service = schema.getService(typeOrServiceName)) != null && (rpc = service.rpc(member)) != null) {
                    this.markOptions(service.options());
                    this.markRpc(rpc);
                    this.mark(service.type());
                    continue;
                }
                throw new IllegalArgumentException("Unexpected member: " + root);
            }
            if (ProtoType.get(root).isScalar()) continue;
            Type type = schema.getType(root);
            if (type != null) {
                this.markType(schema, type);
                continue;
            }
            Service service = schema.getService(root);
            if (service != null) {
                this.markService(service);
                continue;
            }
            throw new IllegalArgumentException("Unexpected type: " + root);
        }
        ImmutableList.Builder retained = ImmutableList.builder();
        for (ProtoFile protoFile : schema.protoFiles()) {
            retained.add((Object)protoFile.retainAll(this.marks));
        }
        return new Schema((Iterable<ProtoFile>)retained.build());
    }

    static boolean hasMarkedMember(NavigableSet<String> marks, ProtoType typeName) {
        String prefix = typeName + "#";
        String ceiling = marks.ceiling(prefix);
        return ceiling != null && ceiling.startsWith(prefix);
    }

    private void mark(ProtoType protoType) {
        this.mark(protoType.toString());
    }

    private void mark(String identifier) {
        if (this.marks.add(identifier)) {
            this.queue.add(identifier);
        }
    }

    private void markExtend(Extend extend) {
        this.mark(extend.type());
        this.markFields(extend.fields());
    }

    private void markType(Schema schema, Type type) {
        this.markOptions(type.options());
        String enclosingTypeOrPackage = type.name().enclosingTypeOrPackage();
        Type enclosingType = schema.getType(enclosingTypeOrPackage);
        if (enclosingType != null) {
            this.mark(enclosingTypeOrPackage);
        }
        if (!Pruner.hasMarkedMember(this.marks, type.name())) {
            for (Type nestedType : type.nestedTypes()) {
                this.mark(nestedType.name());
            }
            if (type instanceof MessageType) {
                this.markMessage((MessageType)type);
            } else if (type instanceof EnumType) {
                this.markEnum((EnumType)type);
            }
        }
    }

    private void markMessage(MessageType message) {
        this.markFields(message.fields());
        for (OneOf oneOf : message.oneOfs()) {
            this.markFields(oneOf.fields());
        }
    }

    private void markEnum(EnumType wireEnum) {
        this.markOptions(wireEnum.options());
        if (!Pruner.hasMarkedMember(this.marks, wireEnum.name())) {
            for (EnumConstant constant : wireEnum.constants()) {
                this.markOptions(constant.options());
            }
        }
    }

    private void markFields(ImmutableList<Field> fields) {
        for (Field field : fields) {
            this.markField(field);
        }
    }

    private void markField(Field field) {
        this.markOptions(field.options());
        this.mark(field.type());
    }

    private void markOptions(Options options) {
        for (Field field : options.fields()) {
            this.markField(field);
        }
    }

    private void markService(Service service) {
        this.markOptions(service.options());
        if (!Pruner.hasMarkedMember(this.marks, service.type())) {
            for (Rpc rpc : service.rpcs()) {
                this.markRpc(rpc);
            }
        }
    }

    private void markRpc(Rpc rpc) {
        this.markOptions(rpc.options());
        this.mark(rpc.requestType());
        this.mark(rpc.responseType());
    }
}

