/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.base.Joiner;
import com.squareup.wire.internal.protoparser.ProtoFileElement;
import com.squareup.wire.internal.protoparser.ProtoParser;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Schema;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.Okio;
import okio.Source;

public final class Loader {
    private final IO io;
    private final Map<String, ProtoFile> loaded = new LinkedHashMap<String, ProtoFile>();

    public Loader(IO io) {
        this.io = io;
    }

    public static Loader forSearchPaths(final List<String> paths) {
        IO io = new IO(){

            @Override
            public Location locate(String file) throws IOException {
                for (String path : paths) {
                    File f = new File(path, file);
                    if (!f.exists()) continue;
                    return Location.get(path, file);
                }
                throw new IOException("Could not locate " + file + " within any of the following: " + Joiner.on((String)", ").join((Iterable)paths) + ".");
            }

            @Override
            public Source open(Location location) throws IOException {
                return Okio.source((File)new File(location.base(), location.path()));
            }

            public String toString() {
                return String.format("Loader(%s)", Joiner.on((String)":").join((Iterable)paths));
            }
        };
        return new Loader(io);
    }

    public Schema load(Iterable<String> sourceFiles) throws IOException {
        for (String path : sourceFiles) {
            this.load(path);
        }
        return new Linker(this.loaded.values()).link();
    }

    private void load(String path) throws IOException {
        ProtoFileElement element;
        Location location;
        if (this.loaded.containsKey(path)) {
            return;
        }
        try {
            location = this.io.locate(path);
        }
        catch (IOException e) {
            throw new IOException("Failed to locate " + path + " with " + this.io, e);
        }
        try (Source source = this.io.open(location);){
            String data = Okio.buffer((Source)source).readUtf8();
            element = ProtoParser.parse(location, data);
        }
        catch (IOException e) {
            throw new IOException("Failed to load " + location + " with " + this.io, e);
        }
        ProtoFile protoFile = ProtoFile.get(element);
        this.loaded.put(path, protoFile);
        for (String dependency : element.dependencies()) {
            this.load(dependency);
        }
    }

    public static interface IO {
        public Location locate(String var1) throws IOException;

        public Source open(Location var1) throws IOException;
    }
}

