/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.squareup.wire.internal.protoparser.EnumElement;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class EnumType
extends Type {
    private final Type.Name name;
    private final EnumElement element;
    private final ImmutableList<EnumConstant> constants;
    private final Options options;

    EnumType(Type.Name name, EnumElement element, ImmutableList<EnumConstant> constants, Options options) {
        this.name = name;
        this.element = element;
        this.constants = constants;
        this.options = options;
    }

    @Override
    public Location location() {
        return this.element.location();
    }

    @Override
    public Type.Name name() {
        return this.name;
    }

    @Override
    public String documentation() {
        return this.element.documentation();
    }

    @Override
    public Options options() {
        return this.options;
    }

    @Override
    public ImmutableList<Type> nestedTypes() {
        return ImmutableList.of();
    }

    public EnumConstant constant(String name) {
        for (EnumConstant constant : this.constants()) {
            if (!constant.name().equals(name)) continue;
            return constant;
        }
        return null;
    }

    public EnumConstant constant(int tag) {
        for (EnumConstant constant : this.constants()) {
            if (constant.tag() != tag) continue;
            return constant;
        }
        return null;
    }

    public ImmutableList<EnumConstant> constants() {
        return this.constants;
    }

    @Override
    void validate(Linker linker) {
        linker = linker.withContext(this);
        if (!"true".equals(this.options.get("allow_alias"))) {
            this.validateTagUniqueness(linker);
        }
    }

    private void validateTagUniqueness(Linker linker) {
        LinkedHashMultimap tagToConstant = LinkedHashMultimap.create();
        for (EnumConstant constant : this.constants) {
            tagToConstant.put((Object)constant.tag(), (Object)constant);
        }
        for (Map.Entry entry : tagToConstant.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            StringBuilder error = new StringBuilder();
            error.append(String.format("multiple enum constants share tag %s:", entry.getKey()));
            int index = 1;
            for (EnumConstant constant : (Collection)entry.getValue()) {
                error.append(String.format("\n  %s. %s (%s)", index++, constant.name(), constant.location()));
            }
            linker.addError("%s", error);
        }
    }

    @Override
    void link(Linker linker) {
    }

    @Override
    void linkOptions(Linker linker) {
        this.options.link(linker);
        for (EnumConstant constant : this.constants) {
            constant.linkOptions(linker);
        }
    }

    @Override
    Type retainAll(Set<String> identifiers) {
        return identifiers.contains(this.name.toString()) ? this : null;
    }
}

