/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.internal.parser.AutoValue_ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ExtendElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.ServiceElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import java.util.Collection;

public abstract class ProtoFileElement {
    public static Builder builder(Location location) {
        return new AutoValue_ProtoFileElement.Builder().location(location).imports((ImmutableList<String>)ImmutableList.of()).publicImports((ImmutableList<String>)ImmutableList.of()).types((ImmutableList<TypeElement>)ImmutableList.of()).services((ImmutableList<ServiceElement>)ImmutableList.of()).extendDeclarations((ImmutableList<ExtendElement>)ImmutableList.of()).options((Collection<OptionElement>)ImmutableList.of());
    }

    public abstract Location location();

    public abstract String packageName();

    public abstract ProtoFile.Syntax syntax();

    public abstract ImmutableList<String> imports();

    public abstract ImmutableList<String> publicImports();

    public abstract ImmutableList<TypeElement> types();

    public abstract ImmutableList<ServiceElement> services();

    public abstract ImmutableList<ExtendElement> extendDeclarations();

    public abstract ImmutableList<OptionElement> options();

    public final String toSchema() {
        StringBuilder builder = new StringBuilder();
        builder.append("// ").append(this.location()).append('\n');
        if (this.packageName() != null) {
            builder.append("package ").append(this.packageName()).append(";\n");
        }
        if (this.syntax() != null) {
            builder.append("syntax \"").append((Object)this.syntax()).append("\";\n");
        }
        if (!this.imports().isEmpty() || !this.publicImports().isEmpty()) {
            builder.append('\n');
            for (String file : this.imports()) {
                builder.append("import \"").append(file).append("\";\n");
            }
            for (String file : this.publicImports()) {
                builder.append("import public \"").append(file).append("\";\n");
            }
        }
        if (!this.options().isEmpty()) {
            builder.append('\n');
            for (OptionElement option : this.options()) {
                builder.append(option.toSchemaDeclaration());
            }
        }
        if (!this.types().isEmpty()) {
            builder.append('\n');
            for (TypeElement typeElement : this.types()) {
                builder.append(typeElement.toSchema());
            }
        }
        if (!this.extendDeclarations().isEmpty()) {
            builder.append('\n');
            for (ExtendElement extendDeclaration : this.extendDeclarations()) {
                builder.append(extendDeclaration.toSchema());
            }
        }
        if (!this.services().isEmpty()) {
            builder.append('\n');
            for (ServiceElement service : this.services()) {
                builder.append(service.toSchema());
            }
        }
        return builder.toString();
    }

    public static interface Builder {
        public Builder location(Location var1);

        public Builder packageName(String var1);

        public Builder syntax(ProtoFile.Syntax var1);

        public Builder imports(ImmutableList<String> var1);

        public Builder publicImports(ImmutableList<String> var1);

        public Builder types(ImmutableList<TypeElement> var1);

        public Builder services(ImmutableList<ServiceElement> var1);

        public Builder extendDeclarations(ImmutableList<ExtendElement> var1);

        public Builder options(Collection<OptionElement> var1);

        public ProtoFileElement build();
    }
}

