/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.squareup.wire.schema.IdentifierSet;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import java.util.LinkedHashSet;
import java.util.Set;

final class MarkSet {
    final IdentifierSet identifierSet;
    final Set<ProtoType> types = new LinkedHashSet<ProtoType>();
    final Multimap<ProtoType, ProtoMember> members = LinkedHashMultimap.create();

    public MarkSet(IdentifierSet identifierSet) {
        this.identifierSet = identifierSet;
    }

    void root(ProtoMember protoMember) {
        if (protoMember == null) {
            throw new NullPointerException("protoMember == null");
        }
        Preconditions.checkArgument((!this.identifierSet.excludes(protoMember) ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.types.contains(protoMember.type()) ? 1 : 0) != 0);
        this.members.put((Object)protoMember.type(), (Object)protoMember);
    }

    void root(ProtoType type) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        Preconditions.checkArgument((!this.identifierSet.excludes(type) ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.members.containsKey((Object)type) ? 1 : 0) != 0);
        this.types.add(type);
    }

    boolean mark(ProtoType type) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        if (this.identifierSet.excludes(type)) {
            return false;
        }
        return this.types.add(type);
    }

    boolean mark(ProtoMember protoMember) {
        if (protoMember == null) {
            throw new NullPointerException("type == null");
        }
        if (this.identifierSet.excludes(protoMember)) {
            return false;
        }
        return this.members.containsKey((Object)protoMember.type()) ? this.members.put((Object)protoMember.type(), (Object)protoMember) : this.types.add(protoMember.type());
    }

    boolean containsAllMembers(ProtoType type) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        return this.types.contains(type) && !this.members.containsKey((Object)type);
    }

    boolean contains(ProtoType type) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        return this.types.contains(type);
    }

    boolean contains(ProtoMember protoMember) {
        if (protoMember == null) {
            throw new NullPointerException("protoMember == null");
        }
        if (this.identifierSet.excludes(protoMember)) {
            return false;
        }
        return this.members.containsKey((Object)protoMember.type()) ? this.members.containsEntry((Object)protoMember.type(), (Object)protoMember) : this.types.contains(protoMember.type());
    }
}

