(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'wire-library-wire-runtime'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('wire-library-wire-runtime'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'wire-library-wire-schema'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'wire-library-wire-schema'.");
    }if (typeof this['wire-library-wire-runtime'] === 'undefined') {
      throw new Error("Error loading module 'wire-library-wire-schema'. Its dependency 'wire-library-wire-runtime' was not found. Please, check whether 'wire-library-wire-runtime' is loaded prior to 'wire-library-wire-schema'.");
    }root['wire-library-wire-schema'] = factory(typeof this['wire-library-wire-schema'] === 'undefined' ? {} : this['wire-library-wire-schema'], kotlin, this['wire-library-wire-runtime']);
  }
}(this, function (_, Kotlin, $module$wire_library_wire_runtime) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var plus = Kotlin.kotlin.collections.plus_mydzjv$;
  var ensureNotNull = Kotlin.ensureNotNull;
  var equals = Kotlin.equals;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var LinkedHashSet_init = Kotlin.kotlin.collections.LinkedHashSet_init_287e2$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var sortedWith = Kotlin.kotlin.collections.sortedWith_eknfly$;
  var wrapFunction = Kotlin.wrapFunction;
  var Comparator = Kotlin.kotlin.Comparator;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var iterator = Kotlin.kotlin.text.iterator_gw00vp$;
  var CharRange = Kotlin.kotlin.ranges.CharRange;
  var toChar = Kotlin.toChar;
  var unboxChar = Kotlin.unboxChar;
  var StringBuilder_init_0 = Kotlin.kotlin.text.StringBuilder_init_za3lpa$;
  var checkIndexOverflow = Kotlin.kotlin.collections.checkIndexOverflow_za3lpa$;
  var plus_0 = Kotlin.kotlin.collections.plus_qloxvw$;
  var toMutableList = Kotlin.kotlin.collections.toMutableList_4c7yge$;
  var removeAll = Kotlin.kotlin.collections.removeAll_qafx1e$;
  var get_indices = Kotlin.kotlin.collections.get_indices_gzk92b$;
  var reversed = Kotlin.kotlin.ranges.reversed_zf1xzc$;
  var toString = Kotlin.toString;
  var Collection = Kotlin.kotlin.collections.Collection;
  var throwCCE = Kotlin.throwCCE;
  var IntRange = Kotlin.kotlin.ranges.IntRange;
  var AssertionError_init = Kotlin.kotlin.AssertionError_init;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  var contains = Kotlin.kotlin.collections.contains_mjy6jw$;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var LinkedHashSet_init_0 = Kotlin.kotlin.collections.LinkedHashSet_init_mqih57$;
  var toSet = Kotlin.kotlin.collections.toSet_7wnvza$;
  var startsWith = Kotlin.kotlin.text.startsWith_7epoxm$;
  var lastIndexOf = Kotlin.kotlin.text.lastIndexOf_8eortd$;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init;
  var endsWith = Kotlin.kotlin.text.endsWith_7epoxm$;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var trimEnd = Kotlin.kotlin.text.trimEnd_wqw3xr$;
  var IllegalStateException_init_0 = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var addAll = Kotlin.kotlin.collections.addAll_ipc267$;
  var substringBeforeLast = Kotlin.kotlin.text.substringBeforeLast_j4ogox$;
  var trimMargin = Kotlin.kotlin.text.trimMargin_rjktp$;
  var firstOrNull = Kotlin.kotlin.collections.firstOrNull_2p1efm$;
  var first = Kotlin.kotlin.collections.first_7wnvza$;
  var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
  var Map = Kotlin.kotlin.collections.Map;
  var List = Kotlin.kotlin.collections.List;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var single = Kotlin.kotlin.collections.single_2p1efm$;
  var LinkedHashMap_init_0 = Kotlin.kotlin.collections.LinkedHashMap_init_73mtqc$;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var union = Kotlin.kotlin.collections.union_q4559j$;
  var emptyMap = Kotlin.kotlin.collections.emptyMap_q3lmfv$;
  var getValue = Kotlin.kotlin.collections.getValue_t9ocha$;
  var indexOf = Kotlin.kotlin.text.indexOf_8eortd$;
  var split = Kotlin.kotlin.text.split_o64adg$;
  var toMap = Kotlin.kotlin.collections.toMap_6hr0sd$;
  var Regex_init = Kotlin.kotlin.text.Regex_init_61zpoe$;
  var isBlank = Kotlin.kotlin.text.isBlank_gw00vp$;
  var copyToArray = Kotlin.kotlin.collections.copyToArray;
  var Syntax = $module$wire_library_wire_runtime.com.squareup.wire.Syntax;
  var substringAfterLast = Kotlin.kotlin.text.substringAfterLast_8cymmc$;
  var hashCode = Kotlin.hashCode;
  var contains_0 = Kotlin.kotlin.text.contains_li3zpu$;
  var listOf_0 = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var mapCapacity = Kotlin.kotlin.collections.mapCapacity_za3lpa$;
  var coerceAtLeast = Kotlin.kotlin.ranges.coerceAtLeast_dqglrj$;
  var LinkedHashMap_init_1 = Kotlin.kotlin.collections.LinkedHashMap_init_bwtc7$;
  var trim = Kotlin.kotlin.text.trim_gw00vp$;
  var minus = Kotlin.kotlin.collections.minus_khz7k3$;
  var intersect = Kotlin.kotlin.collections.intersect_q4559j$;
  var RuntimeException_init = Kotlin.kotlin.RuntimeException_init_pdl1vj$;
  var RuntimeException = Kotlin.kotlin.RuntimeException;
  var UnsupportedOperationException_init = Kotlin.kotlin.UnsupportedOperationException_init_pdl1vj$;
  var ProtoAdapter = $module$wire_library_wire_runtime.com.squareup.wire.ProtoAdapter;
  var UnsupportedOperationException_init_0 = Kotlin.kotlin.UnsupportedOperationException_init;
  var FieldEncoding = $module$wire_library_wire_runtime.com.squareup.wire.FieldEncoding;
  var PrimitiveClasses$anyClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.anyClass;
  var MutableList = Kotlin.kotlin.collections.MutableList;
  var getKClass = Kotlin.getKClass;
  var MutableMap = Kotlin.kotlin.collections.MutableMap;
  var mutableMapOf = Kotlin.kotlin.collections.mutableMapOf_qfcya0$;
  var indexOfAny = Kotlin.kotlin.text.indexOfAny_junqau$;
  var Comparable = Kotlin.kotlin.Comparable;
  var toBoxedChar = Kotlin.toBoxedChar;
  var get_indices_0 = Kotlin.kotlin.text.get_indices_gw00vp$;
  var first_0 = Kotlin.kotlin.collections.first_2p1efm$;
  var camelCase = $module$wire_library_wire_runtime.com.squareup.wire.internal.camelCase_ivxn3r$;
  var toList = Kotlin.kotlin.collections.toList_7wnvza$;
  var Math_0 = Math;
  var toMutableMap = Kotlin.kotlin.collections.toMutableMap_abgq59$;
  var NoSuchElementException_init = Kotlin.kotlin.NoSuchElementException;
  var split_0 = Kotlin.kotlin.text.split_ip8yn$;
  var last = Kotlin.kotlin.collections.last_2p1efm$;
  var dropLast = Kotlin.kotlin.collections.dropLast_yzln2o$;
  var AssertionError_init_0 = Kotlin.kotlin.AssertionError_init_pdl1vj$;
  var reversed_0 = Kotlin.kotlin.collections.reversed_7wnvza$;
  var IllegalArgumentException = Kotlin.kotlin.IllegalArgumentException;
  var toInt = Kotlin.kotlin.text.toInt_pdl1vz$;
  var getCallableRef = Kotlin.getCallableRef;
  var charArray = Kotlin.charArray;
  var String_0 = Kotlin.kotlin.text.String_8chfmy$;
  var toInt_0 = Kotlin.kotlin.text.toInt_6ic1pp$;
  var Exception = Kotlin.kotlin.Exception;
  var isWhitespace = Kotlin.kotlin.text.isWhitespace_myv2d0$;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var NotImplementedError_init = Kotlin.kotlin.NotImplementedError;
  var contains_1 = Kotlin.kotlin.collections.contains_2ws7j4$;
  var flatten = Kotlin.kotlin.collections.flatten_u0ad8z$;
  var MutableCollection = Kotlin.kotlin.collections.MutableCollection;
  var firstOrNull_0 = Kotlin.kotlin.collections.firstOrNull_7wnvza$;
  EnclosingType.prototype = Object.create(Type.prototype);
  EnclosingType.prototype.constructor = EnclosingType;
  EnumType.prototype = Object.create(Type.prototype);
  EnumType.prototype.constructor = EnumType;
  Field$Label.prototype = Object.create(Enum.prototype);
  Field$Label.prototype.constructor = Field$Label;
  Field$EncodeMode.prototype = Object.create(Enum.prototype);
  Field$EncodeMode.prototype.constructor = Field$EncodeMode;
  MessageType.prototype = Object.create(Type.prototype);
  MessageType.prototype.constructor = MessageType;
  SchemaException.prototype = Object.create(RuntimeException.prototype);
  SchemaException.prototype.constructor = SchemaException;
  SchemaProtoAdapterFactory$EnumAdapter.prototype = Object.create(ProtoAdapter.prototype);
  SchemaProtoAdapterFactory$EnumAdapter.prototype.constructor = SchemaProtoAdapterFactory$EnumAdapter;
  SchemaProtoAdapterFactory$MessageAdapter.prototype = Object.create(ProtoAdapter.prototype);
  SchemaProtoAdapterFactory$MessageAdapter.prototype.constructor = SchemaProtoAdapterFactory$MessageAdapter;
  OptionElement$Kind.prototype = Object.create(Enum.prototype);
  OptionElement$Kind.prototype.constructor = OptionElement$Kind;
  ProtoParser$Context.prototype = Object.create(Enum.prototype);
  ProtoParser$Context.prototype.constructor = ProtoParser$Context;
  var compareBy$lambda = wrapFunction(function () {
    var compareValues = Kotlin.kotlin.comparisons.compareValues_s00gnj$;
    return function (closure$selector) {
      return function (a, b) {
        var selector = closure$selector;
        return compareValues(selector(a), selector(b));
      };
    };
  });
  function CycleChecker(fileLinkers, errors) {
    this.fileLinkers_0 = fileLinkers;
    this.errors_0 = errors;
    this.goPackageOption_0 = ProtoMember$Companion_getInstance().get_61zpoe$('google.protobuf.FileOptions#go_package');
  }
  CycleChecker.prototype.get_importsAndPublicImports_0 = function ($receiver) {
    return plus($receiver.protoFile.imports, $receiver.protoFile.publicImports);
  };
  CycleChecker.prototype.get_cycleCheckPackageName_0 = function ($receiver) {
    var tmp$, tmp$_0;
    var goPackage = typeof (tmp$ = $receiver.protoFile.options.get_pnoc8b$(this.goPackageOption_0)) === 'string' ? tmp$ : null;
    if (goPackage != null)
      return goPackage;
    return (tmp$_0 = $receiver.protoFile.packageName) != null ? tmp$_0 : '<default>';
  };
  function CycleChecker$checkForImportCycles$lambda(this$CycleChecker) {
    return function (it) {
      var tmp$;
      tmp$ = this$CycleChecker.fileLinkers_0.get_11rb$(it);
      if (tmp$ == null) {
        return emptyList();
      }var fileLinker = tmp$;
      return plus(fileLinker.protoFile.imports, fileLinker.protoFile.publicImports);
    };
  }
  CycleChecker.prototype.checkForImportCycles = function () {
    var tmp$;
    var dagChecker = new DagChecker(this.fileLinkers_0.keys, CycleChecker$checkForImportCycles$lambda(this));
    var cycles = dagChecker.check();
    tmp$ = cycles.iterator();
    while (tmp$.hasNext()) {
      var cycle = tmp$.next();
      this.errors_0.plusAssign_61zpoe$(this.importCycleMessageError_0(cycle));
    }
  };
  CycleChecker.prototype.importCycleMessageError_0 = function (files) {
    var $receiver = StringBuilder_init();
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    $receiver.append_pdl1vj$('imports form a cycle:');
    tmp$ = files.iterator();
    while (tmp$.hasNext()) {
      var file = tmp$.next();
      tmp$_0 = this.fileLinkers_0.get_11rb$(file);
      if (tmp$_0 == null) {
        continue;
      }var fileLinker = tmp$_0;
      $receiver.append_pdl1vj$('\n' + '  ' + file + ':');
      tmp$_1 = fileLinker.protoFile.imports.iterator();
      while (tmp$_1.hasNext()) {
        var import_0 = tmp$_1.next();
        if (files.contains_11rb$(import_0)) {
          $receiver.append_pdl1vj$('\n' + '    import ' + '"' + import_0 + '"' + ';');
        }}
      tmp$_2 = fileLinker.protoFile.publicImports.iterator();
      while (tmp$_2.hasNext()) {
        var import_1 = tmp$_2.next();
        if (files.contains_11rb$(import_1)) {
          $receiver.append_pdl1vj$('\n' + '    import public ' + '"' + import_1 + '"' + ';');
        }}
    }
    return $receiver.toString();
  };
  function CycleChecker$checkForPackageCycles$lambda(closure$packageDag) {
    return function (it) {
      return ensureNotNull(closure$packageDag.get_11rb$(it));
    };
  }
  CycleChecker.prototype.checkForPackageCycles = function () {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    var packageDag = LinkedHashMap_init();
    tmp$ = this.fileLinkers_0.values.iterator();
    while (tmp$.hasNext()) {
      var fileLinker = tmp$.next();
      var key = this.get_cycleCheckPackageName_0(fileLinker);
      var tmp$_3;
      var value = packageDag.get_11rb$(key);
      if (value == null) {
        var answer = LinkedHashSet_init();
        packageDag.put_xwzc9p$(key, answer);
        tmp$_3 = answer;
      } else {
        tmp$_3 = value;
      }
      var targets = tmp$_3;
      tmp$_0 = this.get_importsAndPublicImports_0(fileLinker).iterator();
      while (tmp$_0.hasNext()) {
        var path = tmp$_0.next();
        tmp$_1 = this.fileLinkers_0.get_11rb$(path);
        if (tmp$_1 == null) {
          continue;
        }var imported = tmp$_1;
        var element = this.get_cycleCheckPackageName_0(imported);
        targets.add_11rb$(element);
      }
      targets.remove_11rb$(this.get_cycleCheckPackageName_0(fileLinker));
    }
    var dagChecker = new DagChecker(packageDag.keys, CycleChecker$checkForPackageCycles$lambda(packageDag));
    var cycles = dagChecker.check();
    tmp$_2 = cycles.iterator();
    while (tmp$_2.hasNext()) {
      var cycle = tmp$_2.next();
      this.errors_0.plusAssign_61zpoe$(this.packagesCycleMessageError_0(cycle));
    }
  };
  function CycleChecker$packagesCycleMessageError$lambda$lambda(this$CycleChecker) {
    return function (it) {
      return this$CycleChecker.get_cycleCheckPackageName_0(it.value);
    };
  }
  CycleChecker.prototype.packagesCycleMessageError_0 = function (packages) {
    var $receiver = StringBuilder_init();
    var tmp$, tmp$_0, tmp$_1;
    $receiver.append_pdl1vj$('packages form a cycle:');
    var sortedFileLinkers = sortedWith(this.fileLinkers_0.entries, new Comparator(compareBy$lambda(CycleChecker$packagesCycleMessageError$lambda$lambda(this))));
    var lastSourcePackage = null;
    var lastTargetPackage = null;
    var lastSourcePath = null;
    tmp$ = sortedFileLinkers.iterator();
    while (tmp$.hasNext()) {
      var tmp$_2 = tmp$.next();
      var sourcePath = tmp$_2.key;
      var sourceFileLinker = tmp$_2.value;
      var sourcePackage = this.get_cycleCheckPackageName_0(sourceFileLinker);
      if (!packages.contains_11rb$(sourcePackage))
        continue;
      tmp$_0 = this.get_importsAndPublicImports_0(sourceFileLinker).iterator();
      while (tmp$_0.hasNext()) {
        var targetPath = tmp$_0.next();
        tmp$_1 = this.fileLinkers_0.get_11rb$(targetPath);
        if (tmp$_1 == null) {
          continue;
        }var targetFileLinker = tmp$_1;
        var targetPackage = this.get_cycleCheckPackageName_0(targetFileLinker);
        if (equals(targetPackage, sourcePackage) || !packages.contains_11rb$(targetPackage))
          continue;
        if (!equals(lastSourcePackage, sourcePackage) || !equals(lastTargetPackage, targetPackage)) {
          $receiver.append_pdl1vj$('\n' + '  ' + sourcePackage + ' imports ' + targetPackage);
          lastSourcePackage = sourcePackage;
          lastTargetPackage = targetPackage;
          lastSourcePath = null;
        }if (!equals(lastSourcePath, sourcePath)) {
          $receiver.append_pdl1vj$('\n' + '    ' + sourcePath + ':');
          lastSourcePath = sourcePath;
        }$receiver.append_pdl1vj$('\n' + '      import ' + '"' + targetPath + '"' + ';');
      }
    }
    return $receiver.toString();
  };
  CycleChecker.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CycleChecker',
    interfaces: []
  };
  function EnclosingType(location, type, documentation, nestedTypes, syntax) {
    Type.call(this);
    this.location_tikynk$_0 = location;
    this.type_qbc3rf$_0 = type;
    this.documentation_9q50h7$_0 = documentation;
    this.nestedTypes_up8mer$_0 = nestedTypes;
    this.syntax_d36j3y$_0 = syntax;
  }
  Object.defineProperty(EnclosingType.prototype, 'location', {
    get: function () {
      return this.location_tikynk$_0;
    }
  });
  Object.defineProperty(EnclosingType.prototype, 'type', {
    get: function () {
      return this.type_qbc3rf$_0;
    }
  });
  Object.defineProperty(EnclosingType.prototype, 'documentation', {
    get: function () {
      return this.documentation_9q50h7$_0;
    }
  });
  Object.defineProperty(EnclosingType.prototype, 'nestedTypes', {
    get: function () {
      return this.nestedTypes_up8mer$_0;
    }
  });
  Object.defineProperty(EnclosingType.prototype, 'syntax', {
    get: function () {
      return this.syntax_d36j3y$_0;
    }
  });
  Object.defineProperty(EnclosingType.prototype, 'options', {
    configurable: true,
    get: function () {
      return new Options(Options$Companion_getInstance().MESSAGE_OPTIONS, emptyList());
    }
  });
  EnclosingType.prototype.linkMembers_n5k2qc$ = function (linker) {
  };
  EnclosingType.prototype.linkOptions_tlzwp4$ = function (linker, syntaxRules, validate) {
    var tmp$;
    tmp$ = this.nestedTypes.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      element.linkOptions_tlzwp4$(linker, syntaxRules, validate);
    }
  };
  EnclosingType.prototype.validate_q5zjs1$ = function (linker, syntaxRules) {
    var tmp$;
    tmp$ = this.nestedTypes.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      element.validate_q5zjs1$(linker, syntaxRules);
    }
  };
  EnclosingType.prototype.retainAll_crjjl2$ = function (schema, markSet) {
    var $receiver = this.nestedTypes;
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0;
      if ((tmp$_0 = element.retainAll_crjjl2$(schema, markSet)) != null) {
        destination.add_11rb$(tmp$_0);
      }}
    var retainedNestedTypes = destination;
    if (retainedNestedTypes.isEmpty())
      return null;
    return new EnclosingType(this.location, this.type, this.documentation, retainedNestedTypes, this.syntax);
  };
  EnclosingType.prototype.retainLinked_d9h3fi$ = function (linkedTypes) {
    var $receiver = this.nestedTypes;
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0;
      if ((tmp$_0 = element.retainLinked_d9h3fi$(linkedTypes)) != null) {
        destination.add_11rb$(tmp$_0);
      }}
    var retainedNestedTypes = destination;
    if (retainedNestedTypes.isEmpty())
      return null;
    return new EnclosingType(this.location, this.type, this.documentation, retainedNestedTypes, this.syntax);
  };
  EnclosingType.prototype.toElement = function () {
    return new MessageElement(this.location, this.type.simpleName, void 0, Type$Companion_getInstance().toElements_qiljpy$(this.nestedTypes));
  };
  EnclosingType.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EnclosingType',
    interfaces: [Type]
  };
  EnclosingType.prototype.component1 = function () {
    return this.location;
  };
  EnclosingType.prototype.component2 = function () {
    return this.type;
  };
  EnclosingType.prototype.component3 = function () {
    return this.documentation;
  };
  EnclosingType.prototype.component4 = function () {
    return this.nestedTypes;
  };
  EnclosingType.prototype.component5 = function () {
    return this.syntax;
  };
  EnclosingType.prototype.copy_h9s5b4$ = function (location, type, documentation, nestedTypes, syntax) {
    return new EnclosingType(location === void 0 ? this.location : location, type === void 0 ? this.type : type, documentation === void 0 ? this.documentation : documentation, nestedTypes === void 0 ? this.nestedTypes : nestedTypes, syntax === void 0 ? this.syntax : syntax);
  };
  EnclosingType.prototype.toString = function () {
    return 'EnclosingType(location=' + Kotlin.toString(this.location) + (', type=' + Kotlin.toString(this.type)) + (', documentation=' + Kotlin.toString(this.documentation)) + (', nestedTypes=' + Kotlin.toString(this.nestedTypes)) + (', syntax=' + Kotlin.toString(this.syntax)) + ')';
  };
  EnclosingType.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.type) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.nestedTypes) | 0;
    result = result * 31 + Kotlin.hashCode(this.syntax) | 0;
    return result;
  };
  EnclosingType.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.type, other.type) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.nestedTypes, other.nestedTypes) && Kotlin.equals(this.syntax, other.syntax)))));
  };
  function EnumConstant(location, name, tag, documentation, options) {
    EnumConstant$Companion_getInstance();
    this.location = location;
    this.name = name;
    this.tag = tag;
    this.documentation = documentation;
    this.options = options;
  }
  Object.defineProperty(EnumConstant.prototype, 'isDeprecated', {
    configurable: true,
    get: function () {
      return equals('true', this.options.get_pnoc8b$(EnumConstant$Companion_getInstance().DEPRECATED_0));
    }
  });
  EnumConstant.prototype.toElement_8be2vx$ = function () {
    return new EnumConstantElement(this.location, this.name, this.tag, this.documentation, this.options.elements);
  };
  EnumConstant.prototype.linkOptions_e4ccz4$ = function (linker, validate) {
    var linker_0 = linker.withContext_za3rmp$(this);
    this.options.link_jszzr1$(linker_0, this.location, validate);
  };
  EnumConstant.prototype.retainAll_wuadq5$ = function (schema, markSet) {
    return new EnumConstant(this.location, this.name, this.tag, this.documentation, this.options.retainAll_crjjl2$(schema, markSet));
  };
  EnumConstant.prototype.retainLinked_8be2vx$ = function () {
    return new EnumConstant(this.location, this.name, this.tag, this.documentation, this.options.retainLinked());
  };
  function EnumConstant$Companion() {
    EnumConstant$Companion_instance = this;
    this.DEPRECATED_0 = ProtoMember$Companion_getInstance().get_bu2imf$(Options$Companion_getInstance().ENUM_VALUE_OPTIONS, 'deprecated');
  }
  EnumConstant$Companion.prototype.fromElements_3wyd9g$ = function (elements) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(elements, 10));
    var tmp$;
    tmp$ = elements.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(new EnumConstant(item.location, item.name, item.tag, item.documentation, new Options(Options$Companion_getInstance().ENUM_VALUE_OPTIONS, item.options)));
    }
    return destination;
  };
  EnumConstant$Companion.prototype.toElements_b67n5q$ = function (constants) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(constants, 10));
    var tmp$;
    tmp$ = constants.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(item.toElement_8be2vx$());
    }
    return destination;
  };
  EnumConstant$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var EnumConstant$Companion_instance = null;
  function EnumConstant$Companion_getInstance() {
    if (EnumConstant$Companion_instance === null) {
      new EnumConstant$Companion();
    }return EnumConstant$Companion_instance;
  }
  EnumConstant.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EnumConstant',
    interfaces: []
  };
  EnumConstant.prototype.component1 = function () {
    return this.location;
  };
  EnumConstant.prototype.component2 = function () {
    return this.name;
  };
  EnumConstant.prototype.component3 = function () {
    return this.tag;
  };
  EnumConstant.prototype.component4 = function () {
    return this.documentation;
  };
  EnumConstant.prototype.component5 = function () {
    return this.options;
  };
  EnumConstant.prototype.copy_d7ai7j$ = function (location, name, tag, documentation, options) {
    return new EnumConstant(location === void 0 ? this.location : location, name === void 0 ? this.name : name, tag === void 0 ? this.tag : tag, documentation === void 0 ? this.documentation : documentation, options === void 0 ? this.options : options);
  };
  EnumConstant.prototype.toString = function () {
    return 'EnumConstant(location=' + Kotlin.toString(this.location) + (', name=' + Kotlin.toString(this.name)) + (', tag=' + Kotlin.toString(this.tag)) + (', documentation=' + Kotlin.toString(this.documentation)) + (', options=' + Kotlin.toString(this.options)) + ')';
  };
  EnumConstant.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.tag) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    return result;
  };
  EnumConstant.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.tag, other.tag) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.options, other.options)))));
  };
  function EnumType(type, location, documentation, name, constants, options, syntax) {
    EnumType$Companion_getInstance();
    Type.call(this);
    this.type_dry31i$_0 = type;
    this.location_t2m3gh$_0 = location;
    this.documentation_jk92jq$_0 = documentation;
    this.name_0 = name;
    this.constants = constants;
    this.options_gq348y$_0 = options;
    this.syntax_t1znkh$_0 = syntax;
    this.allowAlias_0 = null;
  }
  Object.defineProperty(EnumType.prototype, 'type', {
    get: function () {
      return this.type_dry31i$_0;
    }
  });
  Object.defineProperty(EnumType.prototype, 'location', {
    get: function () {
      return this.location_t2m3gh$_0;
    }
  });
  Object.defineProperty(EnumType.prototype, 'documentation', {
    get: function () {
      return this.documentation_jk92jq$_0;
    }
  });
  Object.defineProperty(EnumType.prototype, 'options', {
    get: function () {
      return this.options_gq348y$_0;
    }
  });
  Object.defineProperty(EnumType.prototype, 'syntax', {
    get: function () {
      return this.syntax_t1znkh$_0;
    }
  });
  Object.defineProperty(EnumType.prototype, 'nestedTypes', {
    configurable: true,
    get: function () {
      return emptyList();
    }
  });
  EnumType.prototype.allowAlias = function () {
    return equals('true', this.allowAlias_0);
  };
  EnumType.prototype.constant_61zpoe$ = function (name) {
    var $receiver = this.constants;
    var firstOrNull$result;
    firstOrNull$break: do {
      var tmp$;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (equals(element.name, name)) {
          firstOrNull$result = element;
          break firstOrNull$break;
        }}
      firstOrNull$result = null;
    }
     while (false);
    return firstOrNull$result;
  };
  EnumType.prototype.constant_za3lpa$ = function (tag) {
    var $receiver = this.constants;
    var firstOrNull$result;
    firstOrNull$break: do {
      var tmp$;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (element.tag === tag) {
          firstOrNull$result = element;
          break firstOrNull$break;
        }}
      firstOrNull$result = null;
    }
     while (false);
    return firstOrNull$result;
  };
  EnumType.prototype.linkMembers_n5k2qc$ = function (linker) {
  };
  EnumType.prototype.linkOptions_tlzwp4$ = function (linker, syntaxRules, validate) {
    var tmp$;
    var linker_0 = linker.withContext_za3rmp$(this);
    this.options.link_jszzr1$(linker_0, this.location, validate);
    tmp$ = this.constants.iterator();
    while (tmp$.hasNext()) {
      var constant = tmp$.next();
      constant.linkOptions_e4ccz4$(linker_0, validate);
    }
    this.allowAlias_0 = this.options.get_pnoc8b$(EnumType$Companion_getInstance().ALLOW_ALIAS_8be2vx$);
  };
  EnumType.prototype.validate_q5zjs1$ = function (linker, syntaxRules) {
    var linker_0 = linker.withContext_za3rmp$(this);
    if (!equals('true', this.allowAlias_0)) {
      this.validateTagUniqueness_0(linker_0);
    }this.validateTagNameAmbiguity_0(equals('true', this.allowAlias_0), linker_0);
    syntaxRules.validateEnumConstants_swbzyz$(this.constants, linker_0.errors);
  };
  EnumType.prototype.validateTagNameAmbiguity_0 = function (allowAlias, linker) {
    var tmp$;
    var $receiver = this.constants;
    var destination = LinkedHashMap_init();
    var tmp$_0;
    tmp$_0 = $receiver.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      var $receiver_0 = StringBuilder_init_0(element.name.length);
      var tmp$_1;
      tmp$_1 = iterator(element.name);
      while (tmp$_1.hasNext()) {
        var char = unboxChar(tmp$_1.next());
        if ((new CharRange(65, 90)).contains_mef7kx$(char))
          $receiver_0.append_s8itvh$(toChar(char - -32));
        else
          $receiver_0.append_s8itvh$(char);
      }
      var key = $receiver_0.toString();
      var tmp$_0_0;
      var value = destination.get_11rb$(key);
      if (value == null) {
        var answer = ArrayList_init();
        destination.put_xwzc9p$(key, answer);
        tmp$_0_0 = answer;
      } else {
        tmp$_0_0 = value;
      }
      var list = tmp$_0_0;
      list.add_11rb$(element);
    }
    var nameToConstants = destination;
    tmp$ = nameToConstants.entries.iterator();
    while (tmp$.hasNext()) {
      var tmp$_2 = tmp$.next();
      var constants = tmp$_2.value;
      if (constants.size > 1) {
        var tmp$_3 = allowAlias;
        if (tmp$_3) {
          var destination_0 = LinkedHashMap_init();
          var tmp$_4;
          tmp$_4 = constants.iterator();
          while (tmp$_4.hasNext()) {
            var element_0 = tmp$_4.next();
            var key_0 = element_0.tag;
            var tmp$_0_1;
            var value_0 = destination_0.get_11rb$(key_0);
            if (value_0 == null) {
              var answer_0 = ArrayList_init();
              destination_0.put_xwzc9p$(key_0, answer_0);
              tmp$_0_1 = answer_0;
            } else {
              tmp$_0_1 = value_0;
            }
            var list_0 = tmp$_0_1;
            list_0.add_11rb$(element_0);
          }
          tmp$_3 = destination_0.size === 1;
        }if (tmp$_3)
          continue;
        var $receiver_1 = StringBuilder_init();
        $receiver_1.append_pdl1vj$('Ambiguous constant names (if you are using allow_alias, use the same value for ' + 'these constants):');
        var tmp$_5;
        tmp$_5 = constants.iterator();
        while (tmp$_5.hasNext()) {
          var element_1 = tmp$_5.next();
          $receiver_1.append_pdl1vj$('\n' + '  ' + element_1.name + ':' + element_1.tag + ' (' + element_1.location + ')');
        }
        var error = $receiver_1.toString();
        linker.errors.plusAssign_61zpoe$(error);
      }}
  };
  EnumType.prototype.validateTagUniqueness_0 = function (linker) {
    var tmp$;
    var tagToConstants = LinkedHashMap_init();
    var tmp$_0;
    tmp$_0 = this.constants.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      var key = element.tag;
      var tmp$_1;
      var value = tagToConstants.get_11rb$(key);
      if (value == null) {
        var answer = ArrayList_init();
        tagToConstants.put_xwzc9p$(key, answer);
        tmp$_1 = answer;
      } else {
        tmp$_1 = value;
      }
      tmp$_1.add_11rb$(element);
    }
    tmp$ = tagToConstants.entries.iterator();
    while (tmp$.hasNext()) {
      var tmp$_2 = tmp$.next();
      var tag = tmp$_2.key;
      var constants = tmp$_2.value;
      if (constants.size > 1) {
        var $receiver = StringBuilder_init();
        $receiver.append_pdl1vj$('multiple enum constants share tag ' + tag + ':');
        var tmp$_3, tmp$_0_0;
        var index = 0;
        tmp$_3 = constants.iterator();
        while (tmp$_3.hasNext()) {
          var item = tmp$_3.next();
          $receiver.append_pdl1vj$('\n' + '  ' + (checkIndexOverflow((tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0)) + 1 | 0) + '. ' + item.name + ' (' + item.location + ')');
        }
        var error = $receiver.toString();
        linker.errors.plusAssign_61zpoe$(error);
      }}
  };
  EnumType.prototype.retainAll_crjjl2$ = function (schema, markSet) {
    if (!markSet.contains_rubud1$(this.type))
      return null;
    var $receiver = this.constants;
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      if (markSet.contains_pnoc8b$(ProtoMember$Companion_getInstance().get_bu2imf$(this.type, element.name)))
        destination.add_11rb$(element);
    }
    var destination_0 = ArrayList_init_0(collectionSizeOrDefault(destination, 10));
    var tmp$_0;
    tmp$_0 = destination.iterator();
    while (tmp$_0.hasNext()) {
      var item = tmp$_0.next();
      destination_0.add_11rb$(item.retainAll_wuadq5$(schema, markSet));
    }
    var retainedConstants = destination_0;
    var result = new EnumType(this.type, this.location, this.documentation, this.name_0, retainedConstants, this.options.retainAll_crjjl2$(schema, markSet), this.syntax);
    result.allowAlias_0 = this.allowAlias_0;
    return result;
  };
  EnumType.prototype.retainLinked_d9h3fi$ = function (linkedTypes) {
    if (!linkedTypes.contains_11rb$(this.type)) {
      return null;
    }var $receiver = this.constants;
    var destination = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(item.retainLinked_8be2vx$());
    }
    var retainedConstants = destination;
    return new EnumType(this.type, this.location, this.documentation, this.name_0, retainedConstants, this.options.retainLinked(), this.syntax);
  };
  EnumType.prototype.toElement = function () {
    return new EnumElement(this.location, this.name_0, this.documentation, this.options.elements, EnumConstant$Companion_getInstance().toElements_b67n5q$(this.constants));
  };
  function EnumType$Companion() {
    EnumType$Companion_instance = this;
    this.ALLOW_ALIAS_8be2vx$ = ProtoMember$Companion_getInstance().get_bu2imf$(Options$Companion_getInstance().ENUM_OPTIONS, 'allow_alias');
  }
  EnumType$Companion.prototype.fromElement_m3ep60$ = function (protoType, enumElement, syntax) {
    return new EnumType(protoType, enumElement.location, enumElement.documentation, enumElement.name, EnumConstant$Companion_getInstance().fromElements_3wyd9g$(enumElement.constants), new Options(Options$Companion_getInstance().ENUM_OPTIONS, enumElement.options), syntax);
  };
  EnumType$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var EnumType$Companion_instance = null;
  function EnumType$Companion_getInstance() {
    if (EnumType$Companion_instance === null) {
      new EnumType$Companion();
    }return EnumType$Companion_instance;
  }
  EnumType.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EnumType',
    interfaces: [Type]
  };
  EnumType.prototype.component1 = function () {
    return this.type;
  };
  EnumType.prototype.component2 = function () {
    return this.location;
  };
  EnumType.prototype.component3 = function () {
    return this.documentation;
  };
  EnumType.prototype.component4_0 = function () {
    return this.name_0;
  };
  EnumType.prototype.component5 = function () {
    return this.constants;
  };
  EnumType.prototype.component6 = function () {
    return this.options;
  };
  EnumType.prototype.component7 = function () {
    return this.syntax;
  };
  EnumType.prototype.copy_8puitw$ = function (type, location, documentation, name, constants, options, syntax) {
    return new EnumType(type === void 0 ? this.type : type, location === void 0 ? this.location : location, documentation === void 0 ? this.documentation : documentation, name === void 0 ? this.name_0 : name, constants === void 0 ? this.constants : constants, options === void 0 ? this.options : options, syntax === void 0 ? this.syntax : syntax);
  };
  EnumType.prototype.toString = function () {
    return 'EnumType(type=' + Kotlin.toString(this.type) + (', location=' + Kotlin.toString(this.location)) + (', documentation=' + Kotlin.toString(this.documentation)) + (', name=' + Kotlin.toString(this.name_0)) + (', constants=' + Kotlin.toString(this.constants)) + (', options=' + Kotlin.toString(this.options)) + (', syntax=' + Kotlin.toString(this.syntax)) + ')';
  };
  EnumType.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.type) | 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.name_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.constants) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    result = result * 31 + Kotlin.hashCode(this.syntax) | 0;
    return result;
  };
  EnumType.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.type, other.type) && Kotlin.equals(this.location, other.location) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.name_0, other.name_0) && Kotlin.equals(this.constants, other.constants) && Kotlin.equals(this.options, other.options) && Kotlin.equals(this.syntax, other.syntax)))));
  };
  function ErrorCollector() {
    this.errors_0 = null;
    this.contextStack_0 = null;
  }
  ErrorCollector.prototype.at_za3rmp$ = function (additionalContext) {
    return ErrorCollector_init_0(this, plus_0(this.contextStack_0, additionalContext));
  };
  function ErrorCollector$plusAssign$lambda(it) {
    return Kotlin.isType(it, ProtoFile);
  }
  ErrorCollector.prototype.plusAssign_61zpoe$ = function (message) {
    var tmp$;
    var error = StringBuilder_init();
    error.append_pdl1vj$(message);
    var contextStack = toMutableList(this.contextStack_0);
    var any$result;
    any$break: do {
      var tmp$_0;
      if (Kotlin.isType(contextStack, Collection) && contextStack.isEmpty()) {
        any$result = false;
        break any$break;
      }tmp$_0 = contextStack.iterator();
      while (tmp$_0.hasNext()) {
        var element = tmp$_0.next();
        if (!Kotlin.isType(element, ProtoFile)) {
          any$result = true;
          break any$break;
        }}
      any$result = false;
    }
     while (false);
    if (any$result) {
      removeAll(contextStack, ErrorCollector$plusAssign$lambda);
    }tmp$ = reversed(get_indices(contextStack)).iterator();
    while (tmp$.hasNext()) {
      var i = tmp$.next();
      var context = contextStack.get_za3lpa$(i);
      var prefix = i === (contextStack.size - 1 | 0) ? '\n  for' : '\n  in';
      if (Kotlin.isType(context, Rpc))
        error.append_pdl1vj$(prefix + ' rpc ' + context.name + ' (' + context.location + ')');
      else if (Kotlin.isType(context, Field))
        error.append_pdl1vj$(prefix + ' field ' + context.name + ' (' + context.location + ')');
      else if (Kotlin.isType(context, MessageType))
        error.append_pdl1vj$(prefix + ' message ' + context.type + ' (' + context.location + ')');
      else if (Kotlin.isType(context, EnumConstant))
        error.append_pdl1vj$(prefix + ' constant ' + context.name + ' (' + context.location + ')');
      else if (Kotlin.isType(context, EnumType))
        error.append_pdl1vj$(prefix + ' enum ' + context.type + ' (' + context.location + ')');
      else if (Kotlin.isType(context, Service))
        error.append_pdl1vj$(prefix + ' service ' + context.type + ' (' + context.location + ')');
      else if (Kotlin.isType(context, Extensions))
        error.append_pdl1vj$(prefix + ' extensions (' + context.location + ')');
      else if (Kotlin.isType(context, ProtoFile))
        error.append_pdl1vj$(prefix + ' file ' + context.location);
      else if (Kotlin.isType(context, Extend))
        if (context.type != null) {
          error.append_pdl1vj$(prefix + ' extend ' + toString(context.type) + ' (' + context.location + ')');
        } else {
          error.append_pdl1vj$(prefix + ' extend (' + context.location + ')');
        }
    }
    var $receiver = this.errors_0;
    var element_0 = error.toString();
    $receiver.add_11rb$(element_0);
  };
  ErrorCollector.prototype.throwIfNonEmpty = function () {
    if (!this.errors_0.isEmpty()) {
      throw new SchemaException(this.errors_0);
    }};
  ErrorCollector.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ErrorCollector',
    interfaces: []
  };
  function ErrorCollector_init($this) {
    $this = $this || Object.create(ErrorCollector.prototype);
    ErrorCollector.call($this);
    $this.errors_0 = ArrayList_init();
    $this.contextStack_0 = emptyList();
    return $this;
  }
  function ErrorCollector_init_0(enclosing, contextStack, $this) {
    $this = $this || Object.create(ErrorCollector.prototype);
    ErrorCollector.call($this);
    $this.errors_0 = enclosing.errors_0;
    $this.contextStack_0 = contextStack;
    return $this;
  }
  function Extend(location, documentation, name, fields) {
    Extend$Companion_getInstance();
    this.location = location;
    this.documentation = documentation;
    this.name = name;
    this.fields = fields;
    this.type_1wxh09$_0 = null;
  }
  Object.defineProperty(Extend.prototype, 'type', {
    configurable: true,
    get: function () {
      return this.type_1wxh09$_0;
    },
    set: function (type) {
      this.type_1wxh09$_0 = type;
    }
  });
  Extend.prototype.link_n5k2qc$ = function (linker) {
    var tmp$, tmp$_0;
    var linker_0 = linker.withContext_za3rmp$(this);
    this.type = linker_0.resolveMessageType_61zpoe$(this.name);
    var type = linker_0.get_rubud1$(ensureNotNull(this.type));
    if (type != null) {
      (Kotlin.isType(tmp$ = type, MessageType) ? tmp$ : throwCCE()).addExtensionFields_nh6en2$(this.fields);
    }tmp$_0 = this.fields.iterator();
    while (tmp$_0.hasNext()) {
      var field = tmp$_0.next();
      field.link_n5k2qc$(linker_0);
    }
  };
  Extend.prototype.linkOptions_tlzwp4$ = function (linker, syntaxRules, validate) {
    var tmp$;
    var linker_0 = linker.withContext_za3rmp$(this);
    tmp$ = this.fields.iterator();
    while (tmp$.hasNext()) {
      var field = tmp$.next();
      field.linkOptions_tlzwp4$(linker_0, syntaxRules, validate);
    }
  };
  Extend.prototype.validate_q5zjs1$ = function (linker, syntaxRules) {
    var linker_0 = linker.withContext_za3rmp$(this);
    linker_0.validateImportForType_bi6gv$(this.location, ensureNotNull(this.type));
    syntaxRules.validateExtension_5bayw5$(ProtoType$Companion_getInstance().get_pdl1vj$(this.name), linker_0.errors);
  };
  Extend.prototype.retainAll_crjjl2$ = function (schema, markSet) {
    var retainedFields = Field$Companion_getInstance().retainAll_5bk9gv$(schema, markSet, ensureNotNull(this.type), this.fields);
    if (retainedFields.isEmpty())
      return null;
    var result = new Extend(this.location, this.documentation, this.name, retainedFields);
    result.type = this.type;
    return result;
  };
  Extend.prototype.retainLinked_hclq1m$ = function (linkedFields) {
    var $receiver = this.fields;
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      if (linkedFields.contains_11rb$(element))
        destination.add_11rb$(element);
    }
    var retainedFields = destination;
    if (retainedFields.isEmpty())
      return null;
    var result = new Extend(this.location, this.documentation, this.name, retainedFields);
    result.type = this.type;
    return result;
  };
  function Extend$Companion() {
    Extend$Companion_instance = this;
  }
  Extend$Companion.prototype.fromElements_m6gyht$ = function (packageName, extendElements) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(extendElements, 10));
    var tmp$;
    tmp$ = extendElements.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(new Extend(item.location, item.documentation, item.name, Field$Companion_getInstance().fromElements_az8v47$(packageName, item.fields, true, false)));
    }
    return destination;
  };
  Extend$Companion.prototype.toElements_a4ss5m$ = function (extendList) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(extendList, 10));
    var tmp$;
    tmp$ = extendList.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(new ExtendElement(item.location, item.name, item.documentation, Field$Companion_getInstance().toElements_nh6en2$(item.fields)));
    }
    return destination;
  };
  Extend$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Extend$Companion_instance = null;
  function Extend$Companion_getInstance() {
    if (Extend$Companion_instance === null) {
      new Extend$Companion();
    }return Extend$Companion_instance;
  }
  Extend.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Extend',
    interfaces: []
  };
  Extend.prototype.component1 = function () {
    return this.location;
  };
  Extend.prototype.component2 = function () {
    return this.documentation;
  };
  Extend.prototype.component3 = function () {
    return this.name;
  };
  Extend.prototype.component4 = function () {
    return this.fields;
  };
  Extend.prototype.copy_xhflxg$ = function (location, documentation, name, fields) {
    return new Extend(location === void 0 ? this.location : location, documentation === void 0 ? this.documentation : documentation, name === void 0 ? this.name : name, fields === void 0 ? this.fields : fields);
  };
  Extend.prototype.toString = function () {
    return 'Extend(location=' + Kotlin.toString(this.location) + (', documentation=' + Kotlin.toString(this.documentation)) + (', name=' + Kotlin.toString(this.name)) + (', fields=' + Kotlin.toString(this.fields)) + ')';
  };
  Extend.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.fields) | 0;
    return result;
  };
  Extend.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.fields, other.fields)))));
  };
  function Extensions(location, documentation, values) {
    Extensions$Companion_getInstance();
    this.location = location;
    this.documentation = documentation;
    this.values = values;
  }
  Extensions.prototype.validate_n5k2qc$ = function (linker) {
    var linker_0 = linker.withContext_za3rmp$(this);
    var outOfRangeTags = ArrayList_init();
    var tmp$;
    tmp$ = this.values.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      if (typeof element === 'number') {
        if (!isValidTag(element)) {
          outOfRangeTags.add_11rb$(element.toString());
        }} else if (Kotlin.isType(element, IntRange)) {
        if (!isValidTag(element.first) || !isValidTag(element.last)) {
          outOfRangeTags.add_11rb$(element.first.toString() + ' to ' + element.last);
        }} else
        throw AssertionError_init();
    }
    if (!outOfRangeTags.isEmpty()) {
      linker_0.errors.plusAssign_61zpoe$('tags are out of range: ' + joinToString(outOfRangeTags, ', '));
    }};
  function Extensions$Companion() {
    Extensions$Companion_instance = this;
  }
  Extensions$Companion.prototype.fromElements_ku6uku$ = function (elements) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(elements, 10));
    var tmp$;
    tmp$ = elements.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(new Extensions(item.location, item.documentation, item.values));
    }
    return destination;
  };
  Extensions$Companion.prototype.toElements_j9g6a8$ = function (extensions) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(extensions, 10));
    var tmp$;
    tmp$ = extensions.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(new ExtensionsElement(item.location, item.documentation, item.values));
    }
    return destination;
  };
  Extensions$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Extensions$Companion_instance = null;
  function Extensions$Companion_getInstance() {
    if (Extensions$Companion_instance === null) {
      new Extensions$Companion();
    }return Extensions$Companion_instance;
  }
  Extensions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Extensions',
    interfaces: []
  };
  Extensions.prototype.component1 = function () {
    return this.location;
  };
  Extensions.prototype.component2 = function () {
    return this.documentation;
  };
  Extensions.prototype.component3 = function () {
    return this.values;
  };
  Extensions.prototype.copy_hncgv0$ = function (location, documentation, values) {
    return new Extensions(location === void 0 ? this.location : location, documentation === void 0 ? this.documentation : documentation, values === void 0 ? this.values : values);
  };
  Extensions.prototype.toString = function () {
    return 'Extensions(location=' + Kotlin.toString(this.location) + (', documentation=' + Kotlin.toString(this.documentation)) + (', values=' + Kotlin.toString(this.values)) + ')';
  };
  Extensions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.values) | 0;
    return result;
  };
  Extensions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.values, other.values)))));
  };
  function Field(packageName, location, label, name, documentation, tag, default_0, elementType, options, isExtension, isOneOf, declaredJsonName) {
    Field$Companion_getInstance();
    this.packageName = packageName;
    this.location = location;
    this.label_0 = label;
    this.name = name;
    this.documentation = documentation;
    this.tag = tag;
    this.default = default_0;
    this.elementType_0 = elementType;
    this.options = options;
    this.isExtension = isExtension;
    this.isOneOf = isOneOf;
    this.declaredJsonName = declaredJsonName;
    this.type_jvlvsx$_0 = null;
    this.deprecated_0 = null;
    this.isRedacted_g68pxt$_0 = false;
    this.encodeMode_sed1s0$_0 = null;
    this.jsonName_mexnnq$_0 = null;
  }
  Object.defineProperty(Field.prototype, 'type', {
    configurable: true,
    get: function () {
      return this.type_jvlvsx$_0;
    },
    set: function (type) {
      this.type_jvlvsx$_0 = type;
    }
  });
  Object.defineProperty(Field.prototype, 'isRedacted', {
    configurable: true,
    get: function () {
      return this.isRedacted_g68pxt$_0;
    },
    set: function (isRedacted) {
      this.isRedacted_g68pxt$_0 = isRedacted;
    }
  });
  Object.defineProperty(Field.prototype, 'isRepeated', {
    configurable: true,
    get: function () {
      return equals(this.label_0, Field$Label$REPEATED_getInstance());
    }
  });
  Object.defineProperty(Field.prototype, 'isRequired', {
    configurable: true,
    get: function () {
      return equals(this.encodeMode, Field$EncodeMode$REQUIRED_getInstance());
    }
  });
  Object.defineProperty(Field.prototype, 'encodeMode', {
    configurable: true,
    get: function () {
      return this.encodeMode_sed1s0$_0;
    },
    set: function (encodeMode) {
      this.encodeMode_sed1s0$_0 = encodeMode;
    }
  });
  Object.defineProperty(Field.prototype, 'qualifiedName', {
    configurable: true,
    get: function () {
      var tmp$;
      if (this.packageName != null)
        tmp$ = toString(this.packageName) + '.' + this.name;
      else
        tmp$ = this.name;
      return tmp$;
    }
  });
  Object.defineProperty(Field.prototype, 'isDeprecated', {
    configurable: true,
    get: function () {
      return equals('true', this.deprecated_0);
    }
  });
  Object.defineProperty(Field.prototype, 'isPacked', {
    configurable: true,
    get: function () {
      return equals(this.encodeMode, Field$EncodeMode$PACKED_getInstance());
    }
  });
  Object.defineProperty(Field.prototype, 'jsonName', {
    configurable: true,
    get: function () {
      return this.jsonName_mexnnq$_0;
    },
    set: function (jsonName) {
      this.jsonName_mexnnq$_0 = jsonName;
    }
  });
  Object.defineProperty(Field.prototype, 'member', {
    configurable: true,
    get: function () {
      return ProtoMember$Companion_getInstance().get_uige6c$(ensureNotNull(this.type), this);
    }
  });
  Field.prototype.isPackable_0 = function (linker, type) {
    return !(type != null ? type.equals(ProtoType$Companion_getInstance().STRING) : null) && !(type != null ? type.equals(ProtoType$Companion_getInstance().BYTES) : null) && !Kotlin.isType(linker.get_rubud1$(type), MessageType);
  };
  Field.prototype.link_n5k2qc$ = function (linker) {
    this.type = linker.withContext_za3rmp$(this).resolveType_61zpoe$(this.elementType_0);
  };
  Field.prototype.linkOptions_tlzwp4$ = function (linker, syntaxRules, validate) {
    var tmp$;
    var linker_0 = linker.withContext_za3rmp$(this);
    this.options.link_jszzr1$(linker_0, this.location, validate);
    this.deprecated_0 = this.options.get_pnoc8b$(Field$Companion_getInstance().DEPRECATED_8be2vx$);
    var packed = (tmp$ = this.options.get_pnoc8b$(Field$Companion_getInstance().PACKED_8be2vx$)) != null ? tmp$ : syntaxRules.isPackedByDefault_s7v6az$(ensureNotNull(this.type), this.label_0) ? OptionElement$Companion_getInstance().PACKED_OPTION_ELEMENT_8be2vx$.value : null;
    this.isRedacted = this.options.optionMatches_puj7f4$('.*\\.redacted', 'true');
    this.encodeMode = syntaxRules.getEncodeMode_t06gl$(ensureNotNull(this.type), this.label_0, equals(packed, 'true'), this.isOneOf);
    this.jsonName = syntaxRules.jsonName_jyasbz$(this.name, this.declaredJsonName);
  };
  Field.prototype.validate_q5zjs1$ = function (linker, syntaxRules) {
    var linker_0 = linker.withContext_za3rmp$(this);
    if (this.isPacked && !this.isPackable_0(linker_0, ensureNotNull(this.type))) {
      linker_0.errors.plusAssign_61zpoe$('packed=true not permitted on ' + toString(this.type));
    }if (this.isExtension) {
      if (this.isRequired) {
        linker_0.errors.plusAssign_61zpoe$('extension fields cannot be required');
      }if (ensureNotNull(this.type).isMap) {
        linker_0.errors.plusAssign_61zpoe$('extension fields cannot be a map');
      }}syntaxRules.validateDefaultValue_gt3kov$(this.default != null, linker_0.errors);
    if (ensureNotNull(this.type).isMap) {
      var valueType = linker_0.get_rubud1$(ensureNotNull(ensureNotNull(this.type).valueType));
      if (Kotlin.isType(valueType, EnumType) && valueType.constants.get_za3lpa$(0).tag !== 0) {
        linker_0.errors.plusAssign_61zpoe$('enum value in map must define 0 as the first value');
      }}linker_0.validateImportForType_bi6gv$(this.location, ensureNotNull(this.type));
  };
  Field.prototype.retainAll_osl9ff$ = function (schema, markSet, enclosingType) {
    var tmp$;
    tmp$ = this.type;
    if (tmp$ == null) {
      return null;
    }var type = tmp$;
    if (type.isMap && !markSet.contains_rubud1$(ensureNotNull(type.valueType)))
      return null;
    if (!markSet.contains_rubud1$(type))
      return null;
    var memberName = this.isExtension ? this.qualifiedName : this.name;
    var protoMember = ProtoMember$Companion_getInstance().get_bu2imf$(enclosingType, memberName);
    if (!markSet.contains_pnoc8b$(protoMember) && !(contains(Options$Companion_getInstance().GOOGLE_PROTOBUF_OPTION_TYPES, enclosingType) && !this.isExtension))
      return null;
    return this.withOptions_0(this.options.retainAll_crjjl2$(schema, markSet));
  };
  Field.prototype.withOptions_0 = function (options) {
    var result = new Field(this.packageName, this.location, this.label_0, this.name, this.documentation, this.tag, this.default, this.elementType_0, options, this.isExtension, this.isOneOf, this.declaredJsonName);
    result.type = this.type;
    result.deprecated_0 = this.deprecated_0;
    result.encodeMode = this.encodeMode;
    result.isRedacted = this.isRedacted;
    result.jsonName = this.jsonName;
    return result;
  };
  Field.prototype.toString = function () {
    return this.name;
  };
  function Field$Label(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Field$Label_initFields() {
    Field$Label_initFields = function () {
    };
    Field$Label$OPTIONAL_instance = new Field$Label('OPTIONAL', 0);
    Field$Label$REQUIRED_instance = new Field$Label('REQUIRED', 1);
    Field$Label$REPEATED_instance = new Field$Label('REPEATED', 2);
    Field$Label$ONE_OF_instance = new Field$Label('ONE_OF', 3);
  }
  var Field$Label$OPTIONAL_instance;
  function Field$Label$OPTIONAL_getInstance() {
    Field$Label_initFields();
    return Field$Label$OPTIONAL_instance;
  }
  var Field$Label$REQUIRED_instance;
  function Field$Label$REQUIRED_getInstance() {
    Field$Label_initFields();
    return Field$Label$REQUIRED_instance;
  }
  var Field$Label$REPEATED_instance;
  function Field$Label$REPEATED_getInstance() {
    Field$Label_initFields();
    return Field$Label$REPEATED_instance;
  }
  var Field$Label$ONE_OF_instance;
  function Field$Label$ONE_OF_getInstance() {
    Field$Label_initFields();
    return Field$Label$ONE_OF_instance;
  }
  Field$Label.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Label',
    interfaces: [Enum]
  };
  function Field$Label$values() {
    return [Field$Label$OPTIONAL_getInstance(), Field$Label$REQUIRED_getInstance(), Field$Label$REPEATED_getInstance(), Field$Label$ONE_OF_getInstance()];
  }
  Field$Label.values = Field$Label$values;
  function Field$Label$valueOf(name) {
    switch (name) {
      case 'OPTIONAL':
        return Field$Label$OPTIONAL_getInstance();
      case 'REQUIRED':
        return Field$Label$REQUIRED_getInstance();
      case 'REPEATED':
        return Field$Label$REPEATED_getInstance();
      case 'ONE_OF':
        return Field$Label$ONE_OF_getInstance();
      default:throwISE('No enum constant com.squareup.wire.schema.Field.Label.' + name);
    }
  }
  Field$Label.valueOf_61zpoe$ = Field$Label$valueOf;
  function Field$EncodeMode(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Field$EncodeMode_initFields() {
    Field$EncodeMode_initFields = function () {
    };
    Field$EncodeMode$NULL_IF_ABSENT_instance = new Field$EncodeMode('NULL_IF_ABSENT', 0);
    Field$EncodeMode$REQUIRED_instance = new Field$EncodeMode('REQUIRED', 1);
    Field$EncodeMode$OMIT_IDENTITY_instance = new Field$EncodeMode('OMIT_IDENTITY', 2);
    Field$EncodeMode$REPEATED_instance = new Field$EncodeMode('REPEATED', 3);
    Field$EncodeMode$PACKED_instance = new Field$EncodeMode('PACKED', 4);
    Field$EncodeMode$MAP_instance = new Field$EncodeMode('MAP', 5);
  }
  var Field$EncodeMode$NULL_IF_ABSENT_instance;
  function Field$EncodeMode$NULL_IF_ABSENT_getInstance() {
    Field$EncodeMode_initFields();
    return Field$EncodeMode$NULL_IF_ABSENT_instance;
  }
  var Field$EncodeMode$REQUIRED_instance;
  function Field$EncodeMode$REQUIRED_getInstance() {
    Field$EncodeMode_initFields();
    return Field$EncodeMode$REQUIRED_instance;
  }
  var Field$EncodeMode$OMIT_IDENTITY_instance;
  function Field$EncodeMode$OMIT_IDENTITY_getInstance() {
    Field$EncodeMode_initFields();
    return Field$EncodeMode$OMIT_IDENTITY_instance;
  }
  var Field$EncodeMode$REPEATED_instance;
  function Field$EncodeMode$REPEATED_getInstance() {
    Field$EncodeMode_initFields();
    return Field$EncodeMode$REPEATED_instance;
  }
  var Field$EncodeMode$PACKED_instance;
  function Field$EncodeMode$PACKED_getInstance() {
    Field$EncodeMode_initFields();
    return Field$EncodeMode$PACKED_instance;
  }
  var Field$EncodeMode$MAP_instance;
  function Field$EncodeMode$MAP_getInstance() {
    Field$EncodeMode_initFields();
    return Field$EncodeMode$MAP_instance;
  }
  Field$EncodeMode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EncodeMode',
    interfaces: [Enum]
  };
  function Field$EncodeMode$values() {
    return [Field$EncodeMode$NULL_IF_ABSENT_getInstance(), Field$EncodeMode$REQUIRED_getInstance(), Field$EncodeMode$OMIT_IDENTITY_getInstance(), Field$EncodeMode$REPEATED_getInstance(), Field$EncodeMode$PACKED_getInstance(), Field$EncodeMode$MAP_getInstance()];
  }
  Field$EncodeMode.values = Field$EncodeMode$values;
  function Field$EncodeMode$valueOf(name) {
    switch (name) {
      case 'NULL_IF_ABSENT':
        return Field$EncodeMode$NULL_IF_ABSENT_getInstance();
      case 'REQUIRED':
        return Field$EncodeMode$REQUIRED_getInstance();
      case 'OMIT_IDENTITY':
        return Field$EncodeMode$OMIT_IDENTITY_getInstance();
      case 'REPEATED':
        return Field$EncodeMode$REPEATED_getInstance();
      case 'PACKED':
        return Field$EncodeMode$PACKED_getInstance();
      case 'MAP':
        return Field$EncodeMode$MAP_getInstance();
      default:throwISE('No enum constant com.squareup.wire.schema.Field.EncodeMode.' + name);
    }
  }
  Field$EncodeMode.valueOf_61zpoe$ = Field$EncodeMode$valueOf;
  function Field$Companion() {
    Field$Companion_instance = this;
    this.DEPRECATED_8be2vx$ = ProtoMember$Companion_getInstance().get_bu2imf$(Options$Companion_getInstance().FIELD_OPTIONS, 'deprecated');
    this.PACKED_8be2vx$ = ProtoMember$Companion_getInstance().get_bu2imf$(Options$Companion_getInstance().FIELD_OPTIONS, 'packed');
  }
  Field$Companion.prototype.fromElements_az8v47$ = function (packageName, fieldElements, extension, oneOf) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(fieldElements, 10));
    var tmp$;
    tmp$ = fieldElements.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(new Field(packageName, item.location, item.label, item.name, item.documentation, item.tag, item.defaultValue, item.type, new Options(Options$Companion_getInstance().FIELD_OPTIONS, item.options), extension, oneOf, item.jsonName));
    }
    return destination;
  };
  Field$Companion.prototype.toElements_nh6en2$ = function (fields) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(fields, 10));
    var tmp$;
    tmp$ = fields.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(new FieldElement(item.location, item.label_0, item.elementType_0, item.name, item.default, item.declaredJsonName, item.tag, item.documentation, item.options.elements));
    }
    return destination;
  };
  Field$Companion.prototype.retainLinked_nh6en2$ = function (fields) {
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = fields.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      if (element.type != null)
        destination.add_11rb$(element);
    }
    var destination_0 = ArrayList_init_0(collectionSizeOrDefault(destination, 10));
    var tmp$_0;
    tmp$_0 = destination.iterator();
    while (tmp$_0.hasNext()) {
      var item = tmp$_0.next();
      destination_0.add_11rb$(item.withOptions_0(item.options.retainLinked()));
    }
    return destination_0;
  };
  Field$Companion.prototype.retainAll_5bk9gv$ = function (schema, markSet, enclosingType, fields) {
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = fields.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0;
      if ((tmp$_0 = element.retainAll_osl9ff$(schema, markSet, enclosingType)) != null) {
        destination.add_11rb$(tmp$_0);
      }}
    return destination;
  };
  Field$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Field$Companion_instance = null;
  function Field$Companion_getInstance() {
    if (Field$Companion_instance === null) {
      new Field$Companion();
    }return Field$Companion_instance;
  }
  Field.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Field',
    interfaces: []
  };
  Field.prototype.component1 = function () {
    return this.packageName;
  };
  Field.prototype.component2 = function () {
    return this.location;
  };
  Field.prototype.component3_0 = function () {
    return this.label_0;
  };
  Field.prototype.component4 = function () {
    return this.name;
  };
  Field.prototype.component5 = function () {
    return this.documentation;
  };
  Field.prototype.component6 = function () {
    return this.tag;
  };
  Field.prototype.component7 = function () {
    return this.default;
  };
  Field.prototype.component8_0 = function () {
    return this.elementType_0;
  };
  Field.prototype.component9 = function () {
    return this.options;
  };
  Field.prototype.component10 = function () {
    return this.isExtension;
  };
  Field.prototype.component11 = function () {
    return this.isOneOf;
  };
  Field.prototype.component12 = function () {
    return this.declaredJsonName;
  };
  Field.prototype.copy_df5gmc$ = function (packageName, location, label, name, documentation, tag, default_0, elementType, options, isExtension, isOneOf, declaredJsonName) {
    return new Field(packageName === void 0 ? this.packageName : packageName, location === void 0 ? this.location : location, label === void 0 ? this.label_0 : label, name === void 0 ? this.name : name, documentation === void 0 ? this.documentation : documentation, tag === void 0 ? this.tag : tag, default_0 === void 0 ? this.default : default_0, elementType === void 0 ? this.elementType_0 : elementType, options === void 0 ? this.options : options, isExtension === void 0 ? this.isExtension : isExtension, isOneOf === void 0 ? this.isOneOf : isOneOf, declaredJsonName === void 0 ? this.declaredJsonName : declaredJsonName);
  };
  Field.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.packageName) | 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.label_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.tag) | 0;
    result = result * 31 + Kotlin.hashCode(this.default) | 0;
    result = result * 31 + Kotlin.hashCode(this.elementType_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    result = result * 31 + Kotlin.hashCode(this.isExtension) | 0;
    result = result * 31 + Kotlin.hashCode(this.isOneOf) | 0;
    result = result * 31 + Kotlin.hashCode(this.declaredJsonName) | 0;
    return result;
  };
  Field.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.packageName, other.packageName) && Kotlin.equals(this.location, other.location) && Kotlin.equals(this.label_0, other.label_0) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.tag, other.tag) && Kotlin.equals(this.default, other.default) && Kotlin.equals(this.elementType_0, other.elementType_0) && Kotlin.equals(this.options, other.options) && Kotlin.equals(this.isExtension, other.isExtension) && Kotlin.equals(this.isOneOf, other.isOneOf) && Kotlin.equals(this.declaredJsonName, other.declaredJsonName)))));
  };
  function FileLinker(protoFile, linker) {
    this.protoFile = protoFile;
    this.linker_0 = linker;
    this.effectiveImports_0 = null;
    this.typesRegistered_0 = false;
    this.extensionsLinked_0 = false;
    this.importedExtensionsRegistered_0 = false;
    this.extensionOptionsLinked_0 = false;
    this.importedExtensionOptionsLinked_0 = false;
    this.fileOptionsLinked_0 = false;
    this.typesWithMembersLinked_0 = LinkedHashSet_init();
  }
  FileLinker.prototype.effectiveImports = function () {
    if (this.effectiveImports_0 == null) {
      var sink = LinkedHashSet_init();
      this.addImportsRecursive_0(sink, this.protoFile.imports);
      this.addImportsRecursive_0(sink, this.protoFile.publicImports);
      this.effectiveImports_0 = LinkedHashSet_init_0(sink);
    }return ensureNotNull(this.effectiveImports_0);
  };
  FileLinker.prototype.addImportsRecursive_0 = function (sink, paths) {
    var tmp$;
    tmp$ = paths.iterator();
    while (tmp$.hasNext()) {
      var path = tmp$.next();
      if (sink.add_11rb$(path)) {
        var fileLinker = this.linker_0.getFileLinker_y4putb$(path);
        this.addImportsRecursive_0(sink, fileLinker.protoFile.publicImports);
      }}
  };
  FileLinker.prototype.requireTypesRegistered = function () {
    var tmp$;
    if (this.typesRegistered_0)
      return;
    this.typesRegistered_0 = true;
    tmp$ = this.protoFile.types.iterator();
    while (tmp$.hasNext()) {
      var type = tmp$.next();
      this.addTypes_0(type);
    }
  };
  FileLinker.prototype.addTypes_0 = function (type) {
    var tmp$;
    this.linker_0.addType_hc7hzk$(type.type, type);
    tmp$ = type.nestedTypes.iterator();
    while (tmp$.hasNext()) {
      var nestedType = tmp$.next();
      this.addTypes_0(nestedType);
    }
  };
  FileLinker.prototype.requireExtensionsLinked = function () {
    var tmp$;
    if (this.extensionsLinked_0)
      return;
    this.extensionsLinked_0 = true;
    this.requireTypesRegistered();
    tmp$ = this.protoFile.extendList.iterator();
    while (tmp$.hasNext()) {
      var extend = tmp$.next();
      extend.link_n5k2qc$(this.linker_0);
    }
  };
  FileLinker.prototype.requireImportedExtensionsRegistered = function () {
    var tmp$;
    if (this.importedExtensionsRegistered_0)
      return;
    this.importedExtensionsRegistered_0 = true;
    tmp$ = this.linker_0.contextImportedTypes_8be2vx$().iterator();
    while (tmp$.hasNext()) {
      var importedFileLinker = tmp$.next();
      importedFileLinker.requireExtensionsLinked();
    }
  };
  FileLinker.prototype.requireExtensionOptionsLinked_6taknv$ = function (validate) {
    var tmp$;
    if (this.extensionOptionsLinked_0)
      return;
    this.extensionOptionsLinked_0 = true;
    tmp$ = this.protoFile.extendList.iterator();
    while (tmp$.hasNext()) {
      var extend = tmp$.next();
      var syntaxRules = SyntaxRules$Companion_getInstance().get_gziock$(this.protoFile.syntax);
      extend.linkOptions_tlzwp4$(this.linker_0, syntaxRules, validate);
    }
  };
  FileLinker.prototype.requireImportedExtensionOptionsLinked_6taknv$ = function (validate) {
    var tmp$;
    if (this.importedExtensionOptionsLinked_0)
      return;
    this.importedExtensionOptionsLinked_0 = true;
    tmp$ = this.linker_0.contextImportedTypes_8be2vx$().iterator();
    while (tmp$.hasNext()) {
      var importedFileLinker = tmp$.next();
      importedFileLinker.requireExtensionOptionsLinked_6taknv$(validate);
    }
  };
  FileLinker.prototype.linkMembers = function () {
    var tmp$;
    this.linkMembersRecursive_0(this.protoFile.types);
    tmp$ = this.protoFile.services.iterator();
    while (tmp$.hasNext()) {
      var service = tmp$.next();
      service.link_n5k2qc$(this.linker_0);
    }
  };
  FileLinker.prototype.linkMembersRecursive_0 = function (types) {
    var tmp$;
    tmp$ = types.iterator();
    while (tmp$.hasNext()) {
      var type = tmp$.next();
      this.requireMembersLinked_pgzjyx$(type);
      this.linkMembersRecursive_0(type.nestedTypes);
    }
  };
  FileLinker.prototype.requireMembersLinked_pgzjyx$ = function (type) {
    if (this.typesWithMembersLinked_0.add_11rb$(type.type)) {
      type.linkMembers_n5k2qc$(this.linker_0);
    }};
  FileLinker.prototype.linkOptions_ber40w$ = function (syntaxRules, validate) {
    var tmp$, tmp$_0;
    this.requireFileOptionsLinked_6taknv$(validate);
    this.requireExtensionOptionsLinked_6taknv$(validate);
    tmp$ = this.protoFile.types.iterator();
    while (tmp$.hasNext()) {
      var type = tmp$.next();
      type.linkOptions_tlzwp4$(this.linker_0, syntaxRules, validate);
    }
    tmp$_0 = this.protoFile.services.iterator();
    while (tmp$_0.hasNext()) {
      var service = tmp$_0.next();
      service.linkOptions_dgdekt$(this.linker_0, validate);
    }
  };
  FileLinker.prototype.requireFileOptionsLinked_6taknv$ = function (validate) {
    if (this.fileOptionsLinked_0)
      return;
    this.fileOptionsLinked_0 = true;
    this.protoFile.linkOptions_dgdekt$(this.linker_0, validate);
  };
  FileLinker.prototype.validate_8ylku1$ = function (syntaxRules) {
    var tmp$, tmp$_0, tmp$_1;
    this.protoFile.validate_n5k2qc$(this.linker_0);
    tmp$ = this.protoFile.types.iterator();
    while (tmp$.hasNext()) {
      var type = tmp$.next();
      type.validate_q5zjs1$(this.linker_0, syntaxRules);
    }
    tmp$_0 = this.protoFile.services.iterator();
    while (tmp$_0.hasNext()) {
      var service = tmp$_0.next();
      service.validate_n5k2qc$(this.linker_0);
    }
    tmp$_1 = this.protoFile.extendList.iterator();
    while (tmp$_1.hasNext()) {
      var extend = tmp$_1.next();
      extend.validate_q5zjs1$(this.linker_0, syntaxRules);
    }
  };
  FileLinker.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FileLinker',
    interfaces: []
  };
  function LinkedOptionEntry(optionElement, protoMember, value) {
    this.optionElement = optionElement;
    this.protoMember = protoMember;
    this.value = value;
  }
  LinkedOptionEntry.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LinkedOptionEntry',
    interfaces: []
  };
  LinkedOptionEntry.prototype.component1 = function () {
    return this.optionElement;
  };
  LinkedOptionEntry.prototype.component2 = function () {
    return this.protoMember;
  };
  LinkedOptionEntry.prototype.component3 = function () {
    return this.value;
  };
  LinkedOptionEntry.prototype.copy_5lxijr$ = function (optionElement, protoMember, value) {
    return new LinkedOptionEntry(optionElement === void 0 ? this.optionElement : optionElement, protoMember === void 0 ? this.protoMember : protoMember, value === void 0 ? this.value : value);
  };
  LinkedOptionEntry.prototype.toString = function () {
    return 'LinkedOptionEntry(optionElement=' + Kotlin.toString(this.optionElement) + (', protoMember=' + Kotlin.toString(this.protoMember)) + (', value=' + Kotlin.toString(this.value)) + ')';
  };
  LinkedOptionEntry.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.optionElement) | 0;
    result = result * 31 + Kotlin.hashCode(this.protoMember) | 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  LinkedOptionEntry.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.optionElement, other.optionElement) && Kotlin.equals(this.protoMember, other.protoMember) && Kotlin.equals(this.value, other.value)))));
  };
  function Linker() {
    this.loader_0 = null;
    this.fileLinkers_0 = null;
    this.fileOptionsQueue_0 = null;
    this.protoTypeNames_0 = null;
    this.contextStack_0 = null;
    this.requestedTypes_0 = null;
    this.requestedFields_0 = null;
    this.permitPackageCycles_0 = false;
    this.errors = null;
  }
  Linker.prototype.getFileLinker_y4putb$ = function (path) {
    var existing = this.fileLinkers_0.get_11rb$(path);
    if (existing != null)
      return existing;
    var protoFile = this.loader_0.withErrors_t11pg2$(this.errors).load_61zpoe$(path);
    var result = new FileLinker(protoFile, this.withContext_za3rmp$(protoFile));
    this.fileLinkers_0.put_xwzc9p$(path, result);
    this.fileOptionsQueue_0.add_11rb$(result);
    return result;
  };
  Linker.prototype.link_5z6ry8$ = function (sourceProtoFiles) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7;
    var sourceFiles = ArrayList_init();
    var element = this.getFileLinker_y4putb$('google/protobuf/descriptor.proto');
    sourceFiles.add_11rb$(element);
    tmp$ = sourceProtoFiles.iterator();
    while (tmp$.hasNext()) {
      var sourceFile = tmp$.next();
      var fileLinker = new FileLinker(sourceFile, this.withContext_za3rmp$(sourceFile));
      var $receiver = this.fileLinkers_0;
      var key = sourceFile.location.path;
      $receiver.put_xwzc9p$(key, fileLinker);
      sourceFiles.add_11rb$(fileLinker);
    }
    tmp$_0 = sourceFiles.iterator();
    while (tmp$_0.hasNext()) {
      var fileLinker_0 = tmp$_0.next();
      fileLinker_0.requireTypesRegistered();
    }
    tmp$_1 = sourceFiles.iterator();
    while (tmp$_1.hasNext()) {
      var fileLinker_1 = tmp$_1.next();
      fileLinker_1.requireExtensionsLinked();
    }
    tmp$_2 = sourceFiles.iterator();
    while (tmp$_2.hasNext()) {
      var fileLinker_2 = tmp$_2.next();
      fileLinker_2.requireImportedExtensionsRegistered();
    }
    tmp$_3 = sourceFiles.iterator();
    while (tmp$_3.hasNext()) {
      var fileLinker_3 = tmp$_3.next();
      fileLinker_3.linkMembers();
    }
    tmp$_4 = sourceFiles.iterator();
    while (tmp$_4.hasNext()) {
      var fileLinker_4 = tmp$_4.next();
      var syntaxRules = SyntaxRules$Companion_getInstance().get_gziock$(fileLinker_4.protoFile.syntax);
      fileLinker_4.linkOptions_ber40w$(syntaxRules, true);
    }
    tmp$_5 = sourceFiles.iterator();
    while (tmp$_5.hasNext()) {
      var fileLinker_5 = tmp$_5.next();
      fileLinker_5.requireImportedExtensionOptionsLinked_6taknv$(false);
    }
    while (!this.fileOptionsQueue_0.isEmpty()) {
      var fileLinker_6 = ensureNotNull(this.fileOptionsQueue_0.poll());
      fileLinker_6.requireFileOptionsLinked_6taknv$(false);
    }
    tmp$_6 = sourceFiles.iterator();
    while (tmp$_6.hasNext()) {
      var fileLinker_7 = tmp$_6.next();
      var syntaxRules_0 = SyntaxRules$Companion_getInstance().get_gziock$(fileLinker_7.protoFile.syntax);
      fileLinker_7.validate_8ylku1$(syntaxRules_0);
    }
    var cycleChecker = new CycleChecker(this.fileLinkers_0, this.errors);
    cycleChecker.checkForImportCycles();
    if (!this.permitPackageCycles_0) {
      cycleChecker.checkForPackageCycles();
    }this.errors.throwIfNonEmpty();
    var result = ArrayList_init();
    tmp$_7 = this.fileLinkers_0.values.iterator();
    loop_label: while (tmp$_7.hasNext()) {
      var fileLinker_8 = tmp$_7.next();
      if (sourceFiles.contains_11rb$(fileLinker_8)) {
        result.add_11rb$(fileLinker_8.protoFile);
        continue loop_label;
      }var $receiver_0 = fileLinker_8.protoFile.typesAndNestedTypes();
      var any$result;
      any$break: do {
        var tmp$_8;
        if (Kotlin.isType($receiver_0, Collection) && $receiver_0.isEmpty()) {
          any$result = false;
          break any$break;
        }tmp$_8 = $receiver_0.iterator();
        while (tmp$_8.hasNext()) {
          var element_0 = tmp$_8.next();
          if (this.requestedTypes_0.contains_11rb$(element_0.type)) {
            any$result = true;
            break any$break;
          }}
        any$result = false;
      }
       while (false);
      var anyTypeIsUsed = any$result;
      var $receiver_1 = fileLinker_8.protoFile.extendList;
      var any$result_0;
      any$break: do {
        var tmp$_9;
        if (Kotlin.isType($receiver_1, Collection) && $receiver_1.isEmpty()) {
          any$result_0 = false;
          break any$break;
        }tmp$_9 = $receiver_1.iterator();
        loop_label_0: while (tmp$_9.hasNext()) {
          var element_1 = tmp$_9.next();
          var $receiver_2 = element_1.fields;
          var any$result_1;
          any$break_0: do {
            var tmp$_10;
            if (Kotlin.isType($receiver_2, Collection) && $receiver_2.isEmpty()) {
              any$result_1 = false;
              break any$break_0;
            }tmp$_10 = $receiver_2.iterator();
            while (tmp$_10.hasNext()) {
              var element_2 = tmp$_10.next();
              if (this.requestedFields_0.contains_11rb$(element_2)) {
                any$result_1 = true;
                break any$break_0;
              }}
            any$result_1 = false;
          }
           while (false);
          if (any$result_1) {
            any$result_0 = true;
            break any$break;
          }}
        any$result_0 = false;
      }
       while (false);
      var anyFieldIsUsed = any$result_0;
      if (anyTypeIsUsed || anyFieldIsUsed) {
        result.add_11rb$(fileLinker_8.protoFile.retainLinked_mnadk8$(toSet(this.requestedTypes_0), this.requestedFields_0));
      }}
    return new Schema(result);
  };
  Linker.prototype.resolveType_61zpoe$ = function (name) {
    return this.resolveType_0(name, false);
  };
  Linker.prototype.resolveMessageType_61zpoe$ = function (name) {
    return this.resolveType_0(name, true);
  };
  Linker.prototype.resolveType_0 = function (name, messageOnly) {
    var tmp$;
    var type = ProtoType$Companion_getInstance().get_pdl1vj$(name);
    if (type.isScalar) {
      if (messageOnly) {
        this.errors.plusAssign_61zpoe$('expected a message but was ' + name);
      }return type;
    }if (type.isMap) {
      if (messageOnly) {
        this.errors.plusAssign_61zpoe$('expected a message but was ' + name);
      }var keyType = this.resolveType_0(toString(type.keyType), false);
      var valueType = this.resolveType_0(toString(type.valueType), false);
      return ProtoType$Companion_getInstance().get_xvxixq$(keyType, valueType, name);
    }var resolved = this.resolve_gwvowp$(name, this.protoTypeNames_0);
    if (resolved == null) {
      tmp$ = this.contextImportedTypes_8be2vx$().iterator();
      while (tmp$.hasNext()) {
        var fileLinker = tmp$.next();
        fileLinker.requireTypesRegistered();
      }
      resolved = this.resolve_gwvowp$(name, this.protoTypeNames_0);
    }if (resolved == null) {
      this.errors.plusAssign_61zpoe$('unable to resolve ' + name);
      return ProtoType$Companion_getInstance().BYTES;
    }if (messageOnly && !Kotlin.isType(resolved, MessageType)) {
      this.errors.plusAssign_61zpoe$('expected a message but was ' + name);
      return ProtoType$Companion_getInstance().BYTES;
    }this.requestedTypes_0.add_11rb$(resolved.type);
    return resolved.type;
  };
  Linker.prototype.resolve_gwvowp$ = function (name, map) {
    if (startsWith(name, '.')) {
      var result = map.get_11rb$(name.substring(1));
      if (result != null)
        return result;
    } else {
      var prefix = this.resolveContext_0();
      while (prefix.length > 0) {
        var result_0 = map.get_11rb$(prefix + '.' + name);
        if (result_0 != null)
          return result_0;
        var dot = lastIndexOf(prefix, 46);
        prefix = dot !== -1 ? prefix.substring(0, dot) : '';
      }
      var result_1 = map.get_11rb$(name);
      if (result_1 != null)
        return result_1;
    }
    return null;
  };
  Linker.prototype.resolveContext_0 = function () {
    var tmp$, tmp$_0;
    tmp$ = reversed(get_indices(this.contextStack_0)).iterator();
    while (tmp$.hasNext()) {
      var i = tmp$.next();
      var context = this.contextStack_0.get_za3lpa$(i);
      if (Kotlin.isType(context, Type))
        return context.type.toString();
      else if (Kotlin.isType(context, ProtoFile)) {
        var packageName = context.packageName;
        return packageName != null ? packageName : '';
      } else if (Kotlin.isType(context, Field) && context.isExtension)
        return (tmp$_0 = context.packageName) != null ? tmp$_0 : '';
    }
    throw IllegalStateException_init();
  };
  Linker.prototype.packageName = function () {
    var tmp$;
    tmp$ = this.contextStack_0.iterator();
    while (tmp$.hasNext()) {
      var context = tmp$.next();
      if (Kotlin.isType(context, ProtoFile))
        return context.packageName;
    }
    return null;
  };
  Linker.prototype.contextImportedTypes_8be2vx$ = function () {
    var tmp$, tmp$_0, tmp$_1;
    var result = ArrayList_init();
    tmp$ = reversed(get_indices(this.contextStack_0)).iterator();
    while (tmp$.hasNext()) {
      var i = tmp$.next();
      var context = this.contextStack_0.get_za3lpa$(i);
      if (Kotlin.isType(context, ProtoFile))
        tmp$_0 = context.location;
      else if (Kotlin.isType(context, Field) && context.isExtension)
        tmp$_0 = context.location;
      else
        tmp$_0 = null;
      var location = tmp$_0;
      if (location != null) {
        var path = location.path;
        var fileLinker = this.getFileLinker_y4putb$(path);
        tmp$_1 = fileLinker.effectiveImports().iterator();
        while (tmp$_1.hasNext()) {
          var effectiveImport = tmp$_1.next();
          result.add_11rb$(this.getFileLinker_y4putb$(effectiveImport));
        }
      }}
    return result;
  };
  Linker.prototype.addType_hc7hzk$ = function (protoType, type) {
    var $receiver = this.protoTypeNames_0;
    var key = protoType.toString();
    $receiver.put_xwzc9p$(key, type);
  };
  Linker.prototype.get_rubud1$ = function (protoType) {
    var tmp$;
    var result = this.protoTypeNames_0.get_11rb$(protoType.toString());
    if (result == null) {
      tmp$ = this.contextImportedTypes_8be2vx$().iterator();
      while (tmp$.hasNext()) {
        var fileLinker = tmp$.next();
        fileLinker.requireTypesRegistered();
      }
      result = this.protoTypeNames_0.get_11rb$(protoType.toString());
    }if (result != null) {
      this.requestedTypes_0.add_11rb$(protoType);
    }return result;
  };
  Linker.prototype.getForOptions_rubud1$ = function (protoType) {
    var tmp$;
    tmp$ = this.get_rubud1$(protoType);
    if (tmp$ == null) {
      return null;
    }var result = tmp$;
    var fileLinker = this.getFileLinker_y4putb$(result.location.path);
    fileLinker.requireMembersLinked_pgzjyx$(result);
    return result;
  };
  Linker.prototype.request_8id5cj$ = function (field) {
    this.requestedFields_0.add_11rb$(field);
  };
  Linker.prototype.dereference_qy1mv5$ = function (self_0, field) {
    var field_0 = field;
    if (startsWith(field_0, '[') && endsWith(field_0, ']')) {
      var $receiver = field_0;
      var endIndex = field_0.length - 1 | 0;
      field_0 = $receiver.substring(1, endIndex);
    }var type = this.getForOptions_rubud1$(ensureNotNull(self_0.type));
    if (Kotlin.isType(type, MessageType)) {
      var messageField = type.field_61zpoe$(field_0);
      if (messageField != null)
        return messageField;
      var typeExtensions = type.extensionFieldsMap();
      var extensionField = this.resolve_gwvowp$(field_0, typeExtensions);
      if (extensionField != null)
        return extensionField;
    }return null;
  };
  Linker.prototype.validateFields_ecdeft$ = function (fields, reserveds, syntaxRules) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    var tagToField = LinkedHashMap_init();
    var nameToField = LinkedHashMap_init();
    var jsonNameToField = LinkedHashMap_init();
    tmp$ = fields.iterator();
    while (tmp$.hasNext()) {
      var field = tmp$.next();
      var tag = field.tag;
      if (!isValidTag(tag)) {
        this.errors.at_za3rmp$(field).plusAssign_61zpoe$('tag is out of range: ' + tag);
      }tmp$_0 = reserveds.iterator();
      while (tmp$_0.hasNext()) {
        var reserved = tmp$_0.next();
        if (reserved.matchesTag_za3lpa$(tag)) {
          this.errors.at_za3rmp$(field).plusAssign_61zpoe$('tag ' + tag + ' is reserved (' + reserved.location + ')');
        }if (reserved.matchesName_61zpoe$(field.name)) {
          this.errors.at_za3rmp$(field).plusAssign_61zpoe$("name '" + field.name + "' is reserved (" + reserved.location + ')');
        }}
      var tmp$_4;
      var value = tagToField.get_11rb$(tag);
      if (value == null) {
        var answer = LinkedHashSet_init();
        tagToField.put_xwzc9p$(tag, answer);
        tmp$_4 = answer;
      } else {
        tmp$_4 = value;
      }
      tmp$_4.add_11rb$(field);
      var key = field.qualifiedName;
      var tmp$_5;
      var value_0 = nameToField.get_11rb$(key);
      if (value_0 == null) {
        var answer_0 = LinkedHashSet_init();
        nameToField.put_xwzc9p$(key, answer_0);
        tmp$_5 = answer_0;
      } else {
        tmp$_5 = value_0;
      }
      tmp$_5.add_11rb$(field);
      if (!field.isExtension) {
        var key_0 = syntaxRules.jsonName_jyasbz$(field.name, field.declaredJsonName);
        var tmp$_6;
        var value_1 = jsonNameToField.get_11rb$(key_0);
        if (value_1 == null) {
          var answer_1 = LinkedHashSet_init();
          jsonNameToField.put_xwzc9p$(key_0, answer_1);
          tmp$_6 = answer_1;
        } else {
          tmp$_6 = value_1;
        }
        tmp$_6.add_11rb$(field);
      }syntaxRules.validateTypeReference_1o7xwe$(this.get_rubud1$(ensureNotNull(field.type)), this.errors.at_za3rmp$(field));
    }
    tmp$_1 = tagToField.entries.iterator();
    while (tmp$_1.hasNext()) {
      var tmp$_7 = tmp$_1.next();
      var key_1 = tmp$_7.key;
      var values = tmp$_7.value;
      if (values.size > 1) {
        var error = StringBuilder_init();
        error.append_pdl1vj$('multiple fields share tag ' + key_1 + ':');
        var tmp$_8, tmp$_0_0;
        var index = 0;
        tmp$_8 = values.iterator();
        while (tmp$_8.hasNext()) {
          var item = tmp$_8.next();
          error.append_pdl1vj$('\n' + '  ' + (checkIndexOverflow((tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0)) + 1 | 0) + '. ' + item.name + ' (' + item.location + ')');
        }
        this.errors.plusAssign_61zpoe$(error.toString());
      }}
    var hasCollidingFields = false;
    tmp$_2 = nameToField.values.iterator();
    while (tmp$_2.hasNext()) {
      var collidingFields = tmp$_2.next();
      if (collidingFields.size > 1) {
        hasCollidingFields = true;
        var first = collidingFields.iterator().next();
        var error_0 = StringBuilder_init();
        error_0.append_pdl1vj$('multiple fields share name ' + first.name + ':');
        var tmp$_9, tmp$_0_1;
        var index_0 = 0;
        tmp$_9 = collidingFields.iterator();
        while (tmp$_9.hasNext()) {
          var item_0 = tmp$_9.next();
          error_0.append_pdl1vj$('\n' + '  ' + (checkIndexOverflow((tmp$_0_1 = index_0, index_0 = tmp$_0_1 + 1 | 0, tmp$_0_1)) + 1 | 0) + '. ' + item_0.name + ' (' + item_0.location + ')');
        }
        this.errors.plusAssign_61zpoe$(error_0.toString());
      }}
    if (!hasCollidingFields) {
      tmp$_3 = jsonNameToField.entries.iterator();
      while (tmp$_3.hasNext()) {
        var tmp$_10 = tmp$_3.next();
        var jsonName = tmp$_10.key;
        var fields_0 = tmp$_10.value;
        if (fields_0.size > 1) {
          var error_1 = StringBuilder_init();
          error_1.append_pdl1vj$("multiple fields share same JSON name '" + jsonName + "':");
          var tmp$_11, tmp$_0_2;
          var index_1 = 0;
          tmp$_11 = fields_0.iterator();
          while (tmp$_11.hasNext()) {
            var item_1 = tmp$_11.next();
            error_1.append_pdl1vj$('\n' + '  ' + (checkIndexOverflow((tmp$_0_2 = index_1, index_1 = tmp$_0_2 + 1 | 0, tmp$_0_2)) + 1 | 0) + '. ' + item_1.name + ' (' + item_1.location + ')');
          }
          this.errors.plusAssign_61zpoe$(error_1.toString());
        }}
    }};
  Linker.prototype.validateEnumConstantNameUniqueness_z7e7cu$ = function (nestedTypes) {
    var tmp$, tmp$_0, tmp$_1;
    var nameToType = LinkedHashMap_init();
    tmp$ = nestedTypes.iterator();
    while (tmp$.hasNext()) {
      var type = tmp$.next();
      if (Kotlin.isType(type, EnumType)) {
        tmp$_0 = type.constants.iterator();
        while (tmp$_0.hasNext()) {
          var enumConstant = tmp$_0.next();
          var key = enumConstant.name;
          var tmp$_2;
          var value = nameToType.get_11rb$(key);
          if (value == null) {
            var answer = LinkedHashSet_init();
            nameToType.put_xwzc9p$(key, answer);
            tmp$_2 = answer;
          } else {
            tmp$_2 = value;
          }
          tmp$_2.add_11rb$(type);
        }
      }}
    tmp$_1 = nameToType.entries.iterator();
    while (tmp$_1.hasNext()) {
      var tmp$_3 = tmp$_1.next();
      var constant = tmp$_3.key;
      var values = tmp$_3.value;
      if (values.size > 1) {
        var $receiver = StringBuilder_init();
        $receiver.append_pdl1vj$('multiple enums share constant ' + constant + ':');
        var tmp$_4, tmp$_0_0;
        var index = 0;
        tmp$_4 = values.iterator();
        while (tmp$_4.hasNext()) {
          var item = tmp$_4.next();
          $receiver.append_pdl1vj$('\n' + '  ' + (checkIndexOverflow((tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0)) + 1 | 0) + '. ' + item.type + '.' + constant + ' ' + ('(' + ensureNotNull(item.constant_61zpoe$(constant)).location + ')'));
        }
        var error = $receiver.toString();
        this.errors.plusAssign_61zpoe$(error);
      }}
  };
  Linker.prototype.validateImportForType_bi6gv$ = function (location, type) {
    var type_0 = type;
    if (type_0.isMap)
      type_0 = ensureNotNull(type_0.valueType);
    if (type_0.isScalar)
      return;
    var path = location.path;
    var requiredImport = ensureNotNull(this.get_rubud1$(type_0)).location.path;
    var fileLinker = this.getFileLinker_y4putb$(path);
    if (!equals(path, requiredImport) && !fileLinker.effectiveImports().contains_11rb$(requiredImport)) {
      this.errors.plusAssign_61zpoe$(path + ' needs to import ' + requiredImport);
    }};
  Linker.prototype.validateImportForPath_liszf0$ = function (location, requiredImport) {
    var path = location.path;
    var fileLinker = this.getFileLinker_y4putb$(path);
    if (!equals(path, requiredImport) && !fileLinker.effectiveImports().contains_11rb$(requiredImport)) {
      this.errors.plusAssign_61zpoe$(path + ' needs to import ' + requiredImport);
    }};
  Linker.prototype.withContext_za3rmp$ = function (context) {
    return Linker_init_0(this, context);
  };
  Linker.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Linker',
    interfaces: []
  };
  function Linker_init(loader, errors, permitPackageCycles, $this) {
    $this = $this || Object.create(Linker.prototype);
    Linker.call($this);
    $this.loader_0 = loader;
    $this.fileLinkers_0 = LinkedHashMap_init();
    $this.fileOptionsQueue_0 = mutableQueueOf();
    $this.protoTypeNames_0 = LinkedHashMap_init();
    $this.contextStack_0 = emptyList();
    $this.requestedTypes_0 = LinkedHashSet_init();
    $this.requestedFields_0 = LinkedHashSet_init();
    $this.errors = errors;
    $this.permitPackageCycles_0 = permitPackageCycles;
    return $this;
  }
  function Linker_init_0(enclosing, additionalContext, $this) {
    $this = $this || Object.create(Linker.prototype);
    Linker.call($this);
    $this.loader_0 = enclosing.loader_0;
    $this.fileLinkers_0 = enclosing.fileLinkers_0;
    $this.fileOptionsQueue_0 = enclosing.fileOptionsQueue_0;
    $this.protoTypeNames_0 = enclosing.protoTypeNames_0;
    $this.contextStack_0 = plus_0(enclosing.contextStack_0, additionalContext);
    $this.requestedTypes_0 = enclosing.requestedTypes_0;
    $this.requestedFields_0 = enclosing.requestedFields_0;
    $this.errors = enclosing.errors.at_za3rmp$(additionalContext);
    $this.permitPackageCycles_0 = false;
    return $this;
  }
  function Loader() {
  }
  Loader.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Loader',
    interfaces: []
  };
  function Location(base, path, line, column) {
    Location$Companion_getInstance();
    if (line === void 0)
      line = -1;
    if (column === void 0)
      column = -1;
    this.base = base;
    this.path = path;
    this.line = line;
    this.column = column;
  }
  Location.prototype.at_vux9f0$ = function (line, column) {
    return new Location(this.base, this.path, line, column);
  };
  Location.prototype.withoutBase = function () {
    return new Location('', this.path, this.line, this.column);
  };
  Location.prototype.withPathOnly = function () {
    return new Location('', this.path, -1, -1);
  };
  Location.prototype.toString = function () {
    var $receiver = StringBuilder_init();
    if (this.base.length > 0) {
      $receiver.append_pdl1vj$(this.base);
      $receiver.append_s8itvh$(47);
    }$receiver.append_pdl1vj$(this.path);
    if (this.line !== -1) {
      $receiver.append_s8itvh$(58);
      $receiver.append_s8jyv4$(this.line);
      if (this.column !== -1) {
        $receiver.append_s8itvh$(58);
        $receiver.append_s8jyv4$(this.column);
      }}return $receiver.toString();
  };
  function Location$Companion() {
    Location$Companion_instance = this;
  }
  Location$Companion.prototype.get_61zpoe$ = function (path) {
    return this.get_puj7f4$('', path);
  };
  Location$Companion.prototype.get_puj7f4$ = function (base, path) {
    return new Location(trimEnd(base, Kotlin.charArrayOf(47)), path, -1, -1);
  };
  Location$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Location$Companion_instance = null;
  function Location$Companion_getInstance() {
    if (Location$Companion_instance === null) {
      new Location$Companion();
    }return Location$Companion_instance;
  }
  Location.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Location',
    interfaces: []
  };
  Location.prototype.component1 = function () {
    return this.base;
  };
  Location.prototype.component2 = function () {
    return this.path;
  };
  Location.prototype.component3 = function () {
    return this.line;
  };
  Location.prototype.component4 = function () {
    return this.column;
  };
  Location.prototype.copy_ccskfk$ = function (base, path, line, column) {
    return new Location(base === void 0 ? this.base : base, path === void 0 ? this.path : path, line === void 0 ? this.line : line, column === void 0 ? this.column : column);
  };
  Location.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.base) | 0;
    result = result * 31 + Kotlin.hashCode(this.path) | 0;
    result = result * 31 + Kotlin.hashCode(this.line) | 0;
    result = result * 31 + Kotlin.hashCode(this.column) | 0;
    return result;
  };
  Location.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.base, other.base) && Kotlin.equals(this.path, other.path) && Kotlin.equals(this.line, other.line) && Kotlin.equals(this.column, other.column)))));
  };
  function MarkSet(pruningRules) {
    MarkSet$Companion_getInstance();
    this.pruningRules = pruningRules;
    this.types = LinkedHashSet_init();
    this.members = LinkedHashMap_init();
    this.rootMemberTypes_0 = LinkedHashMap_init();
    this.memberTypes_0 = LinkedHashMap_init();
  }
  MarkSet.prototype.root_pnoc8b$ = function (protoMember) {
    if (!!this.pruningRules.prunes_pnoc8b$(protoMember)) {
      var message = 'Check failed.';
      throw IllegalStateException_init_0(message.toString());
    }this.types.add_11rb$(protoMember.type);
    var $receiver = this.rootMemberTypes_0;
    var value = MarkSet$Companion_getInstance().UNKNOWN_TYPE_0;
    $receiver.put_xwzc9p$(protoMember, value);
    var $receiver_0 = this.members;
    var key = protoMember.type;
    var tmp$;
    var value_0 = $receiver_0.get_11rb$(key);
    if (value_0 == null) {
      var answer = LinkedHashSet_init();
      $receiver_0.put_xwzc9p$(key, answer);
      tmp$ = answer;
    } else {
      tmp$ = value_0;
    }
    var memberSet = tmp$;
    memberSet.add_11rb$(protoMember);
  };
  MarkSet.prototype.root_rubud1$ = function (type) {
    if (!!this.pruningRules.prunes_rubud1$(type)) {
      var message = 'Check failed.';
      throw IllegalStateException_init_0(message.toString());
    }this.types.add_11rb$(type);
  };
  MarkSet.prototype.mark_z6d430$ = function (type, reference) {
    this.memberTypes_0.put_xwzc9p$(reference, type);
    if (this.rootMemberTypes_0.containsKey_11rb$(reference)) {
      this.rootMemberTypes_0.put_xwzc9p$(reference, type);
      return this.types.add_11rb$(type);
    }return this.mark_rubud1$(type);
  };
  MarkSet.prototype.mark_rubud1$ = function (type) {
    if (this.pruningRules.prunes_rubud1$(type))
      return false;
    return this.types.add_11rb$(type);
  };
  MarkSet.prototype.mark_pnoc8b$ = function (protoMember) {
    if (this.pruningRules.prunes_pnoc8b$(protoMember))
      return false;
    this.types.add_11rb$(protoMember.type);
    var $receiver = this.members;
    var key = protoMember.type;
    var tmp$;
    var value = $receiver.get_11rb$(key);
    if (value == null) {
      var answer = LinkedHashSet_init();
      $receiver.put_xwzc9p$(key, answer);
      tmp$ = answer;
    } else {
      tmp$ = value;
    }
    var memberSet = tmp$;
    return memberSet.add_11rb$(protoMember);
  };
  MarkSet.prototype.contains_rubud1$ = function (type) {
    return this.types.contains_11rb$(type);
  };
  MarkSet.prototype.contains_pnoc8b$ = function (protoMember) {
    var memberType = this.memberTypes_0.get_11rb$(protoMember);
    if (!this.rootMemberTypes_0.containsKey_11rb$(protoMember) && memberType != null && this.pruningRules.prunes_rubud1$(memberType)) {
      return false;
    }if (this.pruningRules.prunes_rubud1$(protoMember.type) && this.rootMemberTypes_0.containsValue_11rc$(protoMember.type)) {
      return true;
    }if (this.pruningRules.prunes_pnoc8b$(protoMember))
      return false;
    var memberSet = this.members.get_11rb$(protoMember.type);
    return memberSet != null && memberSet.contains_11rb$(protoMember);
  };
  function MarkSet$Companion() {
    MarkSet$Companion_instance = this;
    this.UNKNOWN_TYPE_0 = ProtoType$Companion_getInstance().get_pdl1vj$('(unknown type)');
  }
  MarkSet$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var MarkSet$Companion_instance = null;
  function MarkSet$Companion_getInstance() {
    if (MarkSet$Companion_instance === null) {
      new MarkSet$Companion();
    }return MarkSet$Companion_instance;
  }
  MarkSet.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MarkSet',
    interfaces: []
  };
  function MessageType(type, location, documentation, name, declaredFields, extensionFields, oneOfs, nestedTypes, extensionsList, reserveds, options, syntax) {
    MessageType$Companion_getInstance();
    Type.call(this);
    this.type_xqpsti$_0 = type;
    this.location_4wi1h1$_0 = location;
    this.documentation_vclu3e$_0 = documentation;
    this.name_0 = name;
    this.declaredFields = declaredFields;
    this.extensionFields = extensionFields;
    this.oneOfs = oneOfs;
    this.nestedTypes_4hqvou$_0 = nestedTypes;
    this.extensionsList_0 = extensionsList;
    this.reserveds_0 = reserveds;
    this.options_7p7hai$_0 = options;
    this.syntax_le5vz1$_0 = syntax;
  }
  Object.defineProperty(MessageType.prototype, 'type', {
    get: function () {
      return this.type_xqpsti$_0;
    }
  });
  Object.defineProperty(MessageType.prototype, 'location', {
    get: function () {
      return this.location_4wi1h1$_0;
    }
  });
  Object.defineProperty(MessageType.prototype, 'documentation', {
    get: function () {
      return this.documentation_vclu3e$_0;
    }
  });
  Object.defineProperty(MessageType.prototype, 'nestedTypes', {
    get: function () {
      return this.nestedTypes_4hqvou$_0;
    }
  });
  Object.defineProperty(MessageType.prototype, 'options', {
    get: function () {
      return this.options_7p7hai$_0;
    }
  });
  Object.defineProperty(MessageType.prototype, 'syntax', {
    get: function () {
      return this.syntax_le5vz1$_0;
    }
  });
  Object.defineProperty(MessageType.prototype, 'fields', {
    configurable: true,
    get: function () {
      return plus(this.declaredFields, this.extensionFields);
    }
  });
  Object.defineProperty(MessageType.prototype, 'requiredFields', {
    configurable: true,
    get: function () {
      var $receiver = this.fieldsAndOneOfFields;
      var destination = ArrayList_init();
      var tmp$;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (element.isRequired)
          destination.add_11rb$(element);
      }
      return destination;
    }
  });
  Object.defineProperty(MessageType.prototype, 'fieldsAndOneOfFields', {
    configurable: true,
    get: function () {
      var tmp$ = plus(this.declaredFields, this.extensionFields);
      var $receiver = this.oneOfs;
      var destination = ArrayList_init();
      var tmp$_0;
      tmp$_0 = $receiver.iterator();
      while (tmp$_0.hasNext()) {
        var element = tmp$_0.next();
        var list = element.fields;
        addAll(destination, list);
      }
      return plus(tmp$, destination);
    }
  });
  MessageType.prototype.field_61zpoe$ = function (name) {
    var tmp$, tmp$_0, tmp$_1;
    tmp$ = this.declaredFields.iterator();
    while (tmp$.hasNext()) {
      var field = tmp$.next();
      if (equals(field.name, name)) {
        return field;
      }}
    tmp$_0 = this.oneOfs.iterator();
    while (tmp$_0.hasNext()) {
      var oneOf = tmp$_0.next();
      tmp$_1 = oneOf.fields.iterator();
      while (tmp$_1.hasNext()) {
        var field_0 = tmp$_1.next();
        if (equals(field_0.name, name)) {
          return field_0;
        }}
    }
    return null;
  };
  MessageType.prototype.extensionField_61zpoe$ = function (qualifiedName) {
    var $receiver = this.extensionFields;
    var firstOrNull$result;
    firstOrNull$break: do {
      var tmp$;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (equals(element.qualifiedName, qualifiedName)) {
          firstOrNull$result = element;
          break firstOrNull$break;
        }}
      firstOrNull$result = null;
    }
     while (false);
    return firstOrNull$result;
  };
  MessageType.prototype.field_za3lpa$ = function (tag) {
    var tmp$, tmp$_0;
    tmp$ = this.declaredFields.iterator();
    while (tmp$.hasNext()) {
      var field = tmp$.next();
      if (field.tag === tag) {
        return field;
      }}
    tmp$_0 = this.extensionFields.iterator();
    while (tmp$_0.hasNext()) {
      var field_0 = tmp$_0.next();
      if (field_0.tag === tag) {
        return field_0;
      }}
    return null;
  };
  MessageType.prototype.extensionFieldsMap = function () {
    var tmp$;
    var extensionsForType = LinkedHashMap_init();
    tmp$ = this.extensionFields.iterator();
    while (tmp$.hasNext()) {
      var field = tmp$.next();
      var key = field.qualifiedName;
      extensionsForType.put_xwzc9p$(key, field);
    }
    return extensionsForType;
  };
  MessageType.prototype.addExtensionFields_nh6en2$ = function (fields) {
    this.extensionFields.addAll_brywnq$(fields);
  };
  MessageType.prototype.linkMembers_n5k2qc$ = function (linker) {
    var tmp$, tmp$_0;
    var linker_0 = linker.withContext_za3rmp$(this);
    tmp$ = this.declaredFields.iterator();
    while (tmp$.hasNext()) {
      var field = tmp$.next();
      field.link_n5k2qc$(linker_0);
    }
    tmp$_0 = this.oneOfs.iterator();
    while (tmp$_0.hasNext()) {
      var oneOf = tmp$_0.next();
      oneOf.link_n5k2qc$(linker_0);
    }
  };
  MessageType.prototype.linkOptions_tlzwp4$ = function (linker, syntaxRules, validate) {
    var tmp$, tmp$_0, tmp$_1;
    var linker_0 = linker.withContext_za3rmp$(this);
    tmp$ = this.nestedTypes.iterator();
    while (tmp$.hasNext()) {
      var nestedType = tmp$.next();
      nestedType.linkOptions_tlzwp4$(linker_0, syntaxRules, validate);
    }
    tmp$_0 = this.declaredFields.iterator();
    while (tmp$_0.hasNext()) {
      var field = tmp$_0.next();
      field.linkOptions_tlzwp4$(linker_0, syntaxRules, validate);
    }
    tmp$_1 = this.oneOfs.iterator();
    while (tmp$_1.hasNext()) {
      var oneOf = tmp$_1.next();
      oneOf.linkOptions_tlzwp4$(linker_0, syntaxRules, validate);
    }
    this.options.link_jszzr1$(linker_0, this.location, validate);
  };
  MessageType.prototype.validate_q5zjs1$ = function (linker, syntaxRules) {
    var tmp$, tmp$_0, tmp$_1;
    var linker_0 = linker.withContext_za3rmp$(this);
    linker_0.validateFields_ecdeft$(this.fieldsAndOneOfFields, this.reserveds_0, syntaxRules);
    linker_0.validateEnumConstantNameUniqueness_z7e7cu$(this.nestedTypes);
    tmp$ = this.fieldsAndOneOfFields.iterator();
    while (tmp$.hasNext()) {
      var field = tmp$.next();
      field.validate_q5zjs1$(linker_0, syntaxRules);
    }
    tmp$_0 = this.nestedTypes.iterator();
    while (tmp$_0.hasNext()) {
      var nestedType = tmp$_0.next();
      nestedType.validate_q5zjs1$(linker_0, syntaxRules);
    }
    tmp$_1 = this.extensionsList_0.iterator();
    while (tmp$_1.hasNext()) {
      var extensions = tmp$_1.next();
      extensions.validate_n5k2qc$(linker_0);
    }
  };
  MessageType.prototype.retainAll_crjjl2$ = function (schema, markSet) {
    var tmp$;
    var $receiver = this.nestedTypes;
    var destination = ArrayList_init();
    var tmp$_0;
    tmp$_0 = $receiver.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      var tmp$_0_0;
      if ((tmp$_0_0 = element.retainAll_crjjl2$(schema, markSet)) != null) {
        destination.add_11rb$(tmp$_0_0);
      }}
    var retainedNestedTypes = destination;
    if (!markSet.contains_rubud1$(this.type) && !contains(Options$Companion_getInstance().GOOGLE_PROTOBUF_OPTION_TYPES, this.type)) {
      if (retainedNestedTypes.isEmpty())
        tmp$ = null;
      else
        tmp$ = new EnclosingType(this.location, this.type, this.documentation, retainedNestedTypes, this.syntax);
      return tmp$;
    }var $receiver_0 = this.oneOfs;
    var destination_0 = ArrayList_init();
    var tmp$_1;
    tmp$_1 = $receiver_0.iterator();
    while (tmp$_1.hasNext()) {
      var element_0 = tmp$_1.next();
      var tmp$_0_1;
      if ((tmp$_0_1 = element_0.retainAll_osl9ff$(schema, markSet, this.type)) != null) {
        destination_0.add_11rb$(tmp$_0_1);
      }}
    var retainedOneOfs = destination_0;
    return new MessageType(this.type, this.location, this.documentation, this.name_0, Field$Companion_getInstance().retainAll_5bk9gv$(schema, markSet, this.type, this.declaredFields), toMutableList(Field$Companion_getInstance().retainAll_5bk9gv$(schema, markSet, this.type, this.extensionFields)), retainedOneOfs, retainedNestedTypes, this.extensionsList_0, this.reserveds_0, this.options.retainAll_crjjl2$(schema, markSet), this.syntax);
  };
  MessageType.prototype.retainLinked_d9h3fi$ = function (linkedTypes) {
    var tmp$;
    var $receiver = this.nestedTypes;
    var destination = ArrayList_init();
    var tmp$_0;
    tmp$_0 = $receiver.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      var tmp$_0_0;
      if ((tmp$_0_0 = element.retainLinked_d9h3fi$(linkedTypes)) != null) {
        destination.add_11rb$(tmp$_0_0);
      }}
    var retainedNestedTypes = destination;
    if (!linkedTypes.contains_11rb$(this.type)) {
      if (retainedNestedTypes.isEmpty())
        tmp$ = null;
      else
        tmp$ = new EnclosingType(this.location, this.type, this.documentation, retainedNestedTypes, this.syntax);
      return tmp$;
    }var $receiver_0 = this.oneOfs;
    var destination_0 = ArrayList_init();
    var tmp$_1;
    tmp$_1 = $receiver_0.iterator();
    while (tmp$_1.hasNext()) {
      var element_0 = tmp$_1.next();
      var tmp$_0_1;
      if ((tmp$_0_1 = element_0.retainLinked()) != null) {
        destination_0.add_11rb$(tmp$_0_1);
      }}
    var retainedOneOfs = destination_0;
    return new MessageType(this.type, this.location, this.documentation, this.name_0, Field$Companion_getInstance().retainLinked_nh6en2$(this.declaredFields), toMutableList(Field$Companion_getInstance().retainLinked_nh6en2$(this.extensionFields)), retainedOneOfs, retainedNestedTypes, emptyList(), emptyList(), this.options.retainLinked(), this.syntax);
  };
  MessageType.prototype.toElement = function () {
    return new MessageElement(this.location, this.name_0, this.documentation, Type$Companion_getInstance().toElements_qiljpy$(this.nestedTypes), this.options.elements, Reserved$Companion_getInstance().toElements_kjt8as$(this.reserveds_0), Field$Companion_getInstance().toElements_nh6en2$(this.declaredFields), OneOf$Companion_getInstance().toElements_rtbdp7$(this.oneOfs), Extensions$Companion_getInstance().toElements_j9g6a8$(this.extensionsList_0), emptyList());
  };
  function MessageType$Companion() {
    MessageType$Companion_instance = this;
  }
  MessageType$Companion.prototype.fromElement_ei4hej$ = function (packageName, protoType, messageElement, syntax) {
    if (!messageElement.groups.isEmpty()) {
      var message = messageElement.groups.get_za3lpa$(0).location.toString() + ": 'group' is not supported";
      throw IllegalStateException_init_0(message.toString());
    }var $receiver = messageElement.nestedTypes;
    var destination = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(Type$Companion_getInstance().get_gi2qek$(packageName, protoType.nestedType_pdl1vj$(item.name), item, syntax));
    }
    var nestedTypes = destination;
    return new MessageType(protoType, messageElement.location, messageElement.documentation, messageElement.name, Field$Companion_getInstance().fromElements_az8v47$(packageName, messageElement.fields, false, false), ArrayList_init(), OneOf$Companion_getInstance().fromElements_ncp6tn$(packageName, messageElement.oneOfs, false), nestedTypes, Extensions$Companion_getInstance().fromElements_ku6uku$(messageElement.extensions), Reserved$Companion_getInstance().fromElements_f8qxcy$(messageElement.reserveds), new Options(Options$Companion_getInstance().MESSAGE_OPTIONS, messageElement.options), syntax);
  };
  MessageType$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var MessageType$Companion_instance = null;
  function MessageType$Companion_getInstance() {
    if (MessageType$Companion_instance === null) {
      new MessageType$Companion();
    }return MessageType$Companion_instance;
  }
  MessageType.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MessageType',
    interfaces: [Type]
  };
  MessageType.prototype.component1 = function () {
    return this.type;
  };
  MessageType.prototype.component2 = function () {
    return this.location;
  };
  MessageType.prototype.component3 = function () {
    return this.documentation;
  };
  MessageType.prototype.component4_0 = function () {
    return this.name_0;
  };
  MessageType.prototype.component5 = function () {
    return this.declaredFields;
  };
  MessageType.prototype.component6 = function () {
    return this.extensionFields;
  };
  MessageType.prototype.component7 = function () {
    return this.oneOfs;
  };
  MessageType.prototype.component8 = function () {
    return this.nestedTypes;
  };
  MessageType.prototype.component9_0 = function () {
    return this.extensionsList_0;
  };
  MessageType.prototype.component10_0 = function () {
    return this.reserveds_0;
  };
  MessageType.prototype.component11 = function () {
    return this.options;
  };
  MessageType.prototype.component12 = function () {
    return this.syntax;
  };
  MessageType.prototype.copy_ah9t53$ = function (type, location, documentation, name, declaredFields, extensionFields, oneOfs, nestedTypes, extensionsList, reserveds, options, syntax) {
    return new MessageType(type === void 0 ? this.type : type, location === void 0 ? this.location : location, documentation === void 0 ? this.documentation : documentation, name === void 0 ? this.name_0 : name, declaredFields === void 0 ? this.declaredFields : declaredFields, extensionFields === void 0 ? this.extensionFields : extensionFields, oneOfs === void 0 ? this.oneOfs : oneOfs, nestedTypes === void 0 ? this.nestedTypes : nestedTypes, extensionsList === void 0 ? this.extensionsList_0 : extensionsList, reserveds === void 0 ? this.reserveds_0 : reserveds, options === void 0 ? this.options : options, syntax === void 0 ? this.syntax : syntax);
  };
  MessageType.prototype.toString = function () {
    return 'MessageType(type=' + Kotlin.toString(this.type) + (', location=' + Kotlin.toString(this.location)) + (', documentation=' + Kotlin.toString(this.documentation)) + (', name=' + Kotlin.toString(this.name_0)) + (', declaredFields=' + Kotlin.toString(this.declaredFields)) + (', extensionFields=' + Kotlin.toString(this.extensionFields)) + (', oneOfs=' + Kotlin.toString(this.oneOfs)) + (', nestedTypes=' + Kotlin.toString(this.nestedTypes)) + (', extensionsList=' + Kotlin.toString(this.extensionsList_0)) + (', reserveds=' + Kotlin.toString(this.reserveds_0)) + (', options=' + Kotlin.toString(this.options)) + (', syntax=' + Kotlin.toString(this.syntax)) + ')';
  };
  MessageType.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.type) | 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.name_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.declaredFields) | 0;
    result = result * 31 + Kotlin.hashCode(this.extensionFields) | 0;
    result = result * 31 + Kotlin.hashCode(this.oneOfs) | 0;
    result = result * 31 + Kotlin.hashCode(this.nestedTypes) | 0;
    result = result * 31 + Kotlin.hashCode(this.extensionsList_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.reserveds_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    result = result * 31 + Kotlin.hashCode(this.syntax) | 0;
    return result;
  };
  MessageType.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.type, other.type) && Kotlin.equals(this.location, other.location) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.name_0, other.name_0) && Kotlin.equals(this.declaredFields, other.declaredFields) && Kotlin.equals(this.extensionFields, other.extensionFields) && Kotlin.equals(this.oneOfs, other.oneOfs) && Kotlin.equals(this.nestedTypes, other.nestedTypes) && Kotlin.equals(this.extensionsList_0, other.extensionsList_0) && Kotlin.equals(this.reserveds_0, other.reserveds_0) && Kotlin.equals(this.options, other.options) && Kotlin.equals(this.syntax, other.syntax)))));
  };
  function OneOf(name, documentation, fields) {
    OneOf$Companion_getInstance();
    this.name = name;
    this.documentation = documentation;
    this.fields = fields;
  }
  OneOf.prototype.link_n5k2qc$ = function (linker) {
    var tmp$;
    tmp$ = this.fields.iterator();
    while (tmp$.hasNext()) {
      var field = tmp$.next();
      field.link_n5k2qc$(linker);
    }
  };
  OneOf.prototype.linkOptions_tlzwp4$ = function (linker, syntaxRules, validate) {
    var tmp$;
    tmp$ = this.fields.iterator();
    while (tmp$.hasNext()) {
      var field = tmp$.next();
      field.linkOptions_tlzwp4$(linker, syntaxRules, validate);
    }
  };
  OneOf.prototype.retainAll_osl9ff$ = function (schema, markSet, enclosingType) {
    var tmp$;
    var retainedFields = Field$Companion_getInstance().retainAll_5bk9gv$(schema, markSet, enclosingType, this.fields);
    if (retainedFields.isEmpty())
      tmp$ = null;
    else
      tmp$ = new OneOf(this.name, this.documentation, retainedFields);
    return tmp$;
  };
  OneOf.prototype.retainLinked = function () {
    var tmp$;
    var retainedFields = Field$Companion_getInstance().retainLinked_nh6en2$(this.fields);
    if (retainedFields.isEmpty())
      tmp$ = null;
    else
      tmp$ = new OneOf(this.name, this.documentation, retainedFields);
    return tmp$;
  };
  function OneOf$Companion() {
    OneOf$Companion_instance = this;
  }
  OneOf$Companion.prototype.fromElements_ncp6tn$ = function (packageName, elements, extension) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(elements, 10));
    var tmp$;
    tmp$ = elements.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      var tmp$_0 = destination.add_11rb$;
      if (!item.groups.isEmpty()) {
        var location = item.groups.get_za3lpa$(0).component2();
        throw IllegalStateException_init_0(location.toString() + ": 'group' is not supported");
      }tmp$_0.call(destination, new OneOf(item.name, item.documentation, Field$Companion_getInstance().fromElements_az8v47$(packageName, item.fields, extension, true)));
    }
    return destination;
  };
  OneOf$Companion.prototype.toElements_rtbdp7$ = function (oneOfs) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(oneOfs, 10));
    var tmp$;
    tmp$ = oneOfs.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(new OneOfElement(item.name, item.documentation, Field$Companion_getInstance().toElements_nh6en2$(item.fields), emptyList()));
    }
    return destination;
  };
  OneOf$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OneOf$Companion_instance = null;
  function OneOf$Companion_getInstance() {
    if (OneOf$Companion_instance === null) {
      new OneOf$Companion();
    }return OneOf$Companion_instance;
  }
  OneOf.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OneOf',
    interfaces: []
  };
  OneOf.prototype.component1 = function () {
    return this.name;
  };
  OneOf.prototype.component2 = function () {
    return this.documentation;
  };
  OneOf.prototype.component3 = function () {
    return this.fields;
  };
  OneOf.prototype.copy_f7jl2y$ = function (name, documentation, fields) {
    return new OneOf(name === void 0 ? this.name : name, documentation === void 0 ? this.documentation : documentation, fields === void 0 ? this.fields : fields);
  };
  OneOf.prototype.toString = function () {
    return 'OneOf(name=' + Kotlin.toString(this.name) + (', documentation=' + Kotlin.toString(this.documentation)) + (', fields=' + Kotlin.toString(this.fields)) + ')';
  };
  OneOf.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.fields) | 0;
    return result;
  };
  OneOf.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.name, other.name) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.fields, other.fields)))));
  };
  function Options(optionType, optionElements) {
    Options$Companion_getInstance();
    this.optionType_0 = optionType;
    this.optionElements_0 = optionElements;
    this.entries_0 = null;
  }
  Object.defineProperty(Options.prototype, 'elements', {
    configurable: true,
    get: function () {
      var tmp$, tmp$_0;
      var tmp$_1;
      if ((tmp$ = this.entries_0) != null) {
        var destination = ArrayList_init_0(collectionSizeOrDefault(tmp$, 10));
        var tmp$_2;
        tmp$_2 = tmp$.iterator();
        while (tmp$_2.hasNext()) {
          var item = tmp$_2.next();
          destination.add_11rb$(item.optionElement);
        }
        tmp$_1 = destination;
      } else
        tmp$_1 = null;
      return (tmp$_0 = tmp$_1) != null ? tmp$_0 : this.optionElements_0;
    }
  });
  Object.defineProperty(Options.prototype, 'map', {
    configurable: true,
    get: function () {
      return this.toMap_0(ensureNotNull(this.entries_0));
    }
  });
  Options.prototype.retainLinked = function () {
    return new Options(this.optionType_0, emptyList());
  };
  Options.prototype.get_pnoc8b$ = function (protoMember) {
    var tmp$, tmp$_0;
    var tmp$_1;
    if ((tmp$ = this.entries_0) != null) {
      var firstOrNull$result;
      firstOrNull$break: do {
        var tmp$_2;
        tmp$_2 = tmp$.iterator();
        while (tmp$_2.hasNext()) {
          var element = tmp$_2.next();
          var tmp$_3;
          if ((tmp$_3 = element.protoMember) != null ? tmp$_3.equals(protoMember) : null) {
            firstOrNull$result = element;
            break firstOrNull$break;
          }}
        firstOrNull$result = null;
      }
       while (false);
      tmp$_1 = firstOrNull$result;
    } else
      tmp$_1 = null;
    return (tmp$_0 = tmp$_1) != null ? tmp$_0.value : null;
  };
  Options.prototype.optionMatches_puj7f4$ = function (namePattern, valuePattern) {
    var nameRegex = Regex_init(namePattern);
    var valueRegex = Regex_init(valuePattern);
    var $receiver = ensureNotNull(this.entries_0);
    var any$result;
    any$break: do {
      var tmp$;
      if (Kotlin.isType($receiver, Collection) && $receiver.isEmpty()) {
        any$result = false;
        break any$break;
      }tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (nameRegex.matchEntire_6bul2c$(element.protoMember.member) != null && valueRegex.matchEntire_6bul2c$(toString(element.value)) != null) {
          any$result = true;
          break any$break;
        }}
      any$result = false;
    }
     while (false);
    return any$result;
  };
  Options.prototype.link_jszzr1$ = function (linker, location, validate) {
    var tmp$, tmp$_0;
    var entries = emptyList();
    tmp$ = this.optionElements_0.iterator();
    while (tmp$.hasNext()) {
      var option = tmp$.next();
      tmp$_0 = this.canonicalizeOption_0(linker, this.optionType_0, option, validate, location);
      if (tmp$_0 == null) {
        continue;
      }var canonicalOption = tmp$_0;
      entries = this.union_0(linker, entries, canonicalOption);
    }
    this.entries_0 = entries;
  };
  Options.prototype.canonicalizeOption_0 = function (linker, extensionType, option, validate, location) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    tmp$_0 = Kotlin.isType(tmp$ = linker.getForOptions_rubud1$(extensionType), MessageType) ? tmp$ : null;
    if (tmp$_0 == null) {
      return null;
    }var type = tmp$_0;
    var path;
    var field = type.field_61zpoe$(option.name);
    if (field != null) {
      path = [option.name];
    } else {
      var extensionsForType = type.extensionFieldsMap();
      path = Options$Companion_getInstance().resolveFieldPath_hzppng$(option.name, extensionsForType.keys);
      var packageName = linker.packageName();
      var checkedExtensionFields = false;
      while (true) {
        var tmp$_4 = path == null;
        if (tmp$_4) {
          var $receiver = packageName;
          tmp$_4 = !($receiver == null || isBlank($receiver));
        }if (!tmp$_4)
          break;
        path = Options$Companion_getInstance().resolveFieldPath_hzppng$(packageName + '.' + option.name, extensionsForType.keys);
        if (path == null) {
          packageName = substringBeforeLast(packageName, '.', '');
          var $receiver_0 = packageName;
          if (($receiver_0 == null || isBlank($receiver_0)) && !checkedExtensionFields) {
            checkedExtensionFields = true;
            var $receiver_1 = type.extensionFields;
            var destination = ArrayList_init();
            var tmp$_5;
            tmp$_5 = $receiver_1.iterator();
            while (tmp$_5.hasNext()) {
              var element = tmp$_5.next();
              if (equals(element.name, option.name))
                destination.add_11rb$(element);
            }
            var extensionFields = destination;
            if (extensionFields.size > 1) {
              if (validate) {
                var tmp$_6 = linker.errors;
                var tmp$_7 = '\n' + '                   |ambiguous options ' + option.name + ' defined in' + '\n' + '                   |  ';
                var destination_0 = ArrayList_init_0(collectionSizeOrDefault(extensionFields, 10));
                var tmp$_8;
                tmp$_8 = extensionFields.iterator();
                while (tmp$_8.hasNext()) {
                  var item = tmp$_8.next();
                  destination_0.add_11rb$('- ' + item.location);
                }
                tmp$_6.plusAssign_61zpoe$(trimMargin(tmp$_7 + joinToString(destination_0, '\n  ') + '\n' + '                   '));
                return null;
              }} else {
              packageName = (tmp$_1 = firstOrNull(extensionFields)) != null ? tmp$_1.packageName : null;
            }
          }}}
      if (path == null) {
        if (validate) {
          linker.errors.plusAssign_61zpoe$('unable to resolve option ' + option.name);
        }return null;
      }field = extensionsForType.get_11rb$(path[0]);
      if (validate) {
        linker.withContext_za3rmp$(ensureNotNull(field)).validateImportForPath_liszf0$(location, field.location.path);
      }}
    linker.request_8id5cj$(ensureNotNull(field));
    var result = LinkedHashMap_init();
    var last = result;
    var lastProtoType = type.type;
    tmp$_2 = path.length;
    for (var i = 1; i < tmp$_2; i++) {
      var nested = LinkedHashMap_init();
      var $receiver_2 = last;
      var key = ProtoMember$Companion_getInstance().get_uige6c$(ensureNotNull(lastProtoType), ensureNotNull(field));
      $receiver_2.put_xwzc9p$(key, nested);
      lastProtoType = field.type;
      if (lastProtoType != null) {
        linker.getForOptions_rubud1$(lastProtoType);
      }last = nested;
      tmp$_3 = linker.dereference_qy1mv5$(field, path[i]);
      if (tmp$_3 == null) {
        return null;
      }field = tmp$_3;
      linker.request_8id5cj$(field);
    }
    var $receiver_3 = last;
    var key_0 = ProtoMember$Companion_getInstance().get_uige6c$(ensureNotNull(lastProtoType), ensureNotNull(field));
    var value = this.canonicalizeValue_0(linker, field, option.value);
    $receiver_3.put_xwzc9p$(key_0, value);
    if (!(result.size === 1)) {
      var message = 'Check failed.';
      throw IllegalStateException_init_0(message.toString());
    }var tmp$_9 = first(result.entries);
    var protoMember = tmp$_9.key;
    var value_0 = tmp$_9.value;
    return listOf(new LinkedOptionEntry(option, protoMember, value_0));
  };
  Options.prototype.canonicalizeValue_0 = function (linker, context, value) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    if (Kotlin.isType(value, OptionElement)) {
      var result = LinkedHashMap_init();
      var field = linker.dereference_qy1mv5$(context, value.name);
      if (field == null) {
        linker.errors.plusAssign_61zpoe$('unable to resolve option ' + value.name + ' on ' + toString(context.type));
      } else {
        var protoMember = ProtoMember$Companion_getInstance().get_uige6c$(ensureNotNull(context.type), field);
        var value_0 = this.canonicalizeValue_0(linker, field, value.value);
        result.put_xwzc9p$(protoMember, value_0);
      }
      return this.coerceValueForField_0(context, result);
    } else if (Kotlin.isType(value, Map)) {
      var result_0 = LinkedHashMap_init();
      tmp$ = value.entries.iterator();
      while (tmp$.hasNext()) {
        var entry = tmp$.next();
        var name = typeof (tmp$_0 = entry.key) === 'string' ? tmp$_0 : throwCCE();
        var field_0 = linker.dereference_qy1mv5$(context, name);
        if (field_0 == null) {
          linker.errors.plusAssign_61zpoe$('unable to resolve option ' + name + ' on ' + toString(context.type));
        } else {
          var protoMember_0 = ProtoMember$Companion_getInstance().get_uige6c$(ensureNotNull(context.type), field_0);
          var value_1 = this.canonicalizeValue_0(linker, field_0, ensureNotNull(entry.value));
          result_0.put_xwzc9p$(protoMember_0, value_1);
        }
      }
      return this.coerceValueForField_0(context, result_0);
    } else if (Kotlin.isType(value, List)) {
      var result_1 = ArrayList_init();
      tmp$_1 = value.iterator();
      while (tmp$_1.hasNext()) {
        var element = tmp$_1.next();
        result_1.addAll_brywnq$(Kotlin.isType(tmp$_2 = this.canonicalizeValue_0(linker, context, ensureNotNull(element)), List) ? tmp$_2 : throwCCE());
      }
      return this.coerceValueForField_0(context, result_1);
    } else if (typeof value === 'string')
      return this.coerceValueForField_0(context, value);
    else {
      throw IllegalArgumentException_init('Unexpected option value: ' + value.toString());
    }
  };
  Options.prototype.coerceValueForField_0 = function (context, value) {
    var tmp$, tmp$_0, tmp$_1;
    if (context.isRepeated)
      tmp$_1 = (tmp$_0 = Kotlin.isType(tmp$ = value, List) ? tmp$ : null) != null ? tmp$_0 : listOf(value);
    else if (Kotlin.isType(value, List))
      tmp$_1 = ensureNotNull(single(value));
    else
      tmp$_1 = value;
    return tmp$_1;
  };
  Options.prototype.union_2 = function (linker, a, b) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    if (Kotlin.isType(a, List)) {
      tmp$_2 = plus(a, Kotlin.isType(tmp$ = b, List) ? tmp$ : throwCCE());
    } else if (Kotlin.isType(a, Map)) {
      tmp$_2 = this.union_1(linker, Kotlin.isType(tmp$_0 = a, Map) ? tmp$_0 : throwCCE(), Kotlin.isType(tmp$_1 = b, Map) ? tmp$_1 : throwCCE());
    } else {
      linker.errors.plusAssign_61zpoe$('conflicting options: ' + a.toString() + ', ' + b.toString());
      tmp$_2 = a;
    }
    return tmp$_2;
  };
  Options.prototype.union_0 = function (linker, a, b) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    var aMap = this.toMap_0(a);
    var bMap = Kotlin.isType(tmp$ = this.toMap_0(b), Map) ? tmp$ : throwCCE();
    var valuesMap = LinkedHashMap_init_0(aMap);
    tmp$_0 = bMap.entries.iterator();
    while (tmp$_0.hasNext()) {
      var entry = tmp$_0.next();
      var bValue = entry.value;
      var aValue = valuesMap.get_11rb$(entry.key);
      tmp$_2 = entry.key;
      if (aValue != null)
        tmp$_1 = this.union_2(linker, aValue, bValue);
      else
        tmp$_1 = bValue;
      var value = tmp$_1;
      valuesMap.put_xwzc9p$(tmp$_2, value);
    }
    var destination = ArrayList_init_0(collectionSizeOrDefault(a, 10));
    var tmp$_3;
    tmp$_3 = a.iterator();
    while (tmp$_3.hasNext()) {
      var item = tmp$_3.next();
      destination.add_11rb$(to(item.optionElement, item.protoMember));
    }
    var destination_0 = ArrayList_init_0(collectionSizeOrDefault(b, 10));
    var tmp$_4;
    tmp$_4 = b.iterator();
    while (tmp$_4.hasNext()) {
      var item_0 = tmp$_4.next();
      destination_0.add_11rb$(to(item_0.optionElement, item_0.protoMember));
    }
    var $receiver = union(destination, destination_0);
    var destination_1 = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
    var tmp$_5;
    tmp$_5 = $receiver.iterator();
    while (tmp$_5.hasNext()) {
      var item_1 = tmp$_5.next();
      var tmp$_6 = destination_1.add_11rb$;
      var optionElement = item_1.component1()
      , protoMember = item_1.component2();
      tmp$_6.call(destination_1, new LinkedOptionEntry(optionElement, protoMember, valuesMap.get_11rb$(protoMember)));
    }
    return destination_1;
  };
  Options.prototype.union_1 = function (linker, a, b) {
    var tmp$, tmp$_0, tmp$_1;
    var result = LinkedHashMap_init_0(a);
    tmp$ = b.entries.iterator();
    while (tmp$.hasNext()) {
      var entry = tmp$.next();
      var bValue = entry.value;
      var aValue = result.get_11rb$(entry.key);
      tmp$_1 = entry.key;
      if (aValue != null)
        tmp$_0 = this.union_2(linker, aValue, bValue);
      else
        tmp$_0 = bValue;
      var value = tmp$_0;
      result.put_xwzc9p$(tmp$_1, value);
    }
    return result;
  };
  Options.prototype.fields = function () {
    return this.fields_vl7o71$((new PruningRules$Builder()).build());
  };
  Options.prototype.fields_vl7o71$ = function (pruningRules) {
    var $receiver = LinkedHashMap_init();
    var tmp$;
    this.gatherFields_0($receiver, this.optionType_0, (tmp$ = this.entries_0) != null ? this.toMap_0(tmp$) : null, pruningRules);
    return toMultimap($receiver);
  };
  Options.prototype.gatherFields_0 = function (sink, type, o, pruningRules) {
    var tmp$, tmp$_0, tmp$_1;
    if (Kotlin.isType(o, Map)) {
      tmp$ = o.entries.iterator();
      while (tmp$.hasNext()) {
        var tmp$_2 = tmp$.next();
        var key = tmp$_2.key;
        var value = tmp$_2.value;
        var protoMember = Kotlin.isType(tmp$_0 = key, ProtoMember) ? tmp$_0 : throwCCE();
        if (pruningRules.prunes_pnoc8b$(protoMember))
          continue;
        var tmp$_3;
        var value_0 = sink.get_11rb$(type);
        if (value_0 == null) {
          var answer = ArrayList_init();
          sink.put_xwzc9p$(type, answer);
          tmp$_3 = answer;
        } else {
          tmp$_3 = value_0;
        }
        tmp$_3.add_11rb$(protoMember);
        this.gatherFields_0(sink, protoMember.type, ensureNotNull(value), pruningRules);
      }
    } else if (Kotlin.isType(o, List)) {
      tmp$_1 = o.iterator();
      while (tmp$_1.hasNext()) {
        var e = tmp$_1.next();
        this.gatherFields_0(sink, type, ensureNotNull(e), pruningRules);
      }
    }};
  Options.prototype.retainAll_crjjl2$ = function (schema, markSet) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    var $receiver = this.entries_0;
    if ($receiver == null || $receiver.isEmpty())
      return this;
    var result = new Options(this.optionType_0, this.optionElements_0);
    var map = (tmp$_0 = (tmp$ = this.retainAll_0(schema, markSet, this.optionType_0, this.toMap_0(ensureNotNull(this.entries_0)))) == null || Kotlin.isType(tmp$, Map) ? tmp$ : throwCCE()) != null ? tmp$_0 : emptyMap();
    var tmp$_3;
    if ((tmp$_1 = this.entries_0) != null) {
      var destination = ArrayList_init();
      var tmp$_4;
      tmp$_4 = tmp$_1.iterator();
      while (tmp$_4.hasNext()) {
        var element = tmp$_4.next();
        if (map.containsKey_11rb$(element.protoMember))
          destination.add_11rb$(element);
      }
      tmp$_3 = destination;
    } else
      tmp$_3 = null;
    var tmp$_5;
    if ((tmp$_2 = tmp$_3) != null) {
      var destination_0 = ArrayList_init_0(collectionSizeOrDefault(tmp$_2, 10));
      var tmp$_6;
      tmp$_6 = tmp$_2.iterator();
      while (tmp$_6.hasNext()) {
        var item = tmp$_6.next();
        destination_0.add_11rb$(item.copy_5lxijr$(void 0, void 0, getValue(map, item.protoMember)));
      }
      tmp$_5 = destination_0;
    } else
      tmp$_5 = null;
    result.entries_0 = tmp$_5;
    return result;
  };
  Options.prototype.retainAll_0 = function (schema, markSet, type, o) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    if (Kotlin.isType(o, Map)) {
      var map = LinkedHashMap_init();
      tmp$ = o.entries.iterator();
      while (tmp$.hasNext()) {
        var tmp$_3 = tmp$.next();
        var key = tmp$_3.key;
        var value = tmp$_3.value;
        var protoMember = Kotlin.isType(tmp$_0 = key, ProtoMember) ? tmp$_0 : throwCCE();
        var isCoreMemberOfGoogleProtobuf = contains(Options$Companion_getInstance().GOOGLE_PROTOBUF_OPTION_TYPES, protoMember.type) && !schema.isExtensionField_pnoc8b$(protoMember);
        if (!markSet.contains_pnoc8b$(protoMember) && !isCoreMemberOfGoogleProtobuf) {
          continue;
        }var field = ensureNotNull(schema.getField_pnoc8b$(protoMember));
        var retainedValue = this.retainAll_0(schema, markSet, field.type, ensureNotNull(value));
        if (retainedValue != null) {
          map.put_xwzc9p$(protoMember, retainedValue);
        } else if (isCoreMemberOfGoogleProtobuf) {
          map.put_xwzc9p$(protoMember, value);
        }}
      tmp$_2 = !map.isEmpty() ? map : null;
    } else if (Kotlin.isType(o, List)) {
      var list = ArrayList_init();
      tmp$_1 = o.iterator();
      while (tmp$_1.hasNext()) {
        var value_0 = tmp$_1.next();
        var retainedValue_0 = this.retainAll_0(schema, markSet, type, ensureNotNull(value_0));
        if (retainedValue_0 != null) {
          list.add_11rb$(retainedValue_0);
        }}
      tmp$_2 = !list.isEmpty() ? list : null;
    } else if (!markSet.contains_rubud1$(ensureNotNull(type)))
      tmp$_2 = null;
    else
      tmp$_2 = o;
    return tmp$_2;
  };
  Options.prototype.assignsMember_e1pxdi$ = function (protoMember) {
    var tmp$, tmp$_0;
    var tmp$_1;
    if ((tmp$ = this.entries_0) != null) {
      var any$result;
      any$break: do {
        var tmp$_2;
        if (Kotlin.isType(tmp$, Collection) && tmp$.isEmpty()) {
          any$result = false;
          break any$break;
        }tmp$_2 = tmp$.iterator();
        while (tmp$_2.hasNext()) {
          var element = tmp$_2.next();
          if (equals(element.protoMember, protoMember)) {
            any$result = true;
            break any$break;
          }}
        any$result = false;
      }
       while (false);
      tmp$_1 = any$result;
    } else
      tmp$_1 = null;
    return (tmp$_0 = tmp$_1) != null ? tmp$_0 : false;
  };
  function Options$Companion() {
    Options$Companion_instance = this;
    this.FILE_OPTIONS = ProtoType$Companion_getInstance().get_pdl1vj$('google.protobuf.FileOptions');
    this.MESSAGE_OPTIONS = ProtoType$Companion_getInstance().get_pdl1vj$('google.protobuf.MessageOptions');
    this.FIELD_OPTIONS = ProtoType$Companion_getInstance().get_pdl1vj$('google.protobuf.FieldOptions');
    this.ENUM_OPTIONS = ProtoType$Companion_getInstance().get_pdl1vj$('google.protobuf.EnumOptions');
    this.ENUM_VALUE_OPTIONS = ProtoType$Companion_getInstance().get_pdl1vj$('google.protobuf.EnumValueOptions');
    this.SERVICE_OPTIONS = ProtoType$Companion_getInstance().get_pdl1vj$('google.protobuf.ServiceOptions');
    this.METHOD_OPTIONS = ProtoType$Companion_getInstance().get_pdl1vj$('google.protobuf.MethodOptions');
    this.GOOGLE_PROTOBUF_OPTION_TYPES = [this.FILE_OPTIONS, this.MESSAGE_OPTIONS, this.FIELD_OPTIONS, this.ENUM_OPTIONS, this.ENUM_VALUE_OPTIONS, this.SERVICE_OPTIONS, this.METHOD_OPTIONS];
  }
  Options$Companion.prototype.resolveFieldPath_hzppng$ = function (name, fullyQualifiedNames) {
    var pos = 0;
    while (pos < name.length) {
      pos = indexOf(name, 46, pos);
      if (pos === -1)
        pos = name.length;
      var endIndex = pos;
      var candidate = name.substring(0, endIndex);
      if (fullyQualifiedNames.contains_11rb$(candidate)) {
        var startIndex = pos;
        var path = copyToArray(split(name.substring(startIndex), Kotlin.charArrayOf(46)));
        var endIndex_0 = pos;
        path[0] = name.substring(0, endIndex_0);
        return path;
      }pos = pos + 1 | 0;
    }
    return null;
  };
  Options$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Options$Companion_instance = null;
  function Options$Companion_getInstance() {
    if (Options$Companion_instance === null) {
      new Options$Companion();
    }return Options$Companion_instance;
  }
  Options.prototype.toMap_0 = function ($receiver) {
    var destination = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(to(item.protoMember, item.value));
    }
    return toMap(destination);
  };
  Options.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Options',
    interfaces: []
  };
  function ProtoFile(location, imports, publicImports, packageName, types, services, extendList, options, syntax) {
    ProtoFile$Companion_getInstance();
    this.location = location;
    this.imports = imports;
    this.publicImports = publicImports;
    this.packageName = packageName;
    this.types = types;
    this.services = services;
    this.extendList = extendList;
    this.options = options;
    this.syntax = syntax;
    this.javaPackage_0 = null;
  }
  ProtoFile.prototype.toElement = function () {
    return new ProtoFileElement(this.location, this.packageName, this.syntax, this.imports, this.publicImports, Type$Companion_getInstance().toElements_qiljpy$(this.types), Service$Companion_getInstance().toElements_arnyqo$(this.services), Extend$Companion_getInstance().toElements_a4ss5m$(this.extendList), this.options.elements);
  };
  ProtoFile.prototype.name = function () {
    var result = this.location.path;
    var slashIndex = lastIndexOf(result, 47);
    if (slashIndex !== -1) {
      var $receiver = result;
      var startIndex = slashIndex + 1 | 0;
      result = $receiver.substring(startIndex);
    }if (endsWith(result, '.proto')) {
      var $receiver_0 = result;
      var endIndex = result.length - 6 | 0;
      result = $receiver_0.substring(0, endIndex);
    }return result;
  };
  ProtoFile.prototype.typesAndNestedTypes = function () {
    var tmp$;
    var typesAndNestedTypes = ArrayList_init();
    tmp$ = this.types.iterator();
    while (tmp$.hasNext()) {
      var type = tmp$.next();
      typesAndNestedTypes.addAll_brywnq$(type.typesAndNestedTypes());
    }
    return typesAndNestedTypes;
  };
  ProtoFile.prototype.javaPackage = function () {
    var tmp$;
    return (tmp$ = this.javaPackage_0) != null ? tmp$.toString() : null;
  };
  ProtoFile.prototype.wirePackage = function () {
    var tmp$;
    return (tmp$ = this.options.get_pnoc8b$(ProtoFile$Companion_getInstance().WIRE_PACKAGE)) != null ? tmp$.toString() : null;
  };
  ProtoFile.prototype.retainAll_crjjl2$ = function (schema, markSet) {
    var $receiver = this.types;
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0;
      if ((tmp$_0 = element.retainAll_crjjl2$(schema, markSet)) != null) {
        destination.add_11rb$(tmp$_0);
      }}
    var retainedTypes = destination;
    var $receiver_0 = this.services;
    var destination_0 = ArrayList_init();
    var tmp$_1;
    tmp$_1 = $receiver_0.iterator();
    while (tmp$_1.hasNext()) {
      var element_0 = tmp$_1.next();
      var tmp$_0_0;
      if ((tmp$_0_0 = element_0.retainAll_crjjl2$(schema, markSet)) != null) {
        destination_0.add_11rb$(tmp$_0_0);
      }}
    var retainedServices = destination_0;
    var $receiver_1 = this.extendList;
    var destination_1 = ArrayList_init();
    var tmp$_2;
    tmp$_2 = $receiver_1.iterator();
    while (tmp$_2.hasNext()) {
      var element_1 = tmp$_2.next();
      var tmp$_0_1;
      if ((tmp$_0_1 = element_1.retainAll_crjjl2$(schema, markSet)) != null) {
        destination_1.add_11rb$(tmp$_0_1);
      }}
    var retainedExtends = destination_1;
    var retainedOptions = this.options.retainAll_crjjl2$(schema, markSet);
    var result = new ProtoFile(this.location, this.imports, this.publicImports, this.packageName, retainedTypes, retainedServices, retainedExtends, retainedOptions, this.syntax);
    result.javaPackage_0 = this.javaPackage_0;
    return result;
  };
  ProtoFile.prototype.retainLinked_mnadk8$ = function (linkedTypes, linkedFields) {
    var $receiver = this.types;
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0;
      if ((tmp$_0 = element.retainLinked_d9h3fi$(linkedTypes)) != null) {
        destination.add_11rb$(tmp$_0);
      }}
    var retainedTypes = destination;
    var $receiver_0 = this.extendList;
    var destination_0 = ArrayList_init();
    var tmp$_1;
    tmp$_1 = $receiver_0.iterator();
    while (tmp$_1.hasNext()) {
      var element_0 = tmp$_1.next();
      var tmp$_0_0;
      if ((tmp$_0_0 = element_0.retainLinked_hclq1m$(linkedFields)) != null) {
        destination_0.add_11rb$(tmp$_0_0);
      }}
    var retainedExtends = destination_0;
    var retainedServices = emptyList();
    var retainedOptions = this.options.retainLinked();
    var result = new ProtoFile(this.location, this.imports, this.publicImports, this.packageName, retainedTypes, retainedServices, retainedExtends, retainedOptions, this.syntax);
    result.javaPackage_0 = this.javaPackage_0;
    return result;
  };
  ProtoFile.prototype.retainImports_6yuc0k$ = function (retained) {
    var tmp$, tmp$_0, tmp$_1;
    var retainedImports = ArrayList_init();
    tmp$ = this.imports.iterator();
    loop_label: while (tmp$.hasNext()) {
      var path = tmp$.next();
      tmp$_0 = ProtoFile$Companion_getInstance().findProtoFile_0(retained, path);
      if (tmp$_0 == null) {
        continue loop_label;
      }var importedProtoFile = tmp$_0;
      var tmp$_2 = equals(path, 'google/protobuf/descriptor.proto');
      if (tmp$_2) {
        var $receiver = this.extendList;
        var any$result;
        any$break: do {
          var tmp$_3;
          if (Kotlin.isType($receiver, Collection) && $receiver.isEmpty()) {
            any$result = false;
            break any$break;
          }tmp$_3 = $receiver.iterator();
          while (tmp$_3.hasNext()) {
            var element = tmp$_3.next();
            if (startsWith(element.name, 'google.protobuf.')) {
              any$result = true;
              break any$break;
            }}
          any$result = false;
        }
         while (false);
        tmp$_2 = any$result;
      }if (tmp$_2) {
        retainedImports.add_11rb$(path);
      } else {
        var tmp$_4 = !importedProtoFile.types.isEmpty();
        if (!tmp$_4) {
          tmp$_4 = !importedProtoFile.services.isEmpty();
        }var tmp$_5 = tmp$_4;
        if (!tmp$_5) {
          tmp$_5 = !importedProtoFile.extendList.isEmpty();
        }if (tmp$_5) {
          retainedImports.add_11rb$(path);
        }}
    }
    if (this.imports.size !== retainedImports.size) {
      var result = new ProtoFile(this.location, retainedImports, this.publicImports, this.packageName, this.types, this.services, this.extendList, this.options, this.syntax);
      result.javaPackage_0 = this.javaPackage_0;
      tmp$_1 = result;
    } else {
      tmp$_1 = this;
    }
    return tmp$_1;
  };
  ProtoFile.prototype.linkOptions_dgdekt$ = function (linker, validate) {
    this.options.link_jszzr1$(linker, this.location, validate);
    this.javaPackage_0 = this.options.get_pnoc8b$(ProtoFile$Companion_getInstance().JAVA_PACKAGE);
  };
  ProtoFile.prototype.toString = function () {
    return this.location.path;
  };
  ProtoFile.prototype.toSchema = function () {
    return this.toElement().toSchema();
  };
  ProtoFile.prototype.validate_n5k2qc$ = function (linker) {
    linker.validateEnumConstantNameUniqueness_z7e7cu$(this.types);
  };
  function ProtoFile$Companion() {
    ProtoFile$Companion_instance = this;
    this.JAVA_PACKAGE = ProtoMember$Companion_getInstance().get_bu2imf$(Options$Companion_getInstance().FILE_OPTIONS, 'java_package');
    this.WIRE_PACKAGE = ProtoMember$Companion_getInstance().get_bu2imf$(Options$Companion_getInstance().FILE_OPTIONS, 'wire.wire_package');
  }
  ProtoFile$Companion.prototype.get_kp3y0t$ = function (protoFileElement) {
    var tmp$;
    var packageName = protoFileElement.packageName;
    var syntax = (tmp$ = protoFileElement.syntax) != null ? tmp$ : Syntax.PROTO_2;
    var types = Type$Companion_getInstance().fromElements_5dmk34$(packageName, protoFileElement.types, syntax);
    var services = Service$Companion_getInstance().fromElements_qmwtvz$(packageName, protoFileElement.services);
    var wireExtends = Extend$Companion_getInstance().fromElements_m6gyht$(packageName, protoFileElement.extendDeclarations);
    var options = new Options(Options$Companion_getInstance().FILE_OPTIONS, protoFileElement.options);
    return new ProtoFile(protoFileElement.location, protoFileElement.imports, protoFileElement.publicImports, packageName, types, services, wireExtends, options, protoFileElement.syntax);
  };
  ProtoFile$Companion.prototype.findProtoFile_0 = function (protoFiles, path) {
    var firstOrNull$result;
    firstOrNull$break: do {
      var tmp$;
      tmp$ = protoFiles.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (equals(element.location.path, path)) {
          firstOrNull$result = element;
          break firstOrNull$break;
        }}
      firstOrNull$result = null;
    }
     while (false);
    return firstOrNull$result;
  };
  ProtoFile$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ProtoFile$Companion_instance = null;
  function ProtoFile$Companion_getInstance() {
    if (ProtoFile$Companion_instance === null) {
      new ProtoFile$Companion();
    }return ProtoFile$Companion_instance;
  }
  ProtoFile.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ProtoFile',
    interfaces: []
  };
  ProtoFile.prototype.component1 = function () {
    return this.location;
  };
  ProtoFile.prototype.component2 = function () {
    return this.imports;
  };
  ProtoFile.prototype.component3 = function () {
    return this.publicImports;
  };
  ProtoFile.prototype.component4 = function () {
    return this.packageName;
  };
  ProtoFile.prototype.component5 = function () {
    return this.types;
  };
  ProtoFile.prototype.component6 = function () {
    return this.services;
  };
  ProtoFile.prototype.component7 = function () {
    return this.extendList;
  };
  ProtoFile.prototype.component8 = function () {
    return this.options;
  };
  ProtoFile.prototype.component9 = function () {
    return this.syntax;
  };
  ProtoFile.prototype.copy_ookjol$ = function (location, imports, publicImports, packageName, types, services, extendList, options, syntax) {
    return new ProtoFile(location === void 0 ? this.location : location, imports === void 0 ? this.imports : imports, publicImports === void 0 ? this.publicImports : publicImports, packageName === void 0 ? this.packageName : packageName, types === void 0 ? this.types : types, services === void 0 ? this.services : services, extendList === void 0 ? this.extendList : extendList, options === void 0 ? this.options : options, syntax === void 0 ? this.syntax : syntax);
  };
  ProtoFile.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.imports) | 0;
    result = result * 31 + Kotlin.hashCode(this.publicImports) | 0;
    result = result * 31 + Kotlin.hashCode(this.packageName) | 0;
    result = result * 31 + Kotlin.hashCode(this.types) | 0;
    result = result * 31 + Kotlin.hashCode(this.services) | 0;
    result = result * 31 + Kotlin.hashCode(this.extendList) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    result = result * 31 + Kotlin.hashCode(this.syntax) | 0;
    return result;
  };
  ProtoFile.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.imports, other.imports) && Kotlin.equals(this.publicImports, other.publicImports) && Kotlin.equals(this.packageName, other.packageName) && Kotlin.equals(this.types, other.types) && Kotlin.equals(this.services, other.services) && Kotlin.equals(this.extendList, other.extendList) && Kotlin.equals(this.options, other.options) && Kotlin.equals(this.syntax, other.syntax)))));
  };
  function ProtoMember(type, member) {
    ProtoMember$Companion_getInstance();
    this.type = type;
    this.member = member;
  }
  Object.defineProperty(ProtoMember.prototype, 'simpleName', {
    configurable: true,
    get: function () {
      return substringAfterLast(this.member, 46);
    }
  });
  ProtoMember.prototype.equals = function (other) {
    var tmp$;
    return Kotlin.isType(other, ProtoMember) && ((tmp$ = this.type) != null ? tmp$.equals(other.type) : null) && equals(this.member, other.member);
  };
  ProtoMember.prototype.hashCode = function () {
    return (this.type.hashCode() * 37 | 0) + hashCode(this.member) | 0;
  };
  ProtoMember.prototype.toString = function () {
    return this.type.toString() + '#' + this.member;
  };
  function ProtoMember$Companion() {
    ProtoMember$Companion_instance = this;
  }
  ProtoMember$Companion.prototype.get_61zpoe$ = function (typeAndMember) {
    var hash = indexOf(typeAndMember, 35);
    if (!(hash !== -1)) {
      var message = "expected a '#' in " + typeAndMember;
      throw IllegalArgumentException_init(message.toString());
    }var type = ProtoType$Companion_getInstance().get_pdl1vj$(typeAndMember.substring(0, hash));
    var startIndex = hash + 1 | 0;
    var member = typeAndMember.substring(startIndex);
    return new ProtoMember(type, member);
  };
  ProtoMember$Companion.prototype.get_bu2imf$ = function (type, member) {
    return new ProtoMember(type, member);
  };
  ProtoMember$Companion.prototype.get_uige6c$ = function (type, field) {
    var member = field.isExtension ? field.qualifiedName : field.name;
    return new ProtoMember(type, member);
  };
  ProtoMember$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ProtoMember$Companion_instance = null;
  function ProtoMember$Companion_getInstance() {
    if (ProtoMember$Companion_instance === null) {
      new ProtoMember$Companion();
    }return ProtoMember$Companion_instance;
  }
  ProtoMember.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ProtoMember',
    interfaces: []
  };
  function ProtoType() {
    ProtoType$Companion_getInstance();
    this.isScalar = false;
    this.string_0 = null;
    this.isMap = false;
    this.keyType = null;
    this.valueType = null;
  }
  Object.defineProperty(ProtoType.prototype, 'simpleName', {
    configurable: true,
    get: function () {
      var dot = lastIndexOf(this.string_0, 46);
      var $receiver = this.string_0;
      var startIndex = dot + 1 | 0;
      return $receiver.substring(startIndex);
    }
  });
  Object.defineProperty(ProtoType.prototype, 'enclosingTypeOrPackage', {
    configurable: true,
    get: function () {
      var dot = lastIndexOf(this.string_0, 46);
      return dot === -1 ? null : this.string_0.substring(0, dot);
    }
  });
  Object.defineProperty(ProtoType.prototype, 'typeUrl', {
    configurable: true,
    get: function () {
      var tmp$;
      if (this.isScalar || this.isMap)
        tmp$ = null;
      else
        tmp$ = 'type.googleapis.com/' + this.string_0;
      return tmp$;
    }
  });
  ProtoType.prototype.nestedType_pdl1vj$ = function (name) {
    if (!!this.isScalar) {
      var message = 'scalar cannot have a nested type';
      throw IllegalStateException_init_0(message.toString());
    }if (!!this.isMap) {
      var message_0 = 'map cannot have a nested type';
      throw IllegalStateException_init_0(message_0.toString());
    }var tmp$ = name != null && !contains_0(name, '.');
    if (tmp$) {
      tmp$ = name.length > 0;
    }if (!tmp$) {
      var message_1 = 'unexpected name: ' + toString(name);
      throw IllegalArgumentException_init(message_1.toString());
    }return ProtoType_init(false, this.string_0 + '.' + toString(name));
  };
  ProtoType.prototype.equals = function (other) {
    return Kotlin.isType(other, ProtoType) && equals(this.string_0, other.string_0);
  };
  ProtoType.prototype.hashCode = function () {
    return hashCode(this.string_0);
  };
  ProtoType.prototype.toString = function () {
    return this.string_0;
  };
  function ProtoType$Companion() {
    ProtoType$Companion_instance = this;
    this.BOOL = ProtoType_init(true, 'bool');
    this.BYTES = ProtoType_init(true, 'bytes');
    this.DOUBLE = ProtoType_init(true, 'double');
    this.FLOAT = ProtoType_init(true, 'float');
    this.FIXED32 = ProtoType_init(true, 'fixed32');
    this.FIXED64 = ProtoType_init(true, 'fixed64');
    this.INT32 = ProtoType_init(true, 'int32');
    this.INT64 = ProtoType_init(true, 'int64');
    this.SFIXED32 = ProtoType_init(true, 'sfixed32');
    this.SFIXED64 = ProtoType_init(true, 'sfixed64');
    this.SINT32 = ProtoType_init(true, 'sint32');
    this.SINT64 = ProtoType_init(true, 'sint64');
    this.STRING = ProtoType_init(true, 'string');
    this.UINT32 = ProtoType_init(true, 'uint32');
    this.UINT64 = ProtoType_init(true, 'uint64');
    this.ANY = ProtoType_init(false, 'google.protobuf.Any');
    this.DURATION = ProtoType_init(false, 'google.protobuf.Duration');
    this.TIMESTAMP = ProtoType_init(false, 'google.protobuf.Timestamp');
    this.EMPTY = ProtoType_init(false, 'google.protobuf.Empty');
    this.STRUCT_MAP = ProtoType_init(false, 'google.protobuf.Struct');
    this.STRUCT_VALUE = ProtoType_init(false, 'google.protobuf.Value');
    this.STRUCT_NULL = ProtoType_init(false, 'google.protobuf.NullValue');
    this.STRUCT_LIST = ProtoType_init(false, 'google.protobuf.ListValue');
    this.DOUBLE_VALUE = ProtoType_init(false, 'google.protobuf.DoubleValue');
    this.FLOAT_VALUE = ProtoType_init(false, 'google.protobuf.FloatValue');
    this.INT64_VALUE = ProtoType_init(false, 'google.protobuf.Int64Value');
    this.UINT64_VALUE = ProtoType_init(false, 'google.protobuf.UInt64Value');
    this.INT32_VALUE = ProtoType_init(false, 'google.protobuf.Int32Value');
    this.UINT32_VALUE = ProtoType_init(false, 'google.protobuf.UInt32Value');
    this.BOOL_VALUE = ProtoType_init(false, 'google.protobuf.BoolValue');
    this.STRING_VALUE = ProtoType_init(false, 'google.protobuf.StringValue');
    this.BYTES_VALUE = ProtoType_init(false, 'google.protobuf.BytesValue');
    var $receiver = listOf_0([this.BOOL, this.BYTES, this.DOUBLE, this.FLOAT, this.FIXED32, this.FIXED64, this.INT32, this.INT64, this.SFIXED32, this.SFIXED64, this.SINT32, this.SINT64, this.STRING, this.UINT32, this.UINT64]);
    var capacity = coerceAtLeast(mapCapacity(collectionSizeOrDefault($receiver, 10)), 16);
    var destination = LinkedHashMap_init_1(capacity);
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      destination.put_xwzc9p$(element.string_0, element);
    }
    this.SCALAR_TYPES_0 = destination;
    this.NUMERIC_SCALAR_TYPES_8be2vx$ = listOf_0([this.DOUBLE, this.FLOAT, this.FIXED32, this.FIXED64, this.INT32, this.INT64, this.SFIXED32, this.SFIXED64, this.SINT32, this.SINT64, this.UINT32, this.UINT64]);
  }
  ProtoType$Companion.prototype.get_f5e6j7$ = function (enclosingTypeOrPackage, typeName) {
    var tmp$;
    if (enclosingTypeOrPackage != null)
      tmp$ = this.get_pdl1vj$(toString(enclosingTypeOrPackage) + '.' + typeName);
    else
      tmp$ = this.get_pdl1vj$(typeName);
    return tmp$;
  };
  ProtoType$Companion.prototype.get_pdl1vj$ = function (name) {
    var $receiver = this.SCALAR_TYPES_0;
    var tmp$;
    var scalar = (Kotlin.isType(tmp$ = $receiver, Map) ? tmp$ : throwCCE()).get_11rb$(name);
    if (scalar != null)
      return scalar;
    var tmp$_0 = name != null;
    if (tmp$_0) {
      tmp$_0 = name.length > 0;
    }if (!(tmp$_0 && !contains_0(name, '#'))) {
      var message = 'unexpected name: ' + toString(name);
      throw IllegalArgumentException_init(message.toString());
    }if (startsWith(name, 'map<') && endsWith(name, '>')) {
      var comma = indexOf(name, 44);
      if (!(comma !== -1)) {
        var message_0 = "expected ',' in map type: " + toString(name);
        throw IllegalArgumentException_init(message_0.toString());
      }var $receiver_0 = name.substring(4, comma);
      var tmp$_1;
      var key = this.get_pdl1vj$(trim(Kotlin.isCharSequence(tmp$_1 = $receiver_0) ? tmp$_1 : throwCCE()).toString());
      var startIndex = comma + 1 | 0;
      var endIndex = name.length - 1 | 0;
      var $receiver_1 = name.substring(startIndex, endIndex);
      var tmp$_2;
      var value = this.get_pdl1vj$(trim(Kotlin.isCharSequence(tmp$_2 = $receiver_1) ? tmp$_2 : throwCCE()).toString());
      return ProtoType_init_0(key, value, name);
    }return ProtoType_init(false, name);
  };
  ProtoType$Companion.prototype.get_xvxixq$ = function (keyType, valueType, name) {
    return ProtoType_init_0(keyType, valueType, name);
  };
  ProtoType$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ProtoType$Companion_instance = null;
  function ProtoType$Companion_getInstance() {
    if (ProtoType$Companion_instance === null) {
      new ProtoType$Companion();
    }return ProtoType$Companion_instance;
  }
  ProtoType.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ProtoType',
    interfaces: []
  };
  function ProtoType_init(isScalar, string, $this) {
    $this = $this || Object.create(ProtoType.prototype);
    ProtoType.call($this);
    $this.isScalar = isScalar;
    $this.string_0 = string;
    $this.isMap = false;
    $this.keyType = null;
    $this.valueType = null;
    return $this;
  }
  function ProtoType_init_0(keyType, valueType, string, $this) {
    $this = $this || Object.create(ProtoType.prototype);
    ProtoType.call($this);
    if (!(keyType.isScalar && !(keyType != null ? keyType.equals(ProtoType$Companion_getInstance().BYTES) : null) && !(keyType != null ? keyType.equals(ProtoType$Companion_getInstance().DOUBLE) : null) && !(keyType != null ? keyType.equals(ProtoType$Companion_getInstance().FLOAT) : null))) {
      var message = 'map key must be non-byte, non-floating point scalar: ' + keyType;
      throw IllegalArgumentException_init(message.toString());
    }$this.isScalar = false;
    $this.string_0 = string;
    $this.isMap = true;
    $this.keyType = keyType;
    $this.valueType = valueType;
    return $this;
  }
  function Pruner(schema, pruningRules) {
    this.schema_0 = schema;
    this.pruningRules_0 = pruningRules;
    this.marks_0 = new MarkSet(this.pruningRules_0);
    this.queue_0 = mutableQueueOf();
  }
  Pruner.prototype.prune = function () {
    this.markRoots_0();
    this.markReachable_0();
    var retained = this.retainImports_0(this.retainAll_0(this.schema_0, this.marks_0));
    return new Schema(retained);
  };
  Pruner.prototype.retainAll_0 = function (schema, marks) {
    var $receiver = schema.protoFiles;
    var destination = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(item.retainAll_crjjl2$(schema, marks));
    }
    return destination;
  };
  Pruner.prototype.retainImports_0 = function (protoFiles) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(protoFiles, 10));
    var tmp$;
    tmp$ = protoFiles.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(item.retainImports_6yuc0k$(protoFiles));
    }
    return destination;
  };
  Pruner.prototype.markRoots_0 = function () {
    var tmp$;
    tmp$ = this.schema_0.protoFiles.iterator();
    while (tmp$.hasNext()) {
      var protoFile = tmp$.next();
      this.markRoots_1(protoFile);
    }
  };
  Pruner.prototype.markRoots_1 = function (protoFile) {
    var tmp$, tmp$_0;
    tmp$ = protoFile.types.iterator();
    while (tmp$.hasNext()) {
      var type = tmp$.next();
      this.markRootsIncludingNested_0(type);
    }
    tmp$_0 = protoFile.services.iterator();
    while (tmp$_0.hasNext()) {
      var service = tmp$_0.next();
      this.markRoots_2(service.type);
    }
  };
  Pruner.prototype.markRootsIncludingNested_0 = function (type) {
    var tmp$;
    this.markRoots_2(type.type);
    tmp$ = type.nestedTypes.iterator();
    while (tmp$.hasNext()) {
      var nested = tmp$.next();
      this.markRootsIncludingNested_0(nested);
    }
  };
  Pruner.prototype.markRoots_2 = function (protoType) {
    var tmp$;
    if (this.pruningRules_0.isRoot_rubud1$(protoType)) {
      this.marks_0.root_rubud1$(protoType);
      this.queue_0.add_11rb$(protoType);
      return;
    }tmp$ = this.reachableObjects_0(protoType).iterator();
    while (tmp$.hasNext()) {
      var reachable = tmp$.next();
      if (!Kotlin.isType(reachable, ProtoMember))
        continue;
      if (!this.isRetainedVersion_0(reachable))
        continue;
      if (this.pruningRules_0.isRoot_pnoc8b$(reachable)) {
        this.marks_0.root_pnoc8b$(reachable);
        this.marks_0.mark_rubud1$(reachable.type);
        this.queue_0.add_11rb$(reachable);
      }}
  };
  Pruner.prototype.isRetainedVersion_0 = function (protoMember) {
    var tmp$, tmp$_0;
    var member = protoMember.member;
    var type = this.schema_0.getType_rubud1$(protoMember.type);
    if (Kotlin.isType(type, MessageType)) {
      var field = (tmp$ = type.field_61zpoe$(member)) != null ? tmp$ : ensureNotNull(type.extensionField_61zpoe$(member));
      tmp$_0 = this.pruningRules_0.isFieldRetainedVersion_g46cmn$(field.options);
    } else if (Kotlin.isType(type, EnumType)) {
      var enumConstant = ensureNotNull(type.constant_61zpoe$(member));
      tmp$_0 = this.pruningRules_0.isEnumConstantRetainedVersion_g46cmn$(enumConstant.options);
    } else
      tmp$_0 = true;
    return tmp$_0;
  };
  Pruner.prototype.markReachable_0 = function () {
    var tmp$, tmp$_0;
    while (true) {
      tmp$ = this.queue_0.poll();
      if (tmp$ == null) {
        break;
      }var root = tmp$;
      var reachableMembers = this.reachableObjects_0(root);
      tmp$_0 = reachableMembers.iterator();
      while (tmp$_0.hasNext()) {
        var reachable = tmp$_0.next();
        if (Kotlin.isType(reachable, ProtoType))
          if (Kotlin.isType(root, ProtoMember)) {
            if (this.marks_0.mark_z6d430$(reachable, root)) {
              this.queue_0.add_11rb$(reachable);
            }} else {
            if (this.marks_0.mark_rubud1$(reachable)) {
              this.queue_0.add_11rb$(reachable);
            }}
         else if (Kotlin.isType(reachable, ProtoMember)) {
          if (this.isRetainedVersion_0(reachable) && this.marks_0.mark_pnoc8b$(reachable)) {
            this.queue_0.add_11rb$(reachable);
          }} else if (reachable != null) {
          throw IllegalStateException_init_0('unexpected object: ' + toString(reachable));
        }}
    }
  };
  Pruner.prototype.reachableObjects_0 = function (root) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7;
    var result = ArrayList_init();
    var options;
    var fileOptions = null;
    if (Kotlin.isType(root, ProtoMember)) {
      var member = root.member;
      var type = this.schema_0.getType_rubud1$(root.type);
      var service = this.schema_0.getService_rubud1$(root.type);
      if (Kotlin.isType(type, MessageType)) {
        var field = (tmp$ = type.field_61zpoe$(member)) != null ? tmp$ : type.extensionField_61zpoe$(member);
        if (field == null) {
          var message = 'unexpected member: ' + member;
          throw IllegalStateException_init_0(message.toString());
        }result.add_11rb$(field.type);
        options = field.options;
      } else if (Kotlin.isType(type, EnumType)) {
        tmp$_0 = type.constant_61zpoe$(member);
        if (tmp$_0 == null) {
          throw IllegalStateException_init_0('unexpected member: ' + member);
        }var constant = tmp$_0;
        options = constant.options;
      } else if (service != null) {
        tmp$_1 = service.rpc_61zpoe$(member);
        if (tmp$_1 == null) {
          throw IllegalStateException_init_0('unexpected rpc: ' + member);
        }var rpc = tmp$_1;
        result.add_11rb$(rpc.requestType);
        result.add_11rb$(rpc.responseType);
        options = rpc.options;
      } else {
        throw IllegalStateException_init_0('unexpected member: ' + member);
      }
    } else if (Kotlin.isType(root, ProtoType)) {
      if (root.isMap) {
        result.add_11rb$(root.keyType);
        result.add_11rb$(root.valueType);
        return result;
      }if (root.isScalar) {
        return result;
      }var type_0 = this.schema_0.getType_rubud1$(root);
      var service_0 = this.schema_0.getService_rubud1$(root);
      fileOptions = ensureNotNull(this.schema_0.protoFile_rubud1$(root)).options;
      if (Kotlin.isType(type_0, MessageType)) {
        options = type_0.options;
        tmp$_2 = type_0.declaredFields.iterator();
        while (tmp$_2.hasNext()) {
          var field_0 = tmp$_2.next();
          result.add_11rb$(ProtoMember$Companion_getInstance().get_bu2imf$(root, field_0.name));
        }
        tmp$_3 = type_0.extensionFields.iterator();
        while (tmp$_3.hasNext()) {
          var field_1 = tmp$_3.next();
          result.add_11rb$(ProtoMember$Companion_getInstance().get_bu2imf$(root, field_1.qualifiedName));
        }
        tmp$_4 = type_0.oneOfs.iterator();
        while (tmp$_4.hasNext()) {
          var oneOf = tmp$_4.next();
          tmp$_5 = oneOf.fields.iterator();
          while (tmp$_5.hasNext()) {
            var field_2 = tmp$_5.next();
            result.add_11rb$(ProtoMember$Companion_getInstance().get_bu2imf$(root, field_2.name));
          }
        }
      } else if (Kotlin.isType(type_0, EnumType)) {
        options = type_0.options;
        tmp$_6 = type_0.constants.iterator();
        while (tmp$_6.hasNext()) {
          var constant_0 = tmp$_6.next();
          result.add_11rb$(ProtoMember$Companion_getInstance().get_bu2imf$(type_0.type, constant_0.name));
        }
      } else if (Kotlin.isType(type_0, EnclosingType)) {
        options = type_0.options;
      } else if (service_0 != null) {
        options = service_0.options;
        tmp$_7 = service_0.rpcs.iterator();
        while (tmp$_7.hasNext()) {
          var rpc_0 = tmp$_7.next();
          result.add_11rb$(ProtoMember$Companion_getInstance().get_bu2imf$(service_0.type, rpc_0.name));
        }
      } else {
        throw IllegalStateException_init_0('unexpected type: ' + root.toString());
      }
    } else {
      throw IllegalStateException_init_0('unexpected root: ' + root.toString());
    }
    this.addOptions_0(options.fields_vl7o71$(this.pruningRules_0).values(), result);
    if (fileOptions != null) {
      this.addOptions_0(fileOptions.fields_vl7o71$(this.pruningRules_0).values(), result);
    }return result;
  };
  Pruner.prototype.addOptions_0 = function (options, result) {
    var tmp$;
    tmp$ = options.iterator();
    while (tmp$.hasNext()) {
      var member = tmp$.next();
      if (!this.schema_0.isExtensionField_pnoc8b$(member)) {
        result.add_11rb$(member.type);
      }result.add_11rb$(member);
    }
  };
  Pruner.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Pruner',
    interfaces: []
  };
  function PruningRules(builder) {
    PruningRules$Companion_getInstance();
    this.roots = toSet(builder.roots_8be2vx$);
    this.prunes = toSet(builder.prunes_8be2vx$);
    this._since_0 = builder.since_8be2vx$;
    this._until_0 = builder.until_8be2vx$;
    this._only_0 = builder.only_8be2vx$;
    this.usedRoots_0 = LinkedHashSet_init();
    this.usedPrunes_0 = LinkedHashSet_init();
  }
  Object.defineProperty(PruningRules.prototype, 'since', {
    configurable: true,
    get: function () {
      var tmp$;
      return (tmp$ = this._since_0) != null ? tmp$.version : null;
    }
  });
  Object.defineProperty(PruningRules.prototype, 'until', {
    configurable: true,
    get: function () {
      var tmp$;
      return (tmp$ = this._until_0) != null ? tmp$.version : null;
    }
  });
  Object.defineProperty(PruningRules.prototype, 'only', {
    configurable: true,
    get: function () {
      var tmp$;
      return (tmp$ = this._only_0) != null ? tmp$.version : null;
    }
  });
  Object.defineProperty(PruningRules.prototype, 'isEmpty', {
    configurable: true,
    get: function () {
      return this.roots.isEmpty() && this.prunes.isEmpty() && this._since_0 == null && this._until_0 == null && this._only_0 == null;
    }
  });
  PruningRules.prototype.isFieldRetainedVersion_g46cmn$ = function (options) {
    return this.isRetainedVersion_0(options, PruningRules$Companion_getInstance().FIELD_SINCE_8be2vx$, PruningRules$Companion_getInstance().FIELD_UNTIL_8be2vx$);
  };
  PruningRules.prototype.isEnumConstantRetainedVersion_g46cmn$ = function (options) {
    return this.isRetainedVersion_0(options, PruningRules$Companion_getInstance().ENUM_CONSTANT_SINCE_8be2vx$, PruningRules$Companion_getInstance().ENUM_CONSTANT_UNTIL_8be2vx$);
  };
  PruningRules.prototype.isRetainedVersion_0 = function (options, sinceMember, untilMember) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    if (this._until_0 != null || this._only_0 != null) {
      var sinceOption = options.get_pnoc8b$(sinceMember);
      var since = (tmp$_0 = typeof (tmp$ = sinceOption) === 'string' ? tmp$ : null) != null ? SemVer$Companion_getInstance().toLowerCaseSemVer_pdl1vz$(tmp$_0) : null;
      if (this._until_0 != null && since != null && since.compareTo_11rb$(this._until_0) >= 0 || (this._only_0 != null && since != null && since.compareTo_11rb$(this._only_0) > 0)) {
        return false;
      }}if (this._since_0 != null || this._only_0 != null) {
      var lowerBound = (tmp$_1 = this._since_0) != null ? tmp$_1 : ensureNotNull(this._only_0);
      var untilOption = options.get_pnoc8b$(untilMember);
      var until = (tmp$_3 = typeof (tmp$_2 = untilOption) === 'string' ? tmp$_2 : null) != null ? SemVer$Companion_getInstance().toLowerCaseSemVer_pdl1vz$(tmp$_3) : null;
      if (until != null && until.compareTo_11rb$(lowerBound) <= 0)
        return false;
    }return true;
  };
  PruningRules.prototype.isRoot_rubud1$ = function (type) {
    return this.isRoot_0(type.toString());
  };
  PruningRules.prototype.isRoot_pnoc8b$ = function (protoMember) {
    return this.isRoot_0(protoMember.toString());
  };
  PruningRules.prototype.isRoot_0 = function (identifier) {
    var tmp$;
    if (this.roots.isEmpty())
      return !this.prunes_0(identifier);
    var rootMatch = null;
    var pruneMatch = null;
    var rule = identifier;
    while (rule != null) {
      if (pruneMatch == null && this.prunes.contains_11rb$(rule)) {
        pruneMatch = rule;
      }if (rootMatch == null && this.roots.contains_11rb$(rule)) {
        rootMatch = rule;
      }rule = PruningRules$Companion_getInstance().enclosing_y4putb$(rule);
    }
    if (pruneMatch != null && rootMatch != null)
      tmp$ = pruneMatch.length < rootMatch.length;
    else if (pruneMatch != null)
      tmp$ = false;
    else if (rootMatch != null)
      tmp$ = true;
    else
      tmp$ = false;
    var isRoot = tmp$;
    if (isRoot) {
      this.usedRoots_0.add_11rb$(ensureNotNull(rootMatch));
    } else if (pruneMatch != null) {
      this.usedPrunes_0.add_11rb$(pruneMatch);
    }return isRoot;
  };
  PruningRules.prototype.prunes_rubud1$ = function (type) {
    return this.prunes_0(type.toString());
  };
  PruningRules.prototype.prunes_pnoc8b$ = function (protoMember) {
    return this.prunes_0(protoMember.toString());
  };
  PruningRules.prototype.prunes_0 = function (identifier) {
    var tmp$;
    var rootMatch = null;
    var pruneMatch = null;
    var rule = identifier;
    while (rule != null) {
      if (pruneMatch == null && this.prunes.contains_11rb$(rule)) {
        pruneMatch = rule;
      }if (rootMatch == null && this.roots.contains_11rb$(rule)) {
        rootMatch = rule;
      }rule = PruningRules$Companion_getInstance().enclosing_y4putb$(rule);
    }
    if (pruneMatch != null && rootMatch != null)
      tmp$ = pruneMatch.length >= rootMatch.length;
    else if (pruneMatch != null)
      tmp$ = true;
    else
      tmp$ = false;
    var pruned = tmp$;
    if (pruned) {
      this.usedPrunes_0.add_11rb$(ensureNotNull(pruneMatch));
    }return pruned;
  };
  PruningRules.prototype.unusedRoots = function () {
    return minus(this.roots, this.usedRoots_0);
  };
  PruningRules.prototype.unusedPrunes = function () {
    return minus(this.prunes, this.usedPrunes_0);
  };
  function PruningRules$Builder() {
    this.roots_8be2vx$ = LinkedHashSet_init();
    this.prunes_8be2vx$ = LinkedHashSet_init();
    this.since_8be2vx$ = null;
    this.until_8be2vx$ = null;
    this.only_8be2vx$ = null;
  }
  PruningRules$Builder.prototype.addRoot_61zpoe$ = function (identifier) {
    this.roots_8be2vx$.add_11rb$(identifier);
    return this;
  };
  PruningRules$Builder.prototype.addRoot_upaayv$ = function (identifiers) {
    addAll(this.roots_8be2vx$, identifiers);
    return this;
  };
  PruningRules$Builder.prototype.prune_61zpoe$ = function (identifier) {
    this.prunes_8be2vx$.add_11rb$(identifier);
    return this;
  };
  PruningRules$Builder.prototype.prune_upaayv$ = function (identifiers) {
    addAll(this.prunes_8be2vx$, identifiers);
    return this;
  };
  PruningRules$Builder.prototype.since_pdl1vj$ = function (since) {
    this.since_8be2vx$ = since != null ? SemVer$Companion_getInstance().toLowerCaseSemVer_pdl1vz$(since) : null;
    return this;
  };
  PruningRules$Builder.prototype.until_pdl1vj$ = function (until) {
    this.until_8be2vx$ = until != null ? SemVer$Companion_getInstance().toLowerCaseSemVer_pdl1vz$(until) : null;
    return this;
  };
  PruningRules$Builder.prototype.only_pdl1vj$ = function (only) {
    this.only_8be2vx$ = only != null ? SemVer$Companion_getInstance().toLowerCaseSemVer_pdl1vz$(only) : null;
    return this;
  };
  PruningRules$Builder.prototype.build = function () {
    if (!(this.only_8be2vx$ == null || (this.since_8be2vx$ == null && this.until_8be2vx$ == null))) {
      var message = 'only cannot be set along side since and until';
      throw IllegalStateException_init_0(message.toString());
    }if (!(this.since_8be2vx$ == null || this.until_8be2vx$ == null || ensureNotNull(this.since_8be2vx$).compareTo_11rb$(ensureNotNull(this.until_8be2vx$)) < 0)) {
      var message_0 = 'expected since ' + toString(this.since_8be2vx$) + ' < until ' + toString(this.until_8be2vx$);
      throw IllegalStateException_init_0(message_0.toString());
    }var conflictingRules = intersect(this.roots_8be2vx$, this.prunes_8be2vx$);
    if (!conflictingRules.isEmpty()) {
      var message_1 = 'same rule(s) defined in both roots and prunes: ' + joinToString(conflictingRules);
      throw IllegalStateException_init_0(message_1.toString());
    }return new PruningRules(this);
  };
  PruningRules$Builder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Builder',
    interfaces: []
  };
  function PruningRules$Companion() {
    PruningRules$Companion_instance = this;
    this.FIELD_SINCE_8be2vx$ = ProtoMember$Companion_getInstance().get_bu2imf$(Options$Companion_getInstance().FIELD_OPTIONS, 'wire.since');
    this.FIELD_UNTIL_8be2vx$ = ProtoMember$Companion_getInstance().get_bu2imf$(Options$Companion_getInstance().FIELD_OPTIONS, 'wire.until');
    this.ENUM_CONSTANT_SINCE_8be2vx$ = ProtoMember$Companion_getInstance().get_bu2imf$(Options$Companion_getInstance().ENUM_VALUE_OPTIONS, 'wire.constant_since');
    this.ENUM_CONSTANT_UNTIL_8be2vx$ = ProtoMember$Companion_getInstance().get_bu2imf$(Options$Companion_getInstance().ENUM_VALUE_OPTIONS, 'wire.constant_until');
  }
  PruningRules$Companion.prototype.enclosing_y4putb$ = function (identifier) {
    var hash = lastIndexOf(identifier, 35);
    if (hash !== -1) {
      return identifier.substring(0, hash);
    }var from = endsWith(identifier, '.*') ? identifier.length - 3 | 0 : identifier.length - 1 | 0;
    var dot = lastIndexOf(identifier, 46, from);
    if (dot !== -1) {
      return identifier.substring(0, dot) + '.*';
    }if (!equals(identifier, '*'))
      return '*';
    return null;
  };
  PruningRules$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PruningRules$Companion_instance = null;
  function PruningRules$Companion_getInstance() {
    if (PruningRules$Companion_instance === null) {
      new PruningRules$Companion();
    }return PruningRules$Companion_instance;
  }
  PruningRules.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PruningRules',
    interfaces: []
  };
  function Reserved(location, documentation, values) {
    Reserved$Companion_getInstance();
    this.location = location;
    this.documentation = documentation;
    this.values = values;
  }
  Reserved.prototype.matchesTag_za3lpa$ = function (tag) {
    var $receiver = this.values;
    var any$result;
    any$break: do {
      var tmp$;
      if (Kotlin.isType($receiver, Collection) && $receiver.isEmpty()) {
        any$result = false;
        break any$break;
      }tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        var tmp$_0, tmp$_1;
        if (typeof element === 'number' && tag === element || ((tmp$_1 = Kotlin.isType(tmp$_0 = element, IntRange) ? tmp$_0 : null) != null ? tmp$_1.contains_mef7kx$(tag) : null) === true) {
          any$result = true;
          break any$break;
        }}
      any$result = false;
    }
     while (false);
    return any$result;
  };
  Reserved.prototype.matchesName_61zpoe$ = function (name) {
    var $receiver = this.values;
    var any$result;
    any$break: do {
      var tmp$;
      if (Kotlin.isType($receiver, Collection) && $receiver.isEmpty()) {
        any$result = false;
        break any$break;
      }tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (typeof element === 'string' && equals(name, element)) {
          any$result = true;
          break any$break;
        }}
      any$result = false;
    }
     while (false);
    return any$result;
  };
  function Reserved$Companion() {
    Reserved$Companion_instance = this;
  }
  Reserved$Companion.prototype.fromElements_f8qxcy$ = function (elements) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(elements, 10));
    var tmp$;
    tmp$ = elements.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(new Reserved(item.location, item.documentation, item.values));
    }
    return destination;
  };
  Reserved$Companion.prototype.toElements_kjt8as$ = function (reserveds) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(reserveds, 10));
    var tmp$;
    tmp$ = reserveds.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(new ReservedElement(item.location, item.documentation, item.values));
    }
    return destination;
  };
  Reserved$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Reserved$Companion_instance = null;
  function Reserved$Companion_getInstance() {
    if (Reserved$Companion_instance === null) {
      new Reserved$Companion();
    }return Reserved$Companion_instance;
  }
  Reserved.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Reserved',
    interfaces: []
  };
  Reserved.prototype.component1 = function () {
    return this.location;
  };
  Reserved.prototype.component2 = function () {
    return this.documentation;
  };
  Reserved.prototype.component3 = function () {
    return this.values;
  };
  Reserved.prototype.copy_hncgv0$ = function (location, documentation, values) {
    return new Reserved(location === void 0 ? this.location : location, documentation === void 0 ? this.documentation : documentation, values === void 0 ? this.values : values);
  };
  Reserved.prototype.toString = function () {
    return 'Reserved(location=' + Kotlin.toString(this.location) + (', documentation=' + Kotlin.toString(this.documentation)) + (', values=' + Kotlin.toString(this.values)) + ')';
  };
  Reserved.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.values) | 0;
    return result;
  };
  Reserved.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.values, other.values)))));
  };
  function Rpc(location, name, documentation, requestTypeElement, responseTypeElement, requestStreaming, responseStreaming, options) {
    Rpc$Companion_getInstance();
    this.location = location;
    this.name = name;
    this.documentation = documentation;
    this.requestTypeElement_0 = requestTypeElement;
    this.responseTypeElement_0 = responseTypeElement;
    this.requestStreaming = requestStreaming;
    this.responseStreaming = responseStreaming;
    this.options = options;
    this.requestType_h7x06x$_0 = null;
    this.responseType_wsm1zr$_0 = null;
  }
  Object.defineProperty(Rpc.prototype, 'requestType', {
    configurable: true,
    get: function () {
      return this.requestType_h7x06x$_0;
    },
    set: function (requestType) {
      this.requestType_h7x06x$_0 = requestType;
    }
  });
  Object.defineProperty(Rpc.prototype, 'responseType', {
    configurable: true,
    get: function () {
      return this.responseType_wsm1zr$_0;
    },
    set: function (responseType) {
      this.responseType_wsm1zr$_0 = responseType;
    }
  });
  Rpc.prototype.link_n5k2qc$ = function (linker) {
    var linker_0 = linker.withContext_za3rmp$(this);
    this.requestType = linker_0.resolveMessageType_61zpoe$(this.requestTypeElement_0);
    this.responseType = linker_0.resolveMessageType_61zpoe$(this.responseTypeElement_0);
  };
  Rpc.prototype.linkOptions_dgdekt$ = function (linker, validate) {
    var linker_0 = linker.withContext_za3rmp$(this);
    this.options.link_jszzr1$(linker_0, this.location, validate);
  };
  Rpc.prototype.validate_n5k2qc$ = function (linker) {
    var linker_0 = linker.withContext_za3rmp$(this);
    linker_0.validateImportForType_bi6gv$(this.location, ensureNotNull(this.requestType));
    linker_0.validateImportForType_bi6gv$(this.location, ensureNotNull(this.responseType));
  };
  Rpc.prototype.retainAll_crjjl2$ = function (schema, markSet) {
    if (!markSet.contains_rubud1$(ensureNotNull(this.requestType)) || !markSet.contains_rubud1$(ensureNotNull(this.responseType)))
      return null;
    var result = new Rpc(this.location, this.name, this.documentation, this.requestTypeElement_0, this.responseTypeElement_0, this.requestStreaming, this.responseStreaming, this.options.retainAll_crjjl2$(schema, markSet));
    result.requestType = this.requestType;
    result.responseType = this.responseType;
    return result;
  };
  function Rpc$Companion() {
    Rpc$Companion_instance = this;
  }
  Rpc$Companion.prototype.fromElements_19magf$ = function (elements) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(elements, 10));
    var tmp$;
    tmp$ = elements.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(new Rpc(item.location, item.name, item.documentation, item.requestType, item.responseType, item.requestStreaming, item.responseStreaming, new Options(Options$Companion_getInstance().METHOD_OPTIONS, item.options)));
    }
    return destination;
  };
  Rpc$Companion.prototype.toElements_uu1d9$ = function (rpcs) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(rpcs, 10));
    var tmp$;
    tmp$ = rpcs.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(new RpcElement(item.location, item.name, item.documentation, item.requestTypeElement_0, item.responseTypeElement_0, item.requestStreaming, item.responseStreaming, item.options.elements));
    }
    return destination;
  };
  Rpc$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Rpc$Companion_instance = null;
  function Rpc$Companion_getInstance() {
    if (Rpc$Companion_instance === null) {
      new Rpc$Companion();
    }return Rpc$Companion_instance;
  }
  Rpc.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Rpc',
    interfaces: []
  };
  Rpc.prototype.component1 = function () {
    return this.location;
  };
  Rpc.prototype.component2 = function () {
    return this.name;
  };
  Rpc.prototype.component3 = function () {
    return this.documentation;
  };
  Rpc.prototype.component4_0 = function () {
    return this.requestTypeElement_0;
  };
  Rpc.prototype.component5_0 = function () {
    return this.responseTypeElement_0;
  };
  Rpc.prototype.component6 = function () {
    return this.requestStreaming;
  };
  Rpc.prototype.component7 = function () {
    return this.responseStreaming;
  };
  Rpc.prototype.component8 = function () {
    return this.options;
  };
  Rpc.prototype.copy_gs4aod$ = function (location, name, documentation, requestTypeElement, responseTypeElement, requestStreaming, responseStreaming, options) {
    return new Rpc(location === void 0 ? this.location : location, name === void 0 ? this.name : name, documentation === void 0 ? this.documentation : documentation, requestTypeElement === void 0 ? this.requestTypeElement_0 : requestTypeElement, responseTypeElement === void 0 ? this.responseTypeElement_0 : responseTypeElement, requestStreaming === void 0 ? this.requestStreaming : requestStreaming, responseStreaming === void 0 ? this.responseStreaming : responseStreaming, options === void 0 ? this.options : options);
  };
  Rpc.prototype.toString = function () {
    return 'Rpc(location=' + Kotlin.toString(this.location) + (', name=' + Kotlin.toString(this.name)) + (', documentation=' + Kotlin.toString(this.documentation)) + (', requestTypeElement=' + Kotlin.toString(this.requestTypeElement_0)) + (', responseTypeElement=' + Kotlin.toString(this.responseTypeElement_0)) + (', requestStreaming=' + Kotlin.toString(this.requestStreaming)) + (', responseStreaming=' + Kotlin.toString(this.responseStreaming)) + (', options=' + Kotlin.toString(this.options)) + ')';
  };
  Rpc.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.requestTypeElement_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.responseTypeElement_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.requestStreaming) | 0;
    result = result * 31 + Kotlin.hashCode(this.responseStreaming) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    return result;
  };
  Rpc.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.requestTypeElement_0, other.requestTypeElement_0) && Kotlin.equals(this.responseTypeElement_0, other.responseTypeElement_0) && Kotlin.equals(this.requestStreaming, other.requestStreaming) && Kotlin.equals(this.responseStreaming, other.responseStreaming) && Kotlin.equals(this.options, other.options)))));
  };
  var compareBy$lambda_0 = wrapFunction(function () {
    var compareValues = Kotlin.kotlin.comparisons.compareValues_s00gnj$;
    return function (closure$selector) {
      return function (a, b) {
        var selector = closure$selector;
        return compareValues(selector(a), selector(b));
      };
    };
  });
  function Schema(protoFiles) {
    Schema$Companion_getInstance();
    this.protoFiles = sortedWith(protoFiles, new Comparator(compareBy$lambda_0(Schema$protoFiles$lambda)));
    this.protoFilesIndex_0 = null;
    this.typesIndex_0 = null;
    this.servicesIndex_0 = null;
    var index = LinkedHashMap_init();
    this.typesIndex_0 = Schema$Companion_getInstance().buildTypesIndex_0(protoFiles, index);
    this.servicesIndex_0 = Schema$Companion_getInstance().buildServicesIndex_0(protoFiles, index);
    this.protoFilesIndex_0 = index;
  }
  Object.defineProperty(Schema.prototype, 'types', {
    configurable: true,
    get: function () {
      return this.protoFilesIndex_0.keys;
    }
  });
  Schema.prototype.protoFile_61zpoe$ = function (path) {
    var $receiver = this.protoFiles;
    var firstOrNull$result;
    firstOrNull$break: do {
      var tmp$;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (equals(element.location.path, path)) {
          firstOrNull$result = element;
          break firstOrNull$break;
        }}
      firstOrNull$result = null;
    }
     while (false);
    return firstOrNull$result;
  };
  Schema.prototype.protoFile_rubud1$ = function (protoType) {
    return this.protoFilesIndex_0.get_11rb$(protoType);
  };
  Schema.prototype.prune_vl7o71$ = function (pruningRules) {
    return (new Pruner(this, pruningRules)).prune();
  };
  Schema.prototype.getService_61zpoe$ = function (name) {
    return this.servicesIndex_0.get_11rb$(name);
  };
  Schema.prototype.getService_rubud1$ = function (protoType) {
    return this.getService_61zpoe$(protoType.toString());
  };
  Schema.prototype.getType_61zpoe$ = function (name) {
    return this.typesIndex_0.get_11rb$(name);
  };
  Schema.prototype.getType_rubud1$ = function (protoType) {
    return this.getType_61zpoe$(protoType.toString());
  };
  Schema.prototype.getField_pnoc8b$ = function (protoMember) {
    var tmp$, tmp$_0, tmp$_1;
    tmp$_0 = Kotlin.isType(tmp$ = this.getType_rubud1$(protoMember.type), MessageType) ? tmp$ : null;
    if (tmp$_0 == null) {
      return null;
    }var type = tmp$_0;
    return (tmp$_1 = type.field_61zpoe$(protoMember.member)) != null ? tmp$_1 : type.extensionField_61zpoe$(protoMember.member);
  };
  Schema.prototype.getField_puj7f4$ = function (typeName, memberName) {
    return this.getField_bu2imf$(ProtoType$Companion_getInstance().get_pdl1vj$(typeName), memberName);
  };
  Schema.prototype.getField_bu2imf$ = function (protoType, memberName) {
    return this.getField_pnoc8b$(ProtoMember$Companion_getInstance().get_bu2imf$(protoType, memberName));
  };
  Schema.prototype.protoAdapter_ivxn3r$ = function (typeName, includeUnknown) {
    var value = this.getType_61zpoe$(typeName);
    var requireNotNull$result;
    if (value == null) {
      var message = 'unexpected type ' + typeName;
      throw IllegalArgumentException_init(message.toString());
    } else {
      requireNotNull$result = value;
    }
    var type = requireNotNull$result;
    return (new SchemaProtoAdapterFactory(this, includeUnknown)).get_rubud1$(type.type);
  };
  Schema.prototype.isExtensionField_pnoc8b$ = function (protoMember) {
    var type = this.getType_rubud1$(protoMember.type);
    return Kotlin.isType(type, MessageType) && type.extensionField_61zpoe$(protoMember.member) != null;
  };
  function Schema$Companion() {
    Schema$Companion_instance = this;
  }
  function Schema$Companion$buildTypesIndex$index(closure$protoFilesIndex, closure$typesByName) {
    return function closure$index(type, protoFile) {
      var tmp$;
      var protoType = type.type;
      var $receiver = closure$protoFilesIndex;
      var tmp$_0;
      if (!(Kotlin.isType(tmp$_0 = $receiver, Map) ? tmp$_0 : throwCCE()).containsKey_11rb$(protoType)) {
        closure$protoFilesIndex.put_xwzc9p$(protoType, protoFile);
      }var $receiver_0 = closure$typesByName;
      var key = protoType.toString();
      $receiver_0.put_xwzc9p$(key, type);
      tmp$ = type.nestedTypes.iterator();
      while (tmp$.hasNext()) {
        var nested = tmp$.next();
        closure$index(nested, protoFile);
      }
    };
  }
  Schema$Companion.prototype.buildTypesIndex_0 = function (protoFiles, protoFilesIndex) {
    var tmp$, tmp$_0;
    var typesByName = LinkedHashMap_init();
    var index = Schema$Companion$buildTypesIndex$index(protoFilesIndex, typesByName);
    tmp$ = protoFiles.iterator();
    while (tmp$.hasNext()) {
      var protoFile = tmp$.next();
      tmp$_0 = protoFile.types.iterator();
      while (tmp$_0.hasNext()) {
        var type = tmp$_0.next();
        index(type, protoFile);
      }
    }
    return typesByName;
  };
  Schema$Companion.prototype.buildServicesIndex_0 = function (protoFiles, protoFilesIndex) {
    var tmp$, tmp$_0;
    var result = LinkedHashMap_init();
    tmp$ = protoFiles.iterator();
    while (tmp$.hasNext()) {
      var protoFile = tmp$.next();
      tmp$_0 = protoFile.services.iterator();
      while (tmp$_0.hasNext()) {
        var service = tmp$_0.next();
        var key = service.type.toString();
        result.put_xwzc9p$(key, service);
        var key_0 = service.type;
        protoFilesIndex.put_xwzc9p$(key_0, protoFile);
      }
    }
    return result;
  };
  Schema$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Schema$Companion_instance = null;
  function Schema$Companion_getInstance() {
    if (Schema$Companion_instance === null) {
      new Schema$Companion();
    }return Schema$Companion_instance;
  }
  function Schema$protoFiles$lambda(it) {
    return it.location.path;
  }
  Schema.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Schema',
    interfaces: []
  };
  function SchemaException(errors) {
    RuntimeException_init(joinToString(errors, '\n'), this);
    this.name = 'SchemaException';
  }
  SchemaException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SchemaException',
    interfaces: [RuntimeException]
  };
  function SchemaProtoAdapterFactory(schema, includeUnknown) {
    this.schema = schema;
    this.includeUnknown_0 = includeUnknown;
    this.adapterMap_0 = mutableMapOf([to(ProtoType$Companion_getInstance().BOOL, ProtoAdapter.Companion.BOOL), to(ProtoType$Companion_getInstance().BYTES, ProtoAdapter.Companion.BYTES), to(ProtoType$Companion_getInstance().DOUBLE, ProtoAdapter.Companion.DOUBLE), to(ProtoType$Companion_getInstance().FLOAT, ProtoAdapter.Companion.FLOAT), to(ProtoType$Companion_getInstance().FIXED32, ProtoAdapter.Companion.FIXED32), to(ProtoType$Companion_getInstance().FIXED64, ProtoAdapter.Companion.FIXED64), to(ProtoType$Companion_getInstance().INT32, ProtoAdapter.Companion.INT32), to(ProtoType$Companion_getInstance().INT64, ProtoAdapter.Companion.INT64), to(ProtoType$Companion_getInstance().SFIXED32, ProtoAdapter.Companion.SFIXED32), to(ProtoType$Companion_getInstance().SFIXED64, ProtoAdapter.Companion.SFIXED64), to(ProtoType$Companion_getInstance().SINT32, ProtoAdapter.Companion.SINT32), to(ProtoType$Companion_getInstance().SINT64, ProtoAdapter.Companion.SINT64), to(ProtoType$Companion_getInstance().STRING, ProtoAdapter.Companion.STRING), to(ProtoType$Companion_getInstance().UINT32, ProtoAdapter.Companion.UINT32), to(ProtoType$Companion_getInstance().UINT64, ProtoAdapter.Companion.UINT64)]);
  }
  SchemaProtoAdapterFactory.prototype.get_rubud1$ = function (protoType) {
    var tmp$, tmp$_0, tmp$_1;
    if (protoType.isMap)
      throw UnsupportedOperationException_init('map types not supported');
    var result = this.adapterMap_0.get_11rb$(protoType);
    if (result != null) {
      return Kotlin.isType(tmp$ = result, ProtoAdapter) ? tmp$ : throwCCE();
    }var value = this.schema.getType_rubud1$(protoType);
    var requireNotNull$result;
    if (value == null) {
      var message = 'unknown type: ' + protoType;
      throw IllegalArgumentException_init(message.toString());
    } else {
      requireNotNull$result = value;
    }
    var type = requireNotNull$result;
    if (Kotlin.isType(type, EnumType)) {
      var enumAdapter = new SchemaProtoAdapterFactory$EnumAdapter(type);
      this.adapterMap_0.put_xwzc9p$(protoType, enumAdapter);
      return enumAdapter;
    }if (Kotlin.isType(type, MessageType)) {
      var messageAdapter = new SchemaProtoAdapterFactory$MessageAdapter(type.type.typeUrl, type.syntax, this.includeUnknown_0);
      this.adapterMap_0.put_xwzc9p$(protoType, messageAdapter);
      tmp$_0 = type.fields.iterator();
      while (tmp$_0.hasNext()) {
        var field = tmp$_0.next();
        var fieldAdapter = new SchemaProtoAdapterFactory$Field(field.name, field.tag, field.isRepeated, this.get_rubud1$(ensureNotNull(field.type)));
        var $receiver = messageAdapter.fieldsByName;
        var key = field.name;
        $receiver.put_xwzc9p$(key, fieldAdapter);
        var $receiver_0 = messageAdapter.fieldsByTag;
        var key_0 = field.tag;
        $receiver_0.put_xwzc9p$(key_0, fieldAdapter);
      }
      return Kotlin.isType(tmp$_1 = messageAdapter, ProtoAdapter) ? tmp$_1 : throwCCE();
    }throw IllegalArgumentException_init('unexpected type: ' + protoType);
  };
  function SchemaProtoAdapterFactory$EnumAdapter(enumType) {
    ProtoAdapter.call(this, FieldEncoding.VARINT, PrimitiveClasses$anyClass, null, enumType.syntax);
    this.enumType_0 = enumType;
  }
  SchemaProtoAdapterFactory$EnumAdapter.prototype.encodedSize_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  SchemaProtoAdapterFactory$EnumAdapter.prototype.encode_c506pi$ = function (writer, value) {
    if (typeof value === 'string') {
      var constant = this.enumType_0.constant_61zpoe$(value);
      writer.writeVarint32_za3lpa$(ensureNotNull(constant).tag);
    } else if (typeof value === 'number') {
      writer.writeVarint32_za3lpa$(value);
    } else {
      throw IllegalArgumentException_init('unexpected ' + toString(this.enumType_0.type) + ': ' + toString(value));
    }
  };
  SchemaProtoAdapterFactory$EnumAdapter.prototype.decode_4lbe4r$ = function (reader) {
    var tmp$;
    var value = ProtoAdapter.Companion.UINT32.decode_4lbe4r$(reader);
    var constant = this.enumType_0.constant_za3lpa$(value);
    return (tmp$ = constant != null ? constant.name : null) != null ? tmp$ : value;
  };
  SchemaProtoAdapterFactory$EnumAdapter.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  SchemaProtoAdapterFactory$EnumAdapter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EnumAdapter',
    interfaces: [ProtoAdapter]
  };
  function SchemaProtoAdapterFactory$MessageAdapter(typeUrl, syntax, includeUnknown) {
    ProtoAdapter.call(this, FieldEncoding.LENGTH_DELIMITED, getKClass(MutableMap), typeUrl, syntax);
    this.includeUnknown_0 = includeUnknown;
    this.fieldsByTag = LinkedHashMap_init();
    this.fieldsByName = LinkedHashMap_init();
  }
  SchemaProtoAdapterFactory$MessageAdapter.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  SchemaProtoAdapterFactory$MessageAdapter.prototype.encodedSize_11rb$ = function (value) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    var size = 0;
    tmp$ = value.entries.iterator();
    while (tmp$.hasNext()) {
      var tmp$_4 = tmp$.next();
      var key = tmp$_4.key;
      var value1 = tmp$_4.value;
      tmp$_0 = this.fieldsByName.get_11rb$(key);
      if (tmp$_0 == null) {
        continue;
      }var field = tmp$_0;
      var protoAdapter = Kotlin.isType(tmp$_1 = field.protoAdapter, ProtoAdapter) ? tmp$_1 : throwCCE();
      if (field.repeated) {
        tmp$_3 = (Kotlin.isType(tmp$_2 = value1, List) ? tmp$_2 : throwCCE()).iterator();
        while (tmp$_3.hasNext()) {
          var o = tmp$_3.next();
          size = size + protoAdapter.encodedSizeWithTag_wxm5ur$(field.tag, o) | 0;
        }
      } else {
        size = size + protoAdapter.encodedSizeWithTag_wxm5ur$(field.tag, value1) | 0;
      }
    }
    return size;
  };
  SchemaProtoAdapterFactory$MessageAdapter.prototype.encode_c506pi$ = function (writer, value) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    tmp$ = value.entries.iterator();
    while (tmp$.hasNext()) {
      var tmp$_4 = tmp$.next();
      var key = tmp$_4.key;
      var value1 = tmp$_4.value;
      tmp$_0 = this.fieldsByName.get_11rb$(key);
      if (tmp$_0 == null) {
        continue;
      }var field = tmp$_0;
      var protoAdapter = Kotlin.isType(tmp$_1 = field.protoAdapter, ProtoAdapter) ? tmp$_1 : throwCCE();
      if (field.repeated) {
        tmp$_3 = (Kotlin.isType(tmp$_2 = value1, List) ? tmp$_2 : throwCCE()).iterator();
        while (tmp$_3.hasNext()) {
          var o = tmp$_3.next();
          protoAdapter.encodeWithTag_iosr72$(writer, field.tag, o);
        }
      } else {
        protoAdapter.encodeWithTag_iosr72$(writer, field.tag, value1);
      }
    }
  };
  SchemaProtoAdapterFactory$MessageAdapter.prototype.decode_4lbe4r$ = function (reader) {
    var tmp$, tmp$_0;
    var result = LinkedHashMap_init();
    var token = reader.beginMessage();
    while (true) {
      var tag = reader.nextTag();
      if (tag === -1)
        break;
      var field = this.fieldsByTag.get_11rb$(tag);
      if (field == null) {
        if (this.includeUnknown_0) {
          var name = tag.toString();
          tmp$ = new SchemaProtoAdapterFactory$Field(name, tag, true, ensureNotNull(reader.peekFieldEncoding()).rawProtoAdapter());
        } else {
          reader.skip();
          continue;
        }
        field = tmp$;
      }var value = ensureNotNull(field.protoAdapter.decode_4lbe4r$(reader));
      if (field.repeated) {
        var key = field.name;
        var tmp$_1;
        var value_0 = result.get_11rb$(key);
        if (value_0 == null) {
          var answer = ArrayList_init();
          result.put_xwzc9p$(key, answer);
          tmp$_1 = answer;
        } else {
          tmp$_1 = value_0;
        }
        var values = Kotlin.isType(tmp$_0 = tmp$_1, MutableList) ? tmp$_0 : throwCCE();
        values.add_11rb$(value);
      } else {
        var key_0 = field.name;
        result.put_xwzc9p$(key_0, value);
      }
    }
    reader.endMessageAndGetUnknownFields_s8cxhz$(token);
    return result;
  };
  SchemaProtoAdapterFactory$MessageAdapter.prototype.toString_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  SchemaProtoAdapterFactory$MessageAdapter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MessageAdapter',
    interfaces: [ProtoAdapter]
  };
  function SchemaProtoAdapterFactory$Field(name, tag, repeated, protoAdapter) {
    this.name = name;
    this.tag = tag;
    this.repeated = repeated;
    this.protoAdapter = protoAdapter;
  }
  SchemaProtoAdapterFactory$Field.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Field',
    interfaces: []
  };
  SchemaProtoAdapterFactory.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SchemaProtoAdapterFactory',
    interfaces: []
  };
  function SemVer(version) {
    SemVer$Companion_getInstance();
    this.version = version;
    if (!equals(toEnglishLowerCase(this.version), this.version)) {
      var message = 'version must be lowercase: ' + this.version;
      throw IllegalArgumentException_init(message.toString());
    }}
  SemVer.prototype.toString = function () {
    return this.version;
  };
  SemVer.prototype.compareTo_11rb$ = function (other) {
    var tmp$;
    var a = this.version;
    var b = other.version;
    var aPos = 0;
    var bPos = 0;
    tmp$ = listOf_0([SemVer$Companion_getInstance().RELEASE_TERMINATORS_0, SemVer$Companion_getInstance().PRERELEASE_TERMINATORS_0]).iterator();
    while (tmp$.hasNext()) {
      var terminators = tmp$.next();
      var aSize = this.find_0(a, terminators, aPos);
      var bSize = this.find_0(b, terminators, bPos);
      if (terminators === SemVer$Companion_getInstance().PRERELEASE_TERMINATORS_0) {
        var aNoPrerelease = aPos === aSize;
        var bNoPrerelease = bPos === bSize;
        if (aNoPrerelease && !bNoPrerelease)
          return 1;
        if (bNoPrerelease && !aNoPrerelease)
          return -1;
      }while (aPos < aSize && bPos < bSize) {
        var aLimit = this.find_0(a, SemVer$Companion_getInstance().SEPARATORS_0, aPos, aSize);
        var bLimit = this.find_0(b, SemVer$Companion_getInstance().SEPARATORS_0, bPos, bSize);
        var startIndex = aPos;
        var tmp$_0 = a.substring(startIndex, aLimit);
        var startIndex_0 = bPos;
        var result = this.compareSegment_0(tmp$_0, b.substring(startIndex_0, bLimit));
        if (result !== 0)
          return result;
        aPos = aLimit < aSize ? aLimit + 1 | 0 : aSize;
        bPos = bLimit < bSize ? bLimit + 1 | 0 : bSize;
      }
      if (aPos < aSize)
        return 1;
      if (bPos < bSize)
        return -1;
    }
    return 0;
  };
  SemVer.prototype.compareSegment_0 = function (a, b) {
    var tmp$;
    var all$result;
    all$break: do {
      var tmp$_0;
      tmp$_0 = iterator(a);
      while (tmp$_0.hasNext()) {
        var element = unboxChar(tmp$_0.next());
        if (!isDigit(unboxChar(toBoxedChar(element)))) {
          all$result = false;
          break all$break;
        }}
      all$result = true;
    }
     while (false);
    var aAllDigits = all$result;
    var all$result_0;
    all$break: do {
      var tmp$_1;
      tmp$_1 = iterator(b);
      while (tmp$_1.hasNext()) {
        var element_0 = unboxChar(tmp$_1.next());
        if (!isDigit(unboxChar(toBoxedChar(element_0)))) {
          all$result_0 = false;
          break all$break;
        }}
      all$result_0 = true;
    }
     while (false);
    var bAllDigits = all$result_0;
    if (aAllDigits && bAllDigits)
      tmp$ = this.compareNumber_0(a, b);
    else if (aAllDigits)
      tmp$ = -1;
    else if (bAllDigits)
      tmp$ = 1;
    else
      tmp$ = Kotlin.compareTo(a, b);
    return tmp$;
  };
  SemVer.prototype.compareNumber_0 = function (a, b) {
    var tmp$;
    var indexOfFirst$result;
    indexOfFirst$break: do {
      var tmp$_0, tmp$_0_0, tmp$_1, tmp$_2;
      tmp$_0 = get_indices_0(a);
      tmp$_0_0 = tmp$_0.first;
      tmp$_1 = tmp$_0.last;
      tmp$_2 = tmp$_0.step;
      for (var index = tmp$_0_0; index <= tmp$_1; index += tmp$_2) {
        if (unboxChar(toBoxedChar(a.charCodeAt(index))) !== 48) {
          indexOfFirst$result = index;
          break indexOfFirst$break;
        }}
      indexOfFirst$result = -1;
    }
     while (false);
    var aStart = indexOfFirst$result;
    var indexOfFirst$result_0;
    indexOfFirst$break: do {
      var tmp$_3, tmp$_0_1, tmp$_1_0, tmp$_2_0;
      tmp$_3 = get_indices_0(b);
      tmp$_0_1 = tmp$_3.first;
      tmp$_1_0 = tmp$_3.last;
      tmp$_2_0 = tmp$_3.step;
      for (var index_0 = tmp$_0_1; index_0 <= tmp$_1_0; index_0 += tmp$_2_0) {
        if (unboxChar(toBoxedChar(b.charCodeAt(index_0))) !== 48) {
          indexOfFirst$result_0 = index_0;
          break indexOfFirst$break;
        }}
      indexOfFirst$result_0 = -1;
    }
     while (false);
    var bStart = indexOfFirst$result_0;
    if (aStart === -1 && bStart === -1)
      tmp$ = 0;
    else if (aStart === -1)
      tmp$ = -1;
    else if (bStart === -1)
      tmp$ = 1;
    else {
      var aLength = a.length - aStart | 0;
      var bLength = b.length - bStart | 0;
      if (aLength < bLength)
        tmp$ = -1;
      else if (aLength > bLength)
        tmp$ = 1;
      else {
        tmp$ = Kotlin.compareTo(a.substring(aStart), b.substring(bStart));
      }
    }
    return tmp$;
  };
  SemVer.prototype.find_0 = function ($receiver, chars, startIndex, endIndex) {
    if (startIndex === void 0)
      startIndex = 0;
    if (endIndex === void 0)
      endIndex = $receiver.length;
    var result = indexOfAny($receiver, chars, startIndex);
    if (result !== -1 && result < endIndex)
      return result;
    return endIndex;
  };
  function SemVer$Companion() {
    SemVer$Companion_instance = this;
    this.RELEASE_TERMINATORS_0 = Kotlin.charArrayOf(43, 45);
    this.PRERELEASE_TERMINATORS_0 = Kotlin.charArrayOf(43);
    this.SEPARATORS_0 = Kotlin.charArrayOf(46, 45);
  }
  SemVer$Companion.prototype.toLowerCaseSemVer_pdl1vz$ = function ($receiver) {
    return new SemVer(toEnglishLowerCase($receiver));
  };
  SemVer$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SemVer$Companion_instance = null;
  function SemVer$Companion_getInstance() {
    if (SemVer$Companion_instance === null) {
      new SemVer$Companion();
    }return SemVer$Companion_instance;
  }
  SemVer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SemVer',
    interfaces: [Comparable]
  };
  SemVer.prototype.component1 = function () {
    return this.version;
  };
  SemVer.prototype.copy_61zpoe$ = function (version) {
    return new SemVer(version === void 0 ? this.version : version);
  };
  SemVer.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.version) | 0;
    return result;
  };
  SemVer.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.version, other.version))));
  };
  function Service(type, location, documentation, name, rpcs, options) {
    Service$Companion_getInstance();
    this.type = type;
    this.location = location;
    this.documentation = documentation;
    this.name = name;
    this.rpcs = rpcs;
    this.options = options;
  }
  Service.prototype.rpc_61zpoe$ = function (name) {
    var $receiver = this.rpcs;
    var firstOrNull$result;
    firstOrNull$break: do {
      var tmp$;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (equals(element.name, name)) {
          firstOrNull$result = element;
          break firstOrNull$break;
        }}
      firstOrNull$result = null;
    }
     while (false);
    return firstOrNull$result;
  };
  Service.prototype.link_n5k2qc$ = function (linker) {
    var tmp$;
    var linker_0 = linker;
    linker_0 = linker_0.withContext_za3rmp$(this);
    tmp$ = this.rpcs.iterator();
    while (tmp$.hasNext()) {
      var rpc = tmp$.next();
      rpc.link_n5k2qc$(linker_0);
    }
  };
  Service.prototype.linkOptions_dgdekt$ = function (linker, validate) {
    var tmp$;
    var linker_0 = linker.withContext_za3rmp$(this);
    tmp$ = this.rpcs.iterator();
    while (tmp$.hasNext()) {
      var rpc = tmp$.next();
      rpc.linkOptions_dgdekt$(linker_0, validate);
    }
    this.options.link_jszzr1$(linker_0, this.location, validate);
  };
  Service.prototype.validate_n5k2qc$ = function (linker) {
    var tmp$;
    var linker_0 = linker;
    linker_0 = linker_0.withContext_za3rmp$(this);
    this.validateRpcUniqueness_0(linker_0, this.rpcs);
    tmp$ = this.rpcs.iterator();
    while (tmp$.hasNext()) {
      var rpc = tmp$.next();
      rpc.validate_n5k2qc$(linker_0);
    }
  };
  Service.prototype.validateRpcUniqueness_0 = function (linker, rpcs) {
    var tmp$, tmp$_0;
    var nameToRpc = LinkedHashMap_init();
    tmp$ = rpcs.iterator();
    while (tmp$.hasNext()) {
      var rpc = tmp$.next();
      var key = rpc.name;
      var tmp$_1;
      var value = nameToRpc.get_11rb$(key);
      if (value == null) {
        var answer = LinkedHashSet_init();
        nameToRpc.put_xwzc9p$(key, answer);
        tmp$_1 = answer;
      } else {
        tmp$_1 = value;
      }
      tmp$_1.add_11rb$(rpc);
    }
    tmp$_0 = nameToRpc.entries.iterator();
    while (tmp$_0.hasNext()) {
      var tmp$_2 = tmp$_0.next();
      var key_0 = tmp$_2.key;
      var values = tmp$_2.value;
      if (values.size > 1) {
        var $receiver = StringBuilder_init();
        $receiver.append_pdl1vj$('mutable rpcs share name ' + key_0 + ':');
        var tmp$_3, tmp$_0_0;
        var index = 0;
        tmp$_3 = values.iterator();
        while (tmp$_3.hasNext()) {
          var item = tmp$_3.next();
          $receiver.append_pdl1vj$('\n' + '  ' + (checkIndexOverflow((tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0)) + 1 | 0) + '. ' + item.name + ' (' + item.location + ')');
        }
        var error = $receiver.toString();
        linker.errors.plusAssign_61zpoe$(error);
      }}
  };
  Service.prototype.retainAll_crjjl2$ = function (schema, markSet) {
    var tmp$;
    if (!markSet.contains_rubud1$(this.type)) {
      return null;
    }var retainedRpcs = ArrayList_init();
    tmp$ = this.rpcs.iterator();
    while (tmp$.hasNext()) {
      var rpc = tmp$.next();
      var retainedRpc = rpc.retainAll_crjjl2$(schema, markSet);
      if (retainedRpc != null && markSet.contains_pnoc8b$(ProtoMember$Companion_getInstance().get_bu2imf$(this.type, rpc.name))) {
        retainedRpcs.add_11rb$(retainedRpc);
      }}
    return new Service(this.type, this.location, this.documentation, this.name, retainedRpcs, this.options.retainAll_crjjl2$(schema, markSet));
  };
  function Service$Companion() {
    Service$Companion_instance = this;
  }
  Service$Companion.prototype.fromElement_5d6pso$ = function (protoType, element) {
    var rpcs = Rpc$Companion_getInstance().fromElements_19magf$(element.rpcs);
    var options = new Options(Options$Companion_getInstance().SERVICE_OPTIONS, element.options);
    return new Service(protoType, element.location, element.documentation, element.name, rpcs, options);
  };
  Service$Companion.prototype.fromElements_qmwtvz$ = function (packageName, elements) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(elements, 10));
    var tmp$;
    tmp$ = elements.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      var tmp$_0 = destination.add_11rb$;
      var protoType = ProtoType$Companion_getInstance().get_f5e6j7$(packageName, item.name);
      tmp$_0.call(destination, this.fromElement_5d6pso$(protoType, item));
    }
    return destination;
  };
  Service$Companion.prototype.toElements_arnyqo$ = function (services) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(services, 10));
    var tmp$;
    tmp$ = services.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(new ServiceElement(item.location, item.name, item.documentation, Rpc$Companion_getInstance().toElements_uu1d9$(item.rpcs), item.options.elements));
    }
    return destination;
  };
  Service$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Service$Companion_instance = null;
  function Service$Companion_getInstance() {
    if (Service$Companion_instance === null) {
      new Service$Companion();
    }return Service$Companion_instance;
  }
  Service.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Service',
    interfaces: []
  };
  Service.prototype.component1 = function () {
    return this.type;
  };
  Service.prototype.component2 = function () {
    return this.location;
  };
  Service.prototype.component3 = function () {
    return this.documentation;
  };
  Service.prototype.component4 = function () {
    return this.name;
  };
  Service.prototype.component5 = function () {
    return this.rpcs;
  };
  Service.prototype.component6 = function () {
    return this.options;
  };
  Service.prototype.copy_w00g4t$ = function (type, location, documentation, name, rpcs, options) {
    return new Service(type === void 0 ? this.type : type, location === void 0 ? this.location : location, documentation === void 0 ? this.documentation : documentation, name === void 0 ? this.name : name, rpcs === void 0 ? this.rpcs : rpcs, options === void 0 ? this.options : options);
  };
  Service.prototype.toString = function () {
    return 'Service(type=' + Kotlin.toString(this.type) + (', location=' + Kotlin.toString(this.location)) + (', documentation=' + Kotlin.toString(this.documentation)) + (', name=' + Kotlin.toString(this.name)) + (', rpcs=' + Kotlin.toString(this.rpcs)) + (', options=' + Kotlin.toString(this.options)) + ')';
  };
  Service.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.type) | 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.rpcs) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    return result;
  };
  Service.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.type, other.type) && Kotlin.equals(this.location, other.location) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.rpcs, other.rpcs) && Kotlin.equals(this.options, other.options)))));
  };
  function SyntaxRules() {
    SyntaxRules$Companion_getInstance();
  }
  function SyntaxRules$Companion() {
    SyntaxRules$Companion_instance = this;
    this.PROTO_2_SYNTAX_RULES_8be2vx$ = new SyntaxRules$Companion$PROTO_2_SYNTAX_RULES$ObjectLiteral();
    this.PROTO_3_SYNTAX_RULES_8be2vx$ = new SyntaxRules$Companion$PROTO_3_SYNTAX_RULES$ObjectLiteral();
  }
  SyntaxRules$Companion.prototype.get_gziock$ = function (syntax) {
    var tmp$;
    if (equals(syntax, Syntax.PROTO_3))
      tmp$ = this.PROTO_3_SYNTAX_RULES_8be2vx$;
    else if (equals(syntax, Syntax.PROTO_2) || syntax == null)
      tmp$ = this.PROTO_2_SYNTAX_RULES_8be2vx$;
    else
      tmp$ = Kotlin.noWhenBranchMatched();
    return tmp$;
  };
  function SyntaxRules$Companion$PROTO_2_SYNTAX_RULES$ObjectLiteral() {
  }
  SyntaxRules$Companion$PROTO_2_SYNTAX_RULES$ObjectLiteral.prototype.validateDefaultValue_gt3kov$ = function (hasDefaultValue, errors) {
  };
  SyntaxRules$Companion$PROTO_2_SYNTAX_RULES$ObjectLiteral.prototype.validateExtension_5bayw5$ = function (protoType, errors) {
  };
  SyntaxRules$Companion$PROTO_2_SYNTAX_RULES$ObjectLiteral.prototype.validateEnumConstants_swbzyz$ = function (constants, errors) {
  };
  SyntaxRules$Companion$PROTO_2_SYNTAX_RULES$ObjectLiteral.prototype.validateTypeReference_1o7xwe$ = function (type, errors) {
  };
  SyntaxRules$Companion$PROTO_2_SYNTAX_RULES$ObjectLiteral.prototype.isPackedByDefault_s7v6az$ = function (type, label) {
    return false;
  };
  SyntaxRules$Companion$PROTO_2_SYNTAX_RULES$ObjectLiteral.prototype.getEncodeMode_t06gl$ = function (protoType, label, isPacked, isOneOf) {
    var tmp$;
    if (equals(label, Field$Label$REPEATED_getInstance()))
      tmp$ = isPacked ? Field$EncodeMode$PACKED_getInstance() : Field$EncodeMode$REPEATED_getInstance();
    else if (equals(label, Field$Label$OPTIONAL_getInstance()))
      tmp$ = Field$EncodeMode$NULL_IF_ABSENT_getInstance();
    else if (equals(label, Field$Label$REQUIRED_getInstance()))
      tmp$ = Field$EncodeMode$REQUIRED_getInstance();
    else if (equals(label, Field$Label$ONE_OF_getInstance()) || label == null)
      tmp$ = protoType.isMap ? Field$EncodeMode$MAP_getInstance() : Field$EncodeMode$NULL_IF_ABSENT_getInstance();
    else
      tmp$ = Kotlin.noWhenBranchMatched();
    return tmp$;
  };
  SyntaxRules$Companion$PROTO_2_SYNTAX_RULES$ObjectLiteral.prototype.jsonName_jyasbz$ = function (name, declaredJsonName) {
    return declaredJsonName != null ? declaredJsonName : name;
  };
  SyntaxRules$Companion$PROTO_2_SYNTAX_RULES$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [SyntaxRules]
  };
  function SyntaxRules$Companion$PROTO_3_SYNTAX_RULES$ObjectLiteral() {
  }
  SyntaxRules$Companion$PROTO_3_SYNTAX_RULES$ObjectLiteral.prototype.validateDefaultValue_gt3kov$ = function (hasDefaultValue, errors) {
    if (hasDefaultValue) {
      errors.plusAssign_61zpoe$('user-defined default values are not permitted in proto3');
    }};
  SyntaxRules$Companion$PROTO_3_SYNTAX_RULES$ObjectLiteral.prototype.validateExtension_5bayw5$ = function (protoType, errors) {
    if (!contains(Options$Companion_getInstance().GOOGLE_PROTOBUF_OPTION_TYPES, protoType)) {
      errors.plusAssign_61zpoe$('extensions are not allowed in proto3');
    }};
  SyntaxRules$Companion$PROTO_3_SYNTAX_RULES$ObjectLiteral.prototype.validateEnumConstants_swbzyz$ = function (constants, errors) {
    if (constants.isEmpty() || first_0(constants).tag !== 0) {
      errors.plusAssign_61zpoe$('missing a zero value at the first element in proto3');
    }};
  SyntaxRules$Companion$PROTO_3_SYNTAX_RULES$ObjectLiteral.prototype.validateTypeReference_1o7xwe$ = function (type, errors) {
    if (type == null)
      return;
    if (!Kotlin.isType(type, EnumType))
      return;
    if (type.syntax === Syntax.PROTO_3)
      return;
    errors.plusAssign_61zpoe$('Proto2 enums cannot be referenced in a proto3 message');
  };
  SyntaxRules$Companion$PROTO_3_SYNTAX_RULES$ObjectLiteral.prototype.isPackedByDefault_s7v6az$ = function (type, label) {
    return equals(label, Field$Label$REPEATED_getInstance()) && ProtoType$Companion_getInstance().NUMERIC_SCALAR_TYPES_8be2vx$.contains_11rb$(type);
  };
  SyntaxRules$Companion$PROTO_3_SYNTAX_RULES$ObjectLiteral.prototype.getEncodeMode_t06gl$ = function (protoType, label, isPacked, isOneOf) {
    var tmp$;
    if (equals(label, Field$Label$REPEATED_getInstance())) {
      if (isPacked) {
        tmp$ = Field$EncodeMode$PACKED_getInstance();
      } else {
        tmp$ = Field$EncodeMode$REPEATED_getInstance();
      }
      return tmp$;
    }if (protoType.isMap)
      return Field$EncodeMode$MAP_getInstance();
    if (isOneOf)
      return Field$EncodeMode$NULL_IF_ABSENT_getInstance();
    if (equals(label, Field$Label$OPTIONAL_getInstance()))
      return Field$EncodeMode$NULL_IF_ABSENT_getInstance();
    return Field$EncodeMode$OMIT_IDENTITY_getInstance();
  };
  SyntaxRules$Companion$PROTO_3_SYNTAX_RULES$ObjectLiteral.prototype.jsonName_jyasbz$ = function (name, declaredJsonName) {
    return declaredJsonName != null ? declaredJsonName : camelCase(name);
  };
  SyntaxRules$Companion$PROTO_3_SYNTAX_RULES$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [SyntaxRules]
  };
  SyntaxRules$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SyntaxRules$Companion_instance = null;
  function SyntaxRules$Companion_getInstance() {
    if (SyntaxRules$Companion_instance === null) {
      new SyntaxRules$Companion();
    }return SyntaxRules$Companion_instance;
  }
  SyntaxRules.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'SyntaxRules',
    interfaces: []
  };
  function Type() {
    Type$Companion_getInstance();
  }
  Type.prototype.typesAndNestedTypes = function () {
    var tmp$;
    var typesAndNestedTypes = ArrayList_init();
    typesAndNestedTypes.add_11rb$(this);
    tmp$ = this.nestedTypes.iterator();
    while (tmp$.hasNext()) {
      var type = tmp$.next();
      typesAndNestedTypes.addAll_brywnq$(type.typesAndNestedTypes());
    }
    return typesAndNestedTypes;
  };
  function Type$Companion() {
    Type$Companion_instance = this;
  }
  Type$Companion.prototype.get_gi2qek$ = function (packageName, protoType, type, syntax) {
    var tmp$;
    if (Kotlin.isType(type, EnumElement))
      tmp$ = EnumType$Companion_getInstance().fromElement_m3ep60$(protoType, type, syntax);
    else if (Kotlin.isType(type, MessageElement))
      tmp$ = MessageType$Companion_getInstance().fromElement_ei4hej$(packageName, protoType, type, syntax);
    else
      throw IllegalArgumentException_init('unexpected type: ' + type);
    return tmp$;
  };
  Type$Companion.prototype.fromElements_5dmk34$ = function (packageName, elements, syntax) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(elements, 10));
    var tmp$;
    tmp$ = elements.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      var tmp$_0 = destination.add_11rb$;
      var protoType = ProtoType$Companion_getInstance().get_f5e6j7$(packageName, item.name);
      tmp$_0.call(destination, this.get_gi2qek$(packageName, protoType, item, syntax));
    }
    return destination;
  };
  Type$Companion.prototype.toElement_0 = function (type) {
    var tmp$;
    if (Kotlin.isType(type, EnumType))
      tmp$ = type.toElement();
    else if (Kotlin.isType(type, MessageType))
      tmp$ = type.toElement();
    else if (Kotlin.isType(type, EnclosingType))
      tmp$ = type.toElement();
    else
      throw IllegalArgumentException_init('unexpected type: ' + type);
    return tmp$;
  };
  Type$Companion.prototype.toElements_qiljpy$ = function (types) {
    var destination = ArrayList_init_0(collectionSizeOrDefault(types, 10));
    var tmp$;
    tmp$ = types.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(this.toElement_0(item));
    }
    return destination;
  };
  Type$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Type$Companion_instance = null;
  function Type$Companion_getInstance() {
    if (Type$Companion_instance === null) {
      new Type$Companion();
    }return Type$Companion_instance;
  }
  Type.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Type',
    interfaces: []
  };
  function DagChecker(nodes, edges) {
    this.nodes_0 = nodes;
    this.edges_0 = edges;
    this.nextDiscoveryId_0 = 0;
    var $receiver = this.nodes_0;
    var result = LinkedHashMap_init_1(coerceAtLeast(mapCapacity(collectionSizeOrDefault($receiver, 10)), 16));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      result.put_xwzc9p$(element, new DagChecker$Tag(element));
    }
    this.tags_0 = result;
    this.stack_0 = ArrayList_init();
    this.result_0 = LinkedHashSet_init();
  }
  DagChecker.prototype.get_tag_0 = function ($receiver) {
    return this.tags_0.get_11rb$($receiver);
  };
  DagChecker.prototype.check = function () {
    var tmp$;
    if (!(this.nextDiscoveryId_0 === 0)) {
      var message = 'Check failed.';
      throw IllegalStateException_init_0(message.toString());
    }tmp$ = this.nodes_0.iterator();
    while (tmp$.hasNext()) {
      var node = tmp$.next();
      var tag = ensureNotNull(this.get_tag_0(node));
      if (tag.discoveryId === -1) {
        this.discoverDepthFirst_0(tag);
      }}
    return this.result_0;
  };
  DagChecker.prototype.discoverDepthFirst_0 = function ($receiver) {
    var tmp$, tmp$_0, tmp$_1;
    $receiver.discoveryId = this.nextDiscoveryId_0;
    $receiver.lowestConnectedDiscoveryId = this.nextDiscoveryId_0;
    this.nextDiscoveryId_0 = this.nextDiscoveryId_0 + 1 | 0;
    var stackIndex = this.stack_0.size;
    this.stack_0.add_11rb$($receiver);
    $receiver.onStack = true;
    tmp$ = this.edges_0($receiver.node).iterator();
    while (tmp$.hasNext()) {
      var target = tmp$.next();
      tmp$_0 = this.get_tag_0(target);
      if (tmp$_0 == null) {
        continue;
      }var t = tmp$_0;
      if (t.discoveryId === -1) {
        var a = $receiver.lowestConnectedDiscoveryId;
        var b = this.discoverDepthFirst_0(t);
        $receiver.lowestConnectedDiscoveryId = Math_0.min(a, b);
      } else if (t.onStack) {
        if (equals(t, $receiver))
          $receiver.selfEdge = true;
        var a_0 = $receiver.lowestConnectedDiscoveryId;
        var b_0 = t.discoveryId;
        $receiver.lowestConnectedDiscoveryId = Math_0.min(a_0, b_0);
      }}
    if ($receiver.discoveryId === $receiver.lowestConnectedDiscoveryId) {
      var slice = this.stack_0.subList_vux9f0$(stackIndex, this.stack_0.size);
      var component = toList(slice);
      slice.clear();
      tmp$_1 = component.iterator();
      while (tmp$_1.hasNext()) {
        var tag = tmp$_1.next();
        tag.onStack = false;
      }
      if (component.size > 1 || single(component).selfEdge) {
        var tmp$_2 = this.result_0;
        var destination = ArrayList_init_0(collectionSizeOrDefault(component, 10));
        var tmp$_3;
        tmp$_3 = component.iterator();
        while (tmp$_3.hasNext()) {
          var item = tmp$_3.next();
          destination.add_11rb$(item.node);
        }
        tmp$_2.add_11rb$(destination);
      }}return $receiver.lowestConnectedDiscoveryId;
  };
  function DagChecker$Tag(node) {
    this.node = node;
    this.discoveryId = -1;
    this.lowestConnectedDiscoveryId = -1;
    this.onStack = false;
    this.selfEdge = false;
  }
  DagChecker$Tag.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Tag',
    interfaces: []
  };
  DagChecker.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DagChecker',
    interfaces: []
  };
  function TypeMover(oldSchema, moves) {
    this.oldSchema_0 = oldSchema;
    this.moves_0 = moves;
    var $receiver = this.oldSchema_0.protoFiles;
    var capacity = coerceAtLeast(mapCapacity(collectionSizeOrDefault($receiver, 10)), 16);
    var destination = LinkedHashMap_init_1(capacity);
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      destination.put_xwzc9p$(element.location.path, element);
    }
    this.pathToFile_0 = toMutableMap(destination);
    this.sourceAndTargetPaths_0 = LinkedHashSet_init();
    this.typeToPath_0 = LinkedHashMap_init();
    this.pathToTypes_0 = LinkedHashMap_init();
    this.errors_0 = ArrayList_init();
  }
  TypeMover.prototype.move = function () {
    var tmp$, tmp$_0, tmp$_1;
    if (this.moves_0.isEmpty())
      return this.oldSchema_0;
    tmp$ = this.moves_0.iterator();
    while (tmp$.hasNext()) {
      var move = tmp$.next();
      if (this.oldSchema_0.protoFile_rubud1$(move.type) == null) {
        var $receiver = this.errors_0;
        var element = 'cannot move ' + move.type + ", it isn't in this schema";
        $receiver.add_11rb$(element);
      }}
    this.checkForErrors_0();
    this.rebuildIndexes_0();
    tmp$_0 = this.moves_0.iterator();
    loop_label: while (tmp$_0.hasNext()) {
      var move_0 = tmp$_0.next();
      var sourcePath = ensureNotNull(this.typeToPath_0.remove_11rb$(move_0.type));
      var targetPath = move_0.targetPath;
      var oldSourceProtoFile = ensureNotNull(this.pathToFile_0.get_11rb$(sourcePath));
      var sourceTypes = toMutableList(oldSourceProtoFile.types);
      var indexOfFirst$result;
      indexOfFirst$break: do {
        var tmp$_2;
        var index = 0;
        tmp$_2 = sourceTypes.iterator();
        while (tmp$_2.hasNext()) {
          var item = tmp$_2.next();
          var tmp$_3;
          if ((tmp$_3 = item.type) != null ? tmp$_3.equals(move_0.type) : null) {
            indexOfFirst$result = index;
            break indexOfFirst$break;
          }index = index + 1 | 0;
        }
        indexOfFirst$result = -1;
      }
       while (false);
      var typeIndex = indexOfFirst$result;
      var movedType = sourceTypes.removeAt_za3lpa$(typeIndex);
      var $receiver_0 = this.pathToFile_0;
      var value = oldSourceProtoFile.copy_ookjol$(void 0, void 0, void 0, void 0, sourceTypes);
      $receiver_0.put_xwzc9p$(sourcePath, value);
      var targetProtoFile = (tmp$_1 = this.pathToFile_0.get_11rb$(targetPath)) != null ? tmp$_1 : this.emptyCopy_0(oldSourceProtoFile, targetPath);
      var $receiver_1 = this.pathToFile_0;
      var value_0 = targetProtoFile.copy_ookjol$(void 0, void 0, void 0, void 0, plus_0(targetProtoFile.types, movedType));
      $receiver_1.put_xwzc9p$(targetPath, value_0);
      this.sourceAndTargetPaths_0.add_11rb$(sourcePath);
      this.sourceAndTargetPaths_0.add_11rb$(targetPath);
    }
    this.rebuildIndexes_0();
    var $receiver_2 = this.pathToFile_0.values;
    var destination = ArrayList_init_0(collectionSizeOrDefault($receiver_2, 10));
    var tmp$_4;
    tmp$_4 = $receiver_2.iterator();
    while (tmp$_4.hasNext()) {
      var item_0 = tmp$_4.next();
      destination.add_11rb$(this.fixImports_0(item_0));
    }
    var updatedProtoFiles = destination;
    this.checkForErrors_0();
    return new Schema(updatedProtoFiles);
  };
  TypeMover.prototype.rebuildIndexes_0 = function () {
    var tmp$, tmp$_0;
    this.pathToTypes_0.clear();
    this.typeToPath_0.clear();
    tmp$ = this.pathToFile_0.entries.iterator();
    while (tmp$.hasNext()) {
      var tmp$_1 = tmp$.next();
      var path = tmp$_1.key;
      var protoFile = tmp$_1.value;
      var declaredTypes = LinkedHashSet_init();
      this.collectDeclaredTypes_0(protoFile, declaredTypes);
      this.pathToTypes_0.put_xwzc9p$(path, declaredTypes);
      tmp$_0 = declaredTypes.iterator();
      while (tmp$_0.hasNext()) {
        var protoType = tmp$_0.next();
        this.typeToPath_0.put_xwzc9p$(protoType, path);
      }
    }
  };
  TypeMover.prototype.fixImports_0 = function ($receiver) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    var tmp$_5 = !this.sourceAndTargetPaths_0.contains_11rb$($receiver.location.path);
    if (tmp$_5) {
      var $receiver_0 = this.sourceAndTargetPaths_0;
      var none$result;
      none$break: do {
        var tmp$_6;
        if (Kotlin.isType($receiver_0, Collection) && $receiver_0.isEmpty()) {
          none$result = true;
          break none$break;
        }tmp$_6 = $receiver_0.iterator();
        while (tmp$_6.hasNext()) {
          var element = tmp$_6.next();
          if ($receiver.imports.contains_11rb$(element) || $receiver.publicImports.contains_11rb$(element)) {
            none$result = false;
            break none$break;
          }}
        none$result = true;
      }
       while (false);
      tmp$_5 = none$result;
    }if (tmp$_5) {
      return $receiver;
    }var referencedTypes = LinkedHashSet_init();
    this.collectReferencedTypes_0($receiver, referencedTypes);
    var definitelyNeed = LinkedHashSet_init();
    var possiblyDrop = LinkedHashSet_init();
    tmp$ = this.moves_0.iterator();
    while (tmp$.hasNext()) {
      var move = tmp$.next();
      if (referencedTypes.contains_11rb$(move.type)) {
        var element_0 = move.type;
        definitelyNeed.add_11rb$(element_0);
      } else {
        var element_1 = move.type;
        possiblyDrop.add_11rb$(element_1);
      }
      var tmp$_7;
      if ((tmp$_0 = this.oldSchema_0.protoFile_rubud1$(move.type)) != null)
        tmp$_7 = tmp$_0;
      else {
        throw IllegalStateException_init_0(('no source file for ' + move.type).toString());
      }
      var oldSchemaFile = tmp$_7;
      if (equals(oldSchemaFile.location.path, $receiver.location.path)) {
        this.collectReferencedTypes_1(this.getType_0(move), possiblyDrop);
      }if (equals($receiver.location.path, move.targetPath)) {
        this.collectReferencedTypes_1(this.getType_0(move), definitelyNeed);
      }}
    var obsoleteImports = LinkedHashSet_init();
    tmp$_1 = possiblyDrop.iterator();
    loop_label: while (tmp$_1.hasNext()) {
      var type = tmp$_1.next();
      tmp$_2 = this.typeToPath_0.get_11rb$(type);
      if (tmp$_2 == null) {
        continue loop_label;
      }var path = tmp$_2;
      var otherTypesInFile = ensureNotNull(this.pathToTypes_0.get_11rb$(path));
      var any$result;
      any$break: do {
        var tmp$_8;
        if (Kotlin.isType(otherTypesInFile, Collection) && otherTypesInFile.isEmpty()) {
          any$result = false;
          break any$break;
        }tmp$_8 = otherTypesInFile.iterator();
        while (tmp$_8.hasNext()) {
          var element_2 = tmp$_8.next();
          if (referencedTypes.contains_11rb$(element_2)) {
            any$result = true;
            break any$break;
          }}
        any$result = false;
      }
       while (false);
      if (any$result)
        continue loop_label;
      obsoleteImports.add_11rb$(path);
    }
    var newImports = toMutableList($receiver.imports);
    var newPublicImports = toMutableList($receiver.publicImports);
    tmp$_3 = definitelyNeed.iterator();
    while (tmp$_3.hasNext()) {
      var requiredType = tmp$_3.next();
      tmp$_4 = this.typeToPath_0.get_11rb$(requiredType);
      if (tmp$_4 == null) {
        continue;
      }var path_0 = tmp$_4;
      if (equals(path_0, $receiver.location.path))
        continue;
      if (newImports.contains_11rb$(path_0) || $receiver.publicImports.contains_11rb$(path_0))
        continue;
      newImports.add_11rb$(path_0);
    }
    newImports.removeAll_brywnq$(obsoleteImports);
    newPublicImports.removeAll_brywnq$(obsoleteImports);
    return $receiver.copy_ookjol$(void 0, newImports, newPublicImports);
  };
  TypeMover.prototype.getType_0 = function (move) {
    var $receiver = ensureNotNull(this.pathToFile_0.get_11rb$(move.targetPath)).types;
    var first$result;
    first$break: do {
      var tmp$;
      tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        var tmp$_0;
        if ((tmp$_0 = element.type) != null ? tmp$_0.equals(move.type) : null) {
          first$result = element;
          break first$break;
        }}
      throw new NoSuchElementException_init('Collection contains no element matching the predicate.');
    }
     while (false);
    return first$result;
  };
  TypeMover.prototype.collectReferencedTypes_0 = function ($receiver, sink) {
    var tmp$, tmp$_0;
    tmp$ = $receiver.types.iterator();
    while (tmp$.hasNext()) {
      var type = tmp$.next();
      this.collectReferencedTypes_1(type, sink);
    }
    tmp$_0 = $receiver.services.iterator();
    while (tmp$_0.hasNext()) {
      var service = tmp$_0.next();
      this.collectReferencedTypes_2(service, sink);
    }
  };
  TypeMover.prototype.collectReferencedTypes_1 = function ($receiver, sink) {
    var tmp$, tmp$_0;
    tmp$ = $receiver.nestedTypes.iterator();
    while (tmp$.hasNext()) {
      var type = tmp$.next();
      this.collectReferencedTypes_1(type, sink);
    }
    if (Kotlin.isType($receiver, MessageType)) {
      tmp$_0 = $receiver.fieldsAndOneOfFields.iterator();
      while (tmp$_0.hasNext()) {
        var field = tmp$_0.next();
        this.collectReferencedTypes_3(field, sink);
      }
    }};
  TypeMover.prototype.collectReferencedTypes_2 = function ($receiver, sink) {
    var tmp$;
    tmp$ = $receiver.rpcs.iterator();
    while (tmp$.hasNext()) {
      var rpc = tmp$.next();
      this.collectReferencedTypes_4(rpc, sink);
    }
  };
  TypeMover.prototype.collectReferencedTypes_4 = function ($receiver, sink) {
    var element = ensureNotNull($receiver.requestType);
    sink.add_11rb$(element);
    var element_0 = ensureNotNull($receiver.responseType);
    sink.add_11rb$(element_0);
  };
  TypeMover.prototype.collectReferencedTypes_3 = function ($receiver, sink) {
    var element = ensureNotNull($receiver.type);
    sink.add_11rb$(element);
  };
  TypeMover.prototype.collectDeclaredTypes_0 = function ($receiver, sink) {
    var tmp$;
    tmp$ = $receiver.types.iterator();
    while (tmp$.hasNext()) {
      var type = tmp$.next();
      this.collectDeclaredTypes_1(type, sink);
    }
  };
  TypeMover.prototype.collectDeclaredTypes_1 = function ($receiver, sink) {
    var tmp$;
    sink.add_11rb$($receiver.type);
    tmp$ = $receiver.nestedTypes.iterator();
    while (tmp$.hasNext()) {
      var type = tmp$.next();
      this.collectDeclaredTypes_1(type, sink);
    }
  };
  TypeMover.prototype.emptyCopy_0 = function ($receiver, path) {
    return $receiver.copy_ookjol$($receiver.location.copy_ccskfk$(void 0, path), emptyList(), emptyList(), void 0, emptyList(), emptyList(), emptyList());
  };
  TypeMover.prototype.checkForErrors_0 = function () {
    if (!this.errors_0.isEmpty()) {
      var message = joinToString(this.errors_0, '\n');
      throw IllegalArgumentException_init(message.toString());
    }};
  function TypeMover$Move(type, targetPath) {
    this.type = type;
    this.targetPath = targetPath;
  }
  TypeMover$Move.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Move',
    interfaces: []
  };
  TypeMover$Move.prototype.component1 = function () {
    return this.type;
  };
  TypeMover$Move.prototype.component2 = function () {
    return this.targetPath;
  };
  TypeMover$Move.prototype.copy_bu2imf$ = function (type, targetPath) {
    return new TypeMover$Move(type === void 0 ? this.type : type, targetPath === void 0 ? this.targetPath : targetPath);
  };
  TypeMover$Move.prototype.toString = function () {
    return 'Move(type=' + Kotlin.toString(this.type) + (', targetPath=' + Kotlin.toString(this.targetPath)) + ')';
  };
  TypeMover$Move.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.type) | 0;
    result = result * 31 + Kotlin.hashCode(this.targetPath) | 0;
    return result;
  };
  TypeMover$Move.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.type, other.type) && Kotlin.equals(this.targetPath, other.targetPath)))));
  };
  TypeMover.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TypeMover',
    interfaces: []
  };
  function appendDocumentation($receiver, documentation) {
    var tmp$;
    if (documentation.length === 0) {
      return;
    }var lines = split_0(documentation, ['\n']);
    var tmp$_0 = lines.size > 1;
    if (tmp$_0) {
      tmp$_0 = last(lines).length === 0;
    }if (tmp$_0) {
      lines = dropLast(lines, 1);
    }tmp$ = lines.iterator();
    while (tmp$.hasNext()) {
      var line = tmp$.next();
      $receiver.append_pdl1vj$('// ').append_pdl1vj$(line).append_s8itvh$(10);
    }
  }
  function appendOptions($receiver, options) {
    var count = options.size;
    if (count === 1) {
      $receiver.append_s8itvh$(91).append_pdl1vj$(options.get_za3lpa$(0).toSchema()).append_s8itvh$(93);
      return;
    }$receiver.append_pdl1vj$('[\n');
    for (var i = 0; i < count; i++) {
      var endl = i < (count - 1 | 0) ? ',' : '';
      appendIndented($receiver, options.get_za3lpa$(i).toSchema() + endl);
    }
    $receiver.append_s8itvh$(93);
  }
  function appendIndented($receiver, value) {
    var tmp$;
    var lines = split_0(value, ['\n']);
    var tmp$_0 = lines.size > 1;
    if (tmp$_0) {
      tmp$_0 = last(lines).length === 0;
    }if (tmp$_0) {
      lines = dropLast(lines, 1);
    }tmp$ = lines.iterator();
    while (tmp$.hasNext()) {
      var line = tmp$.next();
      $receiver.append_pdl1vj$('  ').append_pdl1vj$(line).append_s8itvh$(10);
    }
  }
  var MIN_TAG_VALUE;
  var MAX_TAG_VALUE;
  var RESERVED_TAG_VALUE_START;
  var RESERVED_TAG_VALUE_END;
  function isValidTag($receiver) {
    return 1 <= $receiver && $receiver < 19000 || (20000 <= $receiver && $receiver < 536870912);
  }
  function withStubs($receiver, typesToStub) {
    if (typesToStub.isEmpty()) {
      return $receiver;
    }var $receiver_0 = $receiver.protoFiles;
    var destination = ArrayList_init_0(collectionSizeOrDefault($receiver_0, 10));
    var tmp$;
    tmp$ = $receiver_0.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      var tmp$_0 = destination.add_11rb$;
      var tmp$_1 = void 0;
      var tmp$_2 = void 0;
      var tmp$_3 = void 0;
      var tmp$_4 = void 0;
      var $receiver_1 = item.types;
      var destination_0 = ArrayList_init_0(collectionSizeOrDefault($receiver_1, 10));
      var tmp$_5;
      tmp$_5 = $receiver_1.iterator();
      while (tmp$_5.hasNext()) {
        var item_0 = tmp$_5.next();
        destination_0.add_11rb$(typesToStub.contains_11rb$(item_0.type) ? asStub(item_0) : item_0);
      }
      var $receiver_2 = item.services;
      var destination_1 = ArrayList_init_0(collectionSizeOrDefault($receiver_2, 10));
      var tmp$_6;
      tmp$_6 = $receiver_2.iterator();
      while (tmp$_6.hasNext()) {
        var item_1 = tmp$_6.next();
        destination_1.add_11rb$(typesToStub.contains_11rb$(item_1.type) ? asStub_0(item_1) : item_1);
      }
      tmp$_0.call(destination, item.copy_ookjol$(tmp$_1, tmp$_2, tmp$_3, tmp$_4, destination_0, destination_1));
    }
    return new Schema(destination);
  }
  function asStub($receiver) {
    if (startsWith($receiver.type.toString(), 'google.protobuf.'))
      return $receiver;
    else if (Kotlin.isType($receiver, MessageType)) {
      var tmp$ = void 0;
      var tmp$_0 = void 0;
      var tmp$_1 = void 0;
      var tmp$_2 = void 0;
      var tmp$_3 = emptyList();
      var tmp$_4 = ArrayList_init();
      var tmp$_5 = void 0;
      var $receiver_0 = $receiver.nestedTypes;
      var destination = ArrayList_init_0(collectionSizeOrDefault($receiver_0, 10));
      var tmp$_6;
      tmp$_6 = $receiver_0.iterator();
      while (tmp$_6.hasNext()) {
        var item = tmp$_6.next();
        destination.add_11rb$(asStub(item));
      }
      return $receiver.copy_ah9t53$(tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, destination, void 0, void 0, new Options(Options$Companion_getInstance().MESSAGE_OPTIONS, emptyList()));
    } else if (Kotlin.isType($receiver, EnumType))
      return $receiver.copy_8puitw$(void 0, void 0, void 0, void 0, emptyList(), new Options(Options$Companion_getInstance().ENUM_OPTIONS, emptyList()));
    else if (Kotlin.isType($receiver, EnclosingType)) {
      var tmp$_7 = void 0;
      var tmp$_8 = void 0;
      var tmp$_9 = void 0;
      var $receiver_1 = $receiver.nestedTypes;
      var destination_0 = ArrayList_init_0(collectionSizeOrDefault($receiver_1, 10));
      var tmp$_10;
      tmp$_10 = $receiver_1.iterator();
      while (tmp$_10.hasNext()) {
        var item_0 = tmp$_10.next();
        destination_0.add_11rb$(asStub(item_0));
      }
      return $receiver.copy_h9s5b4$(tmp$_7, tmp$_8, tmp$_9, destination_0);
    } else
      throw AssertionError_init_0('Unknown type ' + $receiver.type);
  }
  function asStub_0($receiver) {
    return $receiver.copy_w00g4t$(void 0, void 0, void 0, void 0, emptyList(), new Options(Options$Companion_getInstance().SERVICE_OPTIONS, emptyList()));
  }
  function EnumConstantElement(location, name, tag, documentation, options) {
    if (documentation === void 0)
      documentation = '';
    if (options === void 0)
      options = emptyList();
    this.location = location;
    this.name = name;
    this.tag = tag;
    this.documentation = documentation;
    this.options = options;
  }
  EnumConstantElement.prototype.toSchema = function () {
    var $receiver = StringBuilder_init();
    appendDocumentation($receiver, this.documentation);
    $receiver.append_pdl1vj$(this.name + ' = ' + this.tag);
    if (!this.options.isEmpty()) {
      $receiver.append_pdl1vj$(' ');
      appendOptions($receiver, this.options);
    }$receiver.append_pdl1vj$(';\n');
    return $receiver.toString();
  };
  EnumConstantElement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EnumConstantElement',
    interfaces: []
  };
  EnumConstantElement.prototype.component1 = function () {
    return this.location;
  };
  EnumConstantElement.prototype.component2 = function () {
    return this.name;
  };
  EnumConstantElement.prototype.component3 = function () {
    return this.tag;
  };
  EnumConstantElement.prototype.component4 = function () {
    return this.documentation;
  };
  EnumConstantElement.prototype.component5 = function () {
    return this.options;
  };
  EnumConstantElement.prototype.copy_tcc2un$ = function (location, name, tag, documentation, options) {
    return new EnumConstantElement(location === void 0 ? this.location : location, name === void 0 ? this.name : name, tag === void 0 ? this.tag : tag, documentation === void 0 ? this.documentation : documentation, options === void 0 ? this.options : options);
  };
  EnumConstantElement.prototype.toString = function () {
    return 'EnumConstantElement(location=' + Kotlin.toString(this.location) + (', name=' + Kotlin.toString(this.name)) + (', tag=' + Kotlin.toString(this.tag)) + (', documentation=' + Kotlin.toString(this.documentation)) + (', options=' + Kotlin.toString(this.options)) + ')';
  };
  EnumConstantElement.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.tag) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    return result;
  };
  EnumConstantElement.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.tag, other.tag) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.options, other.options)))));
  };
  function EnumElement(location, name, documentation, options, constants) {
    if (documentation === void 0)
      documentation = '';
    if (options === void 0)
      options = emptyList();
    if (constants === void 0)
      constants = emptyList();
    this.location_epjqmx$_0 = location;
    this.name_xbjuxd$_0 = name;
    this.documentation_25rgi$_0 = documentation;
    this.options_qchvdy$_0 = options;
    this.constants = constants;
    this.nestedTypes_aqfrgq$_0 = emptyList();
  }
  Object.defineProperty(EnumElement.prototype, 'location', {
    get: function () {
      return this.location_epjqmx$_0;
    }
  });
  Object.defineProperty(EnumElement.prototype, 'name', {
    get: function () {
      return this.name_xbjuxd$_0;
    }
  });
  Object.defineProperty(EnumElement.prototype, 'documentation', {
    get: function () {
      return this.documentation_25rgi$_0;
    }
  });
  Object.defineProperty(EnumElement.prototype, 'options', {
    get: function () {
      return this.options_qchvdy$_0;
    }
  });
  Object.defineProperty(EnumElement.prototype, 'nestedTypes', {
    configurable: true,
    get: function () {
      return this.nestedTypes_aqfrgq$_0;
    }
  });
  EnumElement.prototype.toSchema = function () {
    var $receiver = StringBuilder_init();
    var tmp$, tmp$_0;
    appendDocumentation($receiver, this.documentation);
    $receiver.append_pdl1vj$('enum ' + this.name + ' {');
    var tmp$_1 = !this.options.isEmpty();
    if (!tmp$_1) {
      tmp$_1 = !this.constants.isEmpty();
    }if (tmp$_1) {
      $receiver.append_s8itvh$(10);
    }if (!this.options.isEmpty()) {
      tmp$ = this.options.iterator();
      while (tmp$.hasNext()) {
        var option = tmp$.next();
        appendIndented($receiver, option.toSchemaDeclaration());
      }
    }if (!this.constants.isEmpty()) {
      tmp$_0 = this.constants.iterator();
      while (tmp$_0.hasNext()) {
        var constant = tmp$_0.next();
        appendIndented($receiver, constant.toSchema());
      }
    }$receiver.append_pdl1vj$('}\n');
    return $receiver.toString();
  };
  EnumElement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EnumElement',
    interfaces: [TypeElement]
  };
  EnumElement.prototype.component1 = function () {
    return this.location;
  };
  EnumElement.prototype.component2 = function () {
    return this.name;
  };
  EnumElement.prototype.component3 = function () {
    return this.documentation;
  };
  EnumElement.prototype.component4 = function () {
    return this.options;
  };
  EnumElement.prototype.component5 = function () {
    return this.constants;
  };
  EnumElement.prototype.copy_10ou2y$ = function (location, name, documentation, options, constants) {
    return new EnumElement(location === void 0 ? this.location : location, name === void 0 ? this.name : name, documentation === void 0 ? this.documentation : documentation, options === void 0 ? this.options : options, constants === void 0 ? this.constants : constants);
  };
  EnumElement.prototype.toString = function () {
    return 'EnumElement(location=' + Kotlin.toString(this.location) + (', name=' + Kotlin.toString(this.name)) + (', documentation=' + Kotlin.toString(this.documentation)) + (', options=' + Kotlin.toString(this.options)) + (', constants=' + Kotlin.toString(this.constants)) + ')';
  };
  EnumElement.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    result = result * 31 + Kotlin.hashCode(this.constants) | 0;
    return result;
  };
  EnumElement.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.options, other.options) && Kotlin.equals(this.constants, other.constants)))));
  };
  function ExtendElement(location, name, documentation, fields) {
    if (documentation === void 0)
      documentation = '';
    if (fields === void 0)
      fields = emptyList();
    this.location = location;
    this.name = name;
    this.documentation = documentation;
    this.fields = fields;
  }
  ExtendElement.prototype.toSchema = function () {
    var $receiver = StringBuilder_init();
    var tmp$;
    appendDocumentation($receiver, this.documentation);
    $receiver.append_pdl1vj$('extend ' + this.name + ' {');
    if (!this.fields.isEmpty()) {
      $receiver.append_s8itvh$(10);
      tmp$ = this.fields.iterator();
      while (tmp$.hasNext()) {
        var field = tmp$.next();
        appendIndented($receiver, field.toSchema());
      }
    }$receiver.append_pdl1vj$('}\n');
    return $receiver.toString();
  };
  ExtendElement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ExtendElement',
    interfaces: []
  };
  ExtendElement.prototype.component1 = function () {
    return this.location;
  };
  ExtendElement.prototype.component2 = function () {
    return this.name;
  };
  ExtendElement.prototype.component3 = function () {
    return this.documentation;
  };
  ExtendElement.prototype.component4 = function () {
    return this.fields;
  };
  ExtendElement.prototype.copy_z48ja6$ = function (location, name, documentation, fields) {
    return new ExtendElement(location === void 0 ? this.location : location, name === void 0 ? this.name : name, documentation === void 0 ? this.documentation : documentation, fields === void 0 ? this.fields : fields);
  };
  ExtendElement.prototype.toString = function () {
    return 'ExtendElement(location=' + Kotlin.toString(this.location) + (', name=' + Kotlin.toString(this.name)) + (', documentation=' + Kotlin.toString(this.documentation)) + (', fields=' + Kotlin.toString(this.fields)) + ')';
  };
  ExtendElement.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.fields) | 0;
    return result;
  };
  ExtendElement.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.fields, other.fields)))));
  };
  function ExtensionsElement(location, documentation, values) {
    if (documentation === void 0)
      documentation = '';
    this.location = location;
    this.documentation = documentation;
    this.values = values;
  }
  ExtensionsElement.prototype.toSchema = function () {
    var $receiver = StringBuilder_init();
    appendDocumentation($receiver, this.documentation);
    $receiver.append_pdl1vj$('extensions ');
    var tmp$, tmp$_0;
    var index = 0;
    tmp$ = this.values.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      if (checkIndexOverflow((tmp$_0 = index, index = tmp$_0 + 1 | 0, tmp$_0)) > 0)
        $receiver.append_pdl1vj$(', ');
      if (typeof item === 'number')
        $receiver.append_s8jyv4$(item);
      else if (Kotlin.isType(item, IntRange)) {
        $receiver.append_pdl1vj$(item.first.toString() + ' to ');
        if (item.last < 536870911) {
          $receiver.append_s8jyv4$(item.last);
        } else {
          $receiver.append_pdl1vj$('max');
        }
      } else
        throw AssertionError_init();
    }
    $receiver.append_pdl1vj$(';\n');
    return $receiver.toString();
  };
  ExtensionsElement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ExtensionsElement',
    interfaces: []
  };
  ExtensionsElement.prototype.component1 = function () {
    return this.location;
  };
  ExtensionsElement.prototype.component2 = function () {
    return this.documentation;
  };
  ExtensionsElement.prototype.component3 = function () {
    return this.values;
  };
  ExtensionsElement.prototype.copy_hncgv0$ = function (location, documentation, values) {
    return new ExtensionsElement(location === void 0 ? this.location : location, documentation === void 0 ? this.documentation : documentation, values === void 0 ? this.values : values);
  };
  ExtensionsElement.prototype.toString = function () {
    return 'ExtensionsElement(location=' + Kotlin.toString(this.location) + (', documentation=' + Kotlin.toString(this.documentation)) + (', values=' + Kotlin.toString(this.values)) + ')';
  };
  ExtensionsElement.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.values) | 0;
    return result;
  };
  ExtensionsElement.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.values, other.values)))));
  };
  function FieldElement(location, label, type, name, defaultValue, jsonName, tag, documentation, options) {
    if (label === void 0)
      label = null;
    if (defaultValue === void 0)
      defaultValue = null;
    if (jsonName === void 0)
      jsonName = null;
    if (tag === void 0)
      tag = 0;
    if (documentation === void 0)
      documentation = '';
    if (options === void 0)
      options = emptyList();
    this.location = location;
    this.label = label;
    this.type = type;
    this.name = name;
    this.defaultValue = defaultValue;
    this.jsonName = jsonName;
    this.tag = tag;
    this.documentation = documentation;
    this.options = options;
  }
  FieldElement.prototype.toSchema = function () {
    var $receiver = StringBuilder_init();
    appendDocumentation($receiver, this.documentation);
    if (this.label != null) {
      $receiver.append_pdl1vj$(toEnglishLowerCase(this.label.name) + ' ');
    }$receiver.append_pdl1vj$(this.type + ' ' + this.name + ' = ' + this.tag);
    var optionsWithDefault = this.optionsWithSpecialValues_0();
    if (!optionsWithDefault.isEmpty()) {
      $receiver.append_s8itvh$(32);
      appendOptions($receiver, optionsWithDefault);
    }$receiver.append_pdl1vj$(';\n');
    return $receiver.toString();
  };
  FieldElement.prototype.optionsWithSpecialValues_0 = function () {
    var tmp$;
    if (this.defaultValue == null) {
      tmp$ = this.options;
    } else {
      var protoType = ProtoType$Companion_getInstance().get_pdl1vj$(this.type);
      tmp$ = plus_0(this.options, OptionElement$Companion_getInstance().create_ji0w9g$('default', this.toKind_0(protoType), this.defaultValue));
    }
    var options = tmp$;
    options = this.jsonName == null ? options : plus_0(options, OptionElement$Companion_getInstance().create_ji0w9g$('json_name', OptionElement$Kind$STRING_getInstance(), this.jsonName));
    return options;
  };
  FieldElement.prototype.toKind_0 = function ($receiver) {
    var tmp$;
    switch ($receiver.simpleName) {
      case 'bool':
        tmp$ = OptionElement$Kind$BOOLEAN_getInstance();
        break;
      case 'string':
        tmp$ = OptionElement$Kind$STRING_getInstance();
        break;
      case 'bytes':
      case 'double':
      case 'float':
      case 'fixed32':
      case 'fixed64':
      case 'int32':
      case 'int64':
      case 'sfixed32':
      case 'sfixed64':
      case 'sint32':
      case 'sint64':
      case 'uint32':
      case 'uint64':
        tmp$ = OptionElement$Kind$NUMBER_getInstance();
        break;
      default:tmp$ = OptionElement$Kind$ENUM_getInstance();
        break;
    }
    return tmp$;
  };
  FieldElement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FieldElement',
    interfaces: []
  };
  FieldElement.prototype.component1 = function () {
    return this.location;
  };
  FieldElement.prototype.component2 = function () {
    return this.label;
  };
  FieldElement.prototype.component3 = function () {
    return this.type;
  };
  FieldElement.prototype.component4 = function () {
    return this.name;
  };
  FieldElement.prototype.component5 = function () {
    return this.defaultValue;
  };
  FieldElement.prototype.component6 = function () {
    return this.jsonName;
  };
  FieldElement.prototype.component7 = function () {
    return this.tag;
  };
  FieldElement.prototype.component8 = function () {
    return this.documentation;
  };
  FieldElement.prototype.component9 = function () {
    return this.options;
  };
  FieldElement.prototype.copy_6cf8ch$ = function (location, label, type, name, defaultValue, jsonName, tag, documentation, options) {
    return new FieldElement(location === void 0 ? this.location : location, label === void 0 ? this.label : label, type === void 0 ? this.type : type, name === void 0 ? this.name : name, defaultValue === void 0 ? this.defaultValue : defaultValue, jsonName === void 0 ? this.jsonName : jsonName, tag === void 0 ? this.tag : tag, documentation === void 0 ? this.documentation : documentation, options === void 0 ? this.options : options);
  };
  FieldElement.prototype.toString = function () {
    return 'FieldElement(location=' + Kotlin.toString(this.location) + (', label=' + Kotlin.toString(this.label)) + (', type=' + Kotlin.toString(this.type)) + (', name=' + Kotlin.toString(this.name)) + (', defaultValue=' + Kotlin.toString(this.defaultValue)) + (', jsonName=' + Kotlin.toString(this.jsonName)) + (', tag=' + Kotlin.toString(this.tag)) + (', documentation=' + Kotlin.toString(this.documentation)) + (', options=' + Kotlin.toString(this.options)) + ')';
  };
  FieldElement.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.label) | 0;
    result = result * 31 + Kotlin.hashCode(this.type) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.defaultValue) | 0;
    result = result * 31 + Kotlin.hashCode(this.jsonName) | 0;
    result = result * 31 + Kotlin.hashCode(this.tag) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    return result;
  };
  FieldElement.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.label, other.label) && Kotlin.equals(this.type, other.type) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.defaultValue, other.defaultValue) && Kotlin.equals(this.jsonName, other.jsonName) && Kotlin.equals(this.tag, other.tag) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.options, other.options)))));
  };
  function GroupElement(label, location, name, tag, documentation, fields) {
    if (label === void 0)
      label = null;
    if (documentation === void 0)
      documentation = '';
    if (fields === void 0)
      fields = emptyList();
    this.label = label;
    this.location = location;
    this.name = name;
    this.tag = tag;
    this.documentation = documentation;
    this.fields = fields;
  }
  GroupElement.prototype.toSchema = function () {
    var $receiver = StringBuilder_init();
    var tmp$;
    appendDocumentation($receiver, this.documentation);
    if (this.label != null) {
      $receiver.append_pdl1vj$(toEnglishLowerCase(this.label.name) + ' ');
    }$receiver.append_pdl1vj$('group ' + this.name + ' = ' + this.tag + ' {');
    if (!this.fields.isEmpty()) {
      $receiver.append_s8itvh$(10);
      tmp$ = this.fields.iterator();
      while (tmp$.hasNext()) {
        var field = tmp$.next();
        appendIndented($receiver, field.toSchema());
      }
    }$receiver.append_pdl1vj$('}\n');
    return $receiver.toString();
  };
  GroupElement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GroupElement',
    interfaces: []
  };
  GroupElement.prototype.component1 = function () {
    return this.label;
  };
  GroupElement.prototype.component2 = function () {
    return this.location;
  };
  GroupElement.prototype.component3 = function () {
    return this.name;
  };
  GroupElement.prototype.component4 = function () {
    return this.tag;
  };
  GroupElement.prototype.component5 = function () {
    return this.documentation;
  };
  GroupElement.prototype.component6 = function () {
    return this.fields;
  };
  GroupElement.prototype.copy_wxvi1w$ = function (label, location, name, tag, documentation, fields) {
    return new GroupElement(label === void 0 ? this.label : label, location === void 0 ? this.location : location, name === void 0 ? this.name : name, tag === void 0 ? this.tag : tag, documentation === void 0 ? this.documentation : documentation, fields === void 0 ? this.fields : fields);
  };
  GroupElement.prototype.toString = function () {
    return 'GroupElement(label=' + Kotlin.toString(this.label) + (', location=' + Kotlin.toString(this.location)) + (', name=' + Kotlin.toString(this.name)) + (', tag=' + Kotlin.toString(this.tag)) + (', documentation=' + Kotlin.toString(this.documentation)) + (', fields=' + Kotlin.toString(this.fields)) + ')';
  };
  GroupElement.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.label) | 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.tag) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.fields) | 0;
    return result;
  };
  GroupElement.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.label, other.label) && Kotlin.equals(this.location, other.location) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.tag, other.tag) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.fields, other.fields)))));
  };
  function MessageElement(location, name, documentation, nestedTypes, options, reserveds, fields, oneOfs, extensions, groups) {
    if (documentation === void 0)
      documentation = '';
    if (nestedTypes === void 0)
      nestedTypes = emptyList();
    if (options === void 0)
      options = emptyList();
    if (reserveds === void 0)
      reserveds = emptyList();
    if (fields === void 0)
      fields = emptyList();
    if (oneOfs === void 0)
      oneOfs = emptyList();
    if (extensions === void 0)
      extensions = emptyList();
    if (groups === void 0)
      groups = emptyList();
    this.location_nr4m1j$_0 = location;
    this.name_hzhncv$_0 = name;
    this.documentation_en7g4y$_0 = documentation;
    this.nestedTypes_n3cooq$_0 = nestedTypes;
    this.options_99he3u$_0 = options;
    this.reserveds = reserveds;
    this.fields = fields;
    this.oneOfs = oneOfs;
    this.extensions = extensions;
    this.groups = groups;
  }
  Object.defineProperty(MessageElement.prototype, 'location', {
    get: function () {
      return this.location_nr4m1j$_0;
    }
  });
  Object.defineProperty(MessageElement.prototype, 'name', {
    get: function () {
      return this.name_hzhncv$_0;
    }
  });
  Object.defineProperty(MessageElement.prototype, 'documentation', {
    get: function () {
      return this.documentation_en7g4y$_0;
    }
  });
  Object.defineProperty(MessageElement.prototype, 'nestedTypes', {
    get: function () {
      return this.nestedTypes_n3cooq$_0;
    }
  });
  Object.defineProperty(MessageElement.prototype, 'options', {
    get: function () {
      return this.options_99he3u$_0;
    }
  });
  MessageElement.prototype.toSchema = function () {
    var $receiver = StringBuilder_init();
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5;
    appendDocumentation($receiver, this.documentation);
    $receiver.append_pdl1vj$('message ' + this.name + ' {');
    if (!this.reserveds.isEmpty()) {
      $receiver.append_s8itvh$(10);
      tmp$ = this.reserveds.iterator();
      while (tmp$.hasNext()) {
        var reserved = tmp$.next();
        appendIndented($receiver, reserved.toSchema());
      }
    }if (!this.options.isEmpty()) {
      $receiver.append_s8itvh$(10);
      tmp$_0 = this.options.iterator();
      while (tmp$_0.hasNext()) {
        var option = tmp$_0.next();
        appendIndented($receiver, option.toSchemaDeclaration());
      }
    }if (!this.fields.isEmpty()) {
      tmp$_1 = this.fields.iterator();
      while (tmp$_1.hasNext()) {
        var field = tmp$_1.next();
        $receiver.append_s8itvh$(10);
        appendIndented($receiver, field.toSchema());
      }
    }if (!this.oneOfs.isEmpty()) {
      tmp$_2 = this.oneOfs.iterator();
      while (tmp$_2.hasNext()) {
        var oneOf = tmp$_2.next();
        $receiver.append_s8itvh$(10);
        appendIndented($receiver, oneOf.toSchema());
      }
    }if (!this.groups.isEmpty()) {
      tmp$_3 = this.groups.iterator();
      while (tmp$_3.hasNext()) {
        var group = tmp$_3.next();
        $receiver.append_s8itvh$(10);
        appendIndented($receiver, group.toSchema());
      }
    }if (!this.extensions.isEmpty()) {
      $receiver.append_s8itvh$(10);
      tmp$_4 = this.extensions.iterator();
      while (tmp$_4.hasNext()) {
        var extension = tmp$_4.next();
        appendIndented($receiver, extension.toSchema());
      }
    }if (!this.nestedTypes.isEmpty()) {
      tmp$_5 = this.nestedTypes.iterator();
      while (tmp$_5.hasNext()) {
        var type = tmp$_5.next();
        $receiver.append_s8itvh$(10);
        appendIndented($receiver, type.toSchema());
      }
    }$receiver.append_pdl1vj$('}\n');
    return $receiver.toString();
  };
  MessageElement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MessageElement',
    interfaces: [TypeElement]
  };
  MessageElement.prototype.component1 = function () {
    return this.location;
  };
  MessageElement.prototype.component2 = function () {
    return this.name;
  };
  MessageElement.prototype.component3 = function () {
    return this.documentation;
  };
  MessageElement.prototype.component4 = function () {
    return this.nestedTypes;
  };
  MessageElement.prototype.component5 = function () {
    return this.options;
  };
  MessageElement.prototype.component6 = function () {
    return this.reserveds;
  };
  MessageElement.prototype.component7 = function () {
    return this.fields;
  };
  MessageElement.prototype.component8 = function () {
    return this.oneOfs;
  };
  MessageElement.prototype.component9 = function () {
    return this.extensions;
  };
  MessageElement.prototype.component10 = function () {
    return this.groups;
  };
  MessageElement.prototype.copy_ciwdrd$ = function (location, name, documentation, nestedTypes, options, reserveds, fields, oneOfs, extensions, groups) {
    return new MessageElement(location === void 0 ? this.location : location, name === void 0 ? this.name : name, documentation === void 0 ? this.documentation : documentation, nestedTypes === void 0 ? this.nestedTypes : nestedTypes, options === void 0 ? this.options : options, reserveds === void 0 ? this.reserveds : reserveds, fields === void 0 ? this.fields : fields, oneOfs === void 0 ? this.oneOfs : oneOfs, extensions === void 0 ? this.extensions : extensions, groups === void 0 ? this.groups : groups);
  };
  MessageElement.prototype.toString = function () {
    return 'MessageElement(location=' + Kotlin.toString(this.location) + (', name=' + Kotlin.toString(this.name)) + (', documentation=' + Kotlin.toString(this.documentation)) + (', nestedTypes=' + Kotlin.toString(this.nestedTypes)) + (', options=' + Kotlin.toString(this.options)) + (', reserveds=' + Kotlin.toString(this.reserveds)) + (', fields=' + Kotlin.toString(this.fields)) + (', oneOfs=' + Kotlin.toString(this.oneOfs)) + (', extensions=' + Kotlin.toString(this.extensions)) + (', groups=' + Kotlin.toString(this.groups)) + ')';
  };
  MessageElement.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.nestedTypes) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    result = result * 31 + Kotlin.hashCode(this.reserveds) | 0;
    result = result * 31 + Kotlin.hashCode(this.fields) | 0;
    result = result * 31 + Kotlin.hashCode(this.oneOfs) | 0;
    result = result * 31 + Kotlin.hashCode(this.extensions) | 0;
    result = result * 31 + Kotlin.hashCode(this.groups) | 0;
    return result;
  };
  MessageElement.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.nestedTypes, other.nestedTypes) && Kotlin.equals(this.options, other.options) && Kotlin.equals(this.reserveds, other.reserveds) && Kotlin.equals(this.fields, other.fields) && Kotlin.equals(this.oneOfs, other.oneOfs) && Kotlin.equals(this.extensions, other.extensions) && Kotlin.equals(this.groups, other.groups)))));
  };
  function OneOfElement(name, documentation, fields, groups, options) {
    if (documentation === void 0)
      documentation = '';
    if (fields === void 0)
      fields = emptyList();
    if (groups === void 0)
      groups = emptyList();
    if (options === void 0)
      options = emptyList();
    this.name = name;
    this.documentation = documentation;
    this.fields = fields;
    this.groups = groups;
    this.options = options;
  }
  OneOfElement.prototype.toSchema = function () {
    var $receiver = StringBuilder_init();
    var tmp$, tmp$_0, tmp$_1;
    appendDocumentation($receiver, this.documentation);
    $receiver.append_pdl1vj$('oneof ' + this.name + ' {');
    if (!this.options.isEmpty()) {
      $receiver.append_s8itvh$(10);
      tmp$ = this.options.iterator();
      while (tmp$.hasNext()) {
        var option = tmp$.next();
        appendIndented($receiver, option.toSchemaDeclaration());
      }
    }if (!this.fields.isEmpty()) {
      $receiver.append_s8itvh$(10);
      tmp$_0 = this.fields.iterator();
      while (tmp$_0.hasNext()) {
        var field = tmp$_0.next();
        appendIndented($receiver, field.toSchema());
      }
    }if (!this.groups.isEmpty()) {
      $receiver.append_s8itvh$(10);
      tmp$_1 = this.groups.iterator();
      while (tmp$_1.hasNext()) {
        var group = tmp$_1.next();
        appendIndented($receiver, group.toSchema());
      }
    }$receiver.append_pdl1vj$('}\n');
    return $receiver.toString();
  };
  OneOfElement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OneOfElement',
    interfaces: []
  };
  OneOfElement.prototype.component1 = function () {
    return this.name;
  };
  OneOfElement.prototype.component2 = function () {
    return this.documentation;
  };
  OneOfElement.prototype.component3 = function () {
    return this.fields;
  };
  OneOfElement.prototype.component4 = function () {
    return this.groups;
  };
  OneOfElement.prototype.component5 = function () {
    return this.options;
  };
  OneOfElement.prototype.copy_oamgae$ = function (name, documentation, fields, groups, options) {
    return new OneOfElement(name === void 0 ? this.name : name, documentation === void 0 ? this.documentation : documentation, fields === void 0 ? this.fields : fields, groups === void 0 ? this.groups : groups, options === void 0 ? this.options : options);
  };
  OneOfElement.prototype.toString = function () {
    return 'OneOfElement(name=' + Kotlin.toString(this.name) + (', documentation=' + Kotlin.toString(this.documentation)) + (', fields=' + Kotlin.toString(this.fields)) + (', groups=' + Kotlin.toString(this.groups)) + (', options=' + Kotlin.toString(this.options)) + ')';
  };
  OneOfElement.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.fields) | 0;
    result = result * 31 + Kotlin.hashCode(this.groups) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    return result;
  };
  OneOfElement.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.name, other.name) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.fields, other.fields) && Kotlin.equals(this.groups, other.groups) && Kotlin.equals(this.options, other.options)))));
  };
  function OptionElement(name, kind, value, isParenthesized) {
    OptionElement$Companion_getInstance();
    this.name = name;
    this.kind = kind;
    this.value = value;
    this.isParenthesized = isParenthesized;
    this.formattedName_0 = this.isParenthesized ? '(' + this.name + ')' : this.name;
  }
  function OptionElement$Kind(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function OptionElement$Kind_initFields() {
    OptionElement$Kind_initFields = function () {
    };
    OptionElement$Kind$STRING_instance = new OptionElement$Kind('STRING', 0);
    OptionElement$Kind$BOOLEAN_instance = new OptionElement$Kind('BOOLEAN', 1);
    OptionElement$Kind$NUMBER_instance = new OptionElement$Kind('NUMBER', 2);
    OptionElement$Kind$ENUM_instance = new OptionElement$Kind('ENUM', 3);
    OptionElement$Kind$MAP_instance = new OptionElement$Kind('MAP', 4);
    OptionElement$Kind$LIST_instance = new OptionElement$Kind('LIST', 5);
    OptionElement$Kind$OPTION_instance = new OptionElement$Kind('OPTION', 6);
  }
  var OptionElement$Kind$STRING_instance;
  function OptionElement$Kind$STRING_getInstance() {
    OptionElement$Kind_initFields();
    return OptionElement$Kind$STRING_instance;
  }
  var OptionElement$Kind$BOOLEAN_instance;
  function OptionElement$Kind$BOOLEAN_getInstance() {
    OptionElement$Kind_initFields();
    return OptionElement$Kind$BOOLEAN_instance;
  }
  var OptionElement$Kind$NUMBER_instance;
  function OptionElement$Kind$NUMBER_getInstance() {
    OptionElement$Kind_initFields();
    return OptionElement$Kind$NUMBER_instance;
  }
  var OptionElement$Kind$ENUM_instance;
  function OptionElement$Kind$ENUM_getInstance() {
    OptionElement$Kind_initFields();
    return OptionElement$Kind$ENUM_instance;
  }
  var OptionElement$Kind$MAP_instance;
  function OptionElement$Kind$MAP_getInstance() {
    OptionElement$Kind_initFields();
    return OptionElement$Kind$MAP_instance;
  }
  var OptionElement$Kind$LIST_instance;
  function OptionElement$Kind$LIST_getInstance() {
    OptionElement$Kind_initFields();
    return OptionElement$Kind$LIST_instance;
  }
  var OptionElement$Kind$OPTION_instance;
  function OptionElement$Kind$OPTION_getInstance() {
    OptionElement$Kind_initFields();
    return OptionElement$Kind$OPTION_instance;
  }
  OptionElement$Kind.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Kind',
    interfaces: [Enum]
  };
  function OptionElement$Kind$values() {
    return [OptionElement$Kind$STRING_getInstance(), OptionElement$Kind$BOOLEAN_getInstance(), OptionElement$Kind$NUMBER_getInstance(), OptionElement$Kind$ENUM_getInstance(), OptionElement$Kind$MAP_getInstance(), OptionElement$Kind$LIST_getInstance(), OptionElement$Kind$OPTION_getInstance()];
  }
  OptionElement$Kind.values = OptionElement$Kind$values;
  function OptionElement$Kind$valueOf(name) {
    switch (name) {
      case 'STRING':
        return OptionElement$Kind$STRING_getInstance();
      case 'BOOLEAN':
        return OptionElement$Kind$BOOLEAN_getInstance();
      case 'NUMBER':
        return OptionElement$Kind$NUMBER_getInstance();
      case 'ENUM':
        return OptionElement$Kind$ENUM_getInstance();
      case 'MAP':
        return OptionElement$Kind$MAP_getInstance();
      case 'LIST':
        return OptionElement$Kind$LIST_getInstance();
      case 'OPTION':
        return OptionElement$Kind$OPTION_getInstance();
      default:throwISE('No enum constant com.squareup.wire.schema.internal.parser.OptionElement.Kind.' + name);
    }
  }
  OptionElement$Kind.valueOf_61zpoe$ = OptionElement$Kind$valueOf;
  OptionElement.prototype.toSchema = function () {
    var $receiver = StringBuilder_init();
    var tmp$, tmp$_0, tmp$_1;
    switch (this.kind.name) {
      case 'STRING':
        $receiver.append_pdl1vj$(this.formattedName_0 + ' = ' + '"' + this.value.toString() + '"');
        break;
      case 'BOOLEAN':
      case 'NUMBER':
      case 'ENUM':
        $receiver.append_pdl1vj$(this.formattedName_0 + ' = ' + this.value.toString());
        break;
      case 'OPTION':
        var optionValue = (Kotlin.isType(tmp$ = this.value, OptionElement) ? tmp$ : throwCCE()).copy_ji0w9g$();
        $receiver.append_pdl1vj$(this.formattedName_0 + '.' + optionValue.toSchema());
        break;
      case 'MAP':
        $receiver.append_pdl1vj$(this.formattedName_0 + ' = {' + '\n');
        this.formatOptionMap_0($receiver, Kotlin.isType(tmp$_0 = this.value, Map) ? tmp$_0 : throwCCE());
        $receiver.append_s8itvh$(125);
        break;
      case 'LIST':
        $receiver.append_pdl1vj$(this.formattedName_0 + ' = ');
        appendOptions($receiver, Kotlin.isType(tmp$_1 = this.value, List) ? tmp$_1 : throwCCE());
        break;
      default:Kotlin.noWhenBranchMatched();
        break;
    }
    return $receiver.toString();
  };
  OptionElement.prototype.toSchemaDeclaration = function () {
    return 'option ' + this.toSchema() + ';' + '\n';
  };
  OptionElement.prototype.formatOptionMap_0 = function (builder, valueMap) {
    var lastIndex = valueMap.size - 1 | 0;
    var tmp$, tmp$_0;
    var index = 0;
    tmp$ = valueMap.entries.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      var endl = checkIndexOverflow((tmp$_0 = index, index = tmp$_0 + 1 | 0, tmp$_0)) !== lastIndex ? ',' : '';
      appendIndented(builder, item.key + ': ' + this.formatOptionMapValue_0(ensureNotNull(item.value)) + endl);
    }
  };
  OptionElement.prototype.formatOptionMapValue_0 = function (value) {
    var $receiver = StringBuilder_init();
    var tmp$;
    if (typeof value === 'string')
      $receiver.append_pdl1vj$('"' + value.toString() + '"');
    else if (Kotlin.isType(value, Map)) {
      $receiver.append_pdl1vj$('{\n');
      this.formatOptionMap_0($receiver, Kotlin.isType(tmp$ = value, Map) ? tmp$ : throwCCE());
      $receiver.append_s8itvh$(125);
    } else if (Kotlin.isType(value, List)) {
      $receiver.append_pdl1vj$('[\n');
      var lastIndex = value.size - 1 | 0;
      var tmp$_0, tmp$_0_0;
      var index = 0;
      tmp$_0 = value.iterator();
      while (tmp$_0.hasNext()) {
        var item = tmp$_0.next();
        var endl = checkIndexOverflow((tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0)) !== lastIndex ? ',' : '';
        appendIndented($receiver, this.formatOptionMapValue_0(ensureNotNull(item)) + endl);
      }
      $receiver.append_pdl1vj$(']');
    } else {
      $receiver.append_s8jyv4$(value);
    }
    return $receiver.toString();
  };
  function OptionElement$Companion() {
    OptionElement$Companion_instance = this;
    this.PACKED_OPTION_ELEMENT_8be2vx$ = new OptionElement('packed', OptionElement$Kind$BOOLEAN_getInstance(), 'true', false);
  }
  OptionElement$Companion.prototype.create_ji0w9g$ = function (name, kind, value, isParenthesized) {
    if (isParenthesized === void 0)
      isParenthesized = false;
    return new OptionElement(name, kind, value, isParenthesized);
  };
  OptionElement$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var OptionElement$Companion_instance = null;
  function OptionElement$Companion_getInstance() {
    if (OptionElement$Companion_instance === null) {
      new OptionElement$Companion();
    }return OptionElement$Companion_instance;
  }
  OptionElement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OptionElement',
    interfaces: []
  };
  OptionElement.prototype.component1 = function () {
    return this.name;
  };
  OptionElement.prototype.component2 = function () {
    return this.kind;
  };
  OptionElement.prototype.component3 = function () {
    return this.value;
  };
  OptionElement.prototype.component4 = function () {
    return this.isParenthesized;
  };
  OptionElement.prototype.copy_ji0w9g$ = function (name, kind, value, isParenthesized) {
    return new OptionElement(name === void 0 ? this.name : name, kind === void 0 ? this.kind : kind, value === void 0 ? this.value : value, isParenthesized === void 0 ? this.isParenthesized : isParenthesized);
  };
  OptionElement.prototype.toString = function () {
    return 'OptionElement(name=' + Kotlin.toString(this.name) + (', kind=' + Kotlin.toString(this.kind)) + (', value=' + Kotlin.toString(this.value)) + (', isParenthesized=' + Kotlin.toString(this.isParenthesized)) + ')';
  };
  OptionElement.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.kind) | 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    result = result * 31 + Kotlin.hashCode(this.isParenthesized) | 0;
    return result;
  };
  OptionElement.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.name, other.name) && Kotlin.equals(this.kind, other.kind) && Kotlin.equals(this.value, other.value) && Kotlin.equals(this.isParenthesized, other.isParenthesized)))));
  };
  function OptionReader(reader) {
    this.reader_8be2vx$ = reader;
  }
  OptionReader.prototype.readOptions = function () {
    if (!this.reader_8be2vx$.peekChar_s8itvh$(91))
      return emptyList();
    var result = ArrayList_init();
    while (true) {
      var element = this.readOption_s8itvh$(61);
      result.add_11rb$(element);
      if (this.reader_8be2vx$.peekChar_s8itvh$(93))
        break;
      var $this = this.reader_8be2vx$;
      var condition = this.reader_8be2vx$.peekChar_s8itvh$(44);
      var location;
      location = $this.location();
      if (!condition) {
        throw $this.unexpected_emqsxh$("Expected ',' or ']", location);
      }}
    return result;
  };
  OptionReader.prototype.readOption_s8itvh$ = function (keyValueSeparator) {
    var isExtension = unboxChar(this.reader_8be2vx$.peekChar()) === 91;
    var isParenthesized = unboxChar(this.reader_8be2vx$.peekChar()) === 40;
    var name = this.reader_8be2vx$.readName();
    if (isExtension)
      name = '[' + name + ']';
    var subNames = emptyList();
    var c = unboxChar(this.reader_8be2vx$.readChar());
    if (c === 46) {
      subNames = split_0(this.reader_8be2vx$.readName(), ['.']);
      c = unboxChar(this.reader_8be2vx$.readChar());
    }if (keyValueSeparator === 58 && c === 123) {
      this.reader_8be2vx$.pushBack_s8itvh$(123);
    } else {
      var $this = this.reader_8be2vx$;
      var condition = c === keyValueSeparator;
      var location;
      location = $this.location();
      if (!condition) {
        throw $this.unexpected_emqsxh$("expected '" + String.fromCharCode(keyValueSeparator) + "' in option", location);
      }}
    var kindAndValue = this.readKindAndValue_0();
    var kind = {v: kindAndValue.kind_8be2vx$};
    var value = {v: kindAndValue.value_8be2vx$};
    var tmp$;
    tmp$ = reversed_0(subNames).iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      value.v = OptionElement$Companion_getInstance().create_ji0w9g$(element, kind.v, value.v);
      kind.v = OptionElement$Kind$OPTION_getInstance();
    }
    return OptionElement$Companion_getInstance().create_ji0w9g$(name, kind.v, value.v, isParenthesized);
  };
  OptionReader.prototype.readKindAndValue_0 = function () {
    var tmp$;
    var peeked = unboxChar(this.reader_8be2vx$.peekChar());
    switch (peeked) {
      case 123:
        return new OptionReader$KindAndValue(OptionElement$Kind$MAP_getInstance(), this.readMap_0(123, 125, 58));
      case 91:
        return new OptionReader$KindAndValue(OptionElement$Kind$LIST_getInstance(), this.readList_0());
      case 34:
      case 39:
        return new OptionReader$KindAndValue(OptionElement$Kind$STRING_getInstance(), this.reader_8be2vx$.readString());
      default:if (isDigit(peeked) || peeked === 45) {
          return new OptionReader$KindAndValue(OptionElement$Kind$NUMBER_getInstance(), this.reader_8be2vx$.readWord());
        }
        var word = this.reader_8be2vx$.readWord();
        switch (word) {
          case 'true':
            tmp$ = new OptionReader$KindAndValue(OptionElement$Kind$BOOLEAN_getInstance(), 'true');
            break;
          case 'false':
            tmp$ = new OptionReader$KindAndValue(OptionElement$Kind$BOOLEAN_getInstance(), 'false');
            break;
          default:tmp$ = new OptionReader$KindAndValue(OptionElement$Kind$ENUM_getInstance(), word);
            break;
        }

        return tmp$;
    }
  };
  OptionReader.prototype.readMap_0 = function (openBrace, closeBrace, keyValueSeparator) {
    var tmp$, tmp$_0;
    if (unboxChar(this.reader_8be2vx$.readChar()) !== openBrace)
      throw AssertionError_init();
    var result = LinkedHashMap_init();
    while (true) {
      if (this.reader_8be2vx$.peekChar_s8itvh$(closeBrace)) {
        return result;
      }var option = this.readOption_s8itvh$(keyValueSeparator);
      var name = option.name;
      var value = option.value;
      if (Kotlin.isType(value, OptionElement)) {
        var nested = Kotlin.isType(tmp$ = result.get_11rb$(name), MutableMap) ? tmp$ : null;
        if (nested == null) {
          nested = LinkedHashMap_init();
          var value_0 = nested;
          result.put_xwzc9p$(name, value_0);
        }var $receiver = nested;
        var key = value.name;
        var value_1 = value.value;
        $receiver.put_xwzc9p$(key, value_1);
      } else {
        var previous = result.get_11rb$(name);
        if (previous == null) {
          result.put_xwzc9p$(name, value);
        } else if (Kotlin.isType(previous, List)) {
          this.addToList_0(Kotlin.isType(tmp$_0 = previous, MutableList) ? tmp$_0 : throwCCE(), value);
        } else {
          var newList = ArrayList_init();
          newList.add_11rb$(previous);
          this.addToList_0(newList, value);
          result.put_xwzc9p$(name, newList);
        }
      }
      this.reader_8be2vx$.peekChar_s8itvh$(44) || this.reader_8be2vx$.peekChar_s8itvh$(59);
    }
  };
  OptionReader.prototype.addToList_0 = function (list, value) {
    var tmp$;
    if (Kotlin.isType(value, List)) {
      list.addAll_brywnq$(Kotlin.isType(tmp$ = value, Collection) ? tmp$ : throwCCE());
    } else {
      list.add_11rb$(value);
    }
  };
  OptionReader.prototype.readList_0 = function () {
    this.reader_8be2vx$.require_s8itvh$(91);
    var result = ArrayList_init();
    while (true) {
      if (this.reader_8be2vx$.peekChar_s8itvh$(93))
        return result;
      result.add_11rb$(this.readKindAndValue_0().value_8be2vx$);
      if (this.reader_8be2vx$.peekChar_s8itvh$(44))
        continue;
      var $this = this.reader_8be2vx$;
      var condition = unboxChar(this.reader_8be2vx$.peekChar()) === 93;
      var location;
      location = $this.location();
      if (!condition) {
        throw $this.unexpected_emqsxh$("expected ',' or ']'", location);
      }}
  };
  function OptionReader$KindAndValue(kind, value) {
    this.kind_8be2vx$ = kind;
    this.value_8be2vx$ = value;
  }
  OptionReader$KindAndValue.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KindAndValue',
    interfaces: []
  };
  OptionReader$KindAndValue.prototype.component1_8be2vx$ = function () {
    return this.kind_8be2vx$;
  };
  OptionReader$KindAndValue.prototype.component2_8be2vx$ = function () {
    return this.value_8be2vx$;
  };
  OptionReader$KindAndValue.prototype.copy_ywxtyd$ = function (kind, value) {
    return new OptionReader$KindAndValue(kind === void 0 ? this.kind_8be2vx$ : kind, value === void 0 ? this.value_8be2vx$ : value);
  };
  OptionReader$KindAndValue.prototype.toString = function () {
    return 'KindAndValue(kind=' + Kotlin.toString(this.kind_8be2vx$) + (', value=' + Kotlin.toString(this.value_8be2vx$)) + ')';
  };
  OptionReader$KindAndValue.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.kind_8be2vx$) | 0;
    result = result * 31 + Kotlin.hashCode(this.value_8be2vx$) | 0;
    return result;
  };
  OptionReader$KindAndValue.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.kind_8be2vx$, other.kind_8be2vx$) && Kotlin.equals(this.value_8be2vx$, other.value_8be2vx$)))));
  };
  OptionReader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OptionReader',
    interfaces: []
  };
  function ProtoFileElement(location, packageName, syntax, imports, publicImports, types, services, extendDeclarations, options) {
    ProtoFileElement$Companion_getInstance();
    if (packageName === void 0)
      packageName = null;
    if (syntax === void 0)
      syntax = null;
    if (imports === void 0)
      imports = emptyList();
    if (publicImports === void 0)
      publicImports = emptyList();
    if (types === void 0)
      types = emptyList();
    if (services === void 0)
      services = emptyList();
    if (extendDeclarations === void 0)
      extendDeclarations = emptyList();
    if (options === void 0)
      options = emptyList();
    this.location = location;
    this.packageName = packageName;
    this.syntax = syntax;
    this.imports = imports;
    this.publicImports = publicImports;
    this.types = types;
    this.services = services;
    this.extendDeclarations = extendDeclarations;
    this.options = options;
  }
  ProtoFileElement.prototype.toSchema = function () {
    var $receiver = StringBuilder_init();
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    $receiver.append_pdl1vj$('// Proto schema formatted by Wire, do not edit.\n');
    $receiver.append_pdl1vj$('// Source: ' + this.location.withPathOnly() + '\n');
    if (this.syntax != null) {
      $receiver.append_s8itvh$(10);
      $receiver.append_pdl1vj$('syntax = ' + '"' + toString(this.syntax) + '"' + ';' + '\n');
    }if (this.packageName != null) {
      $receiver.append_s8itvh$(10);
      $receiver.append_pdl1vj$('package ' + toString(this.packageName) + ';' + '\n');
    }var tmp$_5 = !this.imports.isEmpty();
    if (!tmp$_5) {
      tmp$_5 = !this.publicImports.isEmpty();
    }if (tmp$_5) {
      $receiver.append_s8itvh$(10);
      tmp$ = this.imports.iterator();
      while (tmp$.hasNext()) {
        var file = tmp$.next();
        $receiver.append_pdl1vj$('import ' + '"' + file + '"' + ';' + '\n');
      }
      tmp$_0 = this.publicImports.iterator();
      while (tmp$_0.hasNext()) {
        var file_0 = tmp$_0.next();
        $receiver.append_pdl1vj$('import public ' + '"' + file_0 + '"' + ';' + '\n');
      }
    }if (!this.options.isEmpty()) {
      $receiver.append_s8itvh$(10);
      tmp$_1 = this.options.iterator();
      while (tmp$_1.hasNext()) {
        var option = tmp$_1.next();
        $receiver.append_pdl1vj$(option.toSchemaDeclaration());
      }
    }if (!this.types.isEmpty()) {
      tmp$_2 = this.types.iterator();
      while (tmp$_2.hasNext()) {
        var typeElement = tmp$_2.next();
        $receiver.append_s8itvh$(10);
        $receiver.append_pdl1vj$(typeElement.toSchema());
      }
    }if (!this.extendDeclarations.isEmpty()) {
      tmp$_3 = this.extendDeclarations.iterator();
      while (tmp$_3.hasNext()) {
        var extendDeclaration = tmp$_3.next();
        $receiver.append_s8itvh$(10);
        $receiver.append_pdl1vj$(extendDeclaration.toSchema());
      }
    }if (!this.services.isEmpty()) {
      tmp$_4 = this.services.iterator();
      while (tmp$_4.hasNext()) {
        var service = tmp$_4.next();
        $receiver.append_s8itvh$(10);
        $receiver.append_pdl1vj$(service.toSchema());
      }
    }return $receiver.toString();
  };
  function ProtoFileElement$Companion() {
    ProtoFileElement$Companion_instance = this;
  }
  ProtoFileElement$Companion.prototype.empty_61zpoe$ = function (path) {
    return new ProtoFileElement(Location$Companion_getInstance().get_61zpoe$(path));
  };
  ProtoFileElement$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ProtoFileElement$Companion_instance = null;
  function ProtoFileElement$Companion_getInstance() {
    if (ProtoFileElement$Companion_instance === null) {
      new ProtoFileElement$Companion();
    }return ProtoFileElement$Companion_instance;
  }
  ProtoFileElement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ProtoFileElement',
    interfaces: []
  };
  ProtoFileElement.prototype.component1 = function () {
    return this.location;
  };
  ProtoFileElement.prototype.component2 = function () {
    return this.packageName;
  };
  ProtoFileElement.prototype.component3 = function () {
    return this.syntax;
  };
  ProtoFileElement.prototype.component4 = function () {
    return this.imports;
  };
  ProtoFileElement.prototype.component5 = function () {
    return this.publicImports;
  };
  ProtoFileElement.prototype.component6 = function () {
    return this.types;
  };
  ProtoFileElement.prototype.component7 = function () {
    return this.services;
  };
  ProtoFileElement.prototype.component8 = function () {
    return this.extendDeclarations;
  };
  ProtoFileElement.prototype.component9 = function () {
    return this.options;
  };
  ProtoFileElement.prototype.copy_e9wbwl$ = function (location, packageName, syntax, imports, publicImports, types, services, extendDeclarations, options) {
    return new ProtoFileElement(location === void 0 ? this.location : location, packageName === void 0 ? this.packageName : packageName, syntax === void 0 ? this.syntax : syntax, imports === void 0 ? this.imports : imports, publicImports === void 0 ? this.publicImports : publicImports, types === void 0 ? this.types : types, services === void 0 ? this.services : services, extendDeclarations === void 0 ? this.extendDeclarations : extendDeclarations, options === void 0 ? this.options : options);
  };
  ProtoFileElement.prototype.toString = function () {
    return 'ProtoFileElement(location=' + Kotlin.toString(this.location) + (', packageName=' + Kotlin.toString(this.packageName)) + (', syntax=' + Kotlin.toString(this.syntax)) + (', imports=' + Kotlin.toString(this.imports)) + (', publicImports=' + Kotlin.toString(this.publicImports)) + (', types=' + Kotlin.toString(this.types)) + (', services=' + Kotlin.toString(this.services)) + (', extendDeclarations=' + Kotlin.toString(this.extendDeclarations)) + (', options=' + Kotlin.toString(this.options)) + ')';
  };
  ProtoFileElement.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.packageName) | 0;
    result = result * 31 + Kotlin.hashCode(this.syntax) | 0;
    result = result * 31 + Kotlin.hashCode(this.imports) | 0;
    result = result * 31 + Kotlin.hashCode(this.publicImports) | 0;
    result = result * 31 + Kotlin.hashCode(this.types) | 0;
    result = result * 31 + Kotlin.hashCode(this.services) | 0;
    result = result * 31 + Kotlin.hashCode(this.extendDeclarations) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    return result;
  };
  ProtoFileElement.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.packageName, other.packageName) && Kotlin.equals(this.syntax, other.syntax) && Kotlin.equals(this.imports, other.imports) && Kotlin.equals(this.publicImports, other.publicImports) && Kotlin.equals(this.types, other.types) && Kotlin.equals(this.services, other.services) && Kotlin.equals(this.extendDeclarations, other.extendDeclarations) && Kotlin.equals(this.options, other.options)))));
  };
  function ProtoParser(location, data) {
    ProtoParser$Companion_getInstance();
    this.location_0 = location;
    this.reader_0 = new SyntaxReader(data, this.location_0);
    this.publicImports_0 = ArrayList_init();
    this.imports_0 = ArrayList_init();
    this.nestedTypes_0 = ArrayList_init();
    this.services_0 = ArrayList_init();
    this.extendsList_0 = ArrayList_init();
    this.options_0 = ArrayList_init();
    this.declarationCount_0 = 0;
    this.syntax_0 = null;
    this.packageName_0 = null;
    this.prefix_0 = '';
  }
  ProtoParser.prototype.readProtoFile = function () {
    while (true) {
      var documentation = this.reader_0.readDocumentation();
      if (this.reader_0.exhausted()) {
        return new ProtoFileElement(this.location_0, this.packageName_0, this.syntax_0, this.imports_0, this.publicImports_0, this.nestedTypes_0, this.services_0, this.extendsList_0, this.options_0);
      }var declaration = this.readDeclaration_0(documentation, ProtoParser$Context$FILE_getInstance());
      if (Kotlin.isType(declaration, TypeElement)) {
        var $receiver = this.nestedTypes_0;
        var firstOrNull$result;
        firstOrNull$break: do {
          var tmp$;
          tmp$ = $receiver.iterator();
          while (tmp$.hasNext()) {
            var element = tmp$.next();
            if (equals(element.name, declaration.name)) {
              firstOrNull$result = element;
              break firstOrNull$break;
            }}
          firstOrNull$result = null;
        }
         while (false);
        var duplicate = firstOrNull$result;
        if (duplicate != null) {
          throw IllegalStateException_init_0((declaration.name + ' (' + declaration.location + ') is already defined at ' + duplicate.location.toString()).toString());
        }this.nestedTypes_0.add_11rb$(declaration);
      } else if (Kotlin.isType(declaration, ServiceElement)) {
        var $receiver_0 = this.services_0;
        var firstOrNull$result_0;
        firstOrNull$break: do {
          var tmp$_0;
          tmp$_0 = $receiver_0.iterator();
          while (tmp$_0.hasNext()) {
            var element_0 = tmp$_0.next();
            if (equals(element_0.name, declaration.name)) {
              firstOrNull$result_0 = element_0;
              break firstOrNull$break;
            }}
          firstOrNull$result_0 = null;
        }
         while (false);
        var duplicate_0 = firstOrNull$result_0;
        if (duplicate_0 != null) {
          throw IllegalStateException_init_0((declaration.name + ' (' + declaration.location + ') is already defined at ' + duplicate_0.location.toString()).toString());
        }this.services_0.add_11rb$(declaration);
      } else if (Kotlin.isType(declaration, OptionElement))
        this.options_0.add_11rb$(declaration);
      else if (Kotlin.isType(declaration, ExtendElement))
        this.extendsList_0.add_11rb$(declaration);
    }
  };
  ProtoParser.prototype.readDeclaration_0 = function (documentation, context) {
    var tmp$, tmp$_0;
    var index = (tmp$ = this.declarationCount_0, this.declarationCount_0 = tmp$ + 1 | 0, tmp$);
    if (this.reader_0.peekChar_s8itvh$(59))
      return null;
    var location = this.reader_0.location();
    var label = this.reader_0.readWord();
    if (equals(label, 'package') && context.permitsPackage()) {
      this.packageName_0 = this.reader_0.readName();
      this.prefix_0 = toString(this.packageName_0) + '.';
      this.reader_0.require_s8itvh$(59);
      tmp$_0 = null;
    } else if (equals(label, 'import') && context.permitsImport()) {
      var importString = this.reader_0.readString();
      if (equals(importString, 'public'))
        this.publicImports_0.add_11rb$(this.reader_0.readString());
      else
        this.imports_0.add_11rb$(importString);
      this.reader_0.require_s8itvh$(59);
      tmp$_0 = null;
    } else if (equals(label, 'syntax') && context.permitsSyntax()) {
      var $this = this.reader_0;
      if (!(this.syntax_0 == null)) {
        throw $this.unexpected_emqsxh$('too many syntax definitions', location);
      }this.reader_0.require_s8itvh$(61);
      var $this_0 = this.reader_0;
      if (!(index === 0)) {
        throw $this_0.unexpected_emqsxh$("'syntax' element must be the first declaration in a file", location);
      }var syntaxString = this.reader_0.readQuotedString();
      try {
        this.syntax_0 = Syntax.Companion.get_61zpoe$(syntaxString);
      } catch (e) {
        if (Kotlin.isType(e, IllegalArgumentException)) {
          throw this.reader_0.unexpected_emqsxh$(ensureNotNull(e.message), location);
        } else
          throw e;
      }
      this.reader_0.require_s8itvh$(59);
      tmp$_0 = null;
    } else if (equals(label, 'option')) {
      var $receiver = (new OptionReader(this.reader_0)).readOption_s8itvh$(61);
      this.reader_0.require_s8itvh$(59);
      tmp$_0 = $receiver;
    } else if (equals(label, 'reserved'))
      tmp$_0 = this.readReserved_0(location, documentation);
    else if (equals(label, 'message') && context.permitsMessage())
      tmp$_0 = this.readMessage_0(location, documentation);
    else if (equals(label, 'enum') && context.permitsEnum())
      tmp$_0 = this.readEnumElement_0(location, documentation);
    else if (equals(label, 'service') && context.permitsService())
      tmp$_0 = this.readService_0(location, documentation);
    else if (equals(label, 'extend') && context.permitsExtend())
      tmp$_0 = this.readExtend_0(location, documentation);
    else if (equals(label, 'rpc') && context.permitsRpc())
      tmp$_0 = this.readRpc_0(location, documentation);
    else if (equals(label, 'oneof') && context.permitsOneOf())
      tmp$_0 = this.readOneOf_0(documentation);
    else if (equals(label, 'extensions') && context.permitsExtensions())
      tmp$_0 = this.readExtensions_0(location, documentation);
    else if (context === ProtoParser$Context$MESSAGE_getInstance() || context === ProtoParser$Context$EXTEND_getInstance())
      tmp$_0 = this.readField_0(documentation, location, label);
    else if (context === ProtoParser$Context$ENUM_getInstance())
      tmp$_0 = this.readEnumConstant_0(documentation, location, label);
    else
      throw this.reader_0.unexpected_emqsxh$('unexpected label: ' + label, location);
    return tmp$_0;
  };
  ProtoParser.prototype.readMessage_0 = function (location, documentation) {
    var name = this.reader_0.readName();
    var fields = ArrayList_init();
    var oneOfs = ArrayList_init();
    var nestedTypes = ArrayList_init();
    var extensions = ArrayList_init();
    var options = ArrayList_init();
    var reserveds = ArrayList_init();
    var groups = ArrayList_init();
    var previousPrefix = this.prefix_0;
    this.prefix_0 = this.prefix_0 + name + '.';
    this.reader_0.require_s8itvh$(123);
    while (true) {
      var nestedDocumentation = this.reader_0.readDocumentation();
      if (this.reader_0.peekChar_s8itvh$(125))
        break;
      var declared = this.readDeclaration_0(nestedDocumentation, ProtoParser$Context$MESSAGE_getInstance());
      if (Kotlin.isType(declared, FieldElement))
        fields.add_11rb$(declared);
      else if (Kotlin.isType(declared, OneOfElement))
        oneOfs.add_11rb$(declared);
      else if (Kotlin.isType(declared, GroupElement))
        groups.add_11rb$(declared);
      else if (Kotlin.isType(declared, TypeElement))
        nestedTypes.add_11rb$(declared);
      else if (Kotlin.isType(declared, ExtensionsElement))
        extensions.add_11rb$(declared);
      else if (Kotlin.isType(declared, OptionElement))
        options.add_11rb$(declared);
      else if (Kotlin.isType(declared, ExtendElement))
        this.extendsList_0.add_11rb$(declared);
      else if (Kotlin.isType(declared, ReservedElement))
        reserveds.add_11rb$(declared);
    }
    this.prefix_0 = previousPrefix;
    return new MessageElement(location, name, documentation, nestedTypes, options, reserveds, fields, oneOfs, extensions, groups);
  };
  ProtoParser.prototype.readExtend_0 = function (location, documentation) {
    var name = this.reader_0.readName();
    var fields = ArrayList_init();
    this.reader_0.require_s8itvh$(123);
    while (true) {
      var nestedDocumentation = this.reader_0.readDocumentation();
      if (this.reader_0.peekChar_s8itvh$(125))
        break;
      var declared = this.readDeclaration_0(nestedDocumentation, ProtoParser$Context$EXTEND_getInstance());
      if (Kotlin.isType(declared, FieldElement))
        fields.add_11rb$(declared);
    }
    return new ExtendElement(location, name, documentation, fields);
  };
  ProtoParser.prototype.readService_0 = function (location, documentation) {
    var name = this.reader_0.readName();
    var rpcs = ArrayList_init();
    var options = ArrayList_init();
    this.reader_0.require_s8itvh$(123);
    while (true) {
      var rpcDocumentation = this.reader_0.readDocumentation();
      if (this.reader_0.peekChar_s8itvh$(125))
        break;
      var declared = this.readDeclaration_0(rpcDocumentation, ProtoParser$Context$SERVICE_getInstance());
      if (Kotlin.isType(declared, RpcElement))
        rpcs.add_11rb$(declared);
      else if (Kotlin.isType(declared, OptionElement))
        options.add_11rb$(declared);
    }
    return new ServiceElement(location, name, documentation, rpcs, options);
  };
  ProtoParser.prototype.readEnumElement_0 = function (location, documentation) {
    var name = this.reader_0.readName();
    var constants = ArrayList_init();
    var options = ArrayList_init();
    this.reader_0.require_s8itvh$(123);
    while (true) {
      var valueDocumentation = this.reader_0.readDocumentation();
      if (this.reader_0.peekChar_s8itvh$(125))
        break;
      var declared = this.readDeclaration_0(valueDocumentation, ProtoParser$Context$ENUM_getInstance());
      if (Kotlin.isType(declared, EnumConstantElement))
        constants.add_11rb$(declared);
      else if (Kotlin.isType(declared, OptionElement))
        options.add_11rb$(declared);
    }
    return new EnumElement(location, name, documentation, options, constants);
  };
  ProtoParser.prototype.readField_0 = function (documentation, location, word) {
    var tmp$;
    var label;
    var type;
    switch (word) {
      case 'required':
        var $this = this.reader_0;
        if (!!equals(this.syntax_0, Syntax.PROTO_3)) {
          throw $this.unexpected_emqsxh$("'required' label forbidden in proto3 field declarations", location);
        }
        label = Field$Label$REQUIRED_getInstance();
        type = this.reader_0.readDataType();
        break;
      case 'optional':
        label = Field$Label$OPTIONAL_getInstance();
        type = this.reader_0.readDataType();
        break;
      case 'repeated':
        label = Field$Label$REPEATED_getInstance();
        type = this.reader_0.readDataType();
        break;
      default:var $this_0 = this.reader_0;
        if (!(equals(this.syntax_0, Syntax.PROTO_3) || (equals(word, 'map') && unboxChar(this.reader_0.peekChar()) === 60))) {
          throw $this_0.unexpected_emqsxh$('unexpected label: ' + word, location);
        }
        label = null;
        type = this.reader_0.readDataType_61zpoe$(word);
        break;
    }
    var $this_1 = this.reader_0;
    if (!(!startsWith(type, 'map<') || label == null)) {
      throw $this_1.unexpected_emqsxh$("'map' type cannot have label", location);
    }if (equals(type, 'group'))
      tmp$ = this.readGroup_0(location, documentation, label);
    else
      tmp$ = this.readField_1(location, documentation, label, type);
    return tmp$;
  };
  ProtoParser.prototype.readField_1 = function (location, documentation, label, type) {
    var documentation_0 = documentation;
    var name = this.reader_0.readName();
    this.reader_0.require_s8itvh$(61);
    var tag = this.reader_0.readInt();
    var options = toMutableList((new OptionReader(this.reader_0)).readOptions());
    var defaultValue = this.stripDefault_0(options);
    var jsonName = this.stripJsonName_0(options);
    this.reader_0.require_s8itvh$(59);
    documentation_0 = this.reader_0.tryAppendTrailingDocumentation_61zpoe$(documentation_0);
    return new FieldElement(location, label, type, name, defaultValue, jsonName, tag, documentation_0, toList(options));
  };
  ProtoParser.prototype.stripDefault_0 = function (options) {
    return this.stripValue_0('default', options);
  };
  ProtoParser.prototype.stripJsonName_0 = function (options) {
    return this.stripValue_0('json_name', options);
  };
  ProtoParser.prototype.stripValue_0 = function (name, options) {
    var result = null;
    var i = options.iterator();
    while (i.hasNext()) {
      var element = i.next();
      if (equals(element.name, name)) {
        i.remove();
        result = element.value.toString();
      }}
    return result;
  };
  ProtoParser.prototype.readOneOf_0 = function (documentation) {
    var name = this.reader_0.readName();
    var fields = ArrayList_init();
    var groups = ArrayList_init();
    var options = ArrayList_init();
    this.reader_0.require_s8itvh$(123);
    while (true) {
      var nestedDocumentation = this.reader_0.readDocumentation();
      if (this.reader_0.peekChar_s8itvh$(125))
        break;
      var location = this.reader_0.location();
      var type = this.reader_0.readDataType();
      switch (type) {
        case 'group':
          groups.add_11rb$(this.readGroup_0(location, nestedDocumentation, null));
          break;
        case 'option':
          options.add_11rb$((new OptionReader(this.reader_0)).readOption_s8itvh$(61));
          this.reader_0.require_s8itvh$(59);
          break;
        default:fields.add_11rb$(this.readField_1(location, nestedDocumentation, null, type));
          break;
      }
    }
    return new OneOfElement(name, documentation, fields, groups, options);
  };
  ProtoParser.prototype.readGroup_0 = function (location, documentation, label) {
    var name = this.reader_0.readWord();
    this.reader_0.require_s8itvh$(61);
    var tag = this.reader_0.readInt();
    var fields = ArrayList_init();
    this.reader_0.require_s8itvh$(123);
    while (true) {
      var nestedDocumentation = this.reader_0.readDocumentation();
      if (this.reader_0.peekChar_s8itvh$(125))
        break;
      var fieldLocation = this.reader_0.location();
      var fieldLabel = this.reader_0.readWord();
      var field = this.readField_0(nestedDocumentation, fieldLocation, fieldLabel);
      if (Kotlin.isType(field, FieldElement))
        fields.add_11rb$(field);
      else
        throw this.reader_0.unexpected_emqsxh$('expected field declaration, was ' + field.toString());
    }
    return new GroupElement(label, location, name, tag, documentation, fields);
  };
  ProtoParser.prototype.readReserved_0 = function (location, documentation) {
    var documentation_0 = documentation;
    var values = ArrayList_init();
    loop: while (true) {
      switch (unboxChar(this.reader_0.peekChar())) {
        case 34:
        case 39:
          values.add_11rb$(this.reader_0.readQuotedString());
          break;
        default:var tagStart = this.reader_0.readInt();
          switch (unboxChar(this.reader_0.peekChar())) {
            case 44:
            case 59:
              values.add_11rb$(tagStart);
              break;
            default:var $this = this.reader_0;
              if (!equals(this.reader_0.readWord(), 'to')) {
                throw $this.unexpected_emqsxh$("expected ',', ';', or 'to'", location);
              }
              var tagEnd = this.reader_0.readInt();
              values.add_11rb$(new IntRange(tagStart, tagEnd));
              break;
          }

          break;
      }
      switch (unboxChar(this.reader_0.readChar())) {
        case 59:
          break loop;
        case 44:
          continue loop;
        default:throw this.reader_0.unexpected_emqsxh$("expected ',' or ';'");
      }
    }
    var tmp$ = this.reader_0;
    if (!!values.isEmpty()) {
      throw tmp$.unexpected_emqsxh$("'reserved' must have at least one field name or tag", location);
    }documentation_0 = this.reader_0.tryAppendTrailingDocumentation_61zpoe$(documentation_0);
    return new ReservedElement(location, documentation_0, values);
  };
  ProtoParser.prototype.readExtensions_0 = function (location, documentation) {
    var tmp$;
    var values = ArrayList_init();
    loop: while (true) {
      var start = this.reader_0.readInt();
      switch (unboxChar(this.reader_0.peekChar())) {
        case 44:
        case 59:
          values.add_11rb$(start);
          break;
        default:var $this = this.reader_0;
          if (!equals(this.reader_0.readWord(), 'to')) {
            throw $this.unexpected_emqsxh$("expected ',', ';' or 'to'", location);
          }
          var s = this.reader_0.readWord();
          if (equals(s, 'max'))
            tmp$ = 536870911;
          else
            tmp$ = toInt(s);
          var end = tmp$;
          values.add_11rb$(new IntRange(start, end));
          break;
      }
      switch (unboxChar(this.reader_0.readChar())) {
        case 59:
          break loop;
        case 44:
          continue loop;
        default:throw this.reader_0.unexpected_emqsxh$("expected ',' or ';'");
      }
    }
    return new ExtensionsElement(location, documentation, values);
  };
  ProtoParser.prototype.readEnumConstant_0 = function (documentation, location, label) {
    var documentation_0 = documentation;
    this.reader_0.require_s8itvh$(61);
    var tag = this.reader_0.readInt();
    var options = (new OptionReader(this.reader_0)).readOptions();
    this.reader_0.require_s8itvh$(59);
    documentation_0 = this.reader_0.tryAppendTrailingDocumentation_61zpoe$(documentation_0);
    return new EnumConstantElement(location, label, tag, documentation_0, options);
  };
  ProtoParser.prototype.readRpc_0 = function (location, documentation) {
    var tmp$, tmp$_0;
    var name = this.reader_0.readName();
    this.reader_0.require_s8itvh$(40);
    var requestStreaming = {v: false};
    var word = this.reader_0.readWord();
    if (equals(word, 'stream')) {
      var $receiver = this.reader_0.readDataType();
      requestStreaming.v = true;
      tmp$ = $receiver;
    } else
      tmp$ = this.reader_0.readDataType_61zpoe$(word);
    var requestType = tmp$;
    this.reader_0.require_s8itvh$(41);
    var $this = this.reader_0;
    if (!equals(this.reader_0.readWord(), 'returns')) {
      throw $this.unexpected_emqsxh$("expected 'returns'", location);
    }this.reader_0.require_s8itvh$(40);
    var responseStreaming = {v: false};
    var word_0 = this.reader_0.readWord();
    if (equals(word_0, 'stream')) {
      var $receiver_0 = this.reader_0.readDataType();
      responseStreaming.v = true;
      tmp$_0 = $receiver_0;
    } else
      tmp$_0 = this.reader_0.readDataType_61zpoe$(word_0);
    var responseType = tmp$_0;
    this.reader_0.require_s8itvh$(41);
    var options = ArrayList_init();
    if (this.reader_0.peekChar_s8itvh$(123)) {
      while (true) {
        var rpcDocumentation = this.reader_0.readDocumentation();
        if (this.reader_0.peekChar_s8itvh$(125))
          break;
        var declared = this.readDeclaration_0(rpcDocumentation, ProtoParser$Context$RPC_getInstance());
        if (Kotlin.isType(declared, OptionElement))
          options.add_11rb$(declared);
      }
    } else {
      this.reader_0.require_s8itvh$(59);
    }
    return new RpcElement(location, name, documentation, requestType, responseType, requestStreaming.v, responseStreaming.v, options);
  };
  function ProtoParser$Context(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function ProtoParser$Context_initFields() {
    ProtoParser$Context_initFields = function () {
    };
    ProtoParser$Context$FILE_instance = new ProtoParser$Context('FILE', 0);
    ProtoParser$Context$MESSAGE_instance = new ProtoParser$Context('MESSAGE', 1);
    ProtoParser$Context$ENUM_instance = new ProtoParser$Context('ENUM', 2);
    ProtoParser$Context$RPC_instance = new ProtoParser$Context('RPC', 3);
    ProtoParser$Context$EXTEND_instance = new ProtoParser$Context('EXTEND', 4);
    ProtoParser$Context$SERVICE_instance = new ProtoParser$Context('SERVICE', 5);
  }
  var ProtoParser$Context$FILE_instance;
  function ProtoParser$Context$FILE_getInstance() {
    ProtoParser$Context_initFields();
    return ProtoParser$Context$FILE_instance;
  }
  var ProtoParser$Context$MESSAGE_instance;
  function ProtoParser$Context$MESSAGE_getInstance() {
    ProtoParser$Context_initFields();
    return ProtoParser$Context$MESSAGE_instance;
  }
  var ProtoParser$Context$ENUM_instance;
  function ProtoParser$Context$ENUM_getInstance() {
    ProtoParser$Context_initFields();
    return ProtoParser$Context$ENUM_instance;
  }
  var ProtoParser$Context$RPC_instance;
  function ProtoParser$Context$RPC_getInstance() {
    ProtoParser$Context_initFields();
    return ProtoParser$Context$RPC_instance;
  }
  var ProtoParser$Context$EXTEND_instance;
  function ProtoParser$Context$EXTEND_getInstance() {
    ProtoParser$Context_initFields();
    return ProtoParser$Context$EXTEND_instance;
  }
  var ProtoParser$Context$SERVICE_instance;
  function ProtoParser$Context$SERVICE_getInstance() {
    ProtoParser$Context_initFields();
    return ProtoParser$Context$SERVICE_instance;
  }
  ProtoParser$Context.prototype.permitsPackage = function () {
    return this === ProtoParser$Context$FILE_getInstance();
  };
  ProtoParser$Context.prototype.permitsSyntax = function () {
    return this === ProtoParser$Context$FILE_getInstance();
  };
  ProtoParser$Context.prototype.permitsImport = function () {
    return this === ProtoParser$Context$FILE_getInstance();
  };
  ProtoParser$Context.prototype.permitsExtensions = function () {
    return this === ProtoParser$Context$MESSAGE_getInstance();
  };
  ProtoParser$Context.prototype.permitsRpc = function () {
    return this === ProtoParser$Context$SERVICE_getInstance();
  };
  ProtoParser$Context.prototype.permitsOneOf = function () {
    return this === ProtoParser$Context$MESSAGE_getInstance();
  };
  ProtoParser$Context.prototype.permitsMessage = function () {
    return this === ProtoParser$Context$FILE_getInstance() || this === ProtoParser$Context$MESSAGE_getInstance();
  };
  ProtoParser$Context.prototype.permitsService = function () {
    return this === ProtoParser$Context$FILE_getInstance();
  };
  ProtoParser$Context.prototype.permitsEnum = function () {
    return this === ProtoParser$Context$FILE_getInstance() || this === ProtoParser$Context$MESSAGE_getInstance();
  };
  ProtoParser$Context.prototype.permitsExtend = function () {
    return this === ProtoParser$Context$FILE_getInstance() || this === ProtoParser$Context$MESSAGE_getInstance();
  };
  ProtoParser$Context.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Context',
    interfaces: [Enum]
  };
  function ProtoParser$Context$values() {
    return [ProtoParser$Context$FILE_getInstance(), ProtoParser$Context$MESSAGE_getInstance(), ProtoParser$Context$ENUM_getInstance(), ProtoParser$Context$RPC_getInstance(), ProtoParser$Context$EXTEND_getInstance(), ProtoParser$Context$SERVICE_getInstance()];
  }
  ProtoParser$Context.values = ProtoParser$Context$values;
  function ProtoParser$Context$valueOf(name) {
    switch (name) {
      case 'FILE':
        return ProtoParser$Context$FILE_getInstance();
      case 'MESSAGE':
        return ProtoParser$Context$MESSAGE_getInstance();
      case 'ENUM':
        return ProtoParser$Context$ENUM_getInstance();
      case 'RPC':
        return ProtoParser$Context$RPC_getInstance();
      case 'EXTEND':
        return ProtoParser$Context$EXTEND_getInstance();
      case 'SERVICE':
        return ProtoParser$Context$SERVICE_getInstance();
      default:throwISE('No enum constant com.squareup.wire.schema.internal.parser.ProtoParser.Context.' + name);
    }
  }
  ProtoParser$Context.valueOf_61zpoe$ = ProtoParser$Context$valueOf;
  function ProtoParser$Companion() {
    ProtoParser$Companion_instance = this;
  }
  ProtoParser$Companion.prototype.parse_liszf0$ = function (location, data) {
    var size = data.length;
    var init = getCallableRef('get', function ($receiver, p1) {
      return toBoxedChar($receiver.charCodeAt(p1));
    }.bind(null, data));
    var tmp$;
    var array = charArray(size, null);
    tmp$ = array.length - 1 | 0;
    for (var i = 0; i <= tmp$; i++) {
      var value = unboxChar(init(i));
      array[i] = value;
    }
    var chars = array;
    return (new ProtoParser(location, chars)).readProtoFile();
  };
  ProtoParser$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ProtoParser$Companion_instance = null;
  function ProtoParser$Companion_getInstance() {
    if (ProtoParser$Companion_instance === null) {
      new ProtoParser$Companion();
    }return ProtoParser$Companion_instance;
  }
  ProtoParser.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ProtoParser',
    interfaces: []
  };
  function ReservedElement(location, documentation, values) {
    if (documentation === void 0)
      documentation = '';
    this.location = location;
    this.documentation = documentation;
    this.values = values;
  }
  ReservedElement.prototype.toSchema = function () {
    var $receiver = StringBuilder_init();
    appendDocumentation($receiver, this.documentation);
    $receiver.append_pdl1vj$('reserved ');
    var tmp$, tmp$_0;
    var index = 0;
    tmp$ = this.values.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      if (checkIndexOverflow((tmp$_0 = index, index = tmp$_0 + 1 | 0, tmp$_0)) > 0)
        $receiver.append_pdl1vj$(', ');
      if (typeof item === 'string')
        $receiver.append_pdl1vj$('"' + item.toString() + '"');
      else if (typeof item === 'number')
        $receiver.append_s8jyv4$(item);
      else if (Kotlin.isType(item, IntRange))
        $receiver.append_pdl1vj$(item.first.toString() + ' to ' + item.last);
      else
        throw AssertionError_init();
    }
    $receiver.append_pdl1vj$(';\n');
    return $receiver.toString();
  };
  ReservedElement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ReservedElement',
    interfaces: []
  };
  ReservedElement.prototype.component1 = function () {
    return this.location;
  };
  ReservedElement.prototype.component2 = function () {
    return this.documentation;
  };
  ReservedElement.prototype.component3 = function () {
    return this.values;
  };
  ReservedElement.prototype.copy_hncgv0$ = function (location, documentation, values) {
    return new ReservedElement(location === void 0 ? this.location : location, documentation === void 0 ? this.documentation : documentation, values === void 0 ? this.values : values);
  };
  ReservedElement.prototype.toString = function () {
    return 'ReservedElement(location=' + Kotlin.toString(this.location) + (', documentation=' + Kotlin.toString(this.documentation)) + (', values=' + Kotlin.toString(this.values)) + ')';
  };
  ReservedElement.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.values) | 0;
    return result;
  };
  ReservedElement.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.values, other.values)))));
  };
  function RpcElement(location, name, documentation, requestType, responseType, requestStreaming, responseStreaming, options) {
    if (documentation === void 0)
      documentation = '';
    if (requestStreaming === void 0)
      requestStreaming = false;
    if (responseStreaming === void 0)
      responseStreaming = false;
    if (options === void 0)
      options = emptyList();
    this.location = location;
    this.name = name;
    this.documentation = documentation;
    this.requestType = requestType;
    this.responseType = responseType;
    this.requestStreaming = requestStreaming;
    this.responseStreaming = responseStreaming;
    this.options = options;
  }
  RpcElement.prototype.toSchema = function () {
    var $receiver = StringBuilder_init();
    var tmp$;
    appendDocumentation($receiver, this.documentation);
    $receiver.append_pdl1vj$('rpc ' + this.name + ' (');
    if (this.requestStreaming) {
      $receiver.append_pdl1vj$('stream ');
    }$receiver.append_pdl1vj$(this.requestType + ') returns (');
    if (this.responseStreaming) {
      $receiver.append_pdl1vj$('stream ');
    }$receiver.append_pdl1vj$(this.responseType + ')');
    if (!this.options.isEmpty()) {
      $receiver.append_pdl1vj$(' {\n');
      tmp$ = this.options.iterator();
      while (tmp$.hasNext()) {
        var option = tmp$.next();
        appendIndented($receiver, option.toSchemaDeclaration());
      }
      $receiver.append_s8itvh$(125);
    }$receiver.append_pdl1vj$(';\n');
    return $receiver.toString();
  };
  RpcElement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RpcElement',
    interfaces: []
  };
  RpcElement.prototype.component1 = function () {
    return this.location;
  };
  RpcElement.prototype.component2 = function () {
    return this.name;
  };
  RpcElement.prototype.component3 = function () {
    return this.documentation;
  };
  RpcElement.prototype.component4 = function () {
    return this.requestType;
  };
  RpcElement.prototype.component5 = function () {
    return this.responseType;
  };
  RpcElement.prototype.component6 = function () {
    return this.requestStreaming;
  };
  RpcElement.prototype.component7 = function () {
    return this.responseStreaming;
  };
  RpcElement.prototype.component8 = function () {
    return this.options;
  };
  RpcElement.prototype.copy_yj2fwx$ = function (location, name, documentation, requestType, responseType, requestStreaming, responseStreaming, options) {
    return new RpcElement(location === void 0 ? this.location : location, name === void 0 ? this.name : name, documentation === void 0 ? this.documentation : documentation, requestType === void 0 ? this.requestType : requestType, responseType === void 0 ? this.responseType : responseType, requestStreaming === void 0 ? this.requestStreaming : requestStreaming, responseStreaming === void 0 ? this.responseStreaming : responseStreaming, options === void 0 ? this.options : options);
  };
  RpcElement.prototype.toString = function () {
    return 'RpcElement(location=' + Kotlin.toString(this.location) + (', name=' + Kotlin.toString(this.name)) + (', documentation=' + Kotlin.toString(this.documentation)) + (', requestType=' + Kotlin.toString(this.requestType)) + (', responseType=' + Kotlin.toString(this.responseType)) + (', requestStreaming=' + Kotlin.toString(this.requestStreaming)) + (', responseStreaming=' + Kotlin.toString(this.responseStreaming)) + (', options=' + Kotlin.toString(this.options)) + ')';
  };
  RpcElement.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.requestType) | 0;
    result = result * 31 + Kotlin.hashCode(this.responseType) | 0;
    result = result * 31 + Kotlin.hashCode(this.requestStreaming) | 0;
    result = result * 31 + Kotlin.hashCode(this.responseStreaming) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    return result;
  };
  RpcElement.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.requestType, other.requestType) && Kotlin.equals(this.responseType, other.responseType) && Kotlin.equals(this.requestStreaming, other.requestStreaming) && Kotlin.equals(this.responseStreaming, other.responseStreaming) && Kotlin.equals(this.options, other.options)))));
  };
  function ServiceElement(location, name, documentation, rpcs, options) {
    if (documentation === void 0)
      documentation = '';
    if (rpcs === void 0)
      rpcs = emptyList();
    if (options === void 0)
      options = emptyList();
    this.location = location;
    this.name = name;
    this.documentation = documentation;
    this.rpcs = rpcs;
    this.options = options;
  }
  ServiceElement.prototype.toSchema = function () {
    var $receiver = StringBuilder_init();
    var tmp$, tmp$_0;
    appendDocumentation($receiver, this.documentation);
    $receiver.append_pdl1vj$('service ' + this.name + ' {');
    if (!this.options.isEmpty()) {
      $receiver.append_s8itvh$(10);
      tmp$ = this.options.iterator();
      while (tmp$.hasNext()) {
        var option = tmp$.next();
        appendIndented($receiver, option.toSchemaDeclaration());
      }
    }if (!this.rpcs.isEmpty()) {
      $receiver.append_s8itvh$(10);
      tmp$_0 = this.rpcs.iterator();
      while (tmp$_0.hasNext()) {
        var rpc = tmp$_0.next();
        appendIndented($receiver, rpc.toSchema());
      }
    }$receiver.append_pdl1vj$('}\n');
    return $receiver.toString();
  };
  ServiceElement.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ServiceElement',
    interfaces: []
  };
  ServiceElement.prototype.component1 = function () {
    return this.location;
  };
  ServiceElement.prototype.component2 = function () {
    return this.name;
  };
  ServiceElement.prototype.component3 = function () {
    return this.documentation;
  };
  ServiceElement.prototype.component4 = function () {
    return this.rpcs;
  };
  ServiceElement.prototype.component5 = function () {
    return this.options;
  };
  ServiceElement.prototype.copy_a4bj0u$ = function (location, name, documentation, rpcs, options) {
    return new ServiceElement(location === void 0 ? this.location : location, name === void 0 ? this.name : name, documentation === void 0 ? this.documentation : documentation, rpcs === void 0 ? this.rpcs : rpcs, options === void 0 ? this.options : options);
  };
  ServiceElement.prototype.toString = function () {
    return 'ServiceElement(location=' + Kotlin.toString(this.location) + (', name=' + Kotlin.toString(this.name)) + (', documentation=' + Kotlin.toString(this.documentation)) + (', rpcs=' + Kotlin.toString(this.rpcs)) + (', options=' + Kotlin.toString(this.options)) + ')';
  };
  ServiceElement.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.documentation) | 0;
    result = result * 31 + Kotlin.hashCode(this.rpcs) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    return result;
  };
  ServiceElement.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.location, other.location) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.documentation, other.documentation) && Kotlin.equals(this.rpcs, other.rpcs) && Kotlin.equals(this.options, other.options)))));
  };
  function SyntaxReader(data, location) {
    this.data_0 = data;
    this.location_0 = location;
    this.pos_0 = 0;
    this.line_0 = 0;
    this.lineStart_0 = 0;
  }
  SyntaxReader.prototype.exhausted = function () {
    return this.pos_0 === this.data_0.length;
  };
  SyntaxReader.prototype.readChar = function () {
    var $receiver = this.peekChar();
    this.pos_0 = this.pos_0 + 1 | 0;
    return $receiver;
  };
  SyntaxReader.prototype.require_s8itvh$ = function (c) {
    var condition = unboxChar(this.readChar()) === c;
    var location;
    location = this.location();
    if (!condition) {
      throw this.unexpected_emqsxh$("expected '" + String.fromCharCode(c) + "'", location);
    }};
  SyntaxReader.prototype.peekChar = function () {
    this.skipWhitespace_0(true);
    var condition = this.pos_0 < this.data_0.length;
    var location;
    location = this.location();
    if (!condition) {
      throw this.unexpected_emqsxh$('unexpected end of file', location);
    }return toBoxedChar(this.data_0[this.pos_0]);
  };
  SyntaxReader.prototype.peekChar_s8itvh$ = function (c) {
    var tmp$;
    if (unboxChar(this.peekChar()) === c) {
      this.pos_0 = this.pos_0 + 1 | 0;
      tmp$ = true;
    } else
      tmp$ = false;
    return tmp$;
  };
  SyntaxReader.prototype.pushBack_s8itvh$ = function (c) {
    if (!(this.data_0[this.pos_0 - 1 | 0] === c)) {
      var message = 'Failed requirement.';
      throw IllegalArgumentException_init(message.toString());
    }this.pos_0 = this.pos_0 - 1 | 0;
  };
  SyntaxReader.prototype.readString = function () {
    var tmp$;
    this.skipWhitespace_0(true);
    switch (unboxChar(this.peekChar())) {
      case 34:
      case 39:
        tmp$ = this.readQuotedString();
        break;
      default:tmp$ = this.readWord();
        break;
    }
    return tmp$;
  };
  SyntaxReader.prototype.readQuotedString = function () {
    var tmp$, tmp$_0;
    var startQuote = unboxChar(this.readChar());
    if (!(startQuote === 34 || startQuote === 39)) {
      var message = 'Check failed.';
      throw IllegalStateException_init_0(message.toString());
    }var result = StringBuilder_init();
    while (this.pos_0 < this.data_0.length) {
      var c = this.data_0[tmp$ = this.pos_0, this.pos_0 = tmp$ + 1 | 0, tmp$];
      if (c === startQuote) {
        if (unboxChar(this.peekChar()) === 34 || unboxChar(this.peekChar()) === 39) {
          startQuote = unboxChar(this.readChar());
          continue;
        }return result.toString();
      }if (c === 92) {
        var condition = this.pos_0 < this.data_0.length;
        var location;
        location = this.location();
        if (!condition) {
          throw this.unexpected_emqsxh$('unexpected end of file', location);
        }c = this.data_0[tmp$_0 = this.pos_0, this.pos_0 = tmp$_0 + 1 | 0, tmp$_0];
        switch (c) {
          case 97:
            c = 7;
            break;
          case 98:
            c = 8;
            break;
          case 102:
            c = 12;
            break;
          case 110:
            c = 10;
            break;
          case 114:
            c = 13;
            break;
          case 116:
            c = 9;
            break;
          case 118:
            c = 11;
            break;
          case 120:
          case 88:
            c = this.readNumericEscape_0(16, 2);
            break;
          case 48:
          case 49:
          case 50:
          case 51:
          case 52:
          case 53:
          case 54:
          case 55:
            this.pos_0 = this.pos_0 - 1 | 0;
            c = this.readNumericEscape_0(8, 3);
            break;
        }
      }result.append_s8itvh$(c);
      if (c === 10)
        this.newline_0();
    }
    throw this.unexpected_emqsxh$('unterminated string');
  };
  SyntaxReader.prototype.readNumericEscape_0 = function (radix, len) {
    var tmp$;
    var value = -1;
    var a = this.pos_0 + len | 0;
    var b = this.data_0.length;
    var endPos = Math_0.min(a, b);
    while (this.pos_0 < endPos) {
      var digit = this.hexDigit_0(this.data_0[this.pos_0]);
      if (digit === -1 || digit >= radix)
        break;
      if (value < 0)
        tmp$ = digit;
      else
        tmp$ = Kotlin.imul(value, radix) + digit | 0;
      value = tmp$;
      this.pos_0 = this.pos_0 + 1 | 0;
    }
    var condition = value >= 0;
    var location;
    location = this.location();
    if (!condition) {
      throw this.unexpected_emqsxh$('expected a digit after \\x or \\X', location);
    }return toChar(value);
  };
  SyntaxReader.prototype.hexDigit_0 = function (c) {
    var tmp$;
    if ((new CharRange(48, 57)).contains_mef7kx$(c))
      tmp$ = c - 48;
    else if ((new CharRange(97, 102)).contains_mef7kx$(c))
      tmp$ = c - 97 + 10 | 0;
    else if ((new CharRange(65, 70)).contains_mef7kx$(c))
      tmp$ = c - 65 + 10 | 0;
    else
      tmp$ = -1;
    return tmp$;
  };
  SyntaxReader.prototype.readName = function () {
    var tmp$;
    switch (unboxChar(this.peekChar())) {
      case 40:
        this.pos_0 = this.pos_0 + 1 | 0;
        var $receiver = this.readWord();
        var condition = unboxChar(this.readChar()) === 41;
        var location;
        location = this.location();
        if (!condition) {
          throw this.unexpected_emqsxh$("expected ')'", location);
        }
        tmp$ = $receiver;
        break;
      case 91:
        this.pos_0 = this.pos_0 + 1 | 0;
        var $receiver_0 = this.readWord();
        var condition_0 = unboxChar(this.readChar()) === 93;
        var location_0;
        location_0 = this.location();
        if (!condition_0) {
          throw this.unexpected_emqsxh$("expected ']'", location_0);
        }
        tmp$ = $receiver_0;
        break;
      default:tmp$ = this.readWord();
        break;
    }
    return tmp$;
  };
  SyntaxReader.prototype.readDataType = function () {
    var name = this.readWord();
    return this.readDataType_61zpoe$(name);
  };
  SyntaxReader.prototype.readDataType_61zpoe$ = function (name) {
    var tmp$;
    if (equals(name, 'map')) {
      var condition = unboxChar(this.readChar()) === 60;
      var location;
      location = this.location();
      if (!condition) {
        throw this.unexpected_emqsxh$("expected '<'", location);
      }var keyType = this.readDataType();
      var condition_0 = unboxChar(this.readChar()) === 44;
      var location_0;
      location_0 = this.location();
      if (!condition_0) {
        throw this.unexpected_emqsxh$("expected ','", location_0);
      }var valueType = this.readDataType();
      var condition_1 = unboxChar(this.readChar()) === 62;
      var location_1;
      location_1 = this.location();
      if (!condition_1) {
        throw this.unexpected_emqsxh$("expected '>'", location_1);
      }tmp$ = 'map<' + keyType + ', ' + valueType + '>';
    } else
      tmp$ = name;
    return tmp$;
  };
  SyntaxReader.prototype.readWord = function () {
    var tmp$;
    this.skipWhitespace_0(true);
    var start = this.pos_0;
    loop: while (this.pos_0 < this.data_0.length) {
      tmp$ = this.data_0[this.pos_0];
      if ((new CharRange(97, 122)).contains_mef7kx$(tmp$) || (new CharRange(65, 90)).contains_mef7kx$(tmp$) || (new CharRange(48, 57)).contains_mef7kx$(tmp$) || tmp$ === 95 || tmp$ === 45 || tmp$ === 46) {
        this.pos_0 = this.pos_0 + 1 | 0;
      } else
        break loop;
    }
    var condition = start < this.pos_0;
    var location;
    location = this.location();
    if (!condition) {
      throw this.unexpected_emqsxh$('expected a word', location);
    }return String_0(this.data_0, start, this.pos_0 - start | 0);
  };
  SyntaxReader.prototype.readInt = function () {
    var tag = this.readWord();
    try {
      var radix = 10;
      if (startsWith(tag, '0x') || startsWith(tag, '0X')) {
        tag = tag.substring(2);
        radix = 16;
      }return toInt_0(tag, radix);
    } catch (_) {
      if (Kotlin.isType(_, Exception)) {
        throw this.unexpected_emqsxh$('expected an integer but was ' + tag);
      } else
        throw _;
    }
  };
  SyntaxReader.prototype.readDocumentation = function () {
    var tmp$;
    var result = null;
    while (true) {
      this.skipWhitespace_0(false);
      if (this.pos_0 === this.data_0.length || this.data_0[this.pos_0] !== 47)
        return result != null ? result : '';
      var comment = this.readComment_0();
      if (result == null)
        tmp$ = comment;
      else
        tmp$ = toString(result) + '\n' + comment;
      result = tmp$;
    }
  };
  SyntaxReader.prototype.readComment_0 = function () {
    var tmp$, tmp$_0, tmp$_1;
    if (!(this.pos_0 !== this.data_0.length && this.data_0[this.pos_0] === 47)) {
      var message = 'Check failed.';
      throw IllegalStateException_init_0(message.toString());
    }this.pos_0 = this.pos_0 + 1 | 0;
    if (this.pos_0 < this.data_0.length) {
      tmp$_0 = this.data_0[tmp$ = this.pos_0, this.pos_0 = tmp$ + 1 | 0, tmp$] | 0;
    } else
      tmp$_0 = -1;
    switch (tmp$_0) {
      case 42:
        var result = StringBuilder_init();
        var startOfLine = true;
        while ((this.pos_0 + 1 | 0) < this.data_0.length) {
          var c = this.data_0[this.pos_0];
          if (c === 42 && this.data_0[this.pos_0 + 1 | 0] === 47) {
            this.pos_0 = this.pos_0 + 2 | 0;
            var $receiver = result.toString();
            var tmp$_2;
            return trim(Kotlin.isCharSequence(tmp$_2 = $receiver) ? tmp$_2 : throwCCE()).toString();
          } else if (c === 10) {
            result.append_s8itvh$(10);
            this.newline_0();
            startOfLine = true;
          } else if (!startOfLine)
            result.append_s8itvh$(c);
          else if (c === 42) {
            if (this.data_0[this.pos_0 + 1 | 0] === 32) {
              this.pos_0 = this.pos_0 + 1 | 0;
            }startOfLine = false;
          } else if (!isWhitespace(c)) {
            result.append_s8itvh$(c);
            startOfLine = false;
          }this.pos_0 = this.pos_0 + 1 | 0;
        }

        throw this.unexpected_emqsxh$('unterminated comment');
      case 47:
        if (this.pos_0 < this.data_0.length && this.data_0[this.pos_0] === 32) {
          this.pos_0 = this.pos_0 + 1 | 0;
        }
        var start = this.pos_0;
        while (this.pos_0 < this.data_0.length) {
          var c_0 = this.data_0[tmp$_1 = this.pos_0, this.pos_0 = tmp$_1 + 1 | 0, tmp$_1];
          if (c_0 === 10) {
            this.newline_0();
            break;
          }}

        return String_0(this.data_0, start, this.pos_0 - 1 - start | 0);
      default:throw this.unexpected_emqsxh$("unexpected '/'");
    }
  };
  SyntaxReader.prototype.tryAppendTrailingDocumentation_61zpoe$ = function (documentation) {
    var tmp$, tmp$_0;
    loop: while (this.pos_0 < this.data_0.length) {
      switch (this.data_0[this.pos_0]) {
        case 32:
        case 9:
          this.pos_0 = this.pos_0 + 1 | 0;
          break;
        case 47:
          this.pos_0 = this.pos_0 + 1 | 0;
          break loop;
        default:return documentation;
      }
    }
    var condition = this.pos_0 < this.data_0.length && (this.data_0[this.pos_0] === 47 || this.data_0[this.pos_0] === 42);
    var location;
    location = this.location();
    if (!condition) {
      this.pos_0 = this.pos_0 - 1 | 0;
      throw this.unexpected_emqsxh$("expected '//' or '/*'", location);
    }var isStar = this.data_0[this.pos_0] === 42;
    this.pos_0 = this.pos_0 + 1 | 0;
    if (this.pos_0 < this.data_0.length && this.data_0[this.pos_0] === 32) {
      this.pos_0 = this.pos_0 + 1 | 0;
    }var start = this.pos_0;
    var end;
    if (isStar) {
      while (true) {
        var condition_0 = this.pos_0 < this.data_0.length;
        var location_0;
        location_0 = this.location();
        if (!condition_0) {
          throw this.unexpected_emqsxh$('trailing comment must be closed', location_0);
        }if (this.data_0[this.pos_0] === 42 && (this.pos_0 + 1 | 0) < this.data_0.length && this.data_0[this.pos_0 + 1 | 0] === 47) {
          end = this.pos_0 - 1 | 0;
          this.pos_0 = this.pos_0 + 2 | 0;
          break;
        }this.pos_0 = this.pos_0 + 1 | 0;
      }
      while (this.pos_0 < this.data_0.length) {
        var c = this.data_0[tmp$ = this.pos_0, this.pos_0 = tmp$ + 1 | 0, tmp$];
        if (c === 10) {
          this.newline_0();
          break;
        }var condition_1 = c === 32 || c === 9;
        var location_1;
        location_1 = this.location();
        if (!condition_1) {
          throw this.unexpected_emqsxh$('no syntax may follow trailing comment', location_1);
        }}
    } else {
      while (true) {
        if (this.pos_0 === this.data_0.length) {
          end = this.pos_0 - 1 | 0;
          break;
        }var c_0 = this.data_0[tmp$_0 = this.pos_0, this.pos_0 = tmp$_0 + 1 | 0, tmp$_0];
        if (c_0 === 10) {
          this.newline_0();
          end = this.pos_0 - 2 | 0;
          break;
        }}
    }
    while (end > start && (this.data_0[end] === 32 || this.data_0[end] === 9)) {
      end = end - 1 | 0;
    }
    if (end === start)
      return documentation;
    var trailingDocumentation = String_0(this.data_0, start, end - start + 1 | 0);
    if (documentation.length === 0)
      return trailingDocumentation;
    return documentation + '\n' + trailingDocumentation;
  };
  SyntaxReader.prototype.skipWhitespace_0 = function (skipComments) {
    while (this.pos_0 < this.data_0.length) {
      var c = this.data_0[this.pos_0];
      if (c === 32 || c === 9 || c === 13 || c === 10) {
        this.pos_0 = this.pos_0 + 1 | 0;
        if (c === 10)
          this.newline_0();
      } else if (skipComments && c === 47)
        this.readComment_0();
      else
        return;
    }
  };
  SyntaxReader.prototype.newline_0 = function () {
    this.line_0 = this.line_0 + 1 | 0;
    this.lineStart_0 = this.pos_0;
  };
  SyntaxReader.prototype.location = function () {
    return this.location_0.at_vux9f0$(this.line_0 + 1 | 0, this.pos_0 - this.lineStart_0 + 1 | 0);
  };
  SyntaxReader.prototype.expect_7qi25x$ = defineInlineFunction('wire-library-wire-schema.com.squareup.wire.schema.internal.parser.SyntaxReader.expect_7qi25x$', function (condition, location, message) {
    if (location === void 0)
      location = this.location();
    if (!condition)
      throw this.unexpected_emqsxh$(message(), location);
  });
  SyntaxReader.prototype.unexpected_emqsxh$ = function (message, location) {
    if (location === void 0)
      location = this.location();
    throw IllegalStateException_init_0('Syntax error in ' + toString(location) + ': ' + message);
  };
  SyntaxReader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SyntaxReader',
    interfaces: []
  };
  function TypeElement() {
  }
  TypeElement.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TypeElement',
    interfaces: []
  };
  function CoreLoader() {
    CoreLoader_instance = this;
  }
  CoreLoader.prototype.load_61zpoe$ = function (path) {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'Not yet implemented in JS');
  };
  CoreLoader.prototype.withErrors_t11pg2$ = function (errors) {
    return this;
  };
  CoreLoader.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'CoreLoader',
    interfaces: [Loader]
  };
  var CoreLoader_instance = null;
  function CoreLoader_getInstance() {
    if (CoreLoader_instance === null) {
      new CoreLoader();
    }return CoreLoader_instance;
  }
  function Multimap() {
  }
  Multimap.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Multimap',
    interfaces: []
  };
  function SimpleMultimap(map) {
    this.map_0 = map;
  }
  SimpleMultimap.prototype.size = function () {
    var tmp$;
    var sum = 0;
    tmp$ = this.map_0.values.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      sum = sum + element.size | 0;
    }
    return sum;
  };
  SimpleMultimap.prototype.isEmpty = function () {
    return this.map_0.isEmpty();
  };
  SimpleMultimap.prototype.containsKey_s8jyv4$ = function (key) {
    var $receiver = this.map_0;
    var tmp$;
    return (Kotlin.isType(tmp$ = $receiver, Map) ? tmp$ : throwCCE()).containsKey_11rb$(key);
  };
  SimpleMultimap.prototype.containsValue_s8jyv4$ = function (value) {
    var $receiver = this.map_0.values;
    var any$result;
    any$break: do {
      var tmp$;
      if (Kotlin.isType($receiver, Collection) && $receiver.isEmpty()) {
        any$result = false;
        break any$break;
      }tmp$ = $receiver.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        if (contains_1(element, value)) {
          any$result = true;
          break any$break;
        }}
      any$result = false;
    }
     while (false);
    return any$result;
  };
  SimpleMultimap.prototype.get_11rb$ = function (key) {
    var tmp$;
    var $receiver = this.map_0;
    var tmp$_0;
    return (tmp$ = (Kotlin.isType(tmp$_0 = $receiver, Map) ? tmp$_0 : throwCCE()).get_11rb$(key)) != null ? tmp$ : emptyList();
  };
  SimpleMultimap.prototype.values = function () {
    return flatten(this.map_0.values);
  };
  SimpleMultimap.prototype.asMap = function () {
    return this.map_0;
  };
  SimpleMultimap.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SimpleMultimap',
    interfaces: [Multimap]
  };
  function toMultimap($receiver) {
    return new SimpleMultimap($receiver);
  }
  function isDigit($receiver) {
    return (new CharRange(48, 57)).contains_mef7kx$($receiver);
  }
  function toEnglishLowerCase($receiver) {
    return $receiver.toLowerCase();
  }
  function MutableQueue() {
  }
  MutableQueue.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MutableQueue',
    interfaces: [MutableCollection]
  };
  function mutableQueueOf$ObjectLiteral(closure$queue) {
    this.closure$queue = closure$queue;
    this.$delegate_nka7l$_0 = closure$queue;
  }
  mutableQueueOf$ObjectLiteral.prototype.poll = function () {
    return firstOrNull_0(this);
  };
  Object.defineProperty(mutableQueueOf$ObjectLiteral.prototype, 'size', {
    get: function () {
      return this.$delegate_nka7l$_0.size;
    }
  });
  mutableQueueOf$ObjectLiteral.prototype.add_11rb$ = function (element) {
    return this.$delegate_nka7l$_0.add_11rb$(element);
  };
  mutableQueueOf$ObjectLiteral.prototype.addAll_brywnq$ = function (elements) {
    return this.$delegate_nka7l$_0.addAll_brywnq$(elements);
  };
  mutableQueueOf$ObjectLiteral.prototype.clear = function () {
    return this.$delegate_nka7l$_0.clear();
  };
  mutableQueueOf$ObjectLiteral.prototype.contains_11rb$ = function (element) {
    return this.$delegate_nka7l$_0.contains_11rb$(element);
  };
  mutableQueueOf$ObjectLiteral.prototype.containsAll_brywnq$ = function (elements) {
    return this.$delegate_nka7l$_0.containsAll_brywnq$(elements);
  };
  mutableQueueOf$ObjectLiteral.prototype.isEmpty = function () {
    return this.$delegate_nka7l$_0.isEmpty();
  };
  mutableQueueOf$ObjectLiteral.prototype.iterator = function () {
    return this.$delegate_nka7l$_0.iterator();
  };
  mutableQueueOf$ObjectLiteral.prototype.remove_11rb$ = function (element) {
    return this.$delegate_nka7l$_0.remove_11rb$(element);
  };
  mutableQueueOf$ObjectLiteral.prototype.removeAll_brywnq$ = function (elements) {
    return this.$delegate_nka7l$_0.removeAll_brywnq$(elements);
  };
  mutableQueueOf$ObjectLiteral.prototype.retainAll_brywnq$ = function (elements) {
    return this.$delegate_nka7l$_0.retainAll_brywnq$(elements);
  };
  mutableQueueOf$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [MutableQueue, MutableCollection]
  };
  function mutableQueueOf() {
    var queue = ArrayList_init();
    return new mutableQueueOf$ObjectLiteral(queue);
  }
  var package$com = _.com || (_.com = {});
  var package$squareup = package$com.squareup || (package$com.squareup = {});
  var package$wire = package$squareup.wire || (package$squareup.wire = {});
  var package$schema = package$wire.schema || (package$wire.schema = {});
  package$schema.CycleChecker = CycleChecker;
  package$schema.EnclosingType = EnclosingType;
  Object.defineProperty(EnumConstant, 'Companion', {
    get: EnumConstant$Companion_getInstance
  });
  package$schema.EnumConstant = EnumConstant;
  Object.defineProperty(EnumType, 'Companion', {
    get: EnumType$Companion_getInstance
  });
  package$schema.EnumType = EnumType;
  package$schema.ErrorCollector_init = ErrorCollector_init;
  package$schema.ErrorCollector = ErrorCollector;
  Object.defineProperty(Extend, 'Companion', {
    get: Extend$Companion_getInstance
  });
  package$schema.Extend = Extend;
  Object.defineProperty(Extensions, 'Companion', {
    get: Extensions$Companion_getInstance
  });
  package$schema.Extensions = Extensions;
  Object.defineProperty(Field$Label, 'OPTIONAL', {
    get: Field$Label$OPTIONAL_getInstance
  });
  Object.defineProperty(Field$Label, 'REQUIRED', {
    get: Field$Label$REQUIRED_getInstance
  });
  Object.defineProperty(Field$Label, 'REPEATED', {
    get: Field$Label$REPEATED_getInstance
  });
  Object.defineProperty(Field$Label, 'ONE_OF', {
    get: Field$Label$ONE_OF_getInstance
  });
  Field.Label = Field$Label;
  Object.defineProperty(Field$EncodeMode, 'NULL_IF_ABSENT', {
    get: Field$EncodeMode$NULL_IF_ABSENT_getInstance
  });
  Object.defineProperty(Field$EncodeMode, 'REQUIRED', {
    get: Field$EncodeMode$REQUIRED_getInstance
  });
  Object.defineProperty(Field$EncodeMode, 'OMIT_IDENTITY', {
    get: Field$EncodeMode$OMIT_IDENTITY_getInstance
  });
  Object.defineProperty(Field$EncodeMode, 'REPEATED', {
    get: Field$EncodeMode$REPEATED_getInstance
  });
  Object.defineProperty(Field$EncodeMode, 'PACKED', {
    get: Field$EncodeMode$PACKED_getInstance
  });
  Object.defineProperty(Field$EncodeMode, 'MAP', {
    get: Field$EncodeMode$MAP_getInstance
  });
  Field.EncodeMode = Field$EncodeMode;
  Object.defineProperty(Field, 'Companion', {
    get: Field$Companion_getInstance
  });
  package$schema.Field = Field;
  package$schema.FileLinker = FileLinker;
  package$schema.LinkedOptionEntry = LinkedOptionEntry;
  package$schema.Linker_init_x4ty1r$ = Linker_init;
  package$schema.Linker = Linker;
  package$schema.Loader = Loader;
  Object.defineProperty(Location, 'Companion', {
    get: Location$Companion_getInstance
  });
  package$schema.Location = Location;
  Object.defineProperty(MarkSet, 'Companion', {
    get: MarkSet$Companion_getInstance
  });
  package$schema.MarkSet = MarkSet;
  Object.defineProperty(MessageType, 'Companion', {
    get: MessageType$Companion_getInstance
  });
  package$schema.MessageType = MessageType;
  Object.defineProperty(OneOf, 'Companion', {
    get: OneOf$Companion_getInstance
  });
  package$schema.OneOf = OneOf;
  Object.defineProperty(Options, 'Companion', {
    get: Options$Companion_getInstance
  });
  package$schema.Options = Options;
  Object.defineProperty(ProtoFile, 'Companion', {
    get: ProtoFile$Companion_getInstance
  });
  package$schema.ProtoFile = ProtoFile;
  Object.defineProperty(ProtoMember, 'Companion', {
    get: ProtoMember$Companion_getInstance
  });
  package$schema.ProtoMember = ProtoMember;
  Object.defineProperty(ProtoType, 'Companion', {
    get: ProtoType$Companion_getInstance
  });
  package$schema.ProtoType = ProtoType;
  package$schema.Pruner = Pruner;
  PruningRules.Builder = PruningRules$Builder;
  Object.defineProperty(PruningRules, 'Companion', {
    get: PruningRules$Companion_getInstance
  });
  package$schema.PruningRules = PruningRules;
  Object.defineProperty(Reserved, 'Companion', {
    get: Reserved$Companion_getInstance
  });
  package$schema.Reserved = Reserved;
  Object.defineProperty(Rpc, 'Companion', {
    get: Rpc$Companion_getInstance
  });
  package$schema.Rpc = Rpc;
  Object.defineProperty(Schema, 'Companion', {
    get: Schema$Companion_getInstance
  });
  package$schema.Schema = Schema;
  package$schema.SchemaException = SchemaException;
  SchemaProtoAdapterFactory.EnumAdapter = SchemaProtoAdapterFactory$EnumAdapter;
  SchemaProtoAdapterFactory.MessageAdapter = SchemaProtoAdapterFactory$MessageAdapter;
  SchemaProtoAdapterFactory.Field = SchemaProtoAdapterFactory$Field;
  package$schema.SchemaProtoAdapterFactory = SchemaProtoAdapterFactory;
  Object.defineProperty(SemVer, 'Companion', {
    get: SemVer$Companion_getInstance
  });
  package$schema.SemVer = SemVer;
  Object.defineProperty(Service, 'Companion', {
    get: Service$Companion_getInstance
  });
  package$schema.Service = Service;
  Object.defineProperty(SyntaxRules, 'Companion', {
    get: SyntaxRules$Companion_getInstance
  });
  package$schema.SyntaxRules = SyntaxRules;
  Object.defineProperty(Type, 'Companion', {
    get: Type$Companion_getInstance
  });
  package$schema.Type = Type;
  var package$internal = package$schema.internal || (package$schema.internal = {});
  package$internal.DagChecker = DagChecker;
  TypeMover.Move = TypeMover$Move;
  package$internal.TypeMover = TypeMover;
  package$internal.appendDocumentation_s47sd7$ = appendDocumentation;
  package$internal.appendOptions_dnc75x$ = appendOptions;
  package$internal.appendIndented_s47sd7$ = appendIndented;
  Object.defineProperty(package$internal, 'MIN_TAG_VALUE_8be2vx$', {
    get: function () {
      return MIN_TAG_VALUE;
    }
  });
  Object.defineProperty(package$internal, 'MAX_TAG_VALUE_8be2vx$', {
    get: function () {
      return MAX_TAG_VALUE;
    }
  });
  package$internal.isValidTag_8e50z4$ = isValidTag;
  package$internal.withStubs_3d6d7h$ = withStubs;
  var package$parser = package$internal.parser || (package$internal.parser = {});
  package$parser.EnumConstantElement = EnumConstantElement;
  package$parser.EnumElement = EnumElement;
  package$parser.ExtendElement = ExtendElement;
  package$parser.ExtensionsElement = ExtensionsElement;
  package$parser.FieldElement = FieldElement;
  package$parser.GroupElement = GroupElement;
  package$parser.MessageElement = MessageElement;
  package$parser.OneOfElement = OneOfElement;
  Object.defineProperty(OptionElement$Kind, 'STRING', {
    get: OptionElement$Kind$STRING_getInstance
  });
  Object.defineProperty(OptionElement$Kind, 'BOOLEAN', {
    get: OptionElement$Kind$BOOLEAN_getInstance
  });
  Object.defineProperty(OptionElement$Kind, 'NUMBER', {
    get: OptionElement$Kind$NUMBER_getInstance
  });
  Object.defineProperty(OptionElement$Kind, 'ENUM', {
    get: OptionElement$Kind$ENUM_getInstance
  });
  Object.defineProperty(OptionElement$Kind, 'MAP', {
    get: OptionElement$Kind$MAP_getInstance
  });
  Object.defineProperty(OptionElement$Kind, 'LIST', {
    get: OptionElement$Kind$LIST_getInstance
  });
  Object.defineProperty(OptionElement$Kind, 'OPTION', {
    get: OptionElement$Kind$OPTION_getInstance
  });
  OptionElement.Kind = OptionElement$Kind;
  Object.defineProperty(OptionElement, 'Companion', {
    get: OptionElement$Companion_getInstance
  });
  package$parser.OptionElement = OptionElement;
  $$importsForInline$$['wire-library-wire-schema'] = _;
  OptionReader.KindAndValue = OptionReader$KindAndValue;
  package$parser.OptionReader = OptionReader;
  Object.defineProperty(ProtoFileElement, 'Companion', {
    get: ProtoFileElement$Companion_getInstance
  });
  package$parser.ProtoFileElement = ProtoFileElement;
  Object.defineProperty(ProtoParser$Context, 'FILE', {
    get: ProtoParser$Context$FILE_getInstance
  });
  Object.defineProperty(ProtoParser$Context, 'MESSAGE', {
    get: ProtoParser$Context$MESSAGE_getInstance
  });
  Object.defineProperty(ProtoParser$Context, 'ENUM', {
    get: ProtoParser$Context$ENUM_getInstance
  });
  Object.defineProperty(ProtoParser$Context, 'RPC', {
    get: ProtoParser$Context$RPC_getInstance
  });
  Object.defineProperty(ProtoParser$Context, 'EXTEND', {
    get: ProtoParser$Context$EXTEND_getInstance
  });
  Object.defineProperty(ProtoParser$Context, 'SERVICE', {
    get: ProtoParser$Context$SERVICE_getInstance
  });
  ProtoParser.Context = ProtoParser$Context;
  Object.defineProperty(ProtoParser, 'Companion', {
    get: ProtoParser$Companion_getInstance
  });
  package$parser.ProtoParser = ProtoParser;
  package$parser.ReservedElement = ReservedElement;
  package$parser.RpcElement = RpcElement;
  package$parser.ServiceElement = ServiceElement;
  package$parser.SyntaxReader = SyntaxReader;
  package$parser.TypeElement = TypeElement;
  Object.defineProperty(package$schema, 'CoreLoader', {
    get: CoreLoader_getInstance
  });
  package$schema.Multimap = Multimap;
  package$schema.toMultimap_y1gw3g$ = toMultimap;
  package$internal.isDigit_nupfqh$ = isDigit;
  package$internal.toEnglishLowerCase_7efafi$ = toEnglishLowerCase;
  package$internal.MutableQueue = MutableQueue;
  package$internal.mutableQueueOf_yzxhcs$ = mutableQueueOf;
  MIN_TAG_VALUE = 1;
  MAX_TAG_VALUE = 536870911;
  RESERVED_TAG_VALUE_START = 19000;
  RESERVED_TAG_VALUE_END = 19999;
  Kotlin.defineModule('wire-library-wire-schema', _);
  return _;
}));

//# sourceMappingURL=wire-library-wire-schema.js.map
