[wire-runtime](../../index.md) / [com.squareup.wire](../index.md) / [WireField](./index.md)

# WireField

`@Target([AnnotationTarget.FIELD]) annotation class WireField`

Annotates generated [Message](../-message/index.md) fields with metadata for serialization and deserialization.

### Types

| Name | Summary |
|---|---|
| [Label](-label/index.md) | `enum class Label`<br>A protocol buffer label. |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `WireField(tag: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, keyAdapter: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", adapter: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, label: `[`Label`](-label/index.md)` = Label.OPTIONAL, redacted: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false, declaredName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "", jsonName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "")`<br>Annotates generated [Message](../-message/index.md) fields with metadata for serialization and deserialization. |

### Properties

| Name | Summary |
|---|---|
| [adapter](adapter.md) | `val adapter: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Reference to the static field that holds a [ProtoAdapter](../-proto-adapter/index.md) that can encode and decode this field's values. The reference is a string like `com.squareup.wire.protos.person.Person#ADAPTER` and contains a fully-qualified class name followed by a hash symbol and a field name. |
| [declaredName](declared-name.md) | `val declaredName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Name of this field as declared in the proto schema. This value is set to a non-empty string only when the declared name differs from the generated one; for instance, a proto field named `final` generated in Java will be renamed to `final_`. |
| [jsonName](json-name.md) | `val jsonName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Name representing this field as it should be used in JSON. This value is set to a non-empty string only when the json name differs from the name as declared in the proto schema. |
| [keyAdapter](key-adapter.md) | `val keyAdapter: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)<br>Reference to the static field that holds a [ProtoAdapter](../-proto-adapter/index.md) that can encode and decode this field's keys. This only applies to maps. See [adapter](adapter.md) for a description of the value format. |
| [label](label.md) | `val label: `[`Label`](-label/index.md)<br>The field's protocol buffer label, one of [Label.OPTIONAL](-label/-o-p-t-i-o-n-a-l.md), [Label.REQUIRED](-label/-r-e-q-u-i-r-e-d.md), [Label.REPEATED](-label/-r-e-p-e-a-t-e-d.md), [Label.PACKED](-label/-p-a-c-k-e-d.md), or [Label.OMIT_IDENTITY](-label/-o-m-i-t_-i-d-e-n-t-i-t-y.md). Defaults to [Label.OPTIONAL](-label/-o-p-t-i-o-n-a-l.md). |
| [redacted](redacted.md) | `val redacted: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Redacted fields are omitted from toString() to protect sensitive data. Defaults to false. |
| [tag](tag.md) | `val tag: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>The tag number used to store the field's value. |
