/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;

final class MessageSerializedForm<T extends Message<T>>
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final byte[] bytes;
    private final Class<T> messageClass;

    public MessageSerializedForm(T message, Class<T> messageClass) {
        this.bytes = ProtoAdapter.get(messageClass).encode(message);
        this.messageClass = messageClass;
    }

    Object readResolve() throws ObjectStreamException {
        ProtoAdapter<T> adapter = ProtoAdapter.get(this.messageClass);
        try {
            return adapter.decode(this.bytes);
        }
        catch (IOException e) {
            throw new StreamCorruptedException(e.getMessage());
        }
    }
}

