/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.ProtoWriter;
import com.squareup.wire.TypeAdapter;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class UnknownFieldMap {
    final Map<Integer, List<Value>> fieldMap;

    UnknownFieldMap() {
        this(null);
    }

    UnknownFieldMap(UnknownFieldMap other) {
        this.fieldMap = other != null && other.fieldMap != null ? new TreeMap<Integer, List<Value>>(other.fieldMap) : new TreeMap<Integer, List<Value>>();
    }

    <T> void add(int tag, T value, TypeAdapter<T> adapter) throws IOException {
        this.addElement(tag, new Value<T>(tag, value, adapter));
    }

    private void addElement(int tag, Value value) throws IOException {
        List<Value> values = this.fieldMap.get(tag);
        if (values == null) {
            values = new ArrayList<Value>();
            this.fieldMap.put(tag, values);
        } else if (values.get((int)0).adapter.fieldEncoding != value.adapter.fieldEncoding) {
            throw new ProtocolException(String.format("Wire type %s differs from previous type %s for tag %s", new Object[]{value.adapter.fieldEncoding, values.get((int)0).adapter.fieldEncoding, tag}));
        }
        values.add(value);
    }

    int getSerializedSize() {
        int size = 0;
        for (Map.Entry<Integer, List<Value>> entry : this.fieldMap.entrySet()) {
            int tag = entry.getKey();
            for (Value value : entry.getValue()) {
                size += value.serializedSize(tag);
            }
        }
        return size;
    }

    void write(ProtoWriter output) throws IOException {
        for (Map.Entry<Integer, List<Value>> entry : this.fieldMap.entrySet()) {
            int tag = entry.getKey();
            for (Value value : entry.getValue()) {
                value.write(tag, output);
            }
        }
    }

    static final class Value<T> {
        final int tag;
        final T value;
        final TypeAdapter<T> adapter;

        public Value(int tag, T value, TypeAdapter<T> adapter) {
            this.tag = tag;
            this.value = value;
            this.adapter = adapter;
        }

        int serializedSize(int tag) {
            return this.adapter.serializedSize(tag, this.value);
        }

        void write(int tag, ProtoWriter output) throws IOException {
            this.adapter.writeTagged(output, tag, this.value);
        }
    }
}

