/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.ProtoEnum;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.TypeAdapter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

final class RuntimeEnumAdapter<E extends ProtoEnum>
extends TypeAdapter<E> {
    private static final Comparator<ProtoEnum> COMPARATOR = new Comparator<ProtoEnum>(){

        @Override
        public int compare(ProtoEnum o1, ProtoEnum o2) {
            return o1.getValue() - o2.getValue();
        }
    };
    private final Class<E> type;
    private final int[] values;
    private final E[] constants;
    private final boolean isDense;

    RuntimeEnumAdapter(Class<E> type) {
        super(FieldEncoding.VARINT, type);
        this.type = type;
        this.constants = (ProtoEnum[])type.getEnumConstants();
        Arrays.sort(this.constants, COMPARATOR);
        int length = this.constants.length;
        if (this.constants[0].getValue() == 1 && this.constants[length - 1].getValue() == length) {
            this.isDense = true;
            this.values = null;
        } else {
            this.isDense = false;
            this.values = new int[length];
            for (int i = 0; i < length; ++i) {
                this.values[i] = this.constants[i].getValue();
            }
        }
    }

    public E fromInt(int value) {
        int index = this.isDense ? value - 1 : Arrays.binarySearch(this.values, value);
        try {
            return this.constants[index];
        }
        catch (IndexOutOfBoundsException e) {
            throw new EnumConstantNotFoundException(value, this.type);
        }
    }

    @Override
    public int encodedSize(E value) {
        return ProtoWriter.varint32Size(value.getValue());
    }

    @Override
    public void write(ProtoWriter writer, E value) throws IOException {
        writer.writeVarint32(value.getValue());
    }

    @Override
    public E read(ProtoReader reader) throws IOException {
        return this.fromInt(reader.readVarint32());
    }

    static final class EnumConstantNotFoundException
    extends IllegalArgumentException {
        final int value;

        EnumConstantNotFoundException(int value, Class<?> type) {
            super("Unknown enum tag " + value + " for " + type.getCanonicalName());
            this.value = value;
        }
    }
}

