/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.Message;
import com.squareup.wire.TypeAdapter;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;

final class MessageSerializedForm
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final byte[] bytes;
    private final Class<? extends Message> messageClass;

    public MessageSerializedForm(Message message, Class<? extends Message> messageClass) {
        this.bytes = Message.WIRE.adapter(messageClass).writeBytes(message);
        this.messageClass = messageClass;
    }

    Object readResolve() throws ObjectStreamException {
        TypeAdapter<? extends Message> adapter = Message.WIRE.adapter(this.messageClass);
        try {
            return adapter.readBytes(this.bytes);
        }
        catch (IOException e) {
            throw new StreamCorruptedException(e.getMessage());
        }
    }
}

