/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.ExtendableMessage;
import com.squareup.wire.Extension;
import com.squareup.wire.ExtensionMap;
import com.squareup.wire.ExtensionTagBinding;
import com.squareup.wire.FieldEncoding;
import com.squareup.wire.FieldTagBinding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoEnum;
import com.squareup.wire.ProtoField;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.RuntimeEnumAdapter;
import com.squareup.wire.TagBinding;
import com.squareup.wire.TypeAdapter;
import com.squareup.wire.Wire;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;

final class RuntimeMessageAdapter<M extends Message>
extends TypeAdapter<M> {
    private final Wire wire;
    private final Class<M> messageType;
    private final Class<Message.Builder<M>> builderType;
    private final Constructor<Message.Builder<M>> builderCopyConstructor;
    private final Map<Integer, TagBinding<M, Message.Builder<M>>> tagBindings;

    RuntimeMessageAdapter(Wire wire, Class<M> messageType) {
        super(FieldEncoding.LENGTH_DELIMITED, messageType);
        this.wire = wire;
        this.messageType = messageType;
        this.builderType = RuntimeMessageAdapter.getBuilderType(messageType);
        this.builderCopyConstructor = RuntimeMessageAdapter.getBuilderCopyConstructor(this.builderType, messageType);
        LinkedHashMap<Integer, TagBinding> tagBindings = new LinkedHashMap<Integer, TagBinding>();
        for (Field messageField : messageType.getDeclaredFields()) {
            ProtoField protoField = messageField.getAnnotation(ProtoField.class);
            if (protoField == null) continue;
            TypeAdapter<?> singleAdapter = this.singleTypeAdapter(wire, messageField, protoField);
            Class<?> singleType = singleAdapter.javaType;
            FieldTagBinding<M> tagBinding = new FieldTagBinding<M>(protoField, singleAdapter, singleType, messageField, this.builderType);
            tagBindings.put(tagBinding.tag, tagBinding);
        }
        for (Extension extension : wire.getExtensions(messageType)) {
            TypeAdapter<?> singleAdapter = TypeAdapter.get(wire, extension.getDatatype(), extension.getMessageType(), extension.getEnumType());
            tagBindings.put(extension.getTag(), new ExtensionTagBinding(extension, singleAdapter));
        }
        this.tagBindings = Collections.unmodifiableMap(tagBindings);
    }

    private TypeAdapter<?> singleTypeAdapter(Wire wire, Field messageField, ProtoField protoField) {
        if (protoField.type() == Message.Datatype.ENUM) {
            return wire.enumAdapter(RuntimeMessageAdapter.getEnumType(protoField, messageField));
        }
        if (protoField.type() == Message.Datatype.MESSAGE) {
            return wire.adapter(RuntimeMessageAdapter.getMessageType(protoField, messageField));
        }
        return TypeAdapter.get(wire, protoField.type(), null, null);
    }

    private static Class<? extends Message> getMessageType(ProtoField protoField, Field field) {
        Class<?> fieldType = field.getType();
        if (List.class.isAssignableFrom(fieldType)) {
            return protoField.messageType();
        }
        return fieldType;
    }

    private static Class<? extends ProtoEnum> getEnumType(ProtoField protoField, Field field) {
        Class<?> fieldType = field.getType();
        if (List.class.isAssignableFrom(fieldType)) {
            return protoField.enumType();
        }
        return fieldType;
    }

    Map<Integer, TagBinding<M, Message.Builder<M>>> tagBindings() {
        return this.tagBindings;
    }

    Message.Builder<M> newBuilder() {
        try {
            return this.builderType.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
    }

    Message.Builder<M> newBuilder(M value) {
        try {
            return this.builderCopyConstructor.newInstance(value);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static <M extends Message> Class<Message.Builder<M>> getBuilderType(Class<M> messageType) {
        try {
            return Class.forName(messageType.getName() + "$Builder");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No builder class found for message type " + messageType.getName());
        }
    }

    private static <M extends Message> Constructor<Message.Builder<M>> getBuilderCopyConstructor(Class<Message.Builder<M>> builderType, Class<M> messageType) {
        try {
            return builderType.getConstructor(messageType);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int encodedSize(M message) {
        int cachedSerializedSize = ((Message)message).cachedSerializedSize;
        if (cachedSerializedSize != -1) {
            return cachedSerializedSize;
        }
        int size = 0;
        for (TagBinding<M, Message.Builder<M>> tagBinding : this.tagBindingsForMessage(message).values()) {
            Object value = tagBinding.get(message);
            if (value == null) continue;
            size += tagBinding.adapter.serializedSize(tagBinding.tag, value);
        }
        ((Message)message).cachedSerializedSize = size += ((Message)message).getUnknownFieldsSerializedSize();
        return size;
    }

    Map<Integer, TagBinding<M, Message.Builder<M>>> tagBindingsForMessage(M message) {
        Map<Integer, TagBinding<M, Message.Builder<M>>> result = this.tagBindings;
        if (!(message instanceof ExtendableMessage)) {
            return result;
        }
        ExtensionMap map = ((ExtendableMessage)message).extensionMap;
        if (map == null) {
            return result;
        }
        int count = map.size();
        for (int i = 0; i < count; ++i) {
            Extension extension = map.getExtension(i);
            if (this.tagBindings.containsKey(extension.getTag())) continue;
            if (result == this.tagBindings) {
                result = new LinkedHashMap<Integer, TagBinding<M, Message.Builder<M>>>(this.tagBindings);
            }
            TypeAdapter<?> singleAdapter = TypeAdapter.get(this.wire, extension.getDatatype(), extension.getMessageType(), extension.getEnumType());
            result.put(extension.getTag(), new ExtensionTagBinding(extension, singleAdapter));
        }
        return result;
    }

    @Override
    public void write(ProtoWriter writer, M message) throws IOException {
        for (TagBinding<M, Message.Builder<M>> tagBinding : this.tagBindingsForMessage(message).values()) {
            Object value = tagBinding.get(message);
            if (value == null) continue;
            tagBinding.adapter.writeTagged(writer, tagBinding.tag, value);
        }
        ((Message)message).writeUnknownFieldMap(writer);
    }

    @Override
    public M redact(M message) {
        Message.Builder<M> builder = this.newBuilder(message);
        for (TagBinding<M, Message.Builder<M>> tagBinding : this.tagBindingsForMessage(message).values()) {
            if (!tagBinding.redacted && tagBinding.datatype != Message.Datatype.MESSAGE) continue;
            if (tagBinding.redacted && tagBinding.label == Message.Label.REQUIRED) {
                throw new IllegalArgumentException(String.format("Field %s.%s is REQUIRED and cannot be redacted.", this.javaType.getName(), tagBinding.name));
            }
            Object builderValue = tagBinding.getFromBuilder(builder);
            if (builderValue == null) continue;
            Object redactedValue = tagBinding.adapter.redact(builderValue);
            tagBinding.set(builder, redactedValue);
        }
        return builder.build();
    }

    @Override
    public String toString(M message) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.messageType.getSimpleName());
        sb.append('{');
        boolean seenValue = false;
        for (TagBinding<M, Message.Builder<M>> tagBinding : this.tagBindingsForMessage(message).values()) {
            Object value = tagBinding.get(message);
            if (value == null) continue;
            if (seenValue) {
                sb.append(", ");
            }
            sb.append(tagBinding.name);
            sb.append('=');
            sb.append(tagBinding.redacted ? "\u2588\u2588" : value);
            seenValue = true;
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public M read(ProtoReader reader) throws IOException {
        int tag;
        Message.Builder<M> builder = this.newBuilder();
        Storage storage = new Storage();
        long token = reader.beginMessage();
        while ((tag = reader.nextTag()) != -1) {
            TagBinding<M, Message.Builder<M>> tagBinding = this.tagBindings.get(tag);
            if (tagBinding == null) {
                TypeAdapter<?> typeAdapter = reader.peekFieldEncoding().rawTypeAdapter();
                this.readUnknownField(builder, reader, tag, typeAdapter);
                continue;
            }
            try {
                Object value = tagBinding.singleAdapter.read(reader);
                if (tagBinding.label.isRepeated()) {
                    storage.add(tag, value);
                    continue;
                }
                tagBinding.set(builder, value);
            }
            catch (RuntimeEnumAdapter.EnumConstantNotFoundException e) {
                builder.addVarint(tag, e.value);
            }
        }
        reader.endMessage(token);
        for (int storedTag : storage.getTags()) {
            TagBinding<M, Message.Builder<M>> tagBinding = this.tagBindings.get(storedTag);
            List<Object> value = storage.get(storedTag);
            tagBinding.set(builder, value);
        }
        return builder.build();
    }

    private <T> void readUnknownField(Message.Builder builder, ProtoReader input, int tag, TypeAdapter<T> typeAdapter) throws IOException {
        builder.ensureUnknownFieldMap().add(tag, typeAdapter.read(input), typeAdapter);
    }

    static class ImmutableList<T>
    extends AbstractList<T>
    implements Cloneable,
    RandomAccess,
    Serializable {
        private final List<T> list = new ArrayList<T>();

        ImmutableList() {
        }

        public Object clone() {
            return this;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public T get(int i) {
            return this.list.get(i);
        }

        private Object writeReplace() throws ObjectStreamException {
            return Collections.unmodifiableList(this.list);
        }
    }

    private static class Storage {
        private Map<Integer, ImmutableList<Object>> map;

        private Storage() {
        }

        void add(int tag, Object value) {
            ImmutableList<Object> list;
            ImmutableList<Object> immutableList = list = this.map == null ? null : this.map.get(tag);
            if (list == null) {
                list = new ImmutableList();
                if (this.map == null) {
                    this.map = new LinkedHashMap<Integer, ImmutableList<Object>>();
                }
                this.map.put(tag, list);
            }
            ((ImmutableList)list).list.add(value);
        }

        Set<Integer> getTags() {
            if (this.map == null) {
                return Collections.emptySet();
            }
            return this.map.keySet();
        }

        List<Object> get(int tag) {
            return this.map == null ? null : this.map.get(tag);
        }
    }
}

