/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.ExtendableMessage;
import com.squareup.wire.Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class ExtensionMap<T extends ExtendableMessage<?>> {
    private final Map<Extension<T, ?>, Object> map = new TreeMap();

    public ExtensionMap() {
    }

    public ExtensionMap(ExtensionMap<T> other) {
        this.map.putAll(other.map);
    }

    public List<Extension<T, ?>> getExtensions() {
        return Collections.unmodifiableList(new ArrayList(this.map.keySet()));
    }

    public <E> E get(Extension<T, E> extension) {
        return (E)this.map.get(extension);
    }

    public <E> void put(Extension<T, E> extension, E value) {
        this.map.put(extension, value);
    }

    public boolean equals(Object other) {
        return other instanceof ExtensionMap && this.map.equals(((ExtensionMap)other).map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String sep = "";
        for (Map.Entry<Extension<T, ?>, Object> entry : this.map.entrySet()) {
            sb.append(sep);
            sb.append(entry.getKey().getTag());
            sb.append("=");
            sb.append(entry.getValue());
            sep = ", ";
        }
        sb.append("}");
        return sb.toString();
    }
}

