//[wire-compiler](../../../index.md)/[com.squareup.wire](../index.md)/[WireLogger](index.md)

# WireLogger

[jvm]\
interface [WireLogger](index.md)

Logger class used by [WireRun](../../com.squareup.wire.schema/-wire-run/index.md) and [SchemaHandlers](../../com.squareup.wire.schema/-target/-schema-handler/index.md) to log information related to processing the protobuf Schema.

## Functions

| Name | Summary |
|---|---|
| [artifactHandled](artifact-handled.md) | [jvm]<br>abstract fun [artifactHandled](artifact-handled.md)(outputPath: Path, qualifiedName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), targetName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html))<br>This is called when an artifact is handled by a [SchemaHandler](../../com.squareup.wire.schema/-target/-schema-handler/index.md). |
| [artifactSkipped](artifact-skipped.md) | [jvm]<br>abstract fun [artifactSkipped](artifact-skipped.md)(type: ProtoType, targetName: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html))<br>This is called when an artifact has been passed down to a [SchemaHandler](../../com.squareup.wire.schema/-target/-schema-handler/index.md) but has been skipped. This is useful for dry-runs. |
| [unusedExcludesInTarget](unused-excludes-in-target.md) | [jvm]<br>abstract fun [unusedExcludesInTarget](unused-excludes-in-target.md)(unusedExcludes: [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;)<br>This is called if some excludes values have not been used by the target they were defined in. Note that excludes should contain package names (suffixed with .*) and type names only. It should not contain member names, nor file paths. Unused excludes can happen if the referenced type or service isn't part of the parsed and pruned schema model, or has already been consumed by another preceding target. |
| [unusedIncludesInTarget](unused-includes-in-target.md) | [jvm]<br>abstract fun [unusedIncludesInTarget](unused-includes-in-target.md)(unusedIncludes: [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;)<br>This is called if some includes values have not been used by the target they were defined in. Note that includes should contain package names (suffixed with .*) and type names only. It should not contain member names, nor file paths. Unused includes can happen if the referenced type or service isn't part of the parsed and pruned schema model, or has already been consumed by another preceding target. |
| [unusedPrunes](unused-prunes.md) | [jvm]<br>abstract fun [unusedPrunes](unused-prunes.md)(unusedPrunes: [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;)<br>This is called if some prune values have not been used when Wire pruned the schema model. Note that prune should contain package names (suffixed with .*), type names, and member names only. It should not contain file paths. Unused prunes can happen if the referenced type or service isn't part of any .proto files defined in either [sourcePath](../../com.squareup.wire.schema/-wire-run/source-path.md) or [protoPath](../../com.squareup.wire.schema/-wire-run/proto-path.md), or if a broader prune value is already defined. |
| [unusedRoots](unused-roots.md) | [jvm]<br>abstract fun [unusedRoots](unused-roots.md)(unusedRoots: [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;)<br>This is called if some root values have not been used when Wire pruned the schema model. Note that root should contain package names (suffixed with .*), type names, and member names only. It should not contain file paths. Unused roots can happen if the referenced type or service isn't part of any .proto files defined in either [sourcePath](../../com.squareup.wire.schema/-wire-run/source-path.md) or [protoPath](../../com.squareup.wire.schema/-wire-run/proto-path.md), or if a broader root value is already defined. |
