(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'okio-okio'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('okio-okio'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'wire-runtime'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'wire-runtime'.");
    }
    if (typeof this['okio-okio'] === 'undefined') {
      throw new Error("Error loading module 'wire-runtime'. Its dependency 'okio-okio' was not found. Please, check whether 'okio-okio' is loaded prior to 'wire-runtime'.");
    }
    root['wire-runtime'] = factory(typeof this['wire-runtime'] === 'undefined' ? {} : this['wire-runtime'], kotlin, this['okio-okio']);
  }
}(this, function (_, Kotlin, $module$okio_okio) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Enum = Kotlin.kotlin.Enum;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var throwISE = Kotlin.throwISE;
  var UnsupportedOperationException_init = Kotlin.kotlin.UnsupportedOperationException_init_pdl1vj$;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var mapOf = Kotlin.kotlin.collections.mapOf_x2b85n$;
  var emptyMap = Kotlin.kotlin.collections.emptyMap_q3lmfv$;
  var getKClass = Kotlin.getKClass;
  var Map = Kotlin.kotlin.collections.Map;
  var UnsupportedOperationException_init_0 = Kotlin.kotlin.UnsupportedOperationException_init;
  var Map$Entry = Kotlin.kotlin.collections.Map.Entry;
  var IOException = $module$okio_okio.okio.IOException;
  var PrimitiveClasses$booleanClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.booleanClass;
  var PrimitiveClasses$intClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.intClass;
  var Long = Kotlin.Long;
  var toBits = Kotlin.floatToBits;
  var PrimitiveClasses$floatClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.floatClass;
  var toBits_0 = Kotlin.doubleToBits;
  var PrimitiveClasses$doubleClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.doubleClass;
  var utf8Size = $module$okio_okio.okio.utf8Size_qgyqat$;
  var PrimitiveClasses$stringClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.stringClass;
  var ByteString = $module$okio_okio.okio.ByteString;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var Buffer = $module$okio_okio.okio.Buffer;
  var L_1 = Kotlin.Long.NEG_ONE;
  var equals = Kotlin.equals;
  var L0 = Kotlin.Long.ZERO;
  var IllegalStateException_init_0 = Kotlin.kotlin.IllegalStateException_init;
  var EOFException = $module$okio_okio.okio.EOFException;
  var L1 = Kotlin.Long.ONE;
  var L4 = Kotlin.Long.fromInt(4);
  var L8 = Kotlin.Long.fromInt(8);
  var ensureNotNull = Kotlin.ensureNotNull;
  var throwCCE = Kotlin.throwCCE;
  var Long$Companion$MAX_VALUE = Kotlin.Long.MAX_VALUE;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var L_128 = Kotlin.Long.fromInt(-128);
  var L_16384 = Kotlin.Long.fromInt(-16384);
  var L_2097152 = Kotlin.Long.fromInt(-2097152);
  var L_268435456 = Kotlin.Long.fromInt(-268435456);
  var L_34359738368 = new Kotlin.Long(0, -8);
  var L_4398046511104 = new Kotlin.Long(0, -1024);
  var L_562949953421312 = new Kotlin.Long(0, -131072);
  var L_72057594037927936 = new Kotlin.Long(0, -16777216);
  var L_9223372036854775808 = Kotlin.Long.MIN_VALUE;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Annotation = Kotlin.kotlin.Annotation;
  var AbstractList = Kotlin.kotlin.collections.AbstractList;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_mqih57$;
  var RandomAccess = Kotlin.kotlin.collections.RandomAccess;
  var copyToArray = Kotlin.kotlin.collections.copyToArray;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var LinkedHashMap_init_0 = Kotlin.kotlin.collections.LinkedHashMap_init_73mtqc$;
  var List = Kotlin.kotlin.collections.List;
  var MutableMap = Kotlin.kotlin.collections.MutableMap;
  var getCallableRef = Kotlin.getCallableRef;
  var NullPointerException = Kotlin.kotlin.NullPointerException;
  var toString = Kotlin.toString;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init_1 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var mapCapacity = Kotlin.kotlin.collections.mapCapacity_za3lpa$;
  var LinkedHashMap_init_1 = Kotlin.kotlin.collections.LinkedHashMap_init_bwtc7$;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var ArrayList = Kotlin.kotlin.collections.ArrayList;
  var AbstractMutableList = Kotlin.kotlin.collections.AbstractMutableList;
  var NotImplementedError_init = Kotlin.kotlin.NotImplementedError;
  var IllegalArgumentException = Kotlin.kotlin.IllegalArgumentException;
  var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
  FieldEncoding.prototype = Object.create(Enum.prototype);
  FieldEncoding.prototype.constructor = FieldEncoding;
  MapProtoAdapter.prototype = Object.create(ProtoAdapter.prototype);
  MapProtoAdapter.prototype.constructor = MapProtoAdapter;
  MapEntryProtoAdapter.prototype = Object.create(ProtoAdapter.prototype);
  MapEntryProtoAdapter.prototype.constructor = MapEntryProtoAdapter;
  COMMON_BOOL$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
  COMMON_BOOL$ObjectLiteral.prototype.constructor = COMMON_BOOL$ObjectLiteral;
  COMMON_INT32$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
  COMMON_INT32$ObjectLiteral.prototype.constructor = COMMON_INT32$ObjectLiteral;
  COMMON_UINT32$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
  COMMON_UINT32$ObjectLiteral.prototype.constructor = COMMON_UINT32$ObjectLiteral;
  COMMON_SINT32$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
  COMMON_SINT32$ObjectLiteral.prototype.constructor = COMMON_SINT32$ObjectLiteral;
  COMMON_FIXED32$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
  COMMON_FIXED32$ObjectLiteral.prototype.constructor = COMMON_FIXED32$ObjectLiteral;
  COMMON_INT64$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
  COMMON_INT64$ObjectLiteral.prototype.constructor = COMMON_INT64$ObjectLiteral;
  COMMON_UINT64$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
  COMMON_UINT64$ObjectLiteral.prototype.constructor = COMMON_UINT64$ObjectLiteral;
  COMMON_SINT64$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
  COMMON_SINT64$ObjectLiteral.prototype.constructor = COMMON_SINT64$ObjectLiteral;
  COMMON_FIXED64$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
  COMMON_FIXED64$ObjectLiteral.prototype.constructor = COMMON_FIXED64$ObjectLiteral;
  COMMON_FLOAT$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
  COMMON_FLOAT$ObjectLiteral.prototype.constructor = COMMON_FLOAT$ObjectLiteral;
  COMMON_DOUBLE$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
  COMMON_DOUBLE$ObjectLiteral.prototype.constructor = COMMON_DOUBLE$ObjectLiteral;
  COMMON_STRING$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
  COMMON_STRING$ObjectLiteral.prototype.constructor = COMMON_STRING$ObjectLiteral;
  COMMON_BYTES$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
  COMMON_BYTES$ObjectLiteral.prototype.constructor = COMMON_BYTES$ObjectLiteral;
  WireField$Label.prototype = Object.create(Enum.prototype);
  WireField$Label.prototype.constructor = WireField$Label;
  ImmutableList.prototype = Object.create(AbstractList.prototype);
  ImmutableList.prototype.constructor = ImmutableList;
  MutableOnWriteList.prototype = Object.create(AbstractMutableList.prototype);
  MutableOnWriteList.prototype.constructor = MutableOnWriteList;
  EnumAdapter.prototype = Object.create(ProtoAdapter.prototype);
  EnumAdapter.prototype.constructor = EnumAdapter;
  ProtoAdapter$EnumConstantNotFoundException.prototype = Object.create(IllegalArgumentException.prototype);
  ProtoAdapter$EnumConstantNotFoundException.prototype.constructor = ProtoAdapter$EnumConstantNotFoundException;
  ObjectStreamException.prototype = Object.create(IOException.prototype);
  ObjectStreamException.prototype.constructor = ObjectStreamException;
  ProtocolException.prototype = Object.create(IOException.prototype);
  ProtocolException.prototype.constructor = ProtocolException;
  var commonEncodedSize = defineInlineFunction('wire-runtime.com.squareup.wire.commonEncodedSize_cehnm1$', wrapFunction(function () {
    var ProtoWriter = _.com.squareup.wire.ProtoWriter;
    return function (value) {
      return ProtoWriter.Companion.varint32Size_kcn2v3$(value.value);
    };
  }));
  var commonEncode = defineInlineFunction('wire-runtime.com.squareup.wire.commonEncode_z7348q$', function (writer, value) {
    writer.writeVarint32_za3lpa$(value.value);
  });
  var commonDecode = defineInlineFunction('wire-runtime.com.squareup.wire.commonDecode_luandb$', wrapFunction(function () {
    var ProtoAdapter$ProtoAdapter$EnumConstantNotFoundException_init = _.com.squareup.wire.ProtoAdapter.EnumConstantNotFoundException;
    return function ($receiver, reader, fromValue) {
      var tmp$;
      var value = reader.readVarint32();
      tmp$ = fromValue(value);
      if (tmp$ == null) {
        throw new ProtoAdapter$ProtoAdapter$EnumConstantNotFoundException_init(value, $receiver.type);
      }
      return tmp$;
    };
  }));
  var commonRedact = defineInlineFunction('wire-runtime.com.squareup.wire.commonRedact_cehnm1$', wrapFunction(function () {
    var UnsupportedOperationException_init = Kotlin.kotlin.UnsupportedOperationException_init;
    return function (value) {
      throw UnsupportedOperationException_init();
    };
  }));
  function FieldEncoding(name, ordinal, value) {
    Enum.call(this);
    this.value_8be2vx$ = value;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function FieldEncoding_initFields() {
    FieldEncoding_initFields = function () {
    };
    FieldEncoding$VARINT_instance = new FieldEncoding('VARINT', 0, 0);
    FieldEncoding$FIXED64_instance = new FieldEncoding('FIXED64', 1, 1);
    FieldEncoding$LENGTH_DELIMITED_instance = new FieldEncoding('LENGTH_DELIMITED', 2, 2);
    FieldEncoding$FIXED32_instance = new FieldEncoding('FIXED32', 3, 5);
    FieldEncoding$Companion_getInstance();
  }
  var FieldEncoding$VARINT_instance;
  function FieldEncoding$VARINT_getInstance() {
    FieldEncoding_initFields();
    return FieldEncoding$VARINT_instance;
  }
  var FieldEncoding$FIXED64_instance;
  function FieldEncoding$FIXED64_getInstance() {
    FieldEncoding_initFields();
    return FieldEncoding$FIXED64_instance;
  }
  var FieldEncoding$LENGTH_DELIMITED_instance;
  function FieldEncoding$LENGTH_DELIMITED_getInstance() {
    FieldEncoding_initFields();
    return FieldEncoding$LENGTH_DELIMITED_instance;
  }
  var FieldEncoding$FIXED32_instance;
  function FieldEncoding$FIXED32_getInstance() {
    FieldEncoding_initFields();
    return FieldEncoding$FIXED32_instance;
  }
  FieldEncoding.prototype.rawProtoAdapter = function () {
    switch (this.name) {
      case 'VARINT':
        return ProtoAdapter$Companion_getInstance().UINT64;
      case 'FIXED32':
        return ProtoAdapter$Companion_getInstance().FIXED32;
      case 'FIXED64':
        return ProtoAdapter$Companion_getInstance().FIXED64;
      case 'LENGTH_DELIMITED':
        return ProtoAdapter$Companion_getInstance().BYTES;
      default:return Kotlin.noWhenBranchMatched();
    }
  };
  function FieldEncoding$Companion() {
    FieldEncoding$Companion_instance = this;
  }
  FieldEncoding$Companion.prototype.get_kcn2v3$ = function (value) {
    switch (value) {
      case 0:
        return FieldEncoding$VARINT_getInstance();
      case 1:
        return FieldEncoding$FIXED64_getInstance();
      case 2:
        return FieldEncoding$LENGTH_DELIMITED_getInstance();
      case 5:
        return FieldEncoding$FIXED32_getInstance();
      default:throw new ProtocolException('Unexpected FieldEncoding: ' + value);
    }
  };
  FieldEncoding$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FieldEncoding$Companion_instance = null;
  function FieldEncoding$Companion_getInstance() {
    FieldEncoding_initFields();
    if (FieldEncoding$Companion_instance === null) {
      new FieldEncoding$Companion();
    }
    return FieldEncoding$Companion_instance;
  }
  FieldEncoding.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FieldEncoding',
    interfaces: [Enum]
  };
  function FieldEncoding$values() {
    return [FieldEncoding$VARINT_getInstance(), FieldEncoding$FIXED64_getInstance(), FieldEncoding$LENGTH_DELIMITED_getInstance(), FieldEncoding$FIXED32_getInstance()];
  }
  FieldEncoding.values = FieldEncoding$values;
  function FieldEncoding$valueOf(name) {
    switch (name) {
      case 'VARINT':
        return FieldEncoding$VARINT_getInstance();
      case 'FIXED64':
        return FieldEncoding$FIXED64_getInstance();
      case 'LENGTH_DELIMITED':
        return FieldEncoding$LENGTH_DELIMITED_getInstance();
      case 'FIXED32':
        return FieldEncoding$FIXED32_getInstance();
      default:throwISE('No enum constant com.squareup.wire.FieldEncoding.' + name);
    }
  }
  FieldEncoding.valueOf_61zpoe$ = FieldEncoding$valueOf;
  var commonEncodedSizeWithTag = defineInlineFunction('wire-runtime.com.squareup.wire.commonEncodedSizeWithTag_hge2wr$', wrapFunction(function () {
    var FieldEncoding = _.com.squareup.wire.FieldEncoding;
    var ProtoWriter = _.com.squareup.wire.ProtoWriter;
    return function ($receiver, tag, value) {
      if (value == null)
        return 0;
      var size = $receiver.encodedSize_11rb$(value);
      if ($receiver.fieldEncoding_8be2vx$ === FieldEncoding.LENGTH_DELIMITED) {
        size = size + ProtoWriter.Companion.varint32Size_kcn2v3$(size) | 0;
      }
      return size + ProtoWriter.Companion.tagSize_kcn2v3$(tag) | 0;
    };
  }));
  var commonEncodeWithTag = defineInlineFunction('wire-runtime.com.squareup.wire.commonEncodeWithTag_8upgie$', wrapFunction(function () {
    var FieldEncoding = _.com.squareup.wire.FieldEncoding;
    return function ($receiver, writer, tag, value) {
      if (value == null)
        return;
      writer.writeTag_4u0rx9$(tag, $receiver.fieldEncoding_8be2vx$);
      if ($receiver.fieldEncoding_8be2vx$ === FieldEncoding.LENGTH_DELIMITED) {
        writer.writeVarint32_za3lpa$($receiver.encodedSize_11rb$(value));
      }
      $receiver.encode_c506pi$(writer, value);
    };
  }));
  var commonEncode_0 = defineInlineFunction('wire-runtime.com.squareup.wire.commonEncode_v9m7vh$', wrapFunction(function () {
    var ProtoWriter_init = _.com.squareup.wire.ProtoWriter;
    return function ($receiver, sink, value) {
      $receiver.encode_c506pi$(new ProtoWriter_init(sink), value);
    };
  }));
  var commonEncode_1 = defineInlineFunction('wire-runtime.com.squareup.wire.commonEncode_r3am0h$', wrapFunction(function () {
    var Buffer_init = _.$$importsForInline$$['okio-okio'].okio.Buffer;
    return function ($receiver, value) {
      var buffer = new Buffer_init();
      $receiver.encode_qla68p$(buffer, value);
      return buffer.readByteArray();
    };
  }));
  var commonDecode_0 = defineInlineFunction('wire-runtime.com.squareup.wire.commonDecode_6483f1$', wrapFunction(function () {
    var Buffer_init = _.$$importsForInline$$['okio-okio'].okio.Buffer;
    return function ($receiver, bytes) {
      return $receiver.decode_q9ig0q$((new Buffer_init()).write_fqrh44$(bytes));
    };
  }));
  var commonDecode_1 = defineInlineFunction('wire-runtime.com.squareup.wire.commonDecode_fixv0w$', wrapFunction(function () {
    var Buffer_init = _.$$importsForInline$$['okio-okio'].okio.Buffer;
    return function ($receiver, bytes) {
      return $receiver.decode_q9ig0q$((new Buffer_init()).write_9ovubf$(bytes));
    };
  }));
  var commonDecode_2 = defineInlineFunction('wire-runtime.com.squareup.wire.commonDecode_aghuk1$', wrapFunction(function () {
    var ProtoReader_init = _.com.squareup.wire.ProtoReader;
    return function ($receiver, source) {
      return $receiver.decode_4lbe4r$(new ProtoReader_init(source));
    };
  }));
  var commonToString = defineInlineFunction('wire-runtime.com.squareup.wire.commonToString_41v7ql$', wrapFunction(function () {
    var toString = Kotlin.toString;
    return function (value) {
      return toString(value);
    };
  }));
  var commonWithLabel = defineInlineFunction('wire-runtime.com.squareup.wire.commonWithLabel_n4dkva$', function ($receiver, label) {
    if (label.isRepeated) {
      return label.isPacked ? $receiver.asPacked() : $receiver.asRepeated();
    }
    return $receiver;
  });
  var commonAsPacked = defineInlineFunction('wire-runtime.com.squareup.wire.commonAsPacked_vepgix$', wrapFunction(function () {
    var FieldEncoding = _.com.squareup.wire.FieldEncoding;
    var ProtoAdapter = _.com.squareup.wire.ProtoAdapter;
    var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
    var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var getKClass = Kotlin.getKClass;
    var List = Kotlin.kotlin.collections.List;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    commonCreatePacked$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
    commonCreatePacked$ObjectLiteral.prototype.constructor = commonCreatePacked$ObjectLiteral;
    function commonCreatePacked$ObjectLiteral(closure$adapter, fieldEncoding, type) {
      this.closure$adapter = closure$adapter;
      ProtoAdapter.call(this, fieldEncoding, type);
    }
    commonCreatePacked$ObjectLiteral.prototype.encodeWithTag_iosr72$ = function (writer, tag, value) {
      var tmp$ = value != null;
      if (tmp$) {
        tmp$ = !value.isEmpty();
      }
      if (tmp$) {
        ProtoAdapter.prototype.encodeWithTag_iosr72$.call(this, writer, tag, value);
      }
    };
    commonCreatePacked$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
      var tmp$;
      var size = 0;
      tmp$ = value.size;
      for (var i = 0; i < tmp$; i++) {
        size = size + this.closure$adapter.encodedSize_11rb$(value.get_za3lpa$(i)) | 0;
      }
      return size;
    };
    commonCreatePacked$ObjectLiteral.prototype.encodedSizeWithTag_wxm5ur$ = function (tag, value) {
      return value == null || value.isEmpty() ? 0 : ProtoAdapter.prototype.encodedSizeWithTag_wxm5ur$.call(this, tag, value);
    };
    commonCreatePacked$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
      var tmp$;
      tmp$ = value.size;
      for (var i = 0; i < tmp$; i++) {
        this.closure$adapter.encode_c506pi$(writer, value.get_za3lpa$(i));
      }
    };
    commonCreatePacked$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
      return listOf(this.closure$adapter.decode_4lbe4r$(reader));
    };
    commonCreatePacked$ObjectLiteral.prototype.redact_11rb$ = function (value) {
      return emptyList();
    };
    commonCreatePacked$ObjectLiteral.$metadata$ = {
      kind: Kind_CLASS,
      interfaces: [ProtoAdapter]
    };
    return function ($receiver) {
      var tmp$;
      var tmp$_0;
      if ((tmp$ = $receiver.packedAdapter_8be2vx$) != null)
        tmp$_0 = tmp$;
      else {
        if (!($receiver.fieldEncoding_8be2vx$ !== FieldEncoding.LENGTH_DELIMITED)) {
          var message = 'Unable to pack a length-delimited type.';
          throw IllegalArgumentException_init(message.toString());
        }
        var adapter = $receiver;
        var $receiver_0 = new commonCreatePacked$ObjectLiteral(adapter, FieldEncoding.LENGTH_DELIMITED, getKClass(List));
        $receiver.packedAdapter_8be2vx$ = $receiver_0;
        tmp$_0 = $receiver_0;
      }
      return tmp$_0;
    };
  }));
  var commonCreatePacked = defineInlineFunction('wire-runtime.com.squareup.wire.commonCreatePacked_vepgix$', wrapFunction(function () {
    var FieldEncoding = _.com.squareup.wire.FieldEncoding;
    var ProtoAdapter = _.com.squareup.wire.ProtoAdapter;
    var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
    var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var getKClass = Kotlin.getKClass;
    var List = Kotlin.kotlin.collections.List;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    commonCreatePacked$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
    commonCreatePacked$ObjectLiteral.prototype.constructor = commonCreatePacked$ObjectLiteral;
    function commonCreatePacked$ObjectLiteral(closure$adapter, fieldEncoding, type) {
      this.closure$adapter = closure$adapter;
      ProtoAdapter.call(this, fieldEncoding, type);
    }
    commonCreatePacked$ObjectLiteral.prototype.encodeWithTag_iosr72$ = function (writer, tag, value) {
      var tmp$ = value != null;
      if (tmp$) {
        tmp$ = !value.isEmpty();
      }
      if (tmp$) {
        ProtoAdapter.prototype.encodeWithTag_iosr72$.call(this, writer, tag, value);
      }
    };
    commonCreatePacked$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
      var tmp$;
      var size = 0;
      tmp$ = value.size;
      for (var i = 0; i < tmp$; i++) {
        size = size + this.closure$adapter.encodedSize_11rb$(value.get_za3lpa$(i)) | 0;
      }
      return size;
    };
    commonCreatePacked$ObjectLiteral.prototype.encodedSizeWithTag_wxm5ur$ = function (tag, value) {
      return value == null || value.isEmpty() ? 0 : ProtoAdapter.prototype.encodedSizeWithTag_wxm5ur$.call(this, tag, value);
    };
    commonCreatePacked$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
      var tmp$;
      tmp$ = value.size;
      for (var i = 0; i < tmp$; i++) {
        this.closure$adapter.encode_c506pi$(writer, value.get_za3lpa$(i));
      }
    };
    commonCreatePacked$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
      return listOf(this.closure$adapter.decode_4lbe4r$(reader));
    };
    commonCreatePacked$ObjectLiteral.prototype.redact_11rb$ = function (value) {
      return emptyList();
    };
    commonCreatePacked$ObjectLiteral.$metadata$ = {
      kind: Kind_CLASS,
      interfaces: [ProtoAdapter]
    };
    return function ($receiver) {
      if (!($receiver.fieldEncoding_8be2vx$ !== FieldEncoding.LENGTH_DELIMITED)) {
        var message = 'Unable to pack a length-delimited type.';
        throw IllegalArgumentException_init(message.toString());
      }
      var adapter = $receiver;
      return new commonCreatePacked$ObjectLiteral(adapter, FieldEncoding.LENGTH_DELIMITED, getKClass(List));
    };
  }));
  var commonAsRepeated = defineInlineFunction('wire-runtime.com.squareup.wire.commonAsRepeated_vepgix$', wrapFunction(function () {
    var UnsupportedOperationException_init = Kotlin.kotlin.UnsupportedOperationException_init_pdl1vj$;
    var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
    var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
    var ProtoAdapter = _.com.squareup.wire.ProtoAdapter;
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var getKClass = Kotlin.getKClass;
    var List = Kotlin.kotlin.collections.List;
    commonCreateRepeated$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
    commonCreateRepeated$ObjectLiteral.prototype.constructor = commonCreateRepeated$ObjectLiteral;
    function commonCreateRepeated$ObjectLiteral(closure$adapter, fieldEncoding, type) {
      this.closure$adapter = closure$adapter;
      ProtoAdapter.call(this, fieldEncoding, type);
    }
    commonCreateRepeated$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
      throw UnsupportedOperationException_init('Repeated values can only be sized with a tag.');
    };
    commonCreateRepeated$ObjectLiteral.prototype.encodedSizeWithTag_wxm5ur$ = function (tag, value) {
      var tmp$;
      if (value == null)
        return 0;
      var size = 0;
      tmp$ = value.size;
      for (var i = 0; i < tmp$; i++) {
        size = size + this.closure$adapter.encodedSizeWithTag_wxm5ur$(tag, value.get_za3lpa$(i)) | 0;
      }
      return size;
    };
    commonCreateRepeated$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
      throw UnsupportedOperationException_init('Repeated values can only be encoded with a tag.');
    };
    commonCreateRepeated$ObjectLiteral.prototype.encodeWithTag_iosr72$ = function (writer, tag, value) {
      var tmp$;
      if (value == null)
        return;
      tmp$ = value.size;
      for (var i = 0; i < tmp$; i++) {
        this.closure$adapter.encodeWithTag_iosr72$(writer, tag, value.get_za3lpa$(i));
      }
    };
    commonCreateRepeated$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
      return listOf(this.closure$adapter.decode_4lbe4r$(reader));
    };
    commonCreateRepeated$ObjectLiteral.prototype.redact_11rb$ = function (value) {
      return emptyList();
    };
    commonCreateRepeated$ObjectLiteral.$metadata$ = {
      kind: Kind_CLASS,
      interfaces: [ProtoAdapter]
    };
    return function ($receiver) {
      var tmp$;
      var tmp$_0;
      if ((tmp$ = $receiver.repeatedAdapter_8be2vx$) != null)
        tmp$_0 = tmp$;
      else {
        var adapter = $receiver;
        var $receiver_0 = new commonCreateRepeated$ObjectLiteral(adapter, $receiver.fieldEncoding_8be2vx$, getKClass(List));
        $receiver.repeatedAdapter_8be2vx$ = $receiver_0;
        tmp$_0 = $receiver_0;
      }
      return tmp$_0;
    };
  }));
  var commonCreateRepeated = defineInlineFunction('wire-runtime.com.squareup.wire.commonCreateRepeated_vepgix$', wrapFunction(function () {
    var UnsupportedOperationException_init = Kotlin.kotlin.UnsupportedOperationException_init_pdl1vj$;
    var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
    var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
    var ProtoAdapter = _.com.squareup.wire.ProtoAdapter;
    var Kind_CLASS = Kotlin.Kind.CLASS;
    var getKClass = Kotlin.getKClass;
    var List = Kotlin.kotlin.collections.List;
    commonCreateRepeated$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
    commonCreateRepeated$ObjectLiteral.prototype.constructor = commonCreateRepeated$ObjectLiteral;
    function commonCreateRepeated$ObjectLiteral(closure$adapter, fieldEncoding, type) {
      this.closure$adapter = closure$adapter;
      ProtoAdapter.call(this, fieldEncoding, type);
    }
    commonCreateRepeated$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
      throw UnsupportedOperationException_init('Repeated values can only be sized with a tag.');
    };
    commonCreateRepeated$ObjectLiteral.prototype.encodedSizeWithTag_wxm5ur$ = function (tag, value) {
      var tmp$;
      if (value == null)
        return 0;
      var size = 0;
      tmp$ = value.size;
      for (var i = 0; i < tmp$; i++) {
        size = size + this.closure$adapter.encodedSizeWithTag_wxm5ur$(tag, value.get_za3lpa$(i)) | 0;
      }
      return size;
    };
    commonCreateRepeated$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
      throw UnsupportedOperationException_init('Repeated values can only be encoded with a tag.');
    };
    commonCreateRepeated$ObjectLiteral.prototype.encodeWithTag_iosr72$ = function (writer, tag, value) {
      var tmp$;
      if (value == null)
        return;
      tmp$ = value.size;
      for (var i = 0; i < tmp$; i++) {
        this.closure$adapter.encodeWithTag_iosr72$(writer, tag, value.get_za3lpa$(i));
      }
    };
    commonCreateRepeated$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
      return listOf(this.closure$adapter.decode_4lbe4r$(reader));
    };
    commonCreateRepeated$ObjectLiteral.prototype.redact_11rb$ = function (value) {
      return emptyList();
    };
    commonCreateRepeated$ObjectLiteral.$metadata$ = {
      kind: Kind_CLASS,
      interfaces: [ProtoAdapter]
    };
    return function ($receiver) {
      var adapter = $receiver;
      return new commonCreateRepeated$ObjectLiteral(adapter, $receiver.fieldEncoding_8be2vx$, getKClass(List));
    };
  }));
  function MapProtoAdapter(keyAdapter, valueAdapter) {
    ProtoAdapter.call(this, FieldEncoding$LENGTH_DELIMITED_getInstance(), getKClass(Map));
    this.entryAdapter_0 = new MapEntryProtoAdapter(keyAdapter, valueAdapter);
  }
  MapProtoAdapter.prototype.encodedSize_11rb$ = function (value) {
    throw UnsupportedOperationException_init('Repeated values can only be sized with a tag.');
  };
  MapProtoAdapter.prototype.encodedSizeWithTag_wxm5ur$ = function (tag, value) {
    var tmp$;
    if (value == null)
      return 0;
    var size = 0;
    tmp$ = value.entries.iterator();
    while (tmp$.hasNext()) {
      var entry = tmp$.next();
      size = size + this.entryAdapter_0.encodedSizeWithTag_wxm5ur$(tag, entry) | 0;
    }
    return size;
  };
  MapProtoAdapter.prototype.encode_c506pi$ = function (writer, value) {
    throw UnsupportedOperationException_init('Repeated values can only be encoded with a tag.');
  };
  MapProtoAdapter.prototype.encodeWithTag_iosr72$ = function (writer, tag, value) {
    var tmp$;
    if (value == null)
      return;
    tmp$ = value.entries.iterator();
    while (tmp$.hasNext()) {
      var entry = tmp$.next();
      this.entryAdapter_0.encodeWithTag_iosr72$(writer, tag, entry);
    }
  };
  MapProtoAdapter.prototype.decode_4lbe4r$ = function (reader) {
    var key = null;
    var value = null;
    var token = reader.beginMessage();
    while (true) {
      var tag = reader.nextTag();
      if (tag === -1)
        break;
      switch (tag) {
        case 1:
          key = this.entryAdapter_0.keyAdapter_8be2vx$.decode_4lbe4r$(reader);
          break;
        case 2:
          value = this.entryAdapter_0.valueAdapter_8be2vx$.decode_4lbe4r$(reader);
          break;
      }
    }
    reader.endMessageAndGetUnknownFields_s8cxhz$(token);
    if (!(key != null)) {
      var message = 'Map entry with null key';
      throw IllegalStateException_init(message.toString());
    }
    if (!(value != null)) {
      var message_0 = 'Map entry with null value';
      throw IllegalStateException_init(message_0.toString());
    }
    return mapOf(to(key, value));
  };
  MapProtoAdapter.prototype.redact_11rb$ = function (value) {
    return emptyMap();
  };
  MapProtoAdapter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MapProtoAdapter',
    interfaces: [ProtoAdapter]
  };
  function MapEntryProtoAdapter(keyAdapter, valueAdapter) {
    ProtoAdapter.call(this, FieldEncoding$LENGTH_DELIMITED_getInstance(), getKClass(Map$Entry));
    this.keyAdapter_8be2vx$ = keyAdapter;
    this.valueAdapter_8be2vx$ = valueAdapter;
  }
  MapEntryProtoAdapter.prototype.encodedSize_11rb$ = function (value) {
    return this.keyAdapter_8be2vx$.encodedSizeWithTag_wxm5ur$(1, value.key) + this.valueAdapter_8be2vx$.encodedSizeWithTag_wxm5ur$(2, value.value) | 0;
  };
  MapEntryProtoAdapter.prototype.encode_c506pi$ = function (writer, value) {
    this.keyAdapter_8be2vx$.encodeWithTag_iosr72$(writer, 1, value.key);
    this.valueAdapter_8be2vx$.encodeWithTag_iosr72$(writer, 2, value.value);
  };
  MapEntryProtoAdapter.prototype.decode_4lbe4r$ = function (reader) {
    throw UnsupportedOperationException_init_0();
  };
  MapEntryProtoAdapter.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  MapEntryProtoAdapter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MapEntryProtoAdapter',
    interfaces: [ProtoAdapter]
  };
  var FIXED_BOOL_SIZE;
  var FIXED_32_SIZE;
  var FIXED_64_SIZE;
  var commonNewMapAdapter = defineInlineFunction('wire-runtime.com.squareup.wire.commonNewMapAdapter_64l2ob$', wrapFunction(function () {
    var MapProtoAdapter_init = _.com.squareup.wire.MapProtoAdapter;
    return function (keyAdapter, valueAdapter) {
      return new MapProtoAdapter_init(keyAdapter, valueAdapter);
    };
  }));
  function COMMON_BOOL$ObjectLiteral(fieldEncoding, type) {
    ProtoAdapter.call(this, fieldEncoding, type);
  }
  COMMON_BOOL$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
    return 1;
  };
  COMMON_BOOL$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
    writer.writeVarint32_za3lpa$(value ? 1 : 0);
  };
  COMMON_BOOL$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
    var value = reader.readVarint32();
    switch (value) {
      case 0:
        return false;
      case 1:
        return true;
      default:throw new IOException(format('Invalid boolean value 0x%02x', [value]));
    }
  };
  COMMON_BOOL$ObjectLiteral.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  COMMON_BOOL$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ProtoAdapter]
  };
  var COMMON_BOOL;
  function COMMON_INT32$ObjectLiteral(fieldEncoding, type) {
    ProtoAdapter.call(this, fieldEncoding, type);
  }
  COMMON_INT32$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
    return ProtoWriter$Companion_getInstance().int32Size_kcn2v3$(value);
  };
  COMMON_INT32$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
    writer.writeSignedVarint32_kcn2v3$(value);
  };
  COMMON_INT32$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
    return reader.readVarint32();
  };
  COMMON_INT32$ObjectLiteral.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  COMMON_INT32$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ProtoAdapter]
  };
  var COMMON_INT32;
  function COMMON_UINT32$ObjectLiteral(fieldEncoding, type) {
    ProtoAdapter.call(this, fieldEncoding, type);
  }
  COMMON_UINT32$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
    return ProtoWriter$Companion_getInstance().varint32Size_kcn2v3$(value);
  };
  COMMON_UINT32$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
    writer.writeVarint32_za3lpa$(value);
  };
  COMMON_UINT32$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
    return reader.readVarint32();
  };
  COMMON_UINT32$ObjectLiteral.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  COMMON_UINT32$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ProtoAdapter]
  };
  var COMMON_UINT32;
  function COMMON_SINT32$ObjectLiteral(fieldEncoding, type) {
    ProtoAdapter.call(this, fieldEncoding, type);
  }
  COMMON_SINT32$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
    return ProtoWriter$Companion_getInstance().varint32Size_kcn2v3$(ProtoWriter$Companion_getInstance().encodeZigZag32_kcn2v3$(value));
  };
  COMMON_SINT32$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
    writer.writeVarint32_za3lpa$(ProtoWriter$Companion_getInstance().encodeZigZag32_kcn2v3$(value));
  };
  COMMON_SINT32$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
    return ProtoWriter$Companion_getInstance().decodeZigZag32_kcn2v3$(reader.readVarint32());
  };
  COMMON_SINT32$ObjectLiteral.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  COMMON_SINT32$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ProtoAdapter]
  };
  var COMMON_SINT32;
  function COMMON_FIXED32$ObjectLiteral(fieldEncoding, type) {
    ProtoAdapter.call(this, fieldEncoding, type);
  }
  COMMON_FIXED32$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
    return 4;
  };
  COMMON_FIXED32$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
    writer.writeFixed32_za3lpa$(value);
  };
  COMMON_FIXED32$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
    return reader.readFixed32();
  };
  COMMON_FIXED32$ObjectLiteral.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  COMMON_FIXED32$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ProtoAdapter]
  };
  var COMMON_FIXED32;
  var COMMON_SFIXED32;
  function COMMON_INT64$ObjectLiteral(fieldEncoding, type) {
    ProtoAdapter.call(this, fieldEncoding, type);
  }
  COMMON_INT64$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
    return ProtoWriter$Companion_getInstance().varint64Size_8e33dg$(value);
  };
  COMMON_INT64$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
    writer.writeVarint64_s8cxhz$(value);
  };
  COMMON_INT64$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
    return reader.readVarint64();
  };
  COMMON_INT64$ObjectLiteral.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  COMMON_INT64$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ProtoAdapter]
  };
  var COMMON_INT64;
  function COMMON_UINT64$ObjectLiteral(fieldEncoding, type) {
    ProtoAdapter.call(this, fieldEncoding, type);
  }
  COMMON_UINT64$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
    return ProtoWriter$Companion_getInstance().varint64Size_8e33dg$(value);
  };
  COMMON_UINT64$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
    writer.writeVarint64_s8cxhz$(value);
  };
  COMMON_UINT64$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
    return reader.readVarint64();
  };
  COMMON_UINT64$ObjectLiteral.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  COMMON_UINT64$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ProtoAdapter]
  };
  var COMMON_UINT64;
  function COMMON_SINT64$ObjectLiteral(fieldEncoding, type) {
    ProtoAdapter.call(this, fieldEncoding, type);
  }
  COMMON_SINT64$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
    return ProtoWriter$Companion_getInstance().varint64Size_8e33dg$(ProtoWriter$Companion_getInstance().encodeZigZag64_8e33dg$(value));
  };
  COMMON_SINT64$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
    writer.writeVarint64_s8cxhz$(ProtoWriter$Companion_getInstance().encodeZigZag64_8e33dg$(value));
  };
  COMMON_SINT64$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
    return ProtoWriter$Companion_getInstance().decodeZigZag64_8e33dg$(reader.readVarint64());
  };
  COMMON_SINT64$ObjectLiteral.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  COMMON_SINT64$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ProtoAdapter]
  };
  var COMMON_SINT64;
  function COMMON_FIXED64$ObjectLiteral(fieldEncoding, type) {
    ProtoAdapter.call(this, fieldEncoding, type);
  }
  COMMON_FIXED64$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
    return 8;
  };
  COMMON_FIXED64$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
    writer.writeFixed64_s8cxhz$(value);
  };
  COMMON_FIXED64$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
    return reader.readFixed64();
  };
  COMMON_FIXED64$ObjectLiteral.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  COMMON_FIXED64$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ProtoAdapter]
  };
  var COMMON_FIXED64;
  var COMMON_SFIXED64;
  function COMMON_FLOAT$ObjectLiteral(fieldEncoding, type) {
    ProtoAdapter.call(this, fieldEncoding, type);
  }
  COMMON_FLOAT$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
    return 4;
  };
  COMMON_FLOAT$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
    writer.writeFixed32_za3lpa$(toBits(value));
  };
  COMMON_FLOAT$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
    var bits = reader.readFixed32();
    return Kotlin.floatFromBits(bits);
  };
  COMMON_FLOAT$ObjectLiteral.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  COMMON_FLOAT$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ProtoAdapter]
  };
  var COMMON_FLOAT;
  function COMMON_DOUBLE$ObjectLiteral(fieldEncoding, type) {
    ProtoAdapter.call(this, fieldEncoding, type);
  }
  COMMON_DOUBLE$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
    return 8;
  };
  COMMON_DOUBLE$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
    writer.writeFixed64_s8cxhz$(toBits_0(value));
  };
  COMMON_DOUBLE$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
    var bits = reader.readFixed64();
    return Kotlin.doubleFromBits(bits);
  };
  COMMON_DOUBLE$ObjectLiteral.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  COMMON_DOUBLE$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ProtoAdapter]
  };
  var COMMON_DOUBLE;
  function COMMON_STRING$ObjectLiteral(fieldEncoding, type) {
    ProtoAdapter.call(this, fieldEncoding, type);
  }
  COMMON_STRING$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
    return utf8Size(value).toInt();
  };
  COMMON_STRING$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
    writer.writeString_61zpoe$(value);
  };
  COMMON_STRING$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
    return reader.readString();
  };
  COMMON_STRING$ObjectLiteral.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  COMMON_STRING$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ProtoAdapter]
  };
  var COMMON_STRING;
  function COMMON_BYTES$ObjectLiteral(fieldEncoding, type) {
    ProtoAdapter.call(this, fieldEncoding, type);
  }
  COMMON_BYTES$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
    return value.size;
  };
  COMMON_BYTES$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
    writer.writeBytes_9ovubf$(value);
  };
  COMMON_BYTES$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
    return reader.readBytes();
  };
  COMMON_BYTES$ObjectLiteral.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  COMMON_BYTES$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ProtoAdapter]
  };
  var COMMON_BYTES;
  function ProtoReader(source) {
    ProtoReader$Companion_getInstance();
    this.source_0 = source;
    this.pos_0 = L0;
    this.limit_0 = Long$Companion$MAX_VALUE;
    this.recursionDepth_0 = 0;
    this.state_0 = 2;
    this.tag_0 = -1;
    this.pushedLimit_0 = L_1;
    this.nextFieldEncoding_0 = null;
    this.bufferStack_0 = ArrayList_init();
  }
  ProtoReader.prototype.beginMessage = function () {
    if (!(this.state_0 === 2)) {
      var message = 'Unexpected call to beginMessage()';
      throw IllegalStateException_init(message.toString());
    }
    if ((this.recursionDepth_0 = this.recursionDepth_0 + 1 | 0, this.recursionDepth_0) > 65) {
      throw new IOException('Wire recursion limit exceeded');
    }
    if (this.recursionDepth_0 > this.bufferStack_0.size) {
      var $receiver = this.bufferStack_0;
      var element = new Buffer();
      $receiver.add_11rb$(element);
    }
    var token = this.pushedLimit_0;
    this.pushedLimit_0 = L_1;
    this.state_0 = 6;
    return token;
  };
  ProtoReader.prototype.endMessageAndGetUnknownFields_s8cxhz$ = function (token) {
    var tmp$;
    if (!(this.state_0 === 6)) {
      var message = 'Unexpected call to endMessage()';
      throw IllegalStateException_init(message.toString());
    }
    if (!((this.recursionDepth_0 = this.recursionDepth_0 - 1 | 0, this.recursionDepth_0) >= 0 && equals(this.pushedLimit_0, L_1))) {
      var message_0 = 'No corresponding call to beginMessage()';
      throw IllegalStateException_init(message_0.toString());
    }
    if (!equals(this.pos_0, this.limit_0) && this.recursionDepth_0 !== 0) {
      throw new IOException('Expected to end at ' + this.limit_0.toString() + ' but was ' + this.pos_0.toString());
    }
    this.limit_0 = token;
    var unknownFieldsBuffer = this.bufferStack_0.get_za3lpa$(this.recursionDepth_0);
    if (unknownFieldsBuffer.size.compareTo_11rb$(L0) > 0) {
      tmp$ = unknownFieldsBuffer.readByteString();
    }
     else {
      tmp$ = ByteString.Companion.EMPTY;
    }
    return tmp$;
  };
  ProtoReader.prototype.endMessage_s8cxhz$ = function (token) {
    this.endMessageAndGetUnknownFields_s8cxhz$(token);
  };
  ProtoReader.prototype.nextTag = function () {
    if (this.state_0 === 7) {
      this.state_0 = 2;
      return this.tag_0;
    }
     else if (this.state_0 !== 6) {
      throw IllegalStateException_init('Unexpected call to nextTag()');
    }
    loop: while (this.pos_0.compareTo_11rb$(this.limit_0) < 0 && !this.source_0.exhausted()) {
      var tagAndFieldEncoding = this.internalReadVarint32_0();
      if (tagAndFieldEncoding === 0)
        throw new ProtocolException('Unexpected tag 0');
      this.tag_0 = tagAndFieldEncoding >> 3;
      var groupOrFieldEncoding = tagAndFieldEncoding & 7;
      switch (groupOrFieldEncoding) {
        case 3:
          this.skipGroup_0(this.tag_0);
          continue loop;
        case 4:
          throw new ProtocolException('Unexpected end group');
        case 2:
          this.nextFieldEncoding_0 = FieldEncoding$LENGTH_DELIMITED_getInstance();
          this.state_0 = 2;
          var length = this.internalReadVarint32_0();
          if (length < 0)
            throw new ProtocolException('Negative length: ' + length);
          if (!equals(this.pushedLimit_0, L_1))
            throw IllegalStateException_init_0();
          this.pushedLimit_0 = this.limit_0;
          this.limit_0 = this.pos_0.add(Kotlin.Long.fromInt(length));
          if (this.limit_0.compareTo_11rb$(this.pushedLimit_0) > 0)
            throw new EOFException();
          return this.tag_0;
        case 0:
          this.nextFieldEncoding_0 = FieldEncoding$VARINT_getInstance();
          this.state_0 = 0;
          return this.tag_0;
        case 1:
          this.nextFieldEncoding_0 = FieldEncoding$FIXED64_getInstance();
          this.state_0 = 1;
          return this.tag_0;
        case 5:
          this.nextFieldEncoding_0 = FieldEncoding$FIXED32_getInstance();
          this.state_0 = 5;
          return this.tag_0;
        default:throw new ProtocolException('Unexpected field encoding: ' + groupOrFieldEncoding);
      }
    }
    return -1;
  };
  ProtoReader.prototype.peekFieldEncoding = function () {
    return this.nextFieldEncoding_0;
  };
  ProtoReader.prototype.skip = function () {
    switch (this.state_0) {
      case 2:
        var byteCount = this.beforeLengthDelimitedScalar_0();
        this.source_0.skip_s8cxhz$(byteCount);
        break;
      case 0:
        this.readVarint64();
        break;
      case 1:
        this.readFixed64();
        break;
      case 5:
        this.readFixed32();
        break;
      default:throw IllegalStateException_init('Unexpected call to skip()');
    }
  };
  ProtoReader.prototype.skipGroup_0 = function (expectedEndTag) {
    while (this.pos_0.compareTo_11rb$(this.limit_0) < 0 && !this.source_0.exhausted()) {
      var tagAndFieldEncoding = this.internalReadVarint32_0();
      if (tagAndFieldEncoding === 0)
        throw new ProtocolException('Unexpected tag 0');
      var tag = tagAndFieldEncoding >> 3;
      var groupOrFieldEncoding = tagAndFieldEncoding & 7;
      switch (groupOrFieldEncoding) {
        case 3:
          this.skipGroup_0(tag);
          break;
        case 4:
          if (tag === expectedEndTag)
            return;
          throw new ProtocolException('Unexpected end group');
        case 2:
          var length = this.internalReadVarint32_0();
          this.pos_0 = this.pos_0.add(Kotlin.Long.fromInt(length));
          this.source_0.skip_s8cxhz$(Kotlin.Long.fromInt(length));
          break;
        case 0:
          this.state_0 = 0;
          this.readVarint64();
          break;
        case 1:
          this.state_0 = 1;
          this.readFixed64();
          break;
        case 5:
          this.state_0 = 5;
          this.readFixed32();
          break;
        default:throw new ProtocolException('Unexpected field encoding: ' + groupOrFieldEncoding);
      }
    }
    throw new EOFException();
  };
  ProtoReader.prototype.readBytes = function () {
    var byteCount = this.beforeLengthDelimitedScalar_0();
    this.source_0.require_s8cxhz$(byteCount);
    return this.source_0.readByteString_s8cxhz$(byteCount);
  };
  ProtoReader.prototype.readString = function () {
    var byteCount = this.beforeLengthDelimitedScalar_0();
    this.source_0.require_s8cxhz$(byteCount);
    return this.source_0.readUtf8_s8cxhz$(byteCount);
  };
  ProtoReader.prototype.readVarint32 = function () {
    if (this.state_0 !== 0 && this.state_0 !== 2) {
      throw new ProtocolException('Expected VARINT or LENGTH_DELIMITED but was ' + this.state_0);
    }
    var result = this.internalReadVarint32_0();
    this.afterPackableScalar_0(0);
    return result;
  };
  ProtoReader.prototype.internalReadVarint32_0 = function () {
    this.source_0.require_s8cxhz$(L1);
    this.pos_0 = this.pos_0.inc();
    var tmp = this.source_0.readByte();
    if (tmp >= 0) {
      return tmp;
    }
    var result = tmp & 127;
    this.source_0.require_s8cxhz$(L1);
    this.pos_0 = this.pos_0.inc();
    tmp = this.source_0.readByte();
    if (tmp >= 0) {
      result = result | tmp << 7;
    }
     else {
      result = result | (tmp & 127) << 7;
      this.source_0.require_s8cxhz$(L1);
      this.pos_0 = this.pos_0.inc();
      tmp = this.source_0.readByte();
      if (tmp >= 0) {
        result = result | tmp << 14;
      }
       else {
        result = result | (tmp & 127) << 14;
        this.source_0.require_s8cxhz$(L1);
        this.pos_0 = this.pos_0.inc();
        tmp = this.source_0.readByte();
        if (tmp >= 0) {
          result = result | tmp << 21;
        }
         else {
          result = result | (tmp & 127) << 21;
          this.source_0.require_s8cxhz$(L1);
          this.pos_0 = this.pos_0.inc();
          tmp = this.source_0.readByte();
          result = result | tmp << 28;
          if (tmp < 0) {
            for (var i = 0; i <= 4; i++) {
              this.source_0.require_s8cxhz$(L1);
              this.pos_0 = this.pos_0.inc();
              if (this.source_0.readByte() >= 0) {
                return result;
              }
            }
            throw new ProtocolException('Malformed VARINT');
          }
        }
      }
    }
    return result;
  };
  ProtoReader.prototype.readVarint64 = function () {
    if (this.state_0 !== 0 && this.state_0 !== 2) {
      throw new ProtocolException('Expected VARINT or LENGTH_DELIMITED but was ' + this.state_0);
    }
    var shift = 0;
    var result = L0;
    while (shift < 64) {
      this.source_0.require_s8cxhz$(L1);
      this.pos_0 = this.pos_0.inc();
      var b = this.source_0.readByte();
      result = result.or(Kotlin.Long.fromInt(b & 127).shiftLeft(shift));
      if ((b & 128) === 0) {
        this.afterPackableScalar_0(0);
        return result;
      }
      shift = shift + 7 | 0;
    }
    throw new ProtocolException('WireInput encountered a malformed varint');
  };
  ProtoReader.prototype.readFixed32 = function () {
    if (this.state_0 !== 5 && this.state_0 !== 2) {
      throw new ProtocolException('Expected FIXED32 or LENGTH_DELIMITED but was ' + this.state_0);
    }
    this.source_0.require_s8cxhz$(L4);
    this.pos_0 = this.pos_0.add(Kotlin.Long.fromInt(4));
    var result = this.source_0.readIntLe();
    this.afterPackableScalar_0(5);
    return result;
  };
  ProtoReader.prototype.readFixed64 = function () {
    if (this.state_0 !== 1 && this.state_0 !== 2) {
      throw new ProtocolException('Expected FIXED64 or LENGTH_DELIMITED but was ' + this.state_0);
    }
    this.source_0.require_s8cxhz$(L8);
    this.pos_0 = this.pos_0.add(Kotlin.Long.fromInt(8));
    var result = this.source_0.readLongLe();
    this.afterPackableScalar_0(1);
    return result;
  };
  ProtoReader.prototype.afterPackableScalar_0 = function (fieldEncoding) {
    if (this.state_0 === fieldEncoding) {
      this.state_0 = 6;
    }
     else {
      if (this.pos_0.compareTo_11rb$(this.limit_0) > 0)
        throw new IOException('Expected to end at ' + this.limit_0.toString() + ' but was ' + this.pos_0.toString());
      else if (equals(this.pos_0, this.limit_0)) {
        this.limit_0 = this.pushedLimit_0;
        this.pushedLimit_0 = L_1;
        this.state_0 = 6;
      }
       else
        this.state_0 = 7;
    }
  };
  ProtoReader.prototype.beforeLengthDelimitedScalar_0 = function () {
    if (this.state_0 !== 2) {
      throw new ProtocolException('Expected LENGTH_DELIMITED but was ' + this.state_0);
    }
    var byteCount = this.limit_0.subtract(this.pos_0);
    this.source_0.require_s8cxhz$(byteCount);
    this.state_0 = 6;
    this.pos_0 = this.limit_0;
    this.limit_0 = this.pushedLimit_0;
    this.pushedLimit_0 = L_1;
    return byteCount;
  };
  ProtoReader.prototype.forEachTag_ddndb5$ = defineInlineFunction('wire-runtime.com.squareup.wire.ProtoReader.forEachTag_ddndb5$', function (tagHandler) {
    var token = this.beginMessage();
    while (true) {
      var tag = this.nextTag();
      if (tag === -1)
        break;
      tagHandler(tag);
    }
    return this.endMessageAndGetUnknownFields_s8cxhz$(token);
  });
  ProtoReader.prototype.readUnknownField_za3lpa$ = function (tag) {
    var tmp$;
    var unknownFieldsWriter = new ProtoWriter(this.bufferStack_0.get_za3lpa$(this.recursionDepth_0 - 1 | 0));
    var fieldEncoding = this.peekFieldEncoding();
    var protoAdapter = ensureNotNull(fieldEncoding).rawProtoAdapter();
    var value = protoAdapter.decode_4lbe4r$(this);
    (Kotlin.isType(tmp$ = protoAdapter, ProtoAdapter) ? tmp$ : throwCCE()).encodeWithTag_iosr72$(unknownFieldsWriter, tag, value);
  };
  function ProtoReader$Companion() {
    ProtoReader$Companion_instance = this;
    this.RECURSION_LIMIT_0 = 65;
    this.FIELD_ENCODING_MASK_0 = 7;
    this.TAG_FIELD_ENCODING_BITS_8be2vx$ = 3;
    this.STATE_VARINT_0 = 0;
    this.STATE_FIXED64_0 = 1;
    this.STATE_LENGTH_DELIMITED_0 = 2;
    this.STATE_START_GROUP_0 = 3;
    this.STATE_END_GROUP_0 = 4;
    this.STATE_FIXED32_0 = 5;
    this.STATE_TAG_0 = 6;
    this.STATE_PACKED_TAG_0 = 7;
  }
  ProtoReader$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ProtoReader$Companion_instance = null;
  function ProtoReader$Companion_getInstance() {
    if (ProtoReader$Companion_instance === null) {
      new ProtoReader$Companion();
    }
    return ProtoReader$Companion_instance;
  }
  ProtoReader.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ProtoReader',
    interfaces: []
  };
  function ProtoWriter(sink) {
    ProtoWriter$Companion_getInstance();
    this.sink_0 = sink;
  }
  ProtoWriter.prototype.writeBytes_9ovubf$ = function (value) {
    this.sink_0.write_9ovubf$(value);
  };
  ProtoWriter.prototype.writeString_61zpoe$ = function (value) {
    this.sink_0.writeUtf8_61zpoe$(value);
  };
  ProtoWriter.prototype.writeTag_4u0rx9$ = function (fieldNumber, fieldEncoding) {
    this.writeVarint32_za3lpa$(ProtoWriter$Companion_getInstance().makeTag_0(fieldNumber, fieldEncoding));
  };
  ProtoWriter.prototype.writeSignedVarint32_kcn2v3$ = function (value) {
    if (value >= 0) {
      this.writeVarint32_za3lpa$(value);
    }
     else {
      this.writeVarint64_s8cxhz$(Kotlin.Long.fromInt(value));
    }
  };
  ProtoWriter.prototype.writeVarint32_za3lpa$ = function (value) {
    var value_0 = value;
    while ((value_0 & -128) !== 0) {
      this.sink_0.writeByte_za3lpa$(value_0 & 127 | 128);
      value_0 = value_0 >>> 7;
    }
    this.sink_0.writeByte_za3lpa$(value_0);
  };
  ProtoWriter.prototype.writeVarint64_s8cxhz$ = function (value) {
    var value_0 = value;
    while (!equals(value_0.and(L_128), L0)) {
      this.sink_0.writeByte_za3lpa$(value_0.toInt() & 127 | 128);
      value_0 = value_0.shiftRightUnsigned(7);
    }
    this.sink_0.writeByte_za3lpa$(value_0.toInt());
  };
  ProtoWriter.prototype.writeFixed32_za3lpa$ = function (value) {
    this.sink_0.writeIntLe_za3lpa$(value);
  };
  ProtoWriter.prototype.writeFixed64_s8cxhz$ = function (value) {
    this.sink_0.writeLongLe_s8cxhz$(value);
  };
  function ProtoWriter$Companion() {
    ProtoWriter$Companion_instance = this;
  }
  ProtoWriter$Companion.prototype.makeTag_0 = function (fieldNumber, fieldEncoding) {
    return fieldNumber << 3 | fieldEncoding.value_8be2vx$;
  };
  ProtoWriter$Companion.prototype.tagSize_kcn2v3$ = function (tag) {
    return this.varint32Size_kcn2v3$(this.makeTag_0(tag, FieldEncoding$VARINT_getInstance()));
  };
  ProtoWriter$Companion.prototype.int32Size_kcn2v3$ = function (value) {
    var tmp$;
    if (value >= 0) {
      tmp$ = this.varint32Size_kcn2v3$(value);
    }
     else {
      tmp$ = 10;
    }
    return tmp$;
  };
  ProtoWriter$Companion.prototype.varint32Size_kcn2v3$ = function (value) {
    if ((value & -128) === 0)
      return 1;
    if ((value & -16384) === 0)
      return 2;
    if ((value & -2097152) === 0)
      return 3;
    return (value & -268435456) === 0 ? 4 : 5;
  };
  ProtoWriter$Companion.prototype.varint64Size_8e33dg$ = function (value) {
    if (equals(value.and(L_128), L0))
      return 1;
    if (equals(value.and(L_16384), L0))
      return 2;
    if (equals(value.and(L_2097152), L0))
      return 3;
    if (equals(value.and(L_268435456), L0))
      return 4;
    if (equals(value.and(L_34359738368), L0))
      return 5;
    if (equals(value.and(L_4398046511104), L0))
      return 6;
    if (equals(value.and(L_562949953421312), L0))
      return 7;
    if (equals(value.and(L_72057594037927936), L0))
      return 8;
    return equals(value.and(L_9223372036854775808), L0) ? 9 : 10;
  };
  ProtoWriter$Companion.prototype.encodeZigZag32_kcn2v3$ = function (n) {
    return n << 1 ^ n >> 31;
  };
  ProtoWriter$Companion.prototype.decodeZigZag32_kcn2v3$ = function (n) {
    return n >>> 1 ^ (-(n & 1) | 0);
  };
  ProtoWriter$Companion.prototype.encodeZigZag64_8e33dg$ = function (n) {
    return n.shiftLeft(1).xor(n.shiftRight(63));
  };
  ProtoWriter$Companion.prototype.decodeZigZag64_8e33dg$ = function (n) {
    return n.shiftRightUnsigned(1).xor(n.and(L1).unaryMinus());
  };
  ProtoWriter$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ProtoWriter$Companion_instance = null;
  function ProtoWriter$Companion_getInstance() {
    if (ProtoWriter$Companion_instance === null) {
      new ProtoWriter$Companion();
    }
    return ProtoWriter$Companion_instance;
  }
  ProtoWriter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ProtoWriter',
    interfaces: []
  };
  function Service() {
  }
  Service.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Service',
    interfaces: []
  };
  function WireEnum() {
  }
  WireEnum.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'WireEnum',
    interfaces: []
  };
  function WireField(tag, keyAdapter, adapter, label, redacted) {
    if (keyAdapter === void 0)
      keyAdapter = '';
    if (label === void 0)
      label = WireField$Label$OPTIONAL_getInstance();
    if (redacted === void 0)
      redacted = false;
    this.tag = tag;
    this.keyAdapter = keyAdapter;
    this.adapter = adapter;
    this.label = label;
    this.redacted = redacted;
  }
  function WireField$Label(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function WireField$Label_initFields() {
    WireField$Label_initFields = function () {
    };
    WireField$Label$REQUIRED_instance = new WireField$Label('REQUIRED', 0);
    WireField$Label$OPTIONAL_instance = new WireField$Label('OPTIONAL', 1);
    WireField$Label$REPEATED_instance = new WireField$Label('REPEATED', 2);
    WireField$Label$ONE_OF_instance = new WireField$Label('ONE_OF', 3);
    WireField$Label$PACKED_instance = new WireField$Label('PACKED', 4);
  }
  var WireField$Label$REQUIRED_instance;
  function WireField$Label$REQUIRED_getInstance() {
    WireField$Label_initFields();
    return WireField$Label$REQUIRED_instance;
  }
  var WireField$Label$OPTIONAL_instance;
  function WireField$Label$OPTIONAL_getInstance() {
    WireField$Label_initFields();
    return WireField$Label$OPTIONAL_instance;
  }
  var WireField$Label$REPEATED_instance;
  function WireField$Label$REPEATED_getInstance() {
    WireField$Label_initFields();
    return WireField$Label$REPEATED_instance;
  }
  var WireField$Label$ONE_OF_instance;
  function WireField$Label$ONE_OF_getInstance() {
    WireField$Label_initFields();
    return WireField$Label$ONE_OF_instance;
  }
  var WireField$Label$PACKED_instance;
  function WireField$Label$PACKED_getInstance() {
    WireField$Label_initFields();
    return WireField$Label$PACKED_instance;
  }
  Object.defineProperty(WireField$Label.prototype, 'isRepeated', {
    get: function () {
      return this === WireField$Label$REPEATED_getInstance() || this === WireField$Label$PACKED_getInstance();
    }
  });
  Object.defineProperty(WireField$Label.prototype, 'isPacked', {
    get: function () {
      return this === WireField$Label$PACKED_getInstance();
    }
  });
  Object.defineProperty(WireField$Label.prototype, 'isOneOf', {
    get: function () {
      return this === WireField$Label$ONE_OF_getInstance();
    }
  });
  WireField$Label.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Label',
    interfaces: [Enum]
  };
  function WireField$Label$values() {
    return [WireField$Label$REQUIRED_getInstance(), WireField$Label$OPTIONAL_getInstance(), WireField$Label$REPEATED_getInstance(), WireField$Label$ONE_OF_getInstance(), WireField$Label$PACKED_getInstance()];
  }
  WireField$Label.values = WireField$Label$values;
  function WireField$Label$valueOf(name) {
    switch (name) {
      case 'REQUIRED':
        return WireField$Label$REQUIRED_getInstance();
      case 'OPTIONAL':
        return WireField$Label$OPTIONAL_getInstance();
      case 'REPEATED':
        return WireField$Label$REPEATED_getInstance();
      case 'ONE_OF':
        return WireField$Label$ONE_OF_getInstance();
      case 'PACKED':
        return WireField$Label$PACKED_getInstance();
      default:throwISE('No enum constant com.squareup.wire.WireField.Label.' + name);
    }
  }
  WireField$Label.valueOf_61zpoe$ = WireField$Label$valueOf;
  WireField.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WireField',
    interfaces: [Annotation]
  };
  function WireRpc(path, requestAdapter, responseAdapter) {
    this.path = path;
    this.requestAdapter = requestAdapter;
    this.responseAdapter = responseAdapter;
  }
  WireRpc.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'WireRpc',
    interfaces: [Annotation]
  };
  function ImmutableList(list) {
    AbstractList.call(this);
    this.list_0 = ArrayList_init_0(list);
  }
  Object.defineProperty(ImmutableList.prototype, 'size', {
    get: function () {
      return this.list_0.size;
    }
  });
  ImmutableList.prototype.get_za3lpa$ = function (index) {
    return this.list_0.get_za3lpa$(index);
  };
  ImmutableList.prototype.toArray = function () {
    return copyToArray(this.list_0);
  };
  ImmutableList.prototype.writeReplace_0 = function () {
    return this.list_0;
  };
  ImmutableList.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ImmutableList',
    interfaces: [Serializable, RandomAccess, AbstractList]
  };
  function newMutableList() {
    return new MutableOnWriteList(emptyList());
  }
  function newMutableMap() {
    return LinkedHashMap_init();
  }
  function copyOf(name, list) {
    return copyOf_0(ensureNotNull(list));
  }
  function copyOf_0(list) {
    var tmp$;
    if (list === emptyList() || Kotlin.isType(list, ImmutableList)) {
      tmp$ = new MutableOnWriteList(list);
    }
     else {
      tmp$ = ArrayList_init_0(list);
    }
    return tmp$;
  }
  function copyOf_1(name, map) {
    return copyOf_2(ensureNotNull(map));
  }
  function copyOf_2(map) {
    return LinkedHashMap_init_0(map);
  }
  function immutableCopyOf(name, list) {
    var tmp$, tmp$_0;
    var list_0 = list;
    if (Kotlin.isType(list_0, MutableOnWriteList)) {
      list_0 = (Kotlin.isType(tmp$ = list_0, MutableOnWriteList) ? tmp$ : throwCCE()).mutableList_8be2vx$;
    }
    if (list_0 === emptyList() || Kotlin.isType(list_0, ImmutableList)) {
      return list_0;
    }
    var result = new ImmutableList(list_0);
    if (!!result.contains_11rb$(null)) {
      var message = name + '.contains(null)';
      throw IllegalArgumentException_init(message.toString());
    }
    return Kotlin.isType(tmp$_0 = result, List) ? tmp$_0 : throwCCE();
  }
  function immutableCopyOf_0(name, map) {
    var tmp$;
    if (map.isEmpty()) {
      return emptyMap();
    }
    var result = LinkedHashMap_init_0(map);
    if (!!result.keys.contains_11rb$(null)) {
      var message = name + '.containsKey(null)';
      throw IllegalArgumentException_init(message.toString());
    }
    if (!!result.values.contains_11rb$(null)) {
      var message_0 = name + '.containsValue(null)';
      throw IllegalArgumentException_init(message_0.toString());
    }
    return Kotlin.isType(tmp$ = result, MutableMap) ? tmp$ : throwCCE();
  }
  function redactElements($receiver, adapter) {
    var transform = getCallableRef('redact', function ($receiver, value) {
      return $receiver.redact_11rb$(value);
    }.bind(null, adapter));
    var destination = ArrayList_init_1(collectionSizeOrDefault($receiver, 10));
    var tmp$;
    tmp$ = $receiver.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(transform(item));
    }
    return destination;
  }
  function redactElements_0($receiver, adapter) {
    var destination = LinkedHashMap_init_1(mapCapacity($receiver.size));
    var tmp$;
    tmp$ = $receiver.entries.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0 = destination.put_xwzc9p$;
      var tmp$_1 = element.key;
      var value = element.value;
      tmp$_0.call(destination, tmp$_1, adapter.redact_11rb$(value));
    }
    return destination;
  }
  function equals_0(a, b) {
    return a === b || (a != null && equals(a, b));
  }
  function missingRequiredFields(args) {
    var plural = {v: ''};
    var $receiver = StringBuilder_init();
    for (var i = 0; i < args.length; i += 2) {
      if (args[i] == null) {
        if ($receiver.length > 0) {
          plural.v = 's';
        }
        $receiver.append_gw00v9$('\n  ');
        $receiver.append_s8jyv4$(args[i + 1 | 0]);
      }
    }
    var fields = $receiver.toString();
    throw IllegalStateException_init('Required field' + plural.v + ' not set:' + fields);
  }
  function checkElementsNotNull(list) {
    var tmp$;
    tmp$ = list.size;
    for (var i = 0; i < tmp$; i++) {
      if (list.get_za3lpa$(i) == null) {
        throw new NullPointerException('Element at index ' + i + ' is null');
      }
    }
  }
  function checkElementsNotNull_0(map) {
    var tmp$;
    tmp$ = map.entries.iterator();
    while (tmp$.hasNext()) {
      var tmp$_0 = tmp$.next();
      var key = tmp$_0.key;
      var value = tmp$_0.value;
      if (key == null) {
        throw new NullPointerException('map.containsKey(null)');
      }
      if (value == null) {
        throw new NullPointerException('Value for key ' + toString(key) + ' is null');
      }
    }
  }
  function countNonNull(a, b) {
    return (a != null ? 1 : 0) + (b != null ? 1 : 0) | 0;
  }
  function countNonNull_0(a, b, c) {
    return (a != null ? 1 : 0) + (b != null ? 1 : 0) + (c != null ? 1 : 0) | 0;
  }
  function countNonNull_1(a, b, c, d, rest) {
    var tmp$;
    var result = 0;
    if (a != null) {
      result = result + 1 | 0;
    }
    if (b != null) {
      result = result + 1 | 0;
    }
    if (c != null) {
      result = result + 1 | 0;
    }
    if (d != null) {
      result = result + 1 | 0;
    }
    for (tmp$ = 0; tmp$ !== rest.length; ++tmp$) {
      var o = rest[tmp$];
      if (o != null) {
        result = result + 1 | 0;
      }
    }
    return result;
  }
  function MutableOnWriteList(immutableList) {
    AbstractMutableList.call(this);
    this.immutableList_0 = immutableList;
    this.mutableList_8be2vx$ = this.immutableList_0;
  }
  MutableOnWriteList.prototype.get_za3lpa$ = function (index) {
    return this.mutableList_8be2vx$.get_za3lpa$(index);
  };
  Object.defineProperty(MutableOnWriteList.prototype, 'size', {
    get: function () {
      return this.mutableList_8be2vx$.size;
    }
  });
  MutableOnWriteList.prototype.set_wxm5ur$ = function (index, element) {
    var tmp$;
    if (this.mutableList_8be2vx$ === this.immutableList_0) {
      this.mutableList_8be2vx$ = ArrayList_init_0(this.immutableList_0);
    }
    return (Kotlin.isType(tmp$ = this.mutableList_8be2vx$, ArrayList) ? tmp$ : throwCCE()).set_wxm5ur$(index, element);
  };
  MutableOnWriteList.prototype.add_wxm5ur$ = function (index, element) {
    var tmp$;
    if (this.mutableList_8be2vx$ === this.immutableList_0) {
      this.mutableList_8be2vx$ = ArrayList_init_0(this.immutableList_0);
    }
    (Kotlin.isType(tmp$ = this.mutableList_8be2vx$, ArrayList) ? tmp$ : throwCCE()).add_wxm5ur$(index, element);
  };
  MutableOnWriteList.prototype.removeAt_za3lpa$ = function (index) {
    var tmp$;
    if (this.mutableList_8be2vx$ === this.immutableList_0) {
      this.mutableList_8be2vx$ = ArrayList_init_0(this.immutableList_0);
    }
    return (Kotlin.isType(tmp$ = this.mutableList_8be2vx$, ArrayList) ? tmp$ : throwCCE()).removeAt_za3lpa$(index);
  };
  MutableOnWriteList.prototype.writeReplace_0 = function () {
    return ArrayList_init_0(this.mutableList_8be2vx$);
  };
  MutableOnWriteList.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MutableOnWriteList',
    interfaces: [Serializable, RandomAccess, AbstractMutableList]
  };
  var and = defineInlineFunction('wire-runtime.com.squareup.wire.internal.and_g525uh$', function ($receiver, other) {
    return $receiver & other;
  });
  var shl = defineInlineFunction('wire-runtime.com.squareup.wire.internal.shl_g525uh$', function ($receiver, other) {
    return $receiver << other;
  });
  function EnumAdapter(type) {
    ProtoAdapter.call(this, FieldEncoding$VARINT_getInstance(), type);
  }
  EnumAdapter.prototype.encodedSize_11rb$ = function (value) {
    return ProtoWriter.Companion.varint32Size_kcn2v3$(value.value);
  };
  EnumAdapter.prototype.encode_c506pi$ = function (writer, value) {
    writer.writeVarint32_za3lpa$(value.value);
  };
  EnumAdapter.prototype.decode_4lbe4r$ = function (reader) {
    var fromValue = getCallableRef('fromValue', function ($receiver, value) {
      return $receiver.fromValue_za3lpa$(value);
    }.bind(null, this));
    var tmp$;
    var value = reader.readVarint32();
    tmp$ = fromValue(value);
    if (tmp$ == null) {
      throw new ProtoAdapter$EnumConstantNotFoundException(value, this.type);
    }
    return tmp$;
  };
  EnumAdapter.prototype.redact_11rb$ = function (value) {
    throw UnsupportedOperationException_init_0();
  };
  EnumAdapter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EnumAdapter',
    interfaces: [ProtoAdapter]
  };
  function Message(adapter, unknownFields) {
    this.adapter = adapter;
    this.unknownFields = unknownFields;
    this.cachedHashCode = 0;
  }
  Message.prototype.withoutUnknownFields = function () {
    throw new NotImplementedError_init();
  };
  Message.prototype.encode_ttbp7m$ = function (sink) {
    var tmp$;
    this.adapter.encode_qla68p$(sink, Kotlin.isType(tmp$ = this, Message) ? tmp$ : throwCCE());
  };
  Message.prototype.encode = function () {
    var tmp$;
    return this.adapter.encode_11rb$(Kotlin.isType(tmp$ = this, Message) ? tmp$ : throwCCE());
  };
  function Message$Builder() {
  }
  Message$Builder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Builder',
    interfaces: []
  };
  Message.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Message',
    interfaces: []
  };
  function MessageSink() {
  }
  MessageSink.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MessageSink',
    interfaces: []
  };
  function MessageSource() {
  }
  MessageSource.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MessageSource',
    interfaces: []
  };
  commonCreatePacked$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
  commonCreatePacked$ObjectLiteral.prototype.constructor = commonCreatePacked$ObjectLiteral;
  function commonCreatePacked$ObjectLiteral(closure$adapter, fieldEncoding, type) {
    this.closure$adapter = closure$adapter;
    ProtoAdapter.call(this, fieldEncoding, type);
  }
  commonCreatePacked$ObjectLiteral.prototype.encodeWithTag_iosr72$ = function (writer, tag, value) {
    var tmp$ = value != null;
    if (tmp$) {
      tmp$ = !value.isEmpty();
    }
    if (tmp$) {
      ProtoAdapter.prototype.encodeWithTag_iosr72$.call(this, writer, tag, value);
    }
  };
  commonCreatePacked$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
    var tmp$;
    var size = 0;
    tmp$ = value.size;
    for (var i = 0; i < tmp$; i++) {
      size = size + this.closure$adapter.encodedSize_11rb$(value.get_za3lpa$(i)) | 0;
    }
    return size;
  };
  commonCreatePacked$ObjectLiteral.prototype.encodedSizeWithTag_wxm5ur$ = function (tag, value) {
    return value == null || value.isEmpty() ? 0 : ProtoAdapter.prototype.encodedSizeWithTag_wxm5ur$.call(this, tag, value);
  };
  commonCreatePacked$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
    var tmp$;
    tmp$ = value.size;
    for (var i = 0; i < tmp$; i++) {
      this.closure$adapter.encode_c506pi$(writer, value.get_za3lpa$(i));
    }
  };
  commonCreatePacked$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
    return listOf(this.closure$adapter.decode_4lbe4r$(reader));
  };
  commonCreatePacked$ObjectLiteral.prototype.redact_11rb$ = function (value) {
    return emptyList();
  };
  commonCreatePacked$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ProtoAdapter]
  };
  commonCreateRepeated$ObjectLiteral.prototype = Object.create(ProtoAdapter.prototype);
  commonCreateRepeated$ObjectLiteral.prototype.constructor = commonCreateRepeated$ObjectLiteral;
  function commonCreateRepeated$ObjectLiteral(closure$adapter, fieldEncoding, type) {
    this.closure$adapter = closure$adapter;
    ProtoAdapter.call(this, fieldEncoding, type);
  }
  commonCreateRepeated$ObjectLiteral.prototype.encodedSize_11rb$ = function (value) {
    throw UnsupportedOperationException_init('Repeated values can only be sized with a tag.');
  };
  commonCreateRepeated$ObjectLiteral.prototype.encodedSizeWithTag_wxm5ur$ = function (tag, value) {
    var tmp$;
    if (value == null)
      return 0;
    var size = 0;
    tmp$ = value.size;
    for (var i = 0; i < tmp$; i++) {
      size = size + this.closure$adapter.encodedSizeWithTag_wxm5ur$(tag, value.get_za3lpa$(i)) | 0;
    }
    return size;
  };
  commonCreateRepeated$ObjectLiteral.prototype.encode_c506pi$ = function (writer, value) {
    throw UnsupportedOperationException_init('Repeated values can only be encoded with a tag.');
  };
  commonCreateRepeated$ObjectLiteral.prototype.encodeWithTag_iosr72$ = function (writer, tag, value) {
    var tmp$;
    if (value == null)
      return;
    tmp$ = value.size;
    for (var i = 0; i < tmp$; i++) {
      this.closure$adapter.encodeWithTag_iosr72$(writer, tag, value.get_za3lpa$(i));
    }
  };
  commonCreateRepeated$ObjectLiteral.prototype.decode_4lbe4r$ = function (reader) {
    return listOf(this.closure$adapter.decode_4lbe4r$(reader));
  };
  commonCreateRepeated$ObjectLiteral.prototype.redact_11rb$ = function (value) {
    return emptyList();
  };
  commonCreateRepeated$ObjectLiteral.$metadata$ = {
    kind: Kind_CLASS,
    interfaces: [ProtoAdapter]
  };
  function ProtoAdapter(fieldEncoding, type) {
    ProtoAdapter$Companion_getInstance();
    this.fieldEncoding_8be2vx$ = fieldEncoding;
    this.type = type;
    this.packedAdapter_8be2vx$ = null;
    this.repeatedAdapter_8be2vx$ = null;
  }
  ProtoAdapter.prototype.encodedSizeWithTag_wxm5ur$ = function (tag, value) {
    var commonEncodedSizeWithTag$result;
    commonEncodedSizeWithTag$break: do {
      if (value == null) {
        commonEncodedSizeWithTag$result = 0;
        break commonEncodedSizeWithTag$break;
      }
      var size = this.encodedSize_11rb$(value);
      if (this.fieldEncoding_8be2vx$ === FieldEncoding.LENGTH_DELIMITED) {
        size = size + ProtoWriter.Companion.varint32Size_kcn2v3$(size) | 0;
      }
      commonEncodedSizeWithTag$result = size + ProtoWriter.Companion.tagSize_kcn2v3$(tag) | 0;
    }
     while (false);
    return commonEncodedSizeWithTag$result;
  };
  ProtoAdapter.prototype.encodeWithTag_iosr72$ = function (writer, tag, value) {
    commonEncodeWithTag$break: do {
      if (value == null)
        break commonEncodeWithTag$break;
      writer.writeTag_4u0rx9$(tag, this.fieldEncoding_8be2vx$);
      if (this.fieldEncoding_8be2vx$ === FieldEncoding.LENGTH_DELIMITED) {
        writer.writeVarint32_za3lpa$(this.encodedSize_11rb$(value));
      }
      this.encode_c506pi$(writer, value);
    }
     while (false);
  };
  ProtoAdapter.prototype.encode_qla68p$ = function (sink, value) {
    this.encode_c506pi$(new ProtoWriter(sink), value);
  };
  ProtoAdapter.prototype.encode_11rb$ = function (value) {
    var buffer = new Buffer();
    this.encode_qla68p$(buffer, value);
    return buffer.readByteArray();
  };
  ProtoAdapter.prototype.decode_fqrh44$ = function (bytes) {
    return this.decode_q9ig0q$((new Buffer()).write_fqrh44$(bytes));
  };
  ProtoAdapter.prototype.decode_9ovubf$ = function (bytes) {
    return this.decode_q9ig0q$((new Buffer()).write_9ovubf$(bytes));
  };
  ProtoAdapter.prototype.decode_q9ig0q$ = function (source) {
    return this.decode_4lbe4r$(new ProtoReader(source));
  };
  ProtoAdapter.prototype.toString_11rb$ = function (value) {
    return toString(value);
  };
  ProtoAdapter.prototype.withLabel_n7wgde$ = function (label) {
    var commonWithLabel$result;
    commonWithLabel$break: do {
      if (label.isRepeated) {
        commonWithLabel$result = label.isPacked ? this.asPacked() : this.asRepeated();
        break commonWithLabel$break;
      }
      commonWithLabel$result = this;
    }
     while (false);
    return commonWithLabel$result;
  };
  ProtoAdapter.prototype.asPacked = function () {
    var tmp$;
    var tmp$_0;
    if ((tmp$ = this.packedAdapter_8be2vx$) != null)
      tmp$_0 = tmp$;
    else {
      if (!(this.fieldEncoding_8be2vx$ !== FieldEncoding.LENGTH_DELIMITED)) {
        var message = 'Unable to pack a length-delimited type.';
        throw IllegalArgumentException_init(message.toString());
      }
      var adapter = this;
      var $receiver = new commonCreatePacked$ObjectLiteral(adapter, FieldEncoding.LENGTH_DELIMITED, getKClass(List));
      this.packedAdapter_8be2vx$ = $receiver;
      tmp$_0 = $receiver;
    }
    return tmp$_0;
  };
  ProtoAdapter.prototype.asRepeated = function () {
    var tmp$;
    var tmp$_0;
    if ((tmp$ = this.repeatedAdapter_8be2vx$) != null)
      tmp$_0 = tmp$;
    else {
      var adapter = this;
      var $receiver = new commonCreateRepeated$ObjectLiteral(adapter, this.fieldEncoding_8be2vx$, getKClass(List));
      this.repeatedAdapter_8be2vx$ = $receiver;
      tmp$_0 = $receiver;
    }
    return tmp$_0;
  };
  function ProtoAdapter$EnumConstantNotFoundException(value, type) {
    IllegalArgumentException_init('Unknown enum tag ' + value + ' for ' + toString(type != null ? type.simpleName : null), this);
    this.value = value;
    this.name = 'ProtoAdapter$EnumConstantNotFoundException';
  }
  ProtoAdapter$EnumConstantNotFoundException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EnumConstantNotFoundException',
    interfaces: [IllegalArgumentException]
  };
  function ProtoAdapter$Companion() {
    ProtoAdapter$Companion_instance = this;
    this.BOOL = COMMON_BOOL;
    this.INT32 = COMMON_INT32;
    this.UINT32 = COMMON_UINT32;
    this.SINT32 = COMMON_SINT32;
    this.FIXED32 = COMMON_FIXED32;
    this.SFIXED32 = COMMON_SFIXED32;
    this.INT64 = COMMON_INT64;
    this.UINT64 = COMMON_UINT64;
    this.SINT64 = COMMON_SINT64;
    this.FIXED64 = COMMON_FIXED64;
    this.SFIXED64 = COMMON_SFIXED64;
    this.FLOAT = COMMON_FLOAT;
    this.DOUBLE = COMMON_DOUBLE;
    this.BYTES = COMMON_BYTES;
    this.STRING = COMMON_STRING;
  }
  ProtoAdapter$Companion.prototype.newMapAdapter_ii0m42$ = function (keyAdapter, valueAdapter) {
    return new MapProtoAdapter(keyAdapter, valueAdapter);
  };
  ProtoAdapter$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ProtoAdapter$Companion_instance = null;
  function ProtoAdapter$Companion_getInstance() {
    if (ProtoAdapter$Companion_instance === null) {
      new ProtoAdapter$Companion();
    }
    return ProtoAdapter$Companion_instance;
  }
  ProtoAdapter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ProtoAdapter',
    interfaces: []
  };
  function Serializable() {
  }
  Serializable.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Serializable',
    interfaces: []
  };
  function ObjectStreamException() {
    IOException.call(this);
    this.name = 'ObjectStreamException';
  }
  ObjectStreamException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ObjectStreamException',
    interfaces: [IOException]
  };
  function ProtocolException(host) {
    IOException.call(this);
    this.name = 'ProtocolException';
  }
  ProtocolException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ProtocolException',
    interfaces: [IOException]
  };
  var toUnmodifiableList = defineInlineFunction('wire-runtime.com.squareup.wire.internal.toUnmodifiableList_vvxzk3$', function ($receiver) {
    return $receiver;
  });
  var toUnmodifiableMap = defineInlineFunction('wire-runtime.com.squareup.wire.internal.toUnmodifiableMap_5rvit3$', function ($receiver) {
    return $receiver;
  });
  function format($receiver, args) {
    throw new NotImplementedError_init('An operation is not implemented: ' + 'Not implemented');
  }
  var package$com = _.com || (_.com = {});
  var package$squareup = package$com.squareup || (package$com.squareup = {});
  var package$wire = package$squareup.wire || (package$squareup.wire = {});
  package$wire.ProtoWriter = ProtoWriter;
  package$wire.commonEncodedSize_cehnm1$ = commonEncodedSize;
  package$wire.commonEncode_z7348q$ = commonEncode;
  $$importsForInline$$['wire-runtime'] = _;
  package$wire.ProtoAdapter = ProtoAdapter;
  package$wire.commonDecode_luandb$ = commonDecode;
  package$wire.commonRedact_cehnm1$ = commonRedact;
  Object.defineProperty(FieldEncoding, 'VARINT', {
    get: FieldEncoding$VARINT_getInstance
  });
  Object.defineProperty(FieldEncoding, 'FIXED64', {
    get: FieldEncoding$FIXED64_getInstance
  });
  Object.defineProperty(FieldEncoding, 'LENGTH_DELIMITED', {
    get: FieldEncoding$LENGTH_DELIMITED_getInstance
  });
  Object.defineProperty(FieldEncoding, 'FIXED32', {
    get: FieldEncoding$FIXED32_getInstance
  });
  Object.defineProperty(FieldEncoding, 'Companion', {
    get: FieldEncoding$Companion_getInstance
  });
  package$wire.FieldEncoding = FieldEncoding;
  package$wire.commonEncodedSizeWithTag_hge2wr$ = commonEncodedSizeWithTag;
  package$wire.commonEncodeWithTag_8upgie$ = commonEncodeWithTag;
  package$wire.commonEncode_v9m7vh$ = commonEncode_0;
  $$importsForInline$$['okio-okio'] = $module$okio_okio;
  package$wire.commonEncode_r3am0h$ = commonEncode_1;
  package$wire.commonDecode_6483f1$ = commonDecode_0;
  package$wire.commonDecode_fixv0w$ = commonDecode_1;
  package$wire.commonDecode_aghuk1$ = commonDecode_2;
  package$wire.commonToString_41v7ql$ = commonToString;
  package$wire.commonWithLabel_n4dkva$ = commonWithLabel;
  package$wire.commonCreatePacked_vepgix$ = commonCreatePacked;
  package$wire.commonAsPacked_vepgix$ = commonAsPacked;
  package$wire.commonCreateRepeated_vepgix$ = commonCreateRepeated;
  package$wire.commonAsRepeated_vepgix$ = commonAsRepeated;
  package$wire.MapProtoAdapter = MapProtoAdapter;
  package$wire.commonNewMapAdapter_64l2ob$ = commonNewMapAdapter;
  Object.defineProperty(package$wire, 'COMMON_BOOL_8be2vx$', {
    get: function () {
      return COMMON_BOOL;
    }
  });
  Object.defineProperty(package$wire, 'COMMON_INT32_8be2vx$', {
    get: function () {
      return COMMON_INT32;
    }
  });
  Object.defineProperty(package$wire, 'COMMON_UINT32_8be2vx$', {
    get: function () {
      return COMMON_UINT32;
    }
  });
  Object.defineProperty(package$wire, 'COMMON_SINT32_8be2vx$', {
    get: function () {
      return COMMON_SINT32;
    }
  });
  Object.defineProperty(package$wire, 'COMMON_FIXED32_8be2vx$', {
    get: function () {
      return COMMON_FIXED32;
    }
  });
  Object.defineProperty(package$wire, 'COMMON_SFIXED32_8be2vx$', {
    get: function () {
      return COMMON_SFIXED32;
    }
  });
  Object.defineProperty(package$wire, 'COMMON_INT64_8be2vx$', {
    get: function () {
      return COMMON_INT64;
    }
  });
  Object.defineProperty(package$wire, 'COMMON_UINT64_8be2vx$', {
    get: function () {
      return COMMON_UINT64;
    }
  });
  Object.defineProperty(package$wire, 'COMMON_SINT64_8be2vx$', {
    get: function () {
      return COMMON_SINT64;
    }
  });
  Object.defineProperty(package$wire, 'COMMON_FIXED64_8be2vx$', {
    get: function () {
      return COMMON_FIXED64;
    }
  });
  Object.defineProperty(package$wire, 'COMMON_SFIXED64_8be2vx$', {
    get: function () {
      return COMMON_SFIXED64;
    }
  });
  Object.defineProperty(package$wire, 'COMMON_FLOAT_8be2vx$', {
    get: function () {
      return COMMON_FLOAT;
    }
  });
  Object.defineProperty(package$wire, 'COMMON_DOUBLE_8be2vx$', {
    get: function () {
      return COMMON_DOUBLE;
    }
  });
  Object.defineProperty(package$wire, 'COMMON_STRING_8be2vx$', {
    get: function () {
      return COMMON_STRING;
    }
  });
  Object.defineProperty(package$wire, 'COMMON_BYTES_8be2vx$', {
    get: function () {
      return COMMON_BYTES;
    }
  });
  Object.defineProperty(ProtoReader, 'Companion', {
    get: ProtoReader$Companion_getInstance
  });
  package$wire.ProtoReader = ProtoReader;
  Object.defineProperty(ProtoWriter, 'Companion', {
    get: ProtoWriter$Companion_getInstance
  });
  package$wire.Service = Service;
  package$wire.WireEnum = WireEnum;
  Object.defineProperty(WireField$Label, 'REQUIRED', {
    get: WireField$Label$REQUIRED_getInstance
  });
  Object.defineProperty(WireField$Label, 'OPTIONAL', {
    get: WireField$Label$OPTIONAL_getInstance
  });
  Object.defineProperty(WireField$Label, 'REPEATED', {
    get: WireField$Label$REPEATED_getInstance
  });
  Object.defineProperty(WireField$Label, 'ONE_OF', {
    get: WireField$Label$ONE_OF_getInstance
  });
  Object.defineProperty(WireField$Label, 'PACKED', {
    get: WireField$Label$PACKED_getInstance
  });
  WireField.Label = WireField$Label;
  package$wire.WireField = WireField;
  package$wire.WireRpc = WireRpc;
  var package$internal = package$wire.internal || (package$wire.internal = {});
  package$internal.ImmutableList = ImmutableList;
  package$internal.newMutableList_287e2$ = newMutableList;
  package$internal.newMutableMap_q3lmfv$ = newMutableMap;
  package$internal.copyOf_z1m26s$ = copyOf;
  package$internal.copyOf_bemo1h$ = copyOf_0;
  package$internal.copyOf_9wnrhc$ = copyOf_1;
  package$internal.copyOf_4lrrid$ = copyOf_2;
  package$internal.immutableCopyOf_16tubr$ = immutableCopyOf;
  package$internal.immutableCopyOf_hh9161$ = immutableCopyOf_0;
  package$internal.redactElements_fc4dil$ = redactElements;
  package$internal.redactElements_u13keg$ = redactElements_0;
  package$internal.equals_oaftn8$ = equals_0;
  package$internal.missingRequiredFields_yhszz7$ = missingRequiredFields;
  package$internal.checkElementsNotNull_9ma18$ = checkElementsNotNull;
  package$internal.checkElementsNotNull_bkhwtg$ = checkElementsNotNull_0;
  package$internal.countNonNull_oaftn8$ = countNonNull;
  package$internal.countNonNull_6c0xd4$ = countNonNull_0;
  package$internal.countNonNull_gldevh$ = countNonNull_1;
  package$internal.MutableOnWriteList = MutableOnWriteList;
  package$internal.and_g525uh$ = and;
  package$internal.shl_g525uh$ = shl;
  package$wire.EnumAdapter = EnumAdapter;
  Message.Builder = Message$Builder;
  package$wire.Message = Message;
  package$wire.MessageSink = MessageSink;
  package$wire.MessageSource = MessageSource;
  ProtoAdapter.EnumConstantNotFoundException = ProtoAdapter$EnumConstantNotFoundException;
  Object.defineProperty(ProtoAdapter, 'Companion', {
    get: ProtoAdapter$Companion_getInstance
  });
  package$internal.Serializable = Serializable;
  package$internal.ObjectStreamException = ObjectStreamException;
  package$internal.ProtocolException = ProtocolException;
  package$internal.toUnmodifiableList_vvxzk3$ = toUnmodifiableList;
  package$internal.toUnmodifiableMap_5rvit3$ = toUnmodifiableMap;
  package$internal.format_t17dwr$ = format;
  FIXED_BOOL_SIZE = 1;
  FIXED_32_SIZE = 4;
  FIXED_64_SIZE = 8;
  COMMON_BOOL = new COMMON_BOOL$ObjectLiteral(FieldEncoding$VARINT_getInstance(), PrimitiveClasses$booleanClass);
  COMMON_INT32 = new COMMON_INT32$ObjectLiteral(FieldEncoding$VARINT_getInstance(), PrimitiveClasses$intClass);
  COMMON_UINT32 = new COMMON_UINT32$ObjectLiteral(FieldEncoding$VARINT_getInstance(), PrimitiveClasses$intClass);
  COMMON_SINT32 = new COMMON_SINT32$ObjectLiteral(FieldEncoding$VARINT_getInstance(), PrimitiveClasses$intClass);
  COMMON_FIXED32 = new COMMON_FIXED32$ObjectLiteral(FieldEncoding$FIXED32_getInstance(), PrimitiveClasses$intClass);
  COMMON_SFIXED32 = COMMON_FIXED32;
  COMMON_INT64 = new COMMON_INT64$ObjectLiteral(FieldEncoding$VARINT_getInstance(), getKClass(Long));
  COMMON_UINT64 = new COMMON_UINT64$ObjectLiteral(FieldEncoding$VARINT_getInstance(), getKClass(Long));
  COMMON_SINT64 = new COMMON_SINT64$ObjectLiteral(FieldEncoding$VARINT_getInstance(), getKClass(Long));
  COMMON_FIXED64 = new COMMON_FIXED64$ObjectLiteral(FieldEncoding$FIXED64_getInstance(), getKClass(Long));
  COMMON_SFIXED64 = COMMON_FIXED64;
  COMMON_FLOAT = new COMMON_FLOAT$ObjectLiteral(FieldEncoding$FIXED32_getInstance(), PrimitiveClasses$floatClass);
  COMMON_DOUBLE = new COMMON_DOUBLE$ObjectLiteral(FieldEncoding$FIXED64_getInstance(), PrimitiveClasses$doubleClass);
  COMMON_STRING = new COMMON_STRING$ObjectLiteral(FieldEncoding$LENGTH_DELIMITED_getInstance(), PrimitiveClasses$stringClass);
  COMMON_BYTES = new COMMON_BYTES$ObjectLiteral(FieldEncoding$LENGTH_DELIMITED_getInstance(), getKClass(ByteString));
  Kotlin.defineModule('wire-runtime', _);
  return _;
}));

//# sourceMappingURL=wire-runtime.js.map
