/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.kotlin.grpcserver;

import com.google.common.util.concurrent.Monitor;
import com.squareup.wire.MessageSource;
import io.grpc.stub.StreamObserver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0015\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u000f\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/squareup/wire/kotlin/grpcserver/MessageSourceAdapter;", "T", "", "Lcom/squareup/wire/MessageSource;", "Lio/grpc/stub/StreamObserver;", "()V", "completed", "", "error", "", "monitor", "Lcom/google/common/util/concurrent/Monitor;", "value", "Ljava/lang/Object;", "valueAbsent", "Lcom/google/common/util/concurrent/Monitor$Guard;", "kotlin.jvm.PlatformType", "valuePresent", "close", "", "onCompleted", "onError", "t", "onNext", "next", "(Ljava/lang/Object;)V", "read", "()Ljava/lang/Object;", "wire-grpc-server"})
public final class MessageSourceAdapter<T>
implements MessageSource<T>,
StreamObserver<T> {
    @Nullable
    private T value;
    @Nullable
    private Throwable error;
    private boolean completed;
    @NotNull
    private final Monitor monitor = new Monitor();
    private final Monitor.Guard valuePresent = this.monitor.newGuard(() -> MessageSourceAdapter.valuePresent$lambda$0(this));
    private final Monitor.Guard valueAbsent = this.monitor.newGuard(() -> MessageSourceAdapter.valueAbsent$lambda$1(this));

    public void onNext(@NotNull T next) {
        Intrinsics.checkNotNullParameter(next, (String)"next");
        this.monitor.enterIf(this.valueAbsent);
        this.value = next;
        this.monitor.leave();
    }

    public void onError(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.monitor.enterIf(this.valueAbsent);
        this.error = t;
        this.monitor.leave();
    }

    public void onCompleted() {
        this.monitor.enterIf(this.valueAbsent);
        this.completed = true;
        this.monitor.leave();
    }

    public void close() {
        throw new RuntimeException("client streams cannot be closed by the server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T read() {
        T t;
        this.monitor.enterIf(this.valuePresent);
        try {
            T t2;
            if (this.completed) {
                t2 = null;
            } else {
                if (this.error != null) {
                    Throwable throwable = this.error;
                    Intrinsics.checkNotNull((Object)throwable);
                    throw throwable;
                }
                t2 = this.value;
            }
            t = t2;
        }
        finally {
            this.value = null;
            this.error = null;
            this.monitor.leave();
        }
        return t;
    }

    private static final boolean valuePresent$lambda$0(MessageSourceAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.value != null || this$0.error != null || this$0.completed;
    }

    private static final boolean valueAbsent$lambda$1(MessageSourceAdapter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.value == null && this$0.error == null && !this$0.completed;
    }
}

