/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.gradle;

import com.squareup.wire.gradle.InputLocation;
import com.squareup.wire.gradle.WireExtension;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.catalog.DelegatingProjectDependency;
import org.gradle.api.internal.file.FileOrUriNotationConverter;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.internal.typeconversion.NotationParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J\u001c\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00170%J\u001c\u0010)\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0%J\u000e\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u000201H\u0002J\u0018\u00102\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u00103\u001a\u00020\u0001H\u0002J\u001a\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020706052\u0006\u0010\"\u001a\u00020#J\"\u00104\u001a\b\u0012\u0004\u0012\u00020706*\u00020\u00132\u0006\u0010\"\u001a\u00020#2\u0006\u00103\u001a\u00020\u000eH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\u00020\u001b*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u0018\u0010\u001d\u001a\u00020\u001b*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00068"}, d2={"Lcom/squareup/wire/gradle/WireInput;", "", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "(Lorg/gradle/api/artifacts/Configuration;)V", "getConfiguration", "()Lorg/gradle/api/artifacts/Configuration;", "setConfiguration", "dependencies", "Lorg/gradle/api/artifacts/DependencySet;", "getDependencies", "()Lorg/gradle/api/artifacts/DependencySet;", "dependencyFilters", "", "Lorg/gradle/api/artifacts/Dependency;", "", "Lcom/squareup/wire/gradle/WireExtension$Filter;", "inputFiles", "", "Ljava/io/File;", "getInputFiles", "()Ljava/util/Set;", "name", "", "getName", "()Ljava/lang/String;", "isZip", "", "(Ljava/io/File;)Z", "mayBeProject", "getMayBeProject", "(Ljava/lang/String;)Z", "addJars", "", "project", "Lorg/gradle/api/Project;", "jars", "", "Lcom/squareup/wire/gradle/WireExtension$ProtoRootSet;", "addPaths", "paths", "addTrees", "trees", "Lorg/gradle/api/file/SourceDirectorySet;", "debug", "logger", "Lorg/gradle/api/logging/Logger;", "isURL", "uri", "Ljava/net/URI;", "resolveDependency", "dependency", "toLocations", "Lorg/gradle/api/provider/Provider;", "", "Lcom/squareup/wire/gradle/InputLocation;", "wire-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nWireInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WireInput.kt\ncom/squareup/wire/gradle/WireInput\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1855#2,2:211\n1855#2,2:213\n223#2,2:215\n1360#2:218\n1446#2,2:219\n1360#2:221\n1446#2,5:222\n1448#2,3:227\n1#3:217\n*S KotlinDebug\n*F\n+ 1 WireInput.kt\ncom/squareup/wire/gradle/WireInput\n*L\n74#1:211,2\n146#1:213,2\n168#1:215,2\n159#1:218\n159#1:219,2\n161#1:221\n161#1:222,5\n159#1:227,3\n*E\n"})
public final class WireInput {
    @NotNull
    private Configuration configuration;
    @NotNull
    private final Map<Dependency, Collection<WireExtension.Filter>> dependencyFilters;
    @NotNull
    private final Set<File> inputFiles;

    public WireInput(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.dependencyFilters = new LinkedHashMap();
        this.inputFiles = new LinkedHashSet();
    }

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    public final void setConfiguration(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"<set-?>");
        this.configuration = configuration;
    }

    @NotNull
    public final String getName() {
        String string = this.configuration.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public final DependencySet getDependencies() {
        DependencySet dependencySet = this.configuration.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"getDependencies(...)");
        return dependencySet;
    }

    @NotNull
    public final Set<File> getInputFiles() {
        return this.inputFiles;
    }

    public final void addPaths(@NotNull Project project, @NotNull Set<String> paths) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        for (String path : paths) {
            Dependency dependency = this.resolveDependency(project, path);
            this.configuration.getDependencies().add((Object)dependency);
        }
    }

    public final void addJars(@NotNull Project project, @NotNull Set<? extends WireExtension.ProtoRootSet> jars) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(jars, (String)"jars");
        for (WireExtension.ProtoRootSet protoRootSet : jars) {
            DelegatingProjectDependency delegatingProjectDependency = protoRootSet.getSrcJar();
            if (delegatingProjectDependency == null && (delegatingProjectDependency = protoRootSet.getSrcProject()) == null && (delegatingProjectDependency = protoRootSet.getSrcJarAsExternalModuleDependency()) == null && (delegatingProjectDependency = protoRootSet.getSrcProjectDependency()) == null) continue;
            DelegatingProjectDependency unresolvedDependency = delegatingProjectDependency;
            Dependency dependency = this.resolveDependency(project, unresolvedDependency);
            this.dependencyFilters.put(dependency, protoRootSet.getFilters$wire_gradle_plugin());
            this.configuration.getDependencies().add((Object)dependency);
        }
    }

    public final void addTrees(@NotNull Project project, @NotNull Set<? extends SourceDirectorySet> trees) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(trees, (String)"trees");
        for (SourceDirectorySet sourceDirectorySet : trees) {
            Set set = sourceDirectorySet.getSrcDirs();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getSrcDirs(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this.inputFiles.add(it);
            }
            Dependency dependency = project.getDependencies().create((Object)sourceDirectorySet);
            this.configuration.getDependencies().add((Object)dependency);
        }
    }

    private final Dependency resolveDependency(Project project, Object dependency) {
        Object object = dependency;
        if (object instanceof String) {
            NotationParser parser = FileOrUriNotationConverter.parser();
            Object converted = parser.parseNotation(dependency);
            if (converted instanceof File) {
                Dependency dependency2;
                File file;
                File file2 = file = !((File)converted).isAbsolute() ? new File(project.getProjectDir(), ((File)converted).getPath()) : (File)converted;
                if (!this.getMayBeProject((String)dependency)) {
                    this.inputFiles.add(file);
                }
                if (file.isDirectory()) {
                    Object[] objectArray = new Object[]{dependency};
                    Dependency dependency3 = project.getDependencies().create((Object)project.files(objectArray));
                    dependency2 = dependency3;
                    Intrinsics.checkNotNullExpressionValue((Object)dependency3, (String)"create(...)");
                } else if (this.isZip(file)) {
                    Object[] objectArray = new Object[]{file.getPath()};
                    Dependency dependency4 = project.getDependencies().create((Object)project.files(objectArray));
                    dependency2 = dependency4;
                    Intrinsics.checkNotNullExpressionValue((Object)dependency4, (String)"create(...)");
                } else {
                    if (this.getMayBeProject((String)dependency)) {
                        Dependency dependency5 = project.getDependencies().project(MapsKt.mapOf((Pair)TuplesKt.to((Object)"path", (Object)dependency)));
                        Intrinsics.checkNotNullExpressionValue((Object)dependency5, (String)"project(...)");
                        return dependency5;
                    }
                    throw new IllegalArgumentException(StringsKt.trimMargin$default((String)("\n              |Invalid path string: \"" + dependency + "\".\n              |For individual files, use the following syntax:\n              |wire {\n              |  sourcePath {\n              |    srcDir 'dirPath'\n              |    include 'relativePath'\n              |  }\n              |}\n              "), null, (int)1, null));
                }
                return dependency2;
            }
            if (converted instanceof URI && this.isURL((URI)converted)) {
                throw new IllegalArgumentException("Invalid path string: \"" + dependency + "\". URL dependencies are not allowed.");
            }
            Dependency dependency6 = project.getDependencies().create(dependency);
            Intrinsics.checkNotNullExpressionValue((Object)dependency6, (String)"create(...)");
            return dependency6;
        }
        if (object instanceof DelegatingProjectDependency) {
            Dependency dependency7 = project.getDependencies().create(dependency);
            Intrinsics.checkNotNullExpressionValue((Object)dependency7, (String)"create(...)");
            return dependency7;
        }
        if (object instanceof Provider) {
            Dependency dependency8 = project.getDependencies().create(((Provider)dependency).get());
            Intrinsics.checkNotNullExpressionValue((Object)dependency8, (String)"create(...)");
            return dependency8;
        }
        throw new IllegalArgumentException("Unsupported dependency: " + dependency);
    }

    private final boolean isURL(URI uri) {
        boolean bl;
        try {
            uri.toURL();
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    public final void debug(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        DependencySet dependencySet = this.configuration.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"getDependencies(...)");
        Iterable $this$forEach$iv = (Iterable)dependencySet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Dependency dep = (Dependency)element$iv;
            boolean bl = false;
            FileCollectionDependency fileCollectionDependency = dep instanceof FileCollectionDependency ? (FileCollectionDependency)dep : null;
            Dependency[] dependencyArray = fileCollectionDependency != null ? fileCollectionDependency.getFiles() : null;
            SourceDirectorySet sourceDirectorySet = dependencyArray instanceof SourceDirectorySet ? (SourceDirectorySet)dependencyArray : null;
            Set srcDirs = sourceDirectorySet != null ? sourceDirectorySet.getSrcDirs() : null;
            Collection collection = this.dependencyFilters.get(dep);
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Collection includes = collection;
            logger.debug("dep: " + dep + " -> " + srcDirs);
            dependencyArray = new Dependency[]{dep};
            logger.debug(this.getName() + ".files for dep: " + this.configuration.files(dependencyArray));
            logger.debug(this.getName() + ".includes for dep: " + includes);
        }
    }

    @NotNull
    public final Provider<List<InputLocation>> toLocations(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Provider provider = project.provider(() -> WireInput.toLocations$lambda$5(this, project));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"provider(...)");
        return provider;
    }

    private final List<InputLocation> toLocations(File $this$toLocations, Project project, Dependency dependency) {
        List list;
        if (dependency instanceof FileCollectionDependency && ((FileCollectionDependency)dependency).getFiles() instanceof SourceDirectorySet) {
            Object element$iv2;
            block6: {
                FileCollection fileCollection = ((FileCollectionDependency)dependency).getFiles();
                Intrinsics.checkNotNull((Object)fileCollection, (String)"null cannot be cast to non-null type org.gradle.api.file.SourceDirectorySet");
                Set set = ((SourceDirectorySet)fileCollection).getSrcDirs();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getSrcDirs(...)");
                Iterable $this$first$iv = set;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    File it = (File)element$iv2;
                    boolean bl = false;
                    String string = it.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    if (!FilesKt.startsWith((File)$this$toLocations, (String)string)) continue;
                    break block6;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            File srcDir = (File)element$iv2;
            String string = srcDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            Intrinsics.checkNotNull((Object)srcDir);
            String string2 = FilesKt.relativeTo((File)$this$toLocations, (File)srcDir).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            list = CollectionsKt.listOf((Object)InputLocation.Companion.get(project, string, string2));
        } else if (this.isZip($this$toLocations)) {
            List list2 = this.dependencyFilters.getOrDefault(dependency, CollectionsKt.emptyList());
            if (list2.isEmpty()) {
                boolean bl = false;
                String string = $this$toLocations.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                return CollectionsKt.listOf((Object)InputLocation.Companion.get(project, string));
            }
            List filters = list2;
            List $this$toLocations_u24lambda_u2410 = list2 = (List)new ArrayList();
            boolean bl = false;
            project.zipTree((Object)$this$toLocations.getPath()).matching(arg_0 -> WireInput.toLocations$lambda$10$lambda$8((Function1)new Function1<PatternFilterable, Unit>((Collection<? extends WireExtension.Filter>)filters){
                final /* synthetic */ Collection<WireExtension.Filter> $filters;
                {
                    this.$filters = $filters;
                    super(1);
                }

                public final void invoke(PatternFilterable pattern) {
                    Iterable $this$forEach$iv = this.$filters;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        WireExtension.Filter it = (WireExtension.Filter)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)pattern);
                        it.act(pattern);
                    }
                }
            }, arg_0)).visit(arg_0 -> WireInput.toLocations$lambda$10$lambda$9((Function1)new Function1<FileVisitDetails, Unit>((List<InputLocation>)$this$toLocations_u24lambda_u2410, project, $this$toLocations){
                final /* synthetic */ List<InputLocation> $this_apply;
                final /* synthetic */ Project $project;
                final /* synthetic */ File $this_toLocations;
                {
                    this.$this_apply = $receiver;
                    this.$project = $project;
                    this.$this_toLocations = $receiver2;
                    super(1);
                }

                public final void invoke(FileVisitDetails it) {
                    if (!it.isDirectory()) {
                        String string = this.$this_toLocations.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        String string2 = it.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                        this.$this_apply.add(InputLocation.Companion.get(this.$project, string, string2));
                    }
                }
            }, arg_0));
            list = list2;
        } else {
            String string = $this$toLocations.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            list = CollectionsKt.listOf((Object)InputLocation.Companion.get(project, string));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isZip(File $this$isZip) {
        boolean bl;
        block13: {
            block12: {
                if (!$this$isZip.exists() || !$this$isZip.isFile()) {
                    return false;
                }
                String string = $this$isZip.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) break block12;
                String string2 = $this$isZip.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                if (!StringsKt.endsWith$default((String)string2, (String)".zip", (boolean)false, (int)2, null)) break block13;
            }
            return true;
        }
        try {
            int n;
            Closeable closeable = new RandomAccessFile($this$isZip, "r");
            Throwable throwable = null;
            try {
                RandomAccessFile it = (RandomAccessFile)closeable;
                boolean bl2 = false;
                n = it.readInt();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            int signature = n;
            bl = signature == 1347093252 || signature == 1347093766 || signature == 1347094280;
        }
        catch (EOFException eOFException) {
            bl = false;
        }
        return bl;
    }

    private final boolean getMayBeProject(String $this$mayBeProject) {
        return StringsKt.startsWith$default((String)$this$mayBeProject, (String)":", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List toLocations$lambda$5(WireInput this$0, Project $project) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        DependencySet dependencySet = this$0.configuration.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"getDependencies(...)");
        Iterable $this$flatMap$iv = (Iterable)dependencySet;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            Dependency dep = (Dependency)element$iv$iv;
            boolean bl = false;
            Dependency[] dependencyArray = new Dependency[]{dep};
            Set set = this$0.configuration.files(dependencyArray);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"files(...)");
            List sortedFiles = CollectionsKt.sortedWith((Iterable)set, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    File it = (File)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (File)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
            Iterable $this$flatMap$iv2 = sortedFiles;
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                File file = (File)element$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)file);
                Intrinsics.checkNotNull((Object)dep);
                Iterable list$iv$iv = this$0.toLocations(file, $project, dep);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void toLocations$lambda$10$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void toLocations$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

