/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.gradle;

import com.squareup.wire.gradle.WireExtension;
import com.squareup.wire.schema.Location;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.FileOrUriNotationConverter;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.typeconversion.NotationParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J\u001c\u0010&\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100$J\u001c\u0010(\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020%0$J\u001c\u0010*\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0$J\u000e\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u000202H\u0002J\u0018\u00103\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u00104\u001a\u00020\u0010H\u0002J\u001a\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002070\u000f062\u0006\u00108\u001a\u000209J\u001a\u00105\u001a\b\u0012\u0004\u0012\u0002070\u000f*\u00020\u00132\u0006\u0010:\u001a\u00020\u000eH\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\u00020\u001a*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0018\u0010\u001c\u001a\u00020\u001a*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006;"}, d2={"Lcom/squareup/wire/gradle/WireInput;", "", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "(Lorg/gradle/api/artifacts/Configuration;)V", "getConfiguration", "()Lorg/gradle/api/artifacts/Configuration;", "setConfiguration", "dependencies", "Lorg/gradle/api/artifacts/DependencySet;", "getDependencies", "()Lorg/gradle/api/artifacts/DependencySet;", "dependencyToIncludes", "", "Lorg/gradle/api/artifacts/Dependency;", "", "", "inputFiles", "", "Ljava/io/File;", "getInputFiles", "()Ljava/util/Set;", "name", "getName", "()Ljava/lang/String;", "isJar", "", "(Ljava/io/File;)Z", "mayBeProject", "getMayBeProject", "(Ljava/lang/String;)Z", "addJars", "", "project", "Lorg/gradle/api/Project;", "jars", "", "Lcom/squareup/wire/gradle/WireExtension$ProtoRootSet;", "addPaths", "paths", "addProjects", "projects", "addTrees", "trees", "Lorg/gradle/api/file/SourceDirectorySet;", "debug", "logger", "Lorg/gradle/api/logging/Logger;", "isURL", "uri", "Ljava/net/URI;", "resolveDependency", "path", "toLocations", "Lorg/gradle/api/provider/Provider;", "Lcom/squareup/wire/schema/Location;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "dependency", "wire-gradle-plugin"})
public final class WireInput {
    private final Map<Dependency, List<String>> dependencyToIncludes;
    @NotNull
    private final Set<File> inputFiles;
    @NotNull
    private Configuration configuration;

    @NotNull
    public final String getName() {
        String string = this.configuration.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configuration.name");
        return string;
    }

    @NotNull
    public final DependencySet getDependencies() {
        DependencySet dependencySet = this.configuration.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"configuration.dependencies");
        return dependencySet;
    }

    @NotNull
    public final Set<File> getInputFiles() {
        return this.inputFiles;
    }

    public final void addPaths(@NotNull Project project, @NotNull Set<String> paths) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        for (String path : paths) {
            Dependency dependency = this.resolveDependency(project, path);
            this.configuration.getDependencies().add((Object)dependency);
        }
    }

    public final void addJars(@NotNull Project project, @NotNull Set<? extends WireExtension.ProtoRootSet> jars) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(jars, (String)"jars");
        for (WireExtension.ProtoRootSet protoRootSet : jars) {
            String string;
            if (protoRootSet.getSrcJar() == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            String path = string;
            boolean bl3 = false;
            Dependency dependency = this.resolveDependency(project, path);
            this.dependencyToIncludes.put(dependency, protoRootSet.getIncludes());
            this.configuration.getDependencies().add((Object)dependency);
        }
    }

    public final void addProjects(@NotNull Project project, @NotNull Set<? extends WireExtension.ProtoRootSet> projects) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        for (WireExtension.ProtoRootSet protoRootSet : projects) {
            if (protoRootSet.getSrcProject() == null) continue;
            String string = protoRootSet.getSrcProject();
            Intrinsics.checkNotNull((Object)string);
            Dependency dependency = this.resolveDependency(project, string);
            this.dependencyToIncludes.put(dependency, protoRootSet.getIncludes());
            this.configuration.getDependencies().add((Object)dependency);
        }
    }

    public final void addTrees(@NotNull Project project, @NotNull Set<? extends SourceDirectorySet> trees) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(trees, (String)"trees");
        for (SourceDirectorySet sourceDirectorySet : trees) {
            Set set = sourceDirectorySet.getSrcDirs();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"tree.srcDirs");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                File file = it;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                this.inputFiles.add(file);
            }
            Dependency dependency = project.getDependencies().create((Object)sourceDirectorySet);
            this.configuration.getDependencies().add((Object)dependency);
        }
    }

    private final Dependency resolveDependency(Project project, String path) {
        NotationParser parser = FileOrUriNotationConverter.parser();
        Object converted = parser.parseNotation((Object)path);
        if (converted instanceof File) {
            Dependency dependency;
            File file;
            File file2 = file = !((File)converted).isAbsolute() ? new File(project.getProjectDir(), ((File)converted).getPath()) : (File)converted;
            if (!this.getMayBeProject(path)) {
                this.inputFiles.add(file);
            }
            if (file.isDirectory()) {
                Dependency dependency2 = project.getDependencies().create((Object)project.files(new Object[]{path}));
                dependency = dependency2;
                Intrinsics.checkNotNullExpressionValue((Object)dependency2, (String)"project.dependencies.create(project.files(path))");
            } else if (this.isJar(file)) {
                Dependency dependency3 = project.getDependencies().create((Object)project.files(new Object[]{file.getPath()}));
                dependency = dependency3;
                Intrinsics.checkNotNullExpressionValue((Object)dependency3, (String)"project.dependencies.cre\u2026project.files(file.path))");
            } else {
                if (this.getMayBeProject(path)) {
                    Dependency dependency4 = project.getDependencies().project(MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"path", (Object)path)}));
                    Intrinsics.checkNotNullExpressionValue((Object)dependency4, (String)"project.dependencies.pro\u2026bleMapOf(\"path\" to path))");
                    return dependency4;
                }
                throw (Throwable)new IllegalArgumentException(StringsKt.trimMargin$default((String)("\n          |Invalid path string: \"" + path + "\".\n          |For individual files, use the following syntax:\n          |wire {\n          |  sourcePath {\n          |    srcDir 'dirPath'\n          |    include 'relativePath'\n          |  }\n          |}\n          "), null, (int)1, null));
            }
            return dependency;
        }
        if (converted instanceof URI && this.isURL((URI)converted)) {
            throw (Throwable)new IllegalArgumentException("Invalid path string: \"" + path + "\". URL dependencies are not allowed.");
        }
        Dependency dependency = project.getDependencies().create((Object)path);
        Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"project.dependencies.create(path)");
        return dependency;
    }

    private final boolean isURL(URI uri) {
        boolean bl;
        try {
            uri.toURL();
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    public final void debug(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        DependencySet dependencySet = this.configuration.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"configuration.dependencies");
        Iterable $this$forEach$iv = (Iterable)dependencySet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Dependency dep = (Dependency)element$iv;
            boolean bl = false;
            Dependency dependency = dep;
            if (!(dependency instanceof FileCollectionDependency)) {
                dependency = null;
            }
            FileCollectionDependency fileCollectionDependency = (FileCollectionDependency)dependency;
            Object object = fileCollectionDependency != null ? fileCollectionDependency.getFiles() : null;
            if (!(object instanceof SourceDirectorySet)) {
                object = null;
            }
            SourceDirectorySet sourceDirectorySet = (SourceDirectorySet)object;
            Set srcDirs = sourceDirectorySet != null ? sourceDirectorySet.getSrcDirs() : null;
            List list = this.dependencyToIncludes.get(dep);
            if (list == null) {
                boolean bl2 = false;
                list = CollectionsKt.emptyList();
            }
            List includes = list;
            logger.debug("dep: " + dep + " -> " + srcDirs);
            logger.debug(this.getName() + ".files for dep: " + this.configuration.files(new Dependency[]{dep}));
            logger.debug(this.getName() + ".includes for dep: " + includes);
        }
    }

    @NotNull
    public final Provider<List<Location>> toLocations(@NotNull ProviderFactory providerFactory) {
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Provider provider = providerFactory.provider((Callable)new Callable<List<? extends Location>>(this){
            final /* synthetic */ WireInput this$0;

            /*
             * WARNING - void declaration
             */
            public final List<Location> call() {
                void $this$flatMapTo$iv$iv;
                DependencySet dependencySet = this.this$0.getConfiguration().getDependencies();
                Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"configuration.dependencies");
                Iterable $this$flatMap$iv = (Iterable)dependencySet;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    void $this$flatMapTo$iv$iv2;
                    Dependency dep = (Dependency)element$iv$iv;
                    boolean bl = false;
                    Set set = this.this$0.getConfiguration().files(new Dependency[]{dep});
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"configuration.files(dep)");
                    Iterable $this$flatMap$iv2 = set;
                    boolean $i$f$flatMap2 = false;
                    Iterable iterable2 = $this$flatMap$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$flatMapTo2 = false;
                    for (T element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                        File file = (File)element$iv$iv2;
                        boolean bl2 = false;
                        File file2 = file;
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                        Dependency dependency = dep;
                        Intrinsics.checkNotNullExpressionValue((Object)dependency, (String)"dep");
                        Iterable list$iv$iv = WireInput.access$toLocations(this.this$0, file2, dependency);
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = wireInput;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"providerFactory.provider\u2026ions(dep) }\n      }\n    }");
        return provider;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Location> toLocations(File $this$toLocations, Dependency dependency) {
        void $this$mapTo$iv$iv;
        List includes;
        if (dependency instanceof FileCollectionDependency && ((FileCollectionDependency)dependency).getFiles() instanceof SourceDirectorySet) {
            File srcDir;
            Object element$iv;
            int $i$f$first;
            Object $this$first$iv;
            block7: {
                FileCollection fileCollection = ((FileCollectionDependency)dependency).getFiles();
                if (fileCollection == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.file.SourceDirectorySet");
                }
                Set set = ((SourceDirectorySet)fileCollection).getSrcDirs();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"(dependency.files as SourceDirectorySet).srcDirs");
                $this$first$iv = set;
                $i$f$first = 0;
                Iterator iterator = $this$first$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    File it = (File)element$iv;
                    boolean bl = false;
                    String string = $this$toLocations.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                    StringBuilder stringBuilder = new StringBuilder();
                    File file = it;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                    if (!StringsKt.startsWith$default((String)string, (String)stringBuilder.append(file.getPath()).append(File.separator).toString(), (boolean)false, (int)2, null)) continue;
                    break block7;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            File file = srcDir = (File)element$iv;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"srcDir");
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"srcDir.path");
            String string2 = $this$toLocations.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
            $this$first$iv = string2;
            $i$f$first = srcDir.getPath().length() + 1;
            boolean bl = false;
            Object object = $this$first$iv;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = ((String)object).substring($i$f$first);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return CollectionsKt.listOf((Object)Location.Companion.get(string, string3));
        }
        List list = this.dependencyToIncludes.get(dependency);
        if (list == null) {
            boolean $this$first$iv = false;
            list = includes = CollectionsKt.emptyList();
        }
        if (includes.isEmpty()) {
            String string = $this$toLocations.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
            return CollectionsKt.listOf((Object)Location.Companion.get(string));
        }
        Iterable $this$map$iv = includes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void include;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string4 = $this$toLocations.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"path");
            Location location = Location.Companion.get(string4, (String)include);
            collection.add(location);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isJar(File $this$isJar) {
        String string = $this$isJar.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
        return StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null);
    }

    private final boolean getMayBeProject(String $this$mayBeProject) {
        return StringsKt.startsWith$default((String)$this$mayBeProject, (String)":", (boolean)false, (int)2, null);
    }

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    public final void setConfiguration(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"<set-?>");
        this.configuration = configuration;
    }

    public WireInput(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        boolean bl = false;
        this.dependencyToIncludes = new LinkedHashMap();
        bl = false;
        this.inputFiles = new LinkedHashSet();
    }

    public static final /* synthetic */ List access$toLocations(WireInput $this, File $this$access_u24toLocations, Dependency dependency) {
        return $this.toLocations($this$access_u24toLocations, dependency);
    }
}

