/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.java.internal.ProfileFileElement;
import com.squareup.wire.java.internal.ProfileParser;
import com.squareup.wire.schema.FileSystemsKt;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.Root;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ProtoParser;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00000\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/squareup/wire/schema/ProtoFilePath;", "Lcom/squareup/wire/schema/Root;", "location", "Lcom/squareup/wire/schema/Location;", "fileSystem", "Lokio/FileSystem;", "path", "Lokio/Path;", "(Lcom/squareup/wire/schema/Location;Lokio/FileSystem;Lokio/Path;)V", "base", "", "getBase", "()Ljava/lang/String;", "getFileSystem", "()Lokio/FileSystem;", "getLocation", "()Lcom/squareup/wire/schema/Location;", "getPath", "()Lokio/Path;", "allProtoFiles", "", "parse", "Lcom/squareup/wire/schema/ProtoFile;", "parseProfile", "Lcom/squareup/wire/java/internal/ProfileFileElement;", "resolve", "import", "toString", "wire-compiler"})
public final class ProtoFilePath
extends Root {
    @NotNull
    private final Location location;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Path path;

    public ProtoFilePath(@NotNull Location location, @NotNull FileSystem fileSystem, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(null);
        this.location = location;
        this.fileSystem = fileSystem;
        this.path = path;
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    @NotNull
    public final FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public String getBase() {
        return null;
    }

    @Override
    @NotNull
    public Set<ProtoFilePath> allProtoFiles() {
        return SetsKt.setOf((Object)this);
    }

    @Override
    @Nullable
    public ProtoFilePath resolve(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"import");
        if (Intrinsics.areEqual((Object)string, (Object)this.location.getPath())) {
            return this;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProtoFile parse() {
        try {
            void this_$iv;
            FileSystem fileSystem = this.fileSystem;
            Path file$iv = this.path;
            boolean $i$f$read = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
            boolean $i$f$use = false;
            Object result$iv$iv = null;
            Throwable thrown$iv$iv = null;
            try {
                BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                boolean bl = false;
                BufferedSource $this$parse_u24lambda_u2d0 = it$iv;
                boolean bl2 = false;
                Charset charset = FileSystemsKt.readBomAsCharset$default($this$parse_u24lambda_u2d0, null, 1, null);
                String data = $this$parse_u24lambda_u2d0.readString(charset);
                ProtoFileElement element = ProtoParser.Companion.parse(this.getLocation(), data);
                return ProtoFile.Companion.get(element);
            }
            catch (Throwable t$iv$iv2) {
                block9: {
                    thrown$iv$iv = t$iv$iv2;
                    try {
                        Closeable t$iv$iv2 = $this$use$iv$iv;
                        if (t$iv$iv2 != null) {
                            t$iv$iv2.close();
                        }
                    }
                    catch (Throwable t$iv$iv3) {
                        if (thrown$iv$iv == null) {
                            thrown$iv$iv = t$iv$iv3;
                            break block9;
                        }
                        ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv3);
                    }
                }
                if (thrown$iv$iv != null) {
                    throw thrown$iv$iv;
                }
                Intrinsics.checkNotNull(result$iv$iv);
                throw new KotlinNothingValueException();
            }
        }
        catch (IOException e) {
            throw new IOException(Intrinsics.stringPlus((String)"Failed to load ", (Object)this.path), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProfileFileElement parseProfile() {
        try {
            void this_$iv;
            FileSystem fileSystem = this.fileSystem;
            Path file$iv = this.path;
            boolean $i$f$read = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
            boolean $i$f$use = false;
            Object result$iv$iv = null;
            Throwable thrown$iv$iv = null;
            try {
                BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                boolean bl = false;
                BufferedSource $this$parseProfile_u24lambda_u2d1 = it$iv;
                boolean bl2 = false;
                String data = $this$parseProfile_u24lambda_u2d1.readUtf8();
                return new ProfileParser(this.getLocation(), data).read();
            }
            catch (Throwable t$iv$iv2) {
                block9: {
                    thrown$iv$iv = t$iv$iv2;
                    try {
                        Closeable t$iv$iv2 = $this$use$iv$iv;
                        if (t$iv$iv2 != null) {
                            t$iv$iv2.close();
                        }
                    }
                    catch (Throwable t$iv$iv3) {
                        if (thrown$iv$iv == null) {
                            thrown$iv$iv = t$iv$iv3;
                            break block9;
                        }
                        ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv3);
                    }
                }
                if (thrown$iv$iv != null) {
                    throw thrown$iv$iv;
                }
                Intrinsics.checkNotNull(result$iv$iv);
                throw new KotlinNothingValueException();
            }
        }
        catch (IOException e) {
            throw new IOException(Intrinsics.stringPlus((String)"Failed to load ", (Object)this.path), e);
        }
    }

    @NotNull
    public String toString() {
        return this.location.toString();
    }
}

