/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.java.Profile;
import com.squareup.wire.java.internal.ProfileFileElement;
import com.squareup.wire.java.internal.TypeConfigElement;
import com.squareup.wire.schema.CoreLoader;
import com.squareup.wire.schema.ErrorCollector;
import com.squareup.wire.schema.FileSystemsKt;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Loader;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProfileLoader;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoFilePath;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Root;
import com.squareup.wire.schema.RootKt;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.SchemaLoaderKt;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0012\u0012\u0006\u0010\b\u001a\u00020\u0000\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000fH\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020%H\u0002J$\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020#0\u000f2\u000e\b\u0002\u0010*\u001a\b\u0012\u0004\u0012\u00020#0\u000fJ\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u000eH\u0016J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u000203H\u0016J\u0006\u00104\u001a\u000203J\u0013\u00105\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000fH\u0000\u00a2\u0006\u0002\b6J)\u00107\u001a\b\u0012\u0004\u0012\u00020#082\u0006\u00101\u001a\u00020\u000e2\f\u00109\u001a\b\u0012\u0004\u0012\u00020#0\u000fH\u0000\u00a2\u0006\u0002\b:J\r\u0010;\u001a\u00020(H\u0000\u00a2\u0006\u0002\b<J\u001e\u0010=\u001a\u00020(2\u0006\u00102\u001a\u0002032\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u000fH\u0002J\u0010\u0010@\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/squareup/wire/schema/SchemaLoader;", "Lcom/squareup/wire/schema/Loader;", "Lcom/squareup/wire/schema/ProfileLoader;", "fileSystem", "Ljava/nio/file/FileSystem;", "(Ljava/nio/file/FileSystem;)V", "Lokio/FileSystem;", "(Lokio/FileSystem;)V", "enclosing", "errors", "Lcom/squareup/wire/schema/ErrorCollector;", "(Lcom/squareup/wire/schema/SchemaLoader;Lcom/squareup/wire/schema/ErrorCollector;)V", "baseToRoots", "", "", "", "Lcom/squareup/wire/schema/Root;", "loadExhaustively", "", "getLoadExhaustively", "()Z", "setLoadExhaustively", "(Z)V", "permitPackageCycles", "getPermitPackageCycles", "setPermitPackageCycles", "protoPathRoots", "<set-?>", "Lcom/squareup/wire/schema/ProtoFile;", "sourcePathFiles", "getSourcePathFiles", "()Ljava/util/List;", "sourcePathRoots", "allRoots", "locations", "Lcom/squareup/wire/schema/Location;", "importedType", "Lcom/squareup/wire/schema/ProtoType;", "type", "initRoots", "", "sourcePath", "protoPath", "load", "protoFilePath", "Lcom/squareup/wire/schema/ProtoFilePath;", "path", "loadProfile", "Lcom/squareup/wire/java/Profile;", "name", "schema", "Lcom/squareup/wire/schema/Schema;", "loadSchema", "loadSourcePathFiles", "loadSourcePathFiles$wire_compiler", "locationsToCheck", "", "input", "locationsToCheck$wire_compiler", "reportLoadingErrors", "reportLoadingErrors$wire_compiler", "validate", "profileFiles", "Lcom/squareup/wire/java/internal/ProfileFileElement;", "withErrors", "wire-compiler"})
public final class SchemaLoader
implements Loader,
ProfileLoader {
    @NotNull
    private final okio.FileSystem fileSystem;
    @NotNull
    private final ErrorCollector errors;
    @Nullable
    private List<? extends Root> sourcePathRoots;
    @Nullable
    private List<? extends Root> protoPathRoots;
    private boolean permitPackageCycles;
    private boolean loadExhaustively;
    @NotNull
    private List<ProtoFile> sourcePathFiles;
    @NotNull
    private final Map<String, List<Root>> baseToRoots;

    public final boolean getPermitPackageCycles() {
        return this.permitPackageCycles;
    }

    public final void setPermitPackageCycles(boolean bl) {
        this.permitPackageCycles = bl;
    }

    public final boolean getLoadExhaustively() {
        return this.loadExhaustively;
    }

    public final void setLoadExhaustively(boolean bl) {
        this.loadExhaustively = bl;
    }

    @NotNull
    public final List<ProtoFile> getSourcePathFiles() {
        return this.sourcePathFiles;
    }

    public SchemaLoader(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this(FileSystemsKt.toOkioFileSystem(fileSystem));
    }

    public SchemaLoader(@NotNull okio.FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this.errors = new ErrorCollector();
        this.sourcePathRoots = null;
        this.protoPathRoots = null;
        boolean bl = false;
        this.sourcePathFiles = CollectionsKt.emptyList();
        bl = false;
        this.baseToRoots = new LinkedHashMap();
    }

    private SchemaLoader(SchemaLoader enclosing, ErrorCollector errors) {
        this.fileSystem = enclosing.fileSystem;
        this.errors = errors;
        this.sourcePathRoots = enclosing.sourcePathRoots;
        this.protoPathRoots = enclosing.protoPathRoots;
        this.sourcePathFiles = enclosing.sourcePathFiles;
        this.baseToRoots = enclosing.baseToRoots;
    }

    @NotNull
    public SchemaLoader withErrors(@NotNull ErrorCollector errors) {
        Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
        return new SchemaLoader(this, errors);
    }

    public final void initRoots(@NotNull List<Location> sourcePath, @NotNull List<Location> protoPath) {
        Intrinsics.checkNotNullParameter(sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullParameter(protoPath, (String)"protoPath");
        boolean bl = this.sourcePathRoots == null && this.protoPathRoots == null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.sourcePathRoots = this.allRoots(sourcePath);
        this.protoPathRoots = this.allRoots(protoPath);
    }

    public static /* synthetic */ void initRoots$default(SchemaLoader schemaLoader, List list, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        }
        schemaLoader.initRoots(list, list2);
    }

    @NotNull
    public final Schema loadSchema() throws IOException {
        this.sourcePathFiles = this.loadSourcePathFiles$wire_compiler();
        Linker linker = new Linker((Loader)this, this.errors, this.permitPackageCycles, this.loadExhaustively);
        Schema result = linker.link((Iterable)this.sourcePathFiles);
        this.errors.throwIfNonEmpty();
        return result;
    }

    @NotNull
    public final List<ProtoFile> loadSourcePathFiles$wire_compiler() throws IOException {
        boolean bl = this.sourcePathRoots != null && this.protoPathRoots != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "call initRoots() before calling loadSourcePathFiles()";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl2 = false;
        List result = new ArrayList();
        List<? extends Root> list = this.sourcePathRoots;
        Intrinsics.checkNotNull(list);
        for (Root root : list) {
            for (ProtoFilePath locationAndPath : root.allProtoFiles()) {
                Collection collection = result;
                ProtoFile protoFile = this.load(locationAndPath);
                boolean bl5 = false;
                collection.add(protoFile);
            }
        }
        if (result.isEmpty()) {
            SchemaLoader schemaLoader = this;
            schemaLoader.errors.plusAssign("no sources");
        }
        this.errors.throwIfNonEmpty();
        return result;
    }

    @NotNull
    public ProtoFile load(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ProtoFilePath loadFrom = null;
        List<? extends Root> list = this.protoPathRoots;
        Intrinsics.checkNotNull(list);
        for (Root root : list) {
            Object object = root.resolve(path);
            if (object == null) continue;
            ProtoFilePath locationAndPath = object;
            if (loadFrom != null) {
                object = this;
                ((SchemaLoader)object).errors.plusAssign(path + " is ambiguous:\n  " + locationAndPath + "\n  " + loadFrom);
                continue;
            }
            loadFrom = locationAndPath;
        }
        if (loadFrom != null) {
            return this.load(loadFrom);
        }
        if (CoreLoader.INSTANCE.isWireRuntimeProto(path)) {
            return CoreLoader.INSTANCE.load(path);
        }
        SchemaLoader schemaLoader = this;
        ErrorCollector errorCollector = schemaLoader.errors;
        StringBuilder stringBuilder = new StringBuilder().append("\n          |unable to find ").append(path).append("\n          |  searching ");
        List<? extends Root> list2 = this.protoPathRoots;
        Intrinsics.checkNotNull(list2);
        StringBuilder stringBuilder2 = stringBuilder.append(list2.size()).append(" proto paths:\n          |    ");
        List<? extends Root> list3 = this.protoPathRoots;
        Intrinsics.checkNotNull(list3);
        errorCollector.plusAssign(StringsKt.trimMargin$default((String)stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)"\n    ", null, null, (int)0, null, null, (int)62, null)).append("\n          ").toString(), null, (int)1, null));
        return ProtoFile.Companion.get(ProtoFileElement.Companion.empty(path));
    }

    private final ProtoFile load(ProtoFilePath protoFilePath) {
        if (CoreLoader.INSTANCE.isWireRuntimeProto(protoFilePath.getLocation())) {
            return CoreLoader.INSTANCE.load(protoFilePath.getLocation().getPath());
        }
        ProtoFile protoFile = protoFilePath.parse();
        String importPath = SchemaLoaderKt.importPath(protoFile, protoFilePath.getLocation());
        Object object = protoFilePath.getLocation().getBase();
        boolean bl = false;
        if (object.length() == 0 && !Intrinsics.areEqual((Object)protoFilePath.getLocation().getPath(), (Object)importPath) && !StringsKt.endsWith$default((String)protoFilePath.getLocation().getPath(), (String)Intrinsics.stringPlus((String)"/", (Object)importPath), (boolean)false, (int)2, null)) {
            object = this;
            ((SchemaLoader)object).errors.plusAssign("expected " + protoFilePath.getLocation().getPath() + " to have a path ending with " + importPath);
        }
        return protoFile;
    }

    private final List<Root> allRoots(List<Location> locations) {
        boolean bl = false;
        List result = new ArrayList();
        for (Location location : locations) {
            Object object;
            try {
                Collection collection = result;
                object = RootKt.roots(location, this.fileSystem, this.baseToRoots);
                boolean bl2 = false;
                CollectionsKt.addAll((Collection)collection, (Iterable)object);
            }
            catch (IllegalArgumentException e) {
                object = this;
                ErrorCollector errorCollector = ((SchemaLoader)object).errors;
                String string = e.getMessage();
                Intrinsics.checkNotNull((Object)string);
                errorCollector.plusAssign(string);
            }
        }
        return result;
    }

    public final void reportLoadingErrors$wire_compiler() {
        this.errors.throwIfNonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Profile loadProfile(@NotNull String name, @NotNull Schema schema) {
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Iterable $this$map$iv = schema.getProtoFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ProtoFile protoFile = (ProtoFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Location location = it.getLocation();
            collection.add(location);
        }
        List allLocations = (List)destination$iv$iv;
        Set<Location> locationsToCheck = this.locationsToCheck$wire_compiler(name, allLocations);
        boolean $this$mapTo$iv$iv2 = false;
        List profileElements = new ArrayList();
        for (Location location : locationsToCheck) {
            Object object = this.baseToRoots.get(location.getBase());
            if (object == null) continue;
            Iterator roots = object;
            object = roots.iterator();
            while (object.hasNext()) {
                Root root = (Root)object.next();
                Object object2 = root.resolve(location.getPath());
                if (object2 == null) continue;
                ProtoFilePath resolved = object2;
                object2 = profileElements;
                ProfileFileElement profileFileElement = resolved.parseProfile();
                boolean bl = false;
                object2.add(profileFileElement);
            }
        }
        Profile profile = new Profile(profileElements);
        this.validate(schema, profileElements);
        return profile;
    }

    private final void validate(Schema schema, List<ProfileFileElement> profileFiles) {
        for (ProfileFileElement profileFile : profileFiles) {
            for (TypeConfigElement typeConfig : profileFile.getTypeConfigs()) {
                ProtoType type;
                Type resolvedType;
                ProtoType protoType = this.importedType(ProtoType.Companion.get(typeConfig.getType()));
                if (protoType == null || (resolvedType = schema.getType(type = protoType)) == null) continue;
                String requiredImport = resolvedType.getLocation().getPath();
                if (profileFile.getImports().contains(requiredImport)) continue;
                SchemaLoader schemaLoader = this;
                schemaLoader.errors.plusAssign(typeConfig.getLocation().getPath() + " needs to import " + requiredImport + " (" + typeConfig.getLocation() + ')');
            }
        }
        this.errors.throwIfNonEmpty();
    }

    private final ProtoType importedType(ProtoType type) {
        ProtoType type2 = type;
        if (type2.isMap()) {
            ProtoType protoType = type2.getValueType();
            Intrinsics.checkNotNull((Object)protoType);
            type2 = protoType;
        }
        return type2.isScalar() ? null : type2;
    }

    @NotNull
    public final Set<Location> locationsToCheck$wire_compiler(@NotNull String name, @NotNull List<Location> input) {
        Location location;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        ArrayDeque queue = new ArrayDeque(input);
        boolean bl = false;
        Set result = new LinkedHashSet();
        while ((location = (Location)queue.poll()) != null) {
            String parentPath;
            Location protoLocation = location;
            int lastSlash = StringsKt.lastIndexOf$default((CharSequence)protoLocation.getPath(), (String)"/", (int)0, (boolean)false, (int)6, null);
            String string = protoLocation.getPath();
            int n = 0;
            int n2 = lastSlash + 1;
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            Location profileLocation = Location.copy$default((Location)protoLocation, null, (String)(parentPath + name + ".wire"), (int)0, (int)0, (int)13, null);
            if (!result.add(profileLocation)) continue;
            Object object = parentPath;
            n2 = 0;
            if (!(object.length() > 0)) continue;
            object = queue;
            Location location2 = Location.copy$default((Location)protoLocation, null, (String)StringsKt.dropLast((String)parentPath, (int)1), (int)0, (int)0, (int)13, null);
            bl2 = false;
            object.add(location2);
        }
        return result;
    }
}

