/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.wire.WireLogger;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.java.Profile;
import com.squareup.wire.java.ProfileLoader;
import com.squareup.wire.kotlin.KotlinGenerator;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0011\u0012\u0013\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH \u00a2\u0006\u0002\b\u0010R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0003\u0015\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lcom/squareup/wire/schema/Target;", "", "()V", "elements", "", "", "getElements", "()Ljava/util/List;", "newHandler", "Lcom/squareup/wire/schema/Target$SchemaHandler;", "schema", "Lcom/squareup/wire/schema/Schema;", "fs", "Ljava/nio/file/FileSystem;", "logger", "Lcom/squareup/wire/WireLogger;", "newHandler$wire_compiler", "JavaTarget", "KotlinTarget", "NullTarget", "SchemaHandler", "Lcom/squareup/wire/schema/Target$JavaTarget;", "Lcom/squareup/wire/schema/Target$KotlinTarget;", "Lcom/squareup/wire/schema/Target$NullTarget;", "wire-compiler"})
public abstract class Target {
    @NotNull
    public abstract List<String> getElements();

    @NotNull
    public abstract SchemaHandler newHandler$wire_compiler(@NotNull Schema var1, @NotNull FileSystem var2, @NotNull WireLogger var3);

    private Target() {
    }

    public /* synthetic */ Target(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003JA\u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J%\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0010\u00a2\u0006\u0002\b&J\t\u0010'\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lcom/squareup/wire/schema/Target$JavaTarget;", "Lcom/squareup/wire/schema/Target;", "elements", "", "", "outDirectory", "android", "", "androidAnnotations", "compact", "(Ljava/util/List;Ljava/lang/String;ZZZ)V", "getAndroid", "()Z", "getAndroidAnnotations", "getCompact", "getElements", "()Ljava/util/List;", "getOutDirectory", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "newHandler", "Lcom/squareup/wire/schema/Target$SchemaHandler;", "schema", "Lcom/squareup/wire/schema/Schema;", "fs", "Ljava/nio/file/FileSystem;", "logger", "Lcom/squareup/wire/WireLogger;", "newHandler$wire_compiler", "toString", "wire-compiler"})
    public static final class JavaTarget
    extends Target {
        @NotNull
        private final List<String> elements;
        @NotNull
        private final String outDirectory;
        private final boolean android;
        private final boolean androidAnnotations;
        private final boolean compact;

        @Override
        @NotNull
        public SchemaHandler newHandler$wire_compiler(@NotNull Schema schema, @NotNull FileSystem fs, @NotNull WireLogger logger) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            String profileName = this.android ? "android" : "java";
            Profile profile = new ProfileLoader(fs, profileName).schema(schema).load();
            JavaGenerator javaGenerator = JavaGenerator.get((Schema)schema).withProfile(profile).withAndroid(this.android).withAndroidAnnotations(this.androidAnnotations).withCompact(this.compact);
            return new SchemaHandler(this, javaGenerator, fs, logger){
                final /* synthetic */ JavaTarget this$0;
                final /* synthetic */ JavaGenerator $javaGenerator;
                final /* synthetic */ FileSystem $fs;
                final /* synthetic */ WireLogger $logger;

                public void handle(@NotNull Type type) {
                    Path path;
                    Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
                    TypeSpec typeSpec = this.$javaGenerator.generateType(type);
                    ClassName javaTypeName = this.$javaGenerator.generatedTypeName(type);
                    JavaFile.Builder builder = JavaFile.builder((String)javaTypeName.packageName(), (TypeSpec)typeSpec).addFileComment("$L", new Object[]{"Code generated by Wire protocol buffer compiler, do not edit."});
                    boolean bl = false;
                    boolean bl2 = false;
                    JavaFile.Builder $this$apply = builder;
                    boolean bl3 = false;
                    Location location = type.location();
                    if (location != null) {
                        $this$apply.addFileComment("\nSource file: $L", new Object[]{location.withPathOnly()});
                    }
                    JavaFile javaFile = builder.build();
                    Path path2 = path = this.$fs.getPath(this.this$0.getOutDirectory(), new String[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
                    JavaFile javaFile2 = javaFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)javaFile2, (String)"javaFile");
                    this.$logger.artifact(path2, javaFile2);
                    try {
                        javaFile.writeTo(path);
                    }
                    catch (IOException e) {
                        throw (Throwable)new IOException("Error emitting " + javaFile.packageName + '.' + javaFile.typeSpec.name + ' ' + "to " + this.this$0.getOutDirectory(), e);
                    }
                }

                public void handle(@NotNull Service service) {
                    Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
                }
                {
                    this.this$0 = $outer;
                    this.$javaGenerator = $captured_local_variable$1;
                    this.$fs = $captured_local_variable$2;
                    this.$logger = $captured_local_variable$3;
                }
            };
        }

        @Override
        @NotNull
        public List<String> getElements() {
            return this.elements;
        }

        @NotNull
        public final String getOutDirectory() {
            return this.outDirectory;
        }

        public final boolean getAndroid() {
            return this.android;
        }

        public final boolean getAndroidAnnotations() {
            return this.androidAnnotations;
        }

        public final boolean getCompact() {
            return this.compact;
        }

        public JavaTarget(@NotNull List<String> elements, @NotNull String outDirectory, boolean android, boolean androidAnnotations, boolean compact) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull((Object)outDirectory, (String)"outDirectory");
            super(null);
            this.elements = elements;
            this.outDirectory = outDirectory;
            this.android = android;
            this.androidAnnotations = androidAnnotations;
            this.compact = compact;
        }

        public /* synthetic */ JavaTarget(List list, String string, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.listOf((Object)"*");
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            if ((n & 0x10) != 0) {
                bl3 = false;
            }
            this(list, string, bl, bl2, bl3);
        }

        @NotNull
        public final List<String> component1() {
            return this.getElements();
        }

        @NotNull
        public final String component2() {
            return this.outDirectory;
        }

        public final boolean component3() {
            return this.android;
        }

        public final boolean component4() {
            return this.androidAnnotations;
        }

        public final boolean component5() {
            return this.compact;
        }

        @NotNull
        public final JavaTarget copy(@NotNull List<String> elements, @NotNull String outDirectory, boolean android, boolean androidAnnotations, boolean compact) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull((Object)outDirectory, (String)"outDirectory");
            return new JavaTarget(elements, outDirectory, android, androidAnnotations, compact);
        }

        @NotNull
        public static /* synthetic */ JavaTarget copy$default(JavaTarget javaTarget, List list, String string, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                list = javaTarget.getElements();
            }
            if ((n & 2) != 0) {
                string = javaTarget.outDirectory;
            }
            if ((n & 4) != 0) {
                bl = javaTarget.android;
            }
            if ((n & 8) != 0) {
                bl2 = javaTarget.androidAnnotations;
            }
            if ((n & 0x10) != 0) {
                bl3 = javaTarget.compact;
            }
            return javaTarget.copy(list, string, bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "JavaTarget(elements=" + this.getElements() + ", outDirectory=" + this.outDirectory + ", android=" + this.android + ", androidAnnotations=" + this.androidAnnotations + ", compact=" + this.compact + ")";
        }

        public int hashCode() {
            List<String> list = this.getElements();
            String string = this.outDirectory;
            int n = ((list != null ? ((Object)list).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31;
            int n2 = this.android ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.androidAnnotations ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            int n5 = (n3 + n4) * 31;
            int n6 = this.compact ? 1 : 0;
            if (n6 != 0) {
                n6 = 1;
            }
            return n5 + n6;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof JavaTarget)) break block3;
                    JavaTarget javaTarget = (JavaTarget)object;
                    if (!Intrinsics.areEqual(this.getElements(), javaTarget.getElements()) || !Intrinsics.areEqual((Object)this.outDirectory, (Object)javaTarget.outDirectory) || !(this.android == javaTarget.android) || !(this.androidAnnotations == javaTarget.androidAnnotations) || !(this.compact == javaTarget.compact)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003JK\u0010\u001b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J%\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0010\u00a2\u0006\u0002\b)J\t\u0010*\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006+"}, d2={"Lcom/squareup/wire/schema/Target$KotlinTarget;", "Lcom/squareup/wire/schema/Target;", "elements", "", "", "outDirectory", "android", "", "javaInterop", "blockingServices", "singleMethodServices", "(Ljava/util/List;Ljava/lang/String;ZZZZ)V", "getAndroid", "()Z", "getBlockingServices", "getElements", "()Ljava/util/List;", "getJavaInterop", "getOutDirectory", "()Ljava/lang/String;", "getSingleMethodServices", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "hashCode", "", "newHandler", "Lcom/squareup/wire/schema/Target$SchemaHandler;", "schema", "Lcom/squareup/wire/schema/Schema;", "fs", "Ljava/nio/file/FileSystem;", "logger", "Lcom/squareup/wire/WireLogger;", "newHandler$wire_compiler", "toString", "wire-compiler"})
    public static final class KotlinTarget
    extends Target {
        @NotNull
        private final List<String> elements;
        @NotNull
        private final String outDirectory;
        private final boolean android;
        private final boolean javaInterop;
        private final boolean blockingServices;
        private final boolean singleMethodServices;

        @Override
        @NotNull
        public SchemaHandler newHandler$wire_compiler(@NotNull Schema schema, @NotNull FileSystem fs, @NotNull WireLogger logger) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            KotlinGenerator kotlinGenerator = KotlinGenerator.Companion.get(schema, this.android, this.javaInterop, this.blockingServices);
            return new SchemaHandler(this, kotlinGenerator, fs, logger){
                final /* synthetic */ KotlinTarget this$0;
                final /* synthetic */ KotlinGenerator $kotlinGenerator;
                final /* synthetic */ FileSystem $fs;
                final /* synthetic */ WireLogger $logger;

                public void handle(@NotNull Type type) {
                    Path path;
                    Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
                    com.squareup.kotlinpoet.TypeSpec typeSpec = this.$kotlinGenerator.generateType(type);
                    com.squareup.kotlinpoet.ClassName className = this.$kotlinGenerator.generatedTypeName(type);
                    String string = className.getPackageName();
                    String string2 = typeSpec.getName();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    FileSpec.Builder builder = FileSpec.Companion.builder(string, string2).addComment("Code generated by Wire protocol buffer compiler, do not edit.", new Object[0]);
                    boolean bl = false;
                    boolean bl2 = false;
                    FileSpec.Builder $this$apply = builder;
                    boolean bl3 = false;
                    Location location = type.location();
                    if (location != null) {
                        $this$apply.addComment("\nSource file: %L", new Object[]{location.withPathOnly()});
                    }
                    FileSpec kotlinFile = builder.addType(typeSpec).build();
                    Path path2 = path = this.$fs.getPath(this.this$0.getOutDirectory(), new String[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
                    this.$logger.artifact(path2, kotlinFile);
                    try {
                        kotlinFile.writeTo(path);
                    }
                    catch (IOException e) {
                        throw (Throwable)new IOException("Error emitting " + kotlinFile.getPackageName() + '.' + className.getCanonicalName() + " to " + this.this$0.getOutDirectory(), e);
                    }
                }

                public void handle(@NotNull Service service) {
                    Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
                    if (this.this$0.getSingleMethodServices()) {
                        ImmutableList immutableList = service.rpcs();
                        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"service.rpcs()");
                        Iterable $this$forEach$iv = (Iterable)immutableList;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Rpc rpc = (Rpc)element$iv;
                            boolean bl = false;
                            this.write(service, this.$kotlinGenerator.generateService(service, rpc));
                        }
                    } else {
                        this.write(service, KotlinGenerator.generateService$default((KotlinGenerator)this.$kotlinGenerator, (Service)service, null, (int)2, null));
                    }
                }

                private final void write(Service service, com.squareup.kotlinpoet.TypeSpec typeSpec) {
                    Path path;
                    String packageName;
                    String string = packageName = service.type().enclosingTypeOrPackage();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageName");
                    String string2 = typeSpec.getName();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    FileSpec.Builder builder = FileSpec.Companion.builder(string, string2).addComment("Code generated by Wire protocol buffer compiler, do not edit.", new Object[0]);
                    boolean bl = false;
                    boolean bl2 = false;
                    FileSpec.Builder $this$apply = builder;
                    boolean bl3 = false;
                    Location location = service.location();
                    if (location != null) {
                        Location location2 = location;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Location it = location2;
                        boolean bl6 = false;
                        $this$apply.addComment("\nSource file: %L", new Object[]{it.withPathOnly()});
                    }
                    FileSpec kotlinFile = builder.addType(typeSpec).build();
                    Path path2 = path = this.$fs.getPath(this.this$0.getOutDirectory(), new String[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
                    this.$logger.artifact(path2, kotlinFile);
                    try {
                        kotlinFile.writeTo(path);
                    }
                    catch (IOException e) {
                        throw (Throwable)new IOException("Error emitting " + kotlinFile.getPackageName() + '.' + service.type() + " to " + this.this$0.getOutDirectory(), e);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$kotlinGenerator = $captured_local_variable$1;
                    this.$fs = $captured_local_variable$2;
                    this.$logger = $captured_local_variable$3;
                }
            };
        }

        @Override
        @NotNull
        public List<String> getElements() {
            return this.elements;
        }

        @NotNull
        public final String getOutDirectory() {
            return this.outDirectory;
        }

        public final boolean getAndroid() {
            return this.android;
        }

        public final boolean getJavaInterop() {
            return this.javaInterop;
        }

        public final boolean getBlockingServices() {
            return this.blockingServices;
        }

        public final boolean getSingleMethodServices() {
            return this.singleMethodServices;
        }

        public KotlinTarget(@NotNull List<String> elements, @NotNull String outDirectory, boolean android, boolean javaInterop, boolean blockingServices, boolean singleMethodServices) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull((Object)outDirectory, (String)"outDirectory");
            super(null);
            this.elements = elements;
            this.outDirectory = outDirectory;
            this.android = android;
            this.javaInterop = javaInterop;
            this.blockingServices = blockingServices;
            this.singleMethodServices = singleMethodServices;
        }

        public /* synthetic */ KotlinTarget(List list, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.listOf((Object)"*");
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            if ((n & 0x10) != 0) {
                bl3 = false;
            }
            if ((n & 0x20) != 0) {
                bl4 = false;
            }
            this(list, string, bl, bl2, bl3, bl4);
        }

        @NotNull
        public final List<String> component1() {
            return this.getElements();
        }

        @NotNull
        public final String component2() {
            return this.outDirectory;
        }

        public final boolean component3() {
            return this.android;
        }

        public final boolean component4() {
            return this.javaInterop;
        }

        public final boolean component5() {
            return this.blockingServices;
        }

        public final boolean component6() {
            return this.singleMethodServices;
        }

        @NotNull
        public final KotlinTarget copy(@NotNull List<String> elements, @NotNull String outDirectory, boolean android, boolean javaInterop, boolean blockingServices, boolean singleMethodServices) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull((Object)outDirectory, (String)"outDirectory");
            return new KotlinTarget(elements, outDirectory, android, javaInterop, blockingServices, singleMethodServices);
        }

        @NotNull
        public static /* synthetic */ KotlinTarget copy$default(KotlinTarget kotlinTarget, List list, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                list = kotlinTarget.getElements();
            }
            if ((n & 2) != 0) {
                string = kotlinTarget.outDirectory;
            }
            if ((n & 4) != 0) {
                bl = kotlinTarget.android;
            }
            if ((n & 8) != 0) {
                bl2 = kotlinTarget.javaInterop;
            }
            if ((n & 0x10) != 0) {
                bl3 = kotlinTarget.blockingServices;
            }
            if ((n & 0x20) != 0) {
                bl4 = kotlinTarget.singleMethodServices;
            }
            return kotlinTarget.copy(list, string, bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "KotlinTarget(elements=" + this.getElements() + ", outDirectory=" + this.outDirectory + ", android=" + this.android + ", javaInterop=" + this.javaInterop + ", blockingServices=" + this.blockingServices + ", singleMethodServices=" + this.singleMethodServices + ")";
        }

        public int hashCode() {
            List<String> list = this.getElements();
            String string = this.outDirectory;
            int n = ((list != null ? ((Object)list).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31;
            int n2 = this.android ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.javaInterop ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            int n5 = (n3 + n4) * 31;
            int n6 = this.blockingServices ? 1 : 0;
            if (n6 != 0) {
                n6 = 1;
            }
            int n7 = (n5 + n6) * 31;
            int n8 = this.singleMethodServices ? 1 : 0;
            if (n8 != 0) {
                n8 = 1;
            }
            return n7 + n8;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof KotlinTarget)) break block3;
                    KotlinTarget kotlinTarget = (KotlinTarget)object;
                    if (!Intrinsics.areEqual(this.getElements(), kotlinTarget.getElements()) || !Intrinsics.areEqual((Object)this.outDirectory, (Object)kotlinTarget.outDirectory) || !(this.android == kotlinTarget.android) || !(this.javaInterop == kotlinTarget.javaInterop) || !(this.blockingServices == kotlinTarget.blockingServices) || !(this.singleMethodServices == kotlinTarget.singleMethodServices)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J%\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b\u0018J\t\u0010\u0019\u001a\u00020\u0004H\u00d6\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/squareup/wire/schema/Target$NullTarget;", "Lcom/squareup/wire/schema/Target;", "elements", "", "", "(Ljava/util/List;)V", "getElements", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "newHandler", "Lcom/squareup/wire/schema/Target$SchemaHandler;", "schema", "Lcom/squareup/wire/schema/Schema;", "fs", "Ljava/nio/file/FileSystem;", "logger", "Lcom/squareup/wire/WireLogger;", "newHandler$wire_compiler", "toString", "wire-compiler"})
    public static final class NullTarget
    extends Target {
        @NotNull
        private final List<String> elements;

        @Override
        @NotNull
        public SchemaHandler newHandler$wire_compiler(@NotNull Schema schema, @NotNull FileSystem fs, @NotNull WireLogger logger) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            return new SchemaHandler(logger){
                final /* synthetic */ WireLogger $logger;

                public void handle(@NotNull Type type) {
                    Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
                    ProtoType protoType = type.type();
                    Intrinsics.checkExpressionValueIsNotNull((Object)protoType, (String)"type.type()");
                    this.$logger.artifactSkipped(protoType);
                }

                public void handle(@NotNull Service service) {
                    Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
                    ProtoType protoType = service.type();
                    Intrinsics.checkExpressionValueIsNotNull((Object)protoType, (String)"service.type()");
                    this.$logger.artifactSkipped(protoType);
                }
                {
                    this.$logger = $captured_local_variable$0;
                }
            };
        }

        @Override
        @NotNull
        public List<String> getElements() {
            return this.elements;
        }

        public NullTarget(@NotNull List<String> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            super(null);
            this.elements = elements;
        }

        public /* synthetic */ NullTarget(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.listOf((Object)"*");
            }
            this(list);
        }

        public NullTarget() {
            this(null, 1, null);
        }

        @NotNull
        public final List<String> component1() {
            return this.getElements();
        }

        @NotNull
        public final NullTarget copy(@NotNull List<String> elements) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            return new NullTarget(elements);
        }

        @NotNull
        public static /* synthetic */ NullTarget copy$default(NullTarget nullTarget, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = nullTarget.getElements();
            }
            return nullTarget.copy(list);
        }

        @NotNull
        public String toString() {
            return "NullTarget(elements=" + this.getElements() + ")";
        }

        public int hashCode() {
            List<String> list = this.getElements();
            return list != null ? ((Object)list).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NullTarget)) break block3;
                    NullTarget nullTarget = (NullTarget)object;
                    if (!Intrinsics.areEqual(this.getElements(), nullTarget.getElements())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/squareup/wire/schema/Target$SchemaHandler;", "", "handle", "", "service", "Lcom/squareup/wire/schema/Service;", "type", "Lcom/squareup/wire/schema/Type;", "wire-compiler"})
    public static interface SchemaHandler {
        public void handle(@NotNull Type var1);

        public void handle(@NotNull Service var1);
    }
}

