/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.wire.PendingFileSpec;
import com.squareup.wire.PendingServiceFileSpec;
import com.squareup.wire.PendingTypeFileSpec;
import com.squareup.wire.WireLogger;
import com.squareup.wire.kotlin.KotlinGenerator;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/squareup/wire/KotlinFileWriter;", "Ljava/util/concurrent/Callable;", "", "destination", "", "kotlinGenerator", "Lcom/squareup/wire/kotlin/KotlinGenerator;", "queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/squareup/wire/PendingFileSpec;", "fs", "Ljava/nio/file/FileSystem;", "log", "Lcom/squareup/wire/WireLogger;", "dryRun", "", "(Ljava/lang/String;Lcom/squareup/wire/kotlin/KotlinGenerator;Ljava/util/concurrent/ConcurrentLinkedQueue;Ljava/nio/file/FileSystem;Lcom/squareup/wire/WireLogger;Z)V", "call", "generateFile", "Lcom/squareup/kotlinpoet/FileSpec;", "packageName", "typeSpec", "Lcom/squareup/kotlinpoet/TypeSpec;", "location", "Lcom/squareup/wire/schema/Location;", "generateFileForService", "service", "Lcom/squareup/wire/schema/Service;", "generateFileForType", "type", "Lcom/squareup/wire/schema/Type;", "wire-compiler"})
public final class KotlinFileWriter
implements Callable<Unit> {
    private final String destination;
    private final KotlinGenerator kotlinGenerator;
    private final ConcurrentLinkedQueue<PendingFileSpec> queue;
    private final FileSystem fs;
    private final WireLogger log;
    private final boolean dryRun;

    @Override
    public void call() throws IOException {
        while (this.queue.poll() != null) {
            Path path;
            FileSpec fileSpec;
            PendingFileSpec pendingFile;
            PendingFileSpec pendingFileSpec = pendingFile;
            if (pendingFileSpec instanceof PendingTypeFileSpec) {
                fileSpec = this.generateFileForType(((PendingTypeFileSpec)pendingFile).getType());
            } else if (pendingFileSpec instanceof PendingServiceFileSpec) {
                fileSpec = this.generateFileForService(((PendingServiceFileSpec)pendingFile).getService());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            FileSpec kotlinFile = fileSpec;
            Path path2 = path = this.fs.getPath(this.destination, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
            this.log.artifact(path2, kotlinFile);
            if (this.dryRun) {
                return;
            }
            try {
                kotlinFile.writeTo(path);
            }
            catch (IOException e) {
                String string;
                PendingFileSpec pendingFileSpec2 = pendingFile;
                if (pendingFileSpec2 instanceof PendingTypeFileSpec) {
                    string = this.kotlinGenerator.generatedTypeName(((PendingTypeFileSpec)pendingFile).getType()).getCanonicalName();
                } else if (pendingFileSpec2 instanceof PendingServiceFileSpec) {
                    String string2 = ((PendingServiceFileSpec)pendingFile).getService().type().toString();
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"pendingFile.service.type().toString()");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String className = string;
                throw (Throwable)new IOException("Error emitting " + kotlinFile.getPackageName() + '.' + className + " to " + this.destination, e);
            }
        }
        return;
    }

    private final FileSpec generateFileForType(Type type) {
        return this.generateFile(this.kotlinGenerator.generatedTypeName(type).getPackageName(), this.kotlinGenerator.generateType(type), type.location());
    }

    private final FileSpec generateFileForService(Service service) {
        String string = service.type().enclosingTypeOrPackage();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"service.type().enclosingTypeOrPackage()");
        return this.generateFile(string, this.kotlinGenerator.generateService(service), service.location());
    }

    private final FileSpec generateFile(String packageName, TypeSpec typeSpec, Location location) {
        FileSpec.Builder builder;
        String string = typeSpec.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        FileSpec.Builder $receiver = builder = FileSpec.Companion.builder(packageName, string).addComment("Code generated by Wire protocol buffer compiler, do not edit.", new Object[0]).indent("  ");
        boolean bl = false;
        if (location != null) {
            $receiver.addComment("\nSource file: %L", new Object[]{location.withPathOnly()});
        }
        return builder.addType(typeSpec).build();
    }

    public KotlinFileWriter(@NotNull String destination, @NotNull KotlinGenerator kotlinGenerator, @NotNull ConcurrentLinkedQueue<PendingFileSpec> queue, @NotNull FileSystem fs, @NotNull WireLogger log, boolean dryRun) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Intrinsics.checkParameterIsNotNull((Object)kotlinGenerator, (String)"kotlinGenerator");
        Intrinsics.checkParameterIsNotNull(queue, (String)"queue");
        Intrinsics.checkParameterIsNotNull((Object)fs, (String)"fs");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        this.destination = destination;
        this.kotlinGenerator = kotlinGenerator;
        this.queue = queue;
        this.fs = fs;
        this.log = log;
        this.dryRun = dryRun;
    }
}

