/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.java;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.java.ServiceFactory;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.io.IOException;
import java.util.List;
import javax.lang.model.element.Modifier;

public class SimpleServiceFactory
implements ServiceFactory {
    @Override
    public TypeSpec create(JavaGenerator javaGenerator, List<String> options, Service service) {
        ClassName interfaceName = (ClassName)javaGenerator.typeName(service.name());
        TypeSpec.Builder typeBuilder = TypeSpec.interfaceBuilder((String)interfaceName.simpleName());
        typeBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (!service.documentation().isEmpty()) {
            typeBuilder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(service.documentation())});
        }
        for (Rpc rpc : service.rpcs()) {
            Type.Name requestType = rpc.requestType();
            TypeName requestJavaType = javaGenerator.typeName(requestType);
            Type.Name responseType = rpc.responseType();
            TypeName responseJavaType = javaGenerator.typeName(responseType);
            MethodSpec.Builder rpcBuilder = MethodSpec.methodBuilder((String)this.upperToLowerCamel(rpc.name()));
            rpcBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            rpcBuilder.returns(responseJavaType);
            rpcBuilder.addException(IOException.class);
            rpcBuilder.addParameter(requestJavaType, this.upperToLowerCamel(requestType.simpleName()), new Modifier[0]);
            if (!rpc.documentation().isEmpty()) {
                rpcBuilder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(rpc.documentation())});
            }
            typeBuilder.addMethod(rpcBuilder.build());
        }
        return typeBuilder.build();
    }

    private String upperToLowerCamel(String string) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, string);
    }
}

