/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javapoet.JavaFile;
import com.squareup.wire.WireLogger;
import java.io.File;

final class ConsoleWireLogger
implements WireLogger {
    private final boolean isQuiet;

    public ConsoleWireLogger(boolean quiet) {
        this.isQuiet = quiet;
    }

    @Override
    public void info(String message) {
        if (!this.isQuiet) {
            System.out.println(message);
        }
    }

    @Override
    public void artifact(File outputDirectory, JavaFile javaFile) {
        if (this.isQuiet) {
            System.out.printf("%s.%s%n", javaFile.packageName, javaFile.typeSpec.name);
        } else {
            System.out.printf("Writing %s.%s to %s%n", javaFile.packageName, javaFile.typeSpec.name, outputDirectory);
        }
    }
}

