/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.java;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.wire.java.JavaGenerator;
import com.squareup.wire.java.ServiceFactory;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.List;
import javax.lang.model.element.Modifier;

public class RxJavaServiceFactory
implements ServiceFactory {
    public static final ClassName POST = ClassName.get((String)"retrofit.http", (String)"POST", (String[])new String[0]);
    public static final ClassName BODY = ClassName.get((String)"retrofit.http", (String)"Body", (String[])new String[0]);
    public static final ClassName FUNC1 = ClassName.get((String)"rx.functions", (String)"Func1", (String[])new String[0]);
    public static final ClassName INJECT = ClassName.get((String)"javax.inject", (String)"Inject", (String[])new String[0]);

    @Override
    public TypeSpec create(JavaGenerator javaGenerator, List<String> options, Service service) {
        ClassName interfaceName = this.interfaceName(javaGenerator, options, service);
        ClassName endpointName = interfaceName.nestedClass("Endpoint");
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)interfaceName.simpleName());
        typeBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        if (!service.documentation().isEmpty()) {
            typeBuilder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(service.documentation())});
        }
        TypeSpec.Builder endpointBuilder = TypeSpec.interfaceBuilder((String)endpointName.simpleName());
        endpointBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        typeBuilder.addMethod(MethodSpec.constructorBuilder().addAnnotation(INJECT).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)endpointName, "endpoint", new Modifier[0]).addStatement("this.endpoint = endpoint", new Object[0]).build());
        for (Rpc rpc : service.rpcs()) {
            Type.Name requestType = rpc.requestType();
            TypeName requestJavaType = javaGenerator.typeName(requestType);
            Type.Name responseType = rpc.responseType();
            TypeName responseJavaType = javaGenerator.typeName(responseType);
            String methodName = this.upperToLowerCamel(rpc.name());
            MethodSpec.Builder rpcBuilder = MethodSpec.methodBuilder((String)methodName);
            rpcBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            rpcBuilder.returns(responseJavaType);
            rpcBuilder.addAnnotation(AnnotationSpec.builder((ClassName)POST).addMember("value", "$S", new Object[]{"/" + service.name() + "/" + rpc.name()}).build());
            rpcBuilder.addParameter(ParameterSpec.builder((TypeName)requestJavaType, (String)"request", (Modifier[])new Modifier[0]).addAnnotation(BODY).build());
            if (!rpc.documentation().isEmpty()) {
                rpcBuilder.addJavadoc("$L\n", new Object[]{JavaGenerator.sanitizeJavadoc(rpc.documentation())});
            }
            endpointBuilder.addMethod(rpcBuilder.build());
            ParameterizedTypeName functionType = ParameterizedTypeName.get((ClassName)FUNC1, (TypeName[])new TypeName[]{requestJavaType, responseJavaType});
            typeBuilder.addField(FieldSpec.builder((TypeName)functionType, (String)methodName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("$L", new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)functionType).addMethod(MethodSpec.methodBuilder((String)"call").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(responseJavaType).addParameter(requestJavaType, "request", new Modifier[0]).addStatement("return endpoint.$L(request)", new Object[]{methodName}).build()).build()}).build());
            typeBuilder.addMethod(MethodSpec.methodBuilder((String)("get" + rpc.name())).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)functionType).addStatement("return $L", new Object[]{methodName}).build());
        }
        typeBuilder.addField((TypeName)endpointName, "endpoint", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        typeBuilder.addType(endpointBuilder.build());
        return typeBuilder.build();
    }

    private String upperToLowerCamel(String string) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, string);
    }

    protected ClassName interfaceName(JavaGenerator javaGenerator, List<String> options, Service service) {
        return (ClassName)javaGenerator.typeName(service.name());
    }
}

