/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javawriter.JavaWriter;
import com.squareup.protoparser.EnumConstantElement;
import com.squareup.protoparser.EnumElement;
import com.squareup.protoparser.FieldElement;
import com.squareup.protoparser.MessageElement;
import com.squareup.protoparser.OneOfElement;
import com.squareup.protoparser.OptionElement;
import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.TypeElement;
import com.squareup.wire.ExtensionInfo;
import com.squareup.wire.FieldInfo;
import com.squareup.wire.Message;
import com.squareup.wire.OptionsMapMaker;
import com.squareup.wire.ProtoField;
import com.squareup.wire.TypeInfo;
import com.squareup.wire.WireCompiler;
import com.squareup.wire.WireCompilerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Modifier;

public class MessageWriter {
    private static final Set<String> JAVA_KEYWORDS = new LinkedHashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"));
    private static final String URL_CHARS = "[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]";
    private final WireCompiler compiler;

    public MessageWriter(WireCompiler compiler) {
        this.compiler = compiler;
    }

    public static void emitDocumentation(JavaWriter writer, String documentation) throws IOException {
        if (MessageWriter.hasDocumentation(documentation)) {
            writer.emitJavadoc(MessageWriter.sanitizeJavadoc(documentation), new Object[0]);
        }
    }

    static String sanitizeJavadoc(String documentation) {
        documentation = documentation.replace("%", "%%");
        documentation = documentation.replaceAll("[^\\S\n]+\n", "\n");
        documentation = documentation.replaceAll("\\s+$", "");
        documentation = documentation.replaceAll("@see (http:[-!#$%&'()*+,./0-9:;=?@A-Z\\[\\]_a-z~]+)", "@see <a href=\"$1\">$1</a>");
        return documentation;
    }

    public void emitHeader(JavaWriter writer, Set<String> imports, Collection<Message.Datatype> datatypes, Collection<Message.Label> labels) throws IOException {
        writer.emitImports(imports);
        if (!datatypes.isEmpty() || !labels.isEmpty()) {
            writer.emitEmptyLine();
        }
        for (Message.Datatype datatype : datatypes) {
            writer.emitStaticImports(new String[]{"com.squareup.wire.Message.Datatype." + datatype.toString()});
        }
        for (Message.Label label : labels) {
            writer.emitStaticImports(new String[]{"com.squareup.wire.Message.Label." + label.toString()});
        }
    }

    public void emitType(JavaWriter writer, TypeElement type, String currentType, Map<String, ?> optionsMap, boolean topLevel) throws IOException {
        writer.emitEmptyLine();
        if (type instanceof MessageElement) {
            this.emitAll(writer, (MessageElement)type, optionsMap, topLevel);
            for (TypeElement nestedType : type.nestedElements()) {
                this.emitType(writer, nestedType, currentType + nestedType.name() + ".", optionsMap, false);
            }
            writer.endType();
        } else if (type instanceof EnumElement) {
            EnumElement enumType = (EnumElement)type;
            OptionsMapMaker mapMaker = new OptionsMapMaker(this.compiler);
            List<EnumValueOptionInfo> options = this.getEnumValueOptions(enumType, mapMaker);
            writer.beginType(enumType.name(), "enum", EnumSet.of(Modifier.PUBLIC), null, new String[]{"ProtoEnum"});
            List values = enumType.constants();
            int count = values.size();
            for (int i = 0; i < count; ++i) {
                EnumConstantElement value = (EnumConstantElement)values.get(i);
                MessageWriter.emitDocumentation(writer, value.documentation());
                ArrayList<String> initializers = new ArrayList<String>();
                initializers.add(String.valueOf(value.tag()));
                this.addEnumValueOptionInitializers(value, options, mapMaker, initializers);
                writer.emitEnumValue(value.name() + "(" + this.join(initializers, ", ") + ")", i == count - 1);
            }
            if (this.compiler.shouldEmitOptions()) {
                this.emitEnumOptions(writer, mapMaker.createEnumOptionsMap(enumType));
            }
            writer.emitEmptyLine();
            writer.emitField("int", "value", EnumSet.of(Modifier.PRIVATE, Modifier.FINAL));
            for (EnumValueOptionInfo option : options) {
                writer.emitField(option.type, this.trailingSegment(option.name), EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
            }
            writer.emitEmptyLine();
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add("int");
            parameters.add("value");
            for (EnumValueOptionInfo option : options) {
                parameters.add(option.type);
                parameters.add(this.trailingSegment(option.name));
            }
            writer.beginConstructor(Collections.emptySet(), parameters, null);
            writer.emitStatement("this.value = value", new Object[0]);
            for (EnumValueOptionInfo option : options) {
                String name = this.trailingSegment(option.name);
                writer.emitStatement("this.%s = %s", new Object[]{name, name});
            }
            writer.endConstructor();
            writer.emitEmptyLine();
            writer.emitAnnotation(Override.class);
            writer.beginMethod("int", "getValue", EnumSet.of(Modifier.PUBLIC), new String[0]);
            writer.emitStatement("return value", new Object[0]);
            writer.endMethod();
            writer.endType();
        }
    }

    private List<EnumValueOptionInfo> getEnumValueOptions(EnumElement enumType, OptionsMapMaker mapMaker) {
        if (!this.compiler.shouldEmitOptions() && this.compiler.enumOptions().isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, ?> optionsMap = mapMaker.createEnumValueOptionsMap(enumType);
        if (optionsMap == null || optionsMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EnumValueOptionInfo> result = new ArrayList<EnumValueOptionInfo>();
        TreeSet<String> optionNames = new TreeSet<String>();
        for (EnumConstantElement value : enumType.constants()) {
            for (OptionElement option : value.options()) {
                optionNames.add(option.name());
            }
        }
        Set<String> fqNames = optionsMap.keySet();
        for (String optionName : optionNames) {
            for (String fqName : fqNames) {
                if (!fqName.equals(optionName) && !fqName.endsWith("." + optionName) || !this.compiler.enumOptions().contains(fqName)) continue;
                ExtensionInfo info = this.compiler.getExtension(fqName);
                result.add(new EnumValueOptionInfo(this.compiler.javaName(null, info.fqType), optionName));
            }
        }
        return result;
    }

    private void addEnumValueOptionInitializers(EnumConstantElement value, List<EnumValueOptionInfo> optionInfo, OptionsMapMaker mapMaker, List<String> initializers) {
        Map<String, ?> enumValueOptionsMap = mapMaker.createSingleEnumValueOptionMap(value);
        List valueOptions = value.options();
        for (EnumValueOptionInfo option : optionInfo) {
            OptionElement optionByName = OptionElement.findByName((List)valueOptions, (String)option.name);
            String initializer = null;
            if (optionByName != null) {
                for (Map.Entry<String, ?> entry : enumValueOptionsMap.entrySet()) {
                    String fqName = entry.getKey();
                    ExtensionInfo info = this.compiler.getExtension(fqName);
                    String name = optionByName.name();
                    if (!fqName.equals(name) && !fqName.endsWith("." + name)) continue;
                    initializer = mapMaker.createOptionInitializer(entry.getValue(), "", "", info.fqType, false, 1);
                    break;
                }
            }
            initializers.add(initializer);
        }
    }

    private String trailingSegment(String s) {
        int index = s.lastIndexOf(46);
        return index == -1 ? s : s.substring(index + 1);
    }

    private String join(List<String> values, String separator) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String value : values) {
            sb.append(sep);
            sb.append(value);
            sep = separator;
        }
        return sb.toString();
    }

    private void emitAll(JavaWriter writer, MessageElement messageType, Map<String, ?> optionsMap, boolean topLevel) throws IOException {
        EnumSet<Modifier> modifiers = EnumSet.of(Modifier.PUBLIC, Modifier.FINAL);
        if (!topLevel) {
            modifiers.add(Modifier.STATIC);
        }
        String name = messageType.name();
        MessageWriter.emitDocumentation(writer, messageType.documentation());
        writer.beginType(name, "class", modifiers, this.compiler.hasExtensions(messageType) ? "ExtendableMessage<" + name + ">" : "Message", new String[0]);
        writer.emitField("long", "serialVersionUID", EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL), "0L");
        this.emitMessageOptions(writer, optionsMap);
        if (this.compiler.shouldEmitOptions()) {
            this.emitMessageFieldOptions(writer, messageType);
        }
        this.emitMessageFieldDefaults(writer, messageType);
        this.emitMessageFields(writer, messageType);
        this.emitMessageFieldsConstructor(writer, messageType);
        this.emitMessageBuilderConstructor(writer, messageType);
        this.emitMessageEquals(writer, messageType);
        this.emitMessageHashCode(writer, messageType);
        this.emitBuilder(writer, messageType);
    }

    private void emitMessageOptions(JavaWriter writer, Map<String, ?> optionsMap) throws IOException {
        if (optionsMap != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("new MessageOptions.Builder()");
            for (Map.Entry<String, ?> entry : optionsMap.entrySet()) {
                String fqName = entry.getKey();
                ExtensionInfo info = this.compiler.getExtension(fqName);
                sb.append(String.format("%n.setExtension(Ext_%s.%s, %s)", info.location, this.compiler.getTrailingSegment(fqName), this.compiler.getOptionsMapMaker().createOptionInitializer(entry.getValue(), "", "", info.fqType, false, 0)));
            }
            sb.append("\n.build()");
            writer.emitEmptyLine();
            writer.emitField("MessageOptions", "MESSAGE_OPTIONS", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), sb.toString());
        }
    }

    private void emitEnumOptions(JavaWriter writer, Map<String, ?> optionsMap) throws IOException {
        if (optionsMap != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("new EnumOptions.Builder()");
            for (Map.Entry<String, ?> entry : optionsMap.entrySet()) {
                String fqName = entry.getKey();
                ExtensionInfo info = this.compiler.getExtension(fqName);
                sb.append(String.format("%n.setExtension(Ext_%s.%s, %s)", info.location, this.compiler.getTrailingSegment(fqName), this.compiler.getOptionsMapMaker().createOptionInitializer(entry.getValue(), "", "", info.fqType, false, 0)));
            }
            sb.append("\n.build()");
            writer.emitEmptyLine();
            writer.emitField("EnumOptions", "ENUM_OPTIONS", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), sb.toString());
        }
    }

    private void emitMessageFieldOptions(JavaWriter writer, MessageElement messageType) throws IOException {
        LinkedHashMap fieldOptions = new LinkedHashMap();
        for (FieldElement fieldElement : WireCompiler.allFields(messageType)) {
            ArrayList options = new ArrayList(fieldElement.options());
            Iterator iterator = options.iterator();
            while (iterator.hasNext()) {
                String name = ((OptionElement)iterator.next()).name();
                if (!WireCompiler.DEFAULT_FIELD_OPTION_KEYS.contains(name)) continue;
                iterator.remove();
            }
            if (options.isEmpty()) continue;
            fieldOptions.put(fieldElement.name(), options);
        }
        if (!fieldOptions.isEmpty()) {
            writer.emitEmptyLine();
        }
        for (Map.Entry entry : fieldOptions.entrySet()) {
            Map<String, ?> fieldOptionsMap = this.compiler.getOptionsMapMaker().createFieldOptionsMap(messageType, (List)entry.getValue());
            this.emitFieldOptions(writer, (String)entry.getKey(), fieldOptionsMap);
        }
    }

    private void emitFieldOptions(JavaWriter writer, String fieldName, Map<String, ?> optionsMap) throws IOException {
        if (optionsMap == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("new FieldOptions.Builder()");
        for (Map.Entry<String, ?> entry : optionsMap.entrySet()) {
            String fqName = entry.getKey();
            ExtensionInfo info = this.compiler.getExtension(fqName);
            if (info == null) {
                throw new WireCompilerException("No extension info for " + fqName);
            }
            sb.append(String.format("%n.setExtension(Ext_%s.%s, %s)", info.location, this.compiler.getTrailingSegment(fqName), this.compiler.getOptionsMapMaker().createOptionInitializer(entry.getValue(), "", "", info.fqType, false, 0)));
        }
        sb.append("\n.build()");
        writer.emitField("FieldOptions", "FIELD_OPTIONS_" + fieldName.toUpperCase(Locale.US), EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), sb.toString());
    }

    private void emitMessageFieldDefaults(JavaWriter writer, MessageElement messageType) throws IOException {
        ArrayList<FieldElement> defaultFields = new ArrayList<FieldElement>();
        for (FieldElement field : WireCompiler.allFields(messageType)) {
            if (this.isMessageType(messageType, field) && !FieldInfo.isRepeated(field)) continue;
            defaultFields.add(field);
        }
        if (!defaultFields.isEmpty()) {
            writer.emitEmptyLine();
        }
        for (FieldElement field : defaultFields) {
            String javaName = this.getJavaFieldType(messageType, field);
            if (javaName == null) {
                throw new WireCompilerException("Unknown type for field " + field + " in message " + messageType.name());
            }
            String defaultValue = this.getDefaultValue(messageType, field);
            writer.emitField(javaName, "DEFAULT_" + field.name().toUpperCase(Locale.US), EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), defaultValue);
        }
    }

    private void emitMessageFields(JavaWriter writer, MessageElement messageType) throws IOException {
        for (FieldElement field : WireCompiler.allFields(messageType)) {
            int tag = field.tag();
            String fieldType = field.type().toString();
            String javaName = this.compiler.javaName(messageType, fieldType);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("tag", String.valueOf(tag));
            boolean isScalar = false;
            boolean isEnum = false;
            if (TypeInfo.isScalar(fieldType)) {
                isScalar = true;
                map.put("type", this.scalarTypeConstant(fieldType));
            } else {
                String fullyQualifiedName = this.compiler.fullyQualifiedName((TypeElement)messageType, fieldType);
                isEnum = this.compiler.isEnum(fullyQualifiedName);
                if (isEnum) {
                    map.put("type", "ENUM");
                }
            }
            if (!FieldInfo.isOptional(field)) {
                if (FieldInfo.isPacked(field, isEnum)) {
                    map.put("label", "PACKED");
                } else {
                    map.put("label", field.label().toString());
                }
            }
            if (FieldInfo.isRepeated(field) && !isScalar) {
                map.put(isEnum ? "enumType" : "messageType", javaName + ".class");
            }
            if (field.isDeprecated()) {
                map.put("deprecated", "true");
            }
            for (OptionElement option : field.options()) {
                if (!this.compiler.isRedacted(option)) continue;
                map.put("redacted", "true");
                break;
            }
            writer.emitEmptyLine();
            MessageWriter.emitDocumentation(writer, field.documentation());
            writer.emitAnnotation(ProtoField.class, map);
            if (field.isDeprecated()) {
                writer.emitAnnotation(Deprecated.class);
            }
            if (FieldInfo.isRepeated(field)) {
                javaName = "List<" + javaName + ">";
            }
            writer.emitField(javaName, this.sanitize(field.name()), EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
        }
    }

    private void emitMessageFieldsConstructor(JavaWriter writer, MessageElement messageType) throws IOException {
        ArrayList<String> params = new ArrayList<String>();
        for (FieldElement field : WireCompiler.allFields(messageType)) {
            String javaName = this.getJavaFieldType(messageType, field);
            params.add(javaName);
            params.add(this.sanitize(field.name()));
        }
        writer.emitEmptyLine();
        writer.beginMethod(null, messageType.name(), EnumSet.of(Modifier.PUBLIC), params, null);
        for (FieldElement field : WireCompiler.allFields(messageType)) {
            String sanitizedName = this.sanitize(field.name());
            if (FieldInfo.isRepeated(field)) {
                writer.emitStatement("this.%1$s = immutableCopyOf(%1$s)", new Object[]{sanitizedName});
                continue;
            }
            writer.emitStatement("this.%1$s = %1$s", new Object[]{sanitizedName});
        }
        writer.endMethod();
    }

    private void emitMessageBuilderConstructor(JavaWriter writer, MessageElement messageType) throws IOException {
        writer.emitEmptyLine();
        writer.beginMethod(null, messageType.name(), EnumSet.of(Modifier.PRIVATE), new String[]{"Builder", "builder"});
        StringBuilder params = new StringBuilder();
        for (FieldElement field : WireCompiler.allFields(messageType)) {
            if (params.length() > 0) {
                params.append(", ");
            }
            params.append("builder.");
            params.append(this.sanitize(field.name()));
        }
        if (params.length() > 0) {
            writer.emitStatement("this(%1$s)", new Object[]{params});
        }
        writer.emitStatement("setBuilder(builder)", new Object[0]);
        writer.endMethod();
    }

    private void emitMessageEquals(JavaWriter writer, MessageElement messageType) throws IOException {
        writer.emitEmptyLine();
        writer.emitAnnotation(Override.class);
        writer.beginMethod("boolean", "equals", EnumSet.of(Modifier.PUBLIC), new String[]{"Object", "other"});
        List<FieldElement> fields = WireCompiler.allFields(messageType);
        if (fields.isEmpty()) {
            writer.emitStatement("return other instanceof %s", new Object[]{messageType.name()});
        } else {
            writer.emitStatement("if (other == this) return true", new Object[0]);
            writer.emitStatement("if (!(other instanceof %s)) return false", new Object[]{messageType.name()});
            if (this.hasOnlyOneField(messageType)) {
                String name = this.sanitize(fields.get(0).name());
                writer.emitStatement("return equals(%1$s, ((%2$s) other).%3$s)", new Object[]{this.addThisIfOneOf(name, "other", "o"), messageType.name(), name});
            } else {
                writer.emitStatement("%1$s o = (%1$s) other", new Object[]{messageType.name()});
                if (this.compiler.hasExtensions(messageType)) {
                    writer.emitStatement("if (!extensionsEqual(o)) return false", new Object[0]);
                }
                StringBuilder sb = new StringBuilder();
                String prefix = "return ";
                for (FieldElement field : fields) {
                    sb.append(prefix);
                    prefix = "\n&& ";
                    String name = this.sanitize(field.name());
                    sb.append(String.format("equals(%1$s, o.%2$s)", this.addThisIfOneOf(name, "other", "o"), name));
                }
                writer.emitStatement(sb.toString(), new Object[0]);
            }
        }
        writer.endMethod();
    }

    private void emitMessageHashCode(JavaWriter writer, MessageElement messageType) throws IOException {
        writer.emitEmptyLine();
        writer.emitAnnotation(Override.class);
        writer.beginMethod("int", "hashCode", EnumSet.of(Modifier.PUBLIC), new String[0]);
        if (!this.compiler.hasFields((TypeElement)messageType) && !this.compiler.hasExtensions(messageType)) {
            writer.emitStatement("return 0", new Object[0]);
        } else if (this.hasOnlyOneField(messageType)) {
            FieldElement field = WireCompiler.allFields(messageType).get(0);
            String name = this.sanitize(field.name());
            name = this.addThisIfOneOf(name, "result");
            writer.emitStatement("int result = hashCode", new Object[0]);
            writer.emitStatement("return result != 0 ? result : (hashCode = %1$s != null ? %1$s.hashCode() : %2$s)", new Object[]{name, this.nullHashValue(field)});
        } else {
            writer.emitStatement("int result = hashCode", new Object[0]);
            writer.beginControlFlow("if (result == 0)", new Object[0]);
            boolean afterFirstAssignment = false;
            if (this.compiler.hasExtensions(messageType)) {
                writer.emitStatement("result = extensionsHashCode()", new Object[0]);
                afterFirstAssignment = true;
            }
            for (FieldElement field : WireCompiler.allFields(messageType)) {
                String name = this.sanitize(field.name());
                name = this.addThisIfOneOf(name, "result");
                if (afterFirstAssignment) {
                    writer.emitStatement("result = result * 37 + (%1$s != null ? %1$s.hashCode() : %2$s)", new Object[]{name, this.nullHashValue(field)});
                    continue;
                }
                writer.emitStatement("result = %1$s != null ? %1$s.hashCode() : %2$s", new Object[]{name, this.nullHashValue(field)});
                afterFirstAssignment = true;
            }
            writer.emitStatement("hashCode = result", new Object[0]);
            writer.endControlFlow();
            writer.emitStatement("return result", new Object[0]);
        }
        writer.endMethod();
    }

    private int nullHashValue(FieldElement field) {
        return FieldInfo.isRepeated(field) ? 1 : 0;
    }

    private void emitBuilder(JavaWriter writer, MessageElement messageType) throws IOException {
        writer.emitEmptyLine();
        writer.beginType("Builder", "class", EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), (this.compiler.hasExtensions(messageType) ? "ExtendableBuilder<" : "Message.Builder<") + messageType.name() + ">", new String[0]);
        this.emitBuilderFields(writer, messageType);
        this.emitBuilderConstructors(writer, messageType);
        this.emitBuilderSetters(writer, messageType);
        if (this.compiler.hasExtensions(messageType)) {
            this.emitBuilderSetExtension(writer, messageType);
        }
        this.emitBuilderBuild(writer, messageType);
        writer.endType();
    }

    private void emitBuilderFields(JavaWriter writer, MessageElement messageType) throws IOException {
        List<FieldElement> fields = WireCompiler.allFields(messageType);
        if (!fields.isEmpty()) {
            writer.emitEmptyLine();
        }
        for (FieldElement field : fields) {
            String javaName = this.getJavaFieldType(messageType, field);
            writer.emitField(javaName, this.sanitize(field.name()), EnumSet.of(Modifier.PUBLIC));
        }
    }

    private void emitBuilderConstructors(JavaWriter writer, MessageElement messageType) throws IOException {
        writer.emitEmptyLine();
        writer.beginMethod(null, "Builder", EnumSet.of(Modifier.PUBLIC), new String[0]);
        writer.endMethod();
        writer.emitEmptyLine();
        writer.beginMethod(null, "Builder", EnumSet.of(Modifier.PUBLIC), new String[]{messageType.name(), "message"});
        writer.emitStatement("super(message)", new Object[0]);
        List<FieldElement> fields = WireCompiler.allFields(messageType);
        if (!fields.isEmpty()) {
            writer.emitStatement("if (message == null) return", new Object[0]);
        }
        for (FieldElement field : fields) {
            if (FieldInfo.isRepeated(field)) {
                writer.emitStatement("this.%1$s = copyOf(message.%1$s)", new Object[]{this.sanitize(field.name())});
                continue;
            }
            writer.emitStatement("this.%1$s = message.%1$s", new Object[]{this.sanitize(field.name())});
        }
        writer.endMethod();
    }

    private void emitBuilderSetters(JavaWriter writer, MessageElement messageType) throws IOException {
        for (FieldElement field : WireCompiler.allFields(messageType)) {
            String javaName = this.getJavaFieldType(messageType, field);
            ArrayList<String> args = new ArrayList<String>();
            args.add(javaName);
            String sanitizedFieldName = this.sanitize(field.name());
            args.add(sanitizedFieldName);
            writer.emitEmptyLine();
            MessageWriter.emitDocumentation(writer, field.documentation());
            if (field.isDeprecated()) {
                writer.emitAnnotation(Deprecated.class);
            }
            writer.beginMethod("Builder", sanitizedFieldName, EnumSet.of(Modifier.PUBLIC), args, null);
            if (FieldInfo.isRepeated(field)) {
                writer.emitStatement("this.%1$s = checkForNulls(%1$s)", new Object[]{sanitizedFieldName});
            } else {
                writer.emitStatement("this.%1$s = %1$s", new Object[]{sanitizedFieldName});
                if (field.label() == FieldElement.Label.ONE_OF) {
                    OneOfElement oneOfElement = this.getOneOfElement(messageType, field);
                    if (oneOfElement == null) {
                        throw new AssertionError((Object)"Field is a 'oneof' but no OneOfElement found");
                    }
                    writer.emitEmptyLine();
                    for (FieldElement fieldElement : oneOfElement.fields()) {
                        if (field.equals(fieldElement)) continue;
                        writer.emitStatement("this.%1$s = null", new Object[]{this.sanitize(fieldElement.name())});
                    }
                }
            }
            writer.emitStatement("return this", new Object[0]);
            writer.endMethod();
        }
    }

    private OneOfElement getOneOfElement(MessageElement messageType, FieldElement field) {
        for (OneOfElement oneOfElement : messageType.oneOfs()) {
            if (!oneOfElement.fields().contains(field)) continue;
            return oneOfElement;
        }
        return null;
    }

    private void emitBuilderSetExtension(JavaWriter writer, MessageElement messageType) throws IOException {
        writer.emitEmptyLine();
        writer.emitAnnotation(Override.class);
        writer.beginMethod("<E> Builder", "setExtension", EnumSet.of(Modifier.PUBLIC), new String[]{"Extension<" + messageType.name() + ", E>", "extension", "E", "value"});
        writer.emitStatement("super.setExtension(extension, value)", new Object[0]);
        writer.emitStatement("return this", new Object[0]);
        writer.endMethod();
    }

    private void emitBuilderBuild(JavaWriter writer, MessageElement messageType) throws IOException {
        writer.emitEmptyLine();
        writer.emitAnnotation(Override.class);
        writer.beginMethod(messageType.name(), "build", EnumSet.of(Modifier.PUBLIC), new String[0]);
        if (this.hasRequiredFields((TypeElement)messageType)) {
            writer.emitStatement("checkRequiredFields()", new Object[0]);
        }
        writer.emitStatement("return new %s(this)", new Object[]{messageType.name()});
        writer.endMethod();
    }

    private String addThisIfOneOf(String name, String ... matches) {
        for (String match : matches) {
            if (!match.equals(name)) continue;
            return "this." + name;
        }
        return name;
    }

    private String getDefaultValue(MessageElement messageType, FieldElement field) {
        if (FieldInfo.isRepeated(field)) {
            return "Collections.emptyList()";
        }
        OptionElement defaultOption = field.getDefault();
        String javaName = this.compiler.javaName(messageType, field.type().toString());
        if (TypeInfo.isScalar(field.type().toString())) {
            Object initialValue = defaultOption != null ? defaultOption.value() : null;
            return this.compiler.getInitializerForType(initialValue, javaName);
        }
        if (defaultOption != null) {
            return javaName + "." + defaultOption.value();
        }
        String fullyQualifiedName = this.compiler.fullyQualifiedName((TypeElement)messageType, field.type().toString());
        if (this.compiler.isEnum(fullyQualifiedName)) {
            return javaName + "." + this.compiler.getEnumDefault(fullyQualifiedName);
        }
        throw new WireCompilerException("Field " + field + " cannot have default value");
    }

    private String getJavaFieldType(MessageElement messageType, FieldElement field) {
        return this.getJavaFieldType(this.compiler.getProtoFile(), messageType, field);
    }

    private String getJavaFieldType(ProtoFile protoFile, MessageElement messageType, FieldElement field) {
        String javaName = this.compiler.javaName(protoFile, messageType, field.type().toString());
        if (FieldInfo.isRepeated(field)) {
            javaName = "List<" + javaName + ">";
        }
        return javaName;
    }

    private static boolean hasDocumentation(String documentation) {
        return documentation != null && !documentation.isEmpty();
    }

    private boolean hasOnlyOneField(MessageElement messageType) {
        return WireCompiler.allFields(messageType).size() == 1 && !this.compiler.hasExtensions(messageType);
    }

    private boolean hasRequiredFields(TypeElement type) {
        if (type instanceof MessageElement) {
            for (FieldElement field : WireCompiler.allFields((MessageElement)type)) {
                if (!FieldInfo.isRequired(field)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMessageType(MessageElement messageType, FieldElement field) {
        return !TypeInfo.isScalar(field.type().toString()) && !this.compiler.isEnum(this.compiler.fullyQualifiedName((TypeElement)messageType, field.type().toString()));
    }

    private String sanitize(String name) {
        return JAVA_KEYWORDS.contains(name) ? "_" + name : name;
    }

    private String scalarTypeConstant(String type) {
        return type.toUpperCase(Locale.US);
    }

    private static class EnumValueOptionInfo
    implements Comparable<EnumValueOptionInfo> {
        public final String type;
        public final String name;

        EnumValueOptionInfo(String type, String name) {
            this.type = type;
            this.name = name;
        }

        @Override
        public int compareTo(EnumValueOptionInfo other) {
            return this.name.compareTo(other.name);
        }
    }
}

