/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javawriter.JavaWriter;
import com.squareup.protoparser.Service;
import com.squareup.wire.AbstractServiceWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RetrofitServiceWriter
extends AbstractServiceWriter {
    public RetrofitServiceWriter(JavaWriter writer, List<String> options) {
        super(writer, options);
    }

    @Override
    List<String> getImports(Service service) {
        if (!service.getMethods().isEmpty()) {
            return Arrays.asList("retrofit.http.Body", "retrofit.http.POST");
        }
        return Collections.emptyList();
    }

    @Override
    void emitAnnotation(Service service, Service.Method method) throws IOException {
        this.writer.emitAnnotation("POST", (Object)("\"/" + service.getFullyQualifiedName() + "/" + method.getName() + "\""));
    }

    @Override
    String getRequestType(String requestType) {
        return "@Body " + requestType;
    }

    @Override
    String getRequestName(String requestType) {
        return "request";
    }
}

