/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.WireException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;

final class CommandLineOptions {
    public static final String PROTO_PATH_FLAG = "--proto_path=";
    public static final String JAVA_OUT_FLAG = "--java_out=";
    public static final String FILES_FLAG = "--files=";
    public static final String ROOTS_FLAG = "--roots=";
    public static final String REGISTRY_CLASS_FLAG = "--registry_class=";
    public static final String NO_OPTIONS_FLAG = "--no_options";
    public static final String ENUM_OPTIONS_FLAG = "--enum_options=";
    public static final String SERVICE_WRITER_FLAG = "--service_writer=";
    public static final String SERVICE_WRITER_OPT_FLAG = "--service_writer_opt=";
    public static final String QUIET_FLAG = "--quiet";
    public static final String DRY_RUN_FLAG = "--dry_run";
    final String protoPath;
    final String javaOut;
    final List<String> sourceFileNames;
    final List<String> roots;
    final String registryClass;
    final boolean emitOptions;
    final Set<String> enumOptions;
    final String serviceWriter;
    final List<String> serviceWriterOptions;
    final boolean quiet;
    final boolean dryRun;

    CommandLineOptions(String protoPath, String javaOut, List<String> sourceFileNames, List<String> roots, String registryClass, boolean emitOptions, Set<String> enumOptions, String serviceWriter, List<String> serviceWriterOptions, boolean quiet, boolean dryRun) {
        this.protoPath = protoPath;
        this.javaOut = javaOut;
        this.sourceFileNames = sourceFileNames;
        this.roots = roots;
        this.registryClass = registryClass;
        this.emitOptions = emitOptions;
        this.enumOptions = enumOptions;
        this.serviceWriter = serviceWriter;
        this.serviceWriterOptions = serviceWriterOptions;
        this.quiet = quiet;
        this.dryRun = dryRun;
    }

    CommandLineOptions(String ... args) throws WireException {
        ArrayList<String> sourceFileNames = new ArrayList<String>();
        ArrayList<String> serviceWriterOptions = new ArrayList<String>();
        ArrayList<String> roots = new ArrayList<String>();
        boolean emitOptions = true;
        String protoPath = null;
        String javaOut = null;
        String registryClass = null;
        ArrayList<String> enumOptionsList = new ArrayList<String>();
        String serviceWriter = null;
        boolean quiet = false;
        boolean dryRun = false;
        for (int index = 0; index < args.length; ++index) {
            if (args[index].startsWith(PROTO_PATH_FLAG)) {
                protoPath = args[index].substring(PROTO_PATH_FLAG.length());
                continue;
            }
            if (args[index].startsWith(JAVA_OUT_FLAG)) {
                javaOut = args[index].substring(JAVA_OUT_FLAG.length());
                continue;
            }
            if (args[index].startsWith(FILES_FLAG)) {
                String[] fileNames;
                File files = new File(args[index].substring(FILES_FLAG.length()));
                try {
                    fileNames = new Scanner(files, "UTF-8").useDelimiter("\\A").next().split("\n");
                }
                catch (FileNotFoundException ex) {
                    throw new WireException("Error processing argument " + args[index], ex);
                }
                sourceFileNames.addAll(Arrays.asList(fileNames));
                continue;
            }
            if (args[index].startsWith(ROOTS_FLAG)) {
                roots.addAll(CommandLineOptions.splitArg(args[index], ROOTS_FLAG.length()));
                continue;
            }
            if (args[index].startsWith(REGISTRY_CLASS_FLAG)) {
                registryClass = args[index].substring(REGISTRY_CLASS_FLAG.length());
                continue;
            }
            if (args[index].equals(NO_OPTIONS_FLAG)) {
                emitOptions = false;
                continue;
            }
            if (args[index].startsWith(ENUM_OPTIONS_FLAG)) {
                enumOptionsList.addAll(CommandLineOptions.splitArg(args[index], ENUM_OPTIONS_FLAG.length()));
                continue;
            }
            if (args[index].startsWith(SERVICE_WRITER_FLAG)) {
                serviceWriter = args[index].substring(SERVICE_WRITER_FLAG.length());
                continue;
            }
            if (args[index].startsWith(SERVICE_WRITER_OPT_FLAG)) {
                serviceWriterOptions.add(args[index].substring(SERVICE_WRITER_OPT_FLAG.length()));
                continue;
            }
            if (args[index].startsWith(QUIET_FLAG)) {
                quiet = true;
                continue;
            }
            if (args[index].startsWith(DRY_RUN_FLAG)) {
                dryRun = true;
                continue;
            }
            sourceFileNames.add(args[index]);
        }
        this.protoPath = protoPath;
        this.javaOut = javaOut;
        this.sourceFileNames = sourceFileNames;
        this.roots = roots;
        this.registryClass = registryClass;
        this.emitOptions = emitOptions;
        this.enumOptions = new LinkedHashSet<String>(enumOptionsList);
        this.serviceWriter = serviceWriter;
        this.serviceWriterOptions = serviceWriterOptions;
        this.quiet = quiet;
        this.dryRun = dryRun;
    }

    private static List<String> splitArg(String arg, int flagLength) {
        return Arrays.asList(arg.substring(flagLength).split(","));
    }
}

