/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.javawriter.JavaWriter;
import com.squareup.protoparser.Service;
import com.squareup.wire.ServiceWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class RxJavaServiceWriter
extends ServiceWriter {
    String requestType;
    String responseType;
    String func1Type;

    public RxJavaServiceWriter(JavaWriter writer, List<String> options) {
        super(writer, options);
    }

    @Override
    public void emitService(Service service, Set<String> importedTypes) throws IOException {
        if (!service.getMethods().isEmpty()) {
            importedTypes.add("retrofit.http.Body");
            importedTypes.add("retrofit.http.POST");
            importedTypes.add("javax.inject.Inject");
            importedTypes.add("rx.util.functions.Func1");
        }
        this.writer.emitImports(importedTypes);
        this.writer.emitEmptyLine();
        if (!service.getDocumentation().isEmpty()) {
            this.writer.emitJavadoc(service.getDocumentation(), new Object[0]);
        }
        this.writer.beginType(service.getName(), "class", EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
        this.writer.emitEmptyLine();
        this.writer.beginType("Endpoint", "interface", EnumSet.of(Modifier.PUBLIC));
        for (Service.Method method : service.getMethods()) {
            this.writer.emitEmptyLine();
            this.writer.emitJavadoc(method.getDocumentation(), new Object[0]);
            this.setTypes(method);
            this.writer.emitAnnotation("POST", (Object)("\"/" + service.getFullyQualifiedName() + "/" + method.getName() + "\""));
            this.writer.beginMethod(this.responseType, this.getMethodName(method), EnumSet.noneOf(Modifier.class), Arrays.asList("@Body " + this.requestType, "request"), null);
            this.writer.endMethod();
        }
        this.writer.endType();
        for (Service.Method method : service.getMethods()) {
            this.writer.emitEmptyLine();
            this.setTypes(method);
            this.writer.emitField(this.func1Type, this.getMethodName(method), EnumSet.of(Modifier.PRIVATE, Modifier.FINAL), "\nnew " + this.func1Type + "() {\n" + "  @Override\n" + "  public " + this.responseType + " call(" + this.requestType + " request) {\n" + "    return endpoint." + this.getMethodName(method) + "(request);\n" + "  }\n" + "}");
        }
        this.writer.emitEmptyLine();
        this.writer.emitField("Endpoint", "endpoint", EnumSet.of(Modifier.PRIVATE, Modifier.FINAL));
        this.writer.emitEmptyLine();
        this.writer.emitAnnotation("Inject");
        this.writer.beginConstructor(EnumSet.of(Modifier.PUBLIC), new String[]{"Endpoint", "endpoint"});
        this.writer.emitStatement("this.endpoint = endpoint", new Object[0]);
        this.writer.endConstructor();
        for (Service.Method method : service.getMethods()) {
            this.writer.emitEmptyLine();
            this.setTypes(method);
            this.writer.beginMethod(this.func1Type, "get" + method.getName(), EnumSet.of(Modifier.PUBLIC), new String[0]);
            this.writer.emitStatement("return " + this.getMethodName(method), new Object[0]);
            this.writer.endMethod();
        }
        this.writer.endType();
    }

    private String getMethodName(Service.Method method) {
        return this.lowerCaseInitialLetter(method.getName());
    }

    private void setTypes(Service.Method method) {
        this.requestType = this.writer.compressType(method.getRequestType());
        this.responseType = this.writer.compressType(method.getResponseType());
        this.func1Type = "Func1<" + this.requestType + ", " + this.responseType + ">";
    }

    String lowerCaseInitialLetter(String name) {
        return name.substring(0, 1).toLowerCase(Locale.US) + name.substring(1);
    }
}

