/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.protoparser;

import com.squareup.protoparser.Extensions;
import com.squareup.protoparser.Option;
import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.Type;
import com.squareup.protoparser.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class MessageType
implements Type {
    private final String name;
    private final String fqname;
    private final String documentation;
    private final List<Field> fields;
    private final List<Type> nestedTypes;
    private final List<Extensions> extensions;
    private final List<Option> options;

    public MessageType(String name, String fqname, String documentation, List<Field> fields, List<Type> nestedTypes, List<Extensions> extensions, List<Option> options) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (fqname == null) {
            throw new NullPointerException("fqname");
        }
        if (documentation == null) {
            throw new NullPointerException("documentation");
        }
        if (fields == null) {
            throw new NullPointerException("fields");
        }
        if (nestedTypes == null) {
            throw new NullPointerException("nestedTypes");
        }
        if (extensions == null) {
            throw new NullPointerException("extensions");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.name = name;
        this.fqname = fqname;
        this.documentation = documentation;
        this.fields = Collections.unmodifiableList(new ArrayList<Field>(fields));
        this.nestedTypes = Collections.unmodifiableList(new ArrayList<Type>(nestedTypes));
        this.extensions = Collections.unmodifiableList(new ArrayList<Extensions>(extensions));
        this.options = Collections.unmodifiableList(new ArrayList<Option>(options));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fqname;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public List<Type> getNestedTypes() {
        return this.nestedTypes;
    }

    public List<Extensions> getExtensions() {
        return this.extensions;
    }

    @Override
    public List<Option> getOptions() {
        return this.options;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MessageType)) {
            return false;
        }
        MessageType that = (MessageType)other;
        return this.name.equals(that.name) && this.fqname.equals(that.fqname) && this.documentation.equals(that.documentation) && this.fields.equals(that.fields) && this.nestedTypes.equals(that.nestedTypes) && this.extensions.equals(that.extensions) && this.options.equals(that.options);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fqname.hashCode();
        result = 31 * result + this.documentation.hashCode();
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + this.nestedTypes.hashCode();
        result = 31 * result + this.extensions.hashCode();
        result = 31 * result + this.options.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Utils.appendDocumentation(builder, this.documentation);
        builder.append("message ").append(this.name).append(" {");
        if (!this.options.isEmpty()) {
            builder.append('\n');
            for (Option option : this.options) {
                Utils.appendIndented(builder, option.toDeclaration());
            }
        }
        if (!this.fields.isEmpty()) {
            builder.append('\n');
            for (Field field : this.fields) {
                Utils.appendIndented(builder, field.toString());
            }
        }
        if (!this.extensions.isEmpty()) {
            builder.append('\n');
            for (Extensions extension : this.extensions) {
                Utils.appendIndented(builder, extension.toString());
            }
        }
        if (!this.nestedTypes.isEmpty()) {
            builder.append('\n');
            for (Type type : this.nestedTypes) {
                Utils.appendIndented(builder, type.toString());
            }
        }
        return builder.append("}\n").toString();
    }

    public static final class Field {
        private final Label label;
        private final String type;
        private final String name;
        private final int tag;
        private final List<Option> options;
        private final String documentation;

        public Field(Label label, String type, String name, int tag, String documentation, List<Option> options) {
            if (label == null) {
                throw new NullPointerException("label");
            }
            if (type == null) {
                throw new NullPointerException("type");
            }
            if (!ProtoFile.isValidTag(tag)) {
                throw new IllegalArgumentException("Illegal tag value: " + tag);
            }
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (documentation == null) {
                throw new NullPointerException("documentation");
            }
            if (options == null) {
                throw new NullPointerException("options");
            }
            this.label = label;
            this.type = type;
            this.name = name;
            this.tag = tag;
            this.documentation = documentation;
            this.options = Collections.unmodifiableList(new ArrayList<Option>(options));
        }

        public Label getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public int getTag() {
            return this.tag;
        }

        public List<Option> getOptions() {
            return this.options;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public boolean isDeprecated() {
            return "true".equals(this.getOptionValue("deprecated"));
        }

        public boolean isPacked() {
            return "true".equals(this.getOptionValue("packed"));
        }

        public String getDefault() {
            return (String)this.getOptionValue("default");
        }

        private Object getOptionValue(String name) {
            for (Option option : this.options) {
                if (!option.getName().equals(name)) continue;
                return option.getValue();
            }
            return null;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Field)) {
                return false;
            }
            Field that = (Field)other;
            return this.label.equals((Object)that.label) && this.type.equals(that.type) && this.name.equals(that.name) && this.tag == that.tag && this.options.equals(that.options) && this.documentation.equals(that.documentation);
        }

        public int hashCode() {
            int result = this.label.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.tag;
            result = 31 * result + this.options.hashCode();
            result = 31 * result + this.documentation.hashCode();
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            Utils.appendDocumentation(builder, this.documentation);
            builder.append(this.label.toString().toLowerCase(Locale.US)).append(' ').append(this.type).append(' ').append(this.name).append(" = ").append(this.tag);
            if (!this.options.isEmpty()) {
                builder.append(" [\n");
                for (Option option : this.options) {
                    Utils.appendIndented(builder, option.toString());
                }
                builder.append(']');
            }
            return builder.append(";\n").toString();
        }
    }

    public static enum Label {
        OPTIONAL,
        REQUIRED,
        REPEATED;

    }
}

