/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.protoparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Service {
    private final String name;
    private final String documentation;
    private final List<Method> methods;

    Service(String name, String documentation, List<Method> methods) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (documentation == null) {
            throw new NullPointerException("documentation");
        }
        if (methods == null) {
            throw new NullPointerException("methods");
        }
        this.name = name;
        this.documentation = documentation;
        this.methods = Collections.unmodifiableList(new ArrayList<Method>(methods));
    }

    public String getName() {
        return this.name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public boolean equals(Object other) {
        if (other instanceof Service) {
            Service that = (Service)other;
            return this.name.equals(that.name) && this.documentation.equals(that.documentation) && this.methods.equals(that.methods);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        for (Method method : this.methods) {
            result.append("\n  ").append(method);
        }
        return result.toString();
    }

    public static final class Method {
        private final String name;
        private final String documentation;
        private final String requestType;
        private final String responseType;
        private final Map<String, Object> options;

        public Method(String name, String documentation, String requestType, String responseType, Map<String, Object> options) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (documentation == null) {
                throw new NullPointerException("documentation");
            }
            if (requestType == null) {
                throw new NullPointerException("requestType");
            }
            if (responseType == null) {
                throw new NullPointerException("responseType");
            }
            if (options == null) {
                throw new NullPointerException("options");
            }
            this.name = name;
            this.documentation = documentation;
            this.requestType = requestType;
            this.responseType = responseType;
            this.options = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(options));
        }

        public String getName() {
            return this.name;
        }

        public String getDocumentation() {
            return this.documentation;
        }

        public String getRequestType() {
            return this.requestType;
        }

        public String getResponseType() {
            return this.responseType;
        }

        public Map<String, Object> getOptions() {
            return this.options;
        }

        public boolean equals(Object other) {
            if (other instanceof Method) {
                Method that = (Method)other;
                return this.name.equals(that.name) && this.documentation.equals(that.documentation) && this.requestType.equals(that.requestType) && this.responseType.equals(that.responseType) && this.options.equals(that.options);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return String.format("rpc %s (%s) returns (%s) %s", this.name, this.requestType, this.responseType, this.options);
        }
    }
}

