/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.proto;

import com.squareup.proto.EnumType;
import com.squareup.proto.MessageType;
import com.squareup.proto.Option;
import com.squareup.proto.ProtoFile;
import com.squareup.proto.Type;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class ProtoSchemaParser {
    private final String fileName;
    private final char[] data;
    private int pos;
    private int line;
    private int lineStart;
    private String packageName;
    private List<String> dependencies = new ArrayList<String>();
    private List<Type> types = new ArrayList<Type>();
    private Map<String, Object> options = new LinkedHashMap<String, Object>();

    public static ProtoFile parse(File file) throws IOException {
        return new ProtoSchemaParser(file).readProtoFile();
    }

    public static ProtoFile parse(String name, String data) {
        return new ProtoSchemaParser(name, data).readProtoFile();
    }

    ProtoSchemaParser(String fileName, String data) {
        this.fileName = fileName;
        this.data = data.toCharArray();
    }

    ProtoSchemaParser(File file) throws IOException {
        this.fileName = file.getPath();
        this.data = this.fileToCharArray(file);
    }

    private char[] fileToCharArray(File file) throws IOException {
        int count;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        CharArrayWriter writer = new CharArrayWriter();
        char[] buffer = new char[1024];
        while ((count = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, count);
        }
        return writer.toCharArray();
    }

    public ProtoFile readProtoFile() {
        while (true) {
            String documentation = this.readDocumentation();
            if (this.pos == this.data.length) {
                return new ProtoFile(this.fileName, this.packageName, this.dependencies, this.types, this.options);
            }
            Object declaration = this.readDeclaration(documentation, Context.FILE);
            if (declaration instanceof Type) {
                this.types.add((Type)declaration);
                continue;
            }
            if (!(declaration instanceof Option)) continue;
            Option option = (Option)declaration;
            this.options.put(option.getName(), option.getValue());
        }
    }

    private Object readDeclaration(String documentation, Context context) {
        if (this.peekChar() == ';') {
            ++this.pos;
            return null;
        }
        String label = this.readWord();
        if (label.equals("package")) {
            if (!context.permitsPackage()) {
                throw this.unexpected("package in " + (Object)((Object)context));
            }
            if (this.packageName != null) {
                throw this.unexpected("too many package names");
            }
            this.packageName = this.readName();
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return null;
        }
        if (label.equals("import")) {
            if (!context.permitsImport()) {
                throw this.unexpected("import in " + (Object)((Object)context));
            }
            this.dependencies.add(this.readString());
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return null;
        }
        if (label.equals("option")) {
            Option result = this.readOption('=');
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return result;
        }
        if (label.equals("message")) {
            return this.readMessage(documentation);
        }
        if (label.equals("enum")) {
            return this.readEnumType(documentation);
        }
        if (label.equals("service")) {
            this.readService();
            return null;
        }
        if (label.equals("extend")) {
            this.readExtend();
            return null;
        }
        if (label.equals("rpc")) {
            if (!context.permitsRpc()) {
                throw this.unexpected("rpc in " + (Object)((Object)context));
            }
            this.readRpc();
            return null;
        }
        if (label.equals("required") || label.equals("optional") || label.equals("repeated")) {
            if (!context.permitsField()) {
                throw this.unexpected("fields must be nested");
            }
            return this.readField(documentation, label);
        }
        if (label.equals("extensions")) {
            if (!context.permitsExtensions()) {
                throw this.unexpected("extensions must be nested");
            }
            this.readExtensions();
            return null;
        }
        if (context == Context.ENUM) {
            if (this.readChar() != '=') {
                throw this.unexpected("expected '='");
            }
            int tag = this.readInt();
            if (this.readChar() != ';') {
                throw this.unexpected("expected ';'");
            }
            return new EnumType.Value(label, tag, documentation);
        }
        throw this.unexpected("unexpected label: " + label);
    }

    private MessageType readMessage(String documentation) {
        String name = this.readName();
        ArrayList<MessageType.Field> fields = new ArrayList<MessageType.Field>();
        ArrayList<Type> nestedTypes = new ArrayList<Type>();
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        while (true) {
            String nestedDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            Object declared = this.readDeclaration(nestedDocumentation, Context.MESSAGE);
            if (declared instanceof MessageType.Field) {
                fields.add((MessageType.Field)declared);
                continue;
            }
            if (!(declared instanceof Type)) continue;
            nestedTypes.add((Type)declared);
        }
        return new MessageType(name, documentation, fields, nestedTypes);
    }

    private void readExtend() {
        this.readName();
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        while (true) {
            String nestedDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            this.readDeclaration(nestedDocumentation, Context.EXTEND);
        }
    }

    private void readService() {
        this.readName();
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        while (true) {
            String nestedDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            this.readDeclaration(nestedDocumentation, Context.SERVICE);
        }
    }

    private EnumType readEnumType(String documentation) {
        String name = this.readName();
        ArrayList<EnumType.Value> values = new ArrayList<EnumType.Value>();
        if (this.readChar() != '{') {
            throw this.unexpected("expected '{'");
        }
        while (true) {
            String valueDocumentation = this.readDocumentation();
            if (this.peekChar() == '}') {
                ++this.pos;
                break;
            }
            Object declared = this.readDeclaration(valueDocumentation, Context.ENUM);
            if (!(declared instanceof EnumType.Value)) continue;
            values.add((EnumType.Value)declared);
        }
        return new EnumType(name, documentation, values);
    }

    private MessageType.Field readField(String documentation, String label) {
        LinkedHashMap<String, Object> options;
        MessageType.Label labelEnum = MessageType.Label.valueOf(label.toUpperCase(Locale.US));
        String type = this.readName();
        String name = this.readName();
        if (this.readChar() != '=') {
            throw this.unexpected("expected '='");
        }
        int tag = this.readInt();
        char c = this.peekChar();
        if (c == '[') {
            options = this.readMap('[', ']', '=');
            c = this.peekChar();
        } else {
            options = new LinkedHashMap();
        }
        if (c == ';') {
            ++this.pos;
            return new MessageType.Field(labelEnum, type, name, tag, documentation, options);
        }
        throw this.unexpected("expected ';'");
    }

    private void readExtensions() {
        this.readWord();
        if (this.peekChar() != ';') {
            this.readWord();
            this.readWord();
        }
        if (this.readChar() != ';') {
            throw this.unexpected("expected ';'");
        }
    }

    private Option readOption(char keyValueSeparator) {
        String name = this.readName();
        if (this.readChar() != keyValueSeparator) {
            throw this.unexpected("expected '" + keyValueSeparator + "' in option");
        }
        String value = this.peekChar() == '{' ? this.readMap('{', '}', ':') : this.readString();
        return new Option(name, value);
    }

    private Map<String, Object> readMap(char openBrace, char closeBrace, char keyValueSeparator) {
        if (this.readChar() != openBrace) {
            throw new AssertionError();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        while (true) {
            if (this.peekChar() == closeBrace) {
                ++this.pos;
                return result;
            }
            Option option = this.readOption(keyValueSeparator);
            result.put(option.getName(), option.getValue());
            char c = this.peekChar();
            if (c == ',') {
                ++this.pos;
                continue;
            }
            if (c != closeBrace) break;
        }
        throw this.unexpected("expected ',' or '" + closeBrace + "'");
    }

    private void readRpc() {
        block4: {
            this.readName();
            this.readName();
            this.readWord();
            this.readName();
            char c = this.readChar();
            if (c == '{') {
                while (true) {
                    String nestedDocumentation = this.readDocumentation();
                    if (this.peekChar() == '}') {
                        ++this.pos;
                        break block4;
                    }
                    this.readDeclaration(nestedDocumentation, Context.RPC);
                }
            }
            if (c != ';') {
                throw this.unexpected("expected '{' or ';'");
            }
        }
    }

    private char readChar() {
        char result = this.peekChar();
        ++this.pos;
        return result;
    }

    private char peekChar() {
        this.skipWhitespace(true);
        if (this.pos == this.data.length) {
            throw this.unexpected("unexpected end of file");
        }
        return this.data[this.pos];
    }

    private String readString() {
        this.skipWhitespace(true);
        return this.peekChar() == '\"' ? this.readQuotedString() : this.readWord();
    }

    private String readQuotedString() {
        if (this.readChar() != '\"') {
            throw new AssertionError();
        }
        StringBuilder result = new StringBuilder();
        while (this.pos < this.data.length) {
            char c;
            if ((c = this.data[this.pos++]) == '\"') {
                return result.toString();
            }
            if (c == '\\') {
                if (this.pos == this.data.length) {
                    throw this.unexpected("unexpected end of file");
                }
                c = this.data[this.pos++];
            }
            result.append(c);
            if (c != '\n') continue;
            this.newline();
        }
        throw this.unexpected("unterminated string");
    }

    private String readName() {
        String optionName;
        char c = this.peekChar();
        if (c == '(') {
            ++this.pos;
            optionName = this.readWord();
            if (this.readChar() != ')') {
                throw this.unexpected("expected ')'");
            }
        } else if (c == '[') {
            ++this.pos;
            optionName = this.readWord();
            if (this.readChar() != ']') {
                throw this.unexpected("expected ']'");
            }
        } else {
            optionName = this.readWord();
        }
        return optionName;
    }

    private String readWord() {
        char c;
        this.skipWhitespace(true);
        int start = this.pos;
        while (this.pos < this.data.length && ((c = this.data[this.pos]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == '.')) {
            ++this.pos;
        }
        if (start == this.pos) {
            throw this.unexpected("expected a word");
        }
        return new String(this.data, start, this.pos - start);
    }

    private int readInt() {
        String tag = this.readWord();
        try {
            int radix = 10;
            if (tag.startsWith("0x")) {
                tag = tag.substring("0x".length());
                radix = 16;
            }
            return Integer.valueOf(tag, radix);
        }
        catch (Exception e) {
            throw this.unexpected("expected an integer but was " + tag);
        }
    }

    private String readDocumentation() {
        String result = null;
        while (true) {
            this.skipWhitespace(false);
            if (this.pos == this.data.length || this.data[this.pos] != '/') {
                return result != null ? this.cleanUpDocumentation(result) : "";
            }
            String comment = this.readComment();
            result = result == null ? comment : result + "\n" + comment;
        }
    }

    private String readComment() {
        int commentType;
        if (this.pos == this.data.length || this.data[this.pos] != '/') {
            throw new AssertionError();
        }
        ++this.pos;
        int n = commentType = this.pos < this.data.length ? this.data[this.pos++] : -1;
        if (commentType == 42) {
            int start = this.pos;
            while (this.pos + 1 < this.data.length) {
                char c;
                if (this.data[this.pos] == '*' && this.data[this.pos + 1] == '/') {
                    this.pos += 2;
                    return new String(this.data, start, this.pos - 2 - start);
                }
                if ((c = this.data[this.pos++]) != '\n') continue;
                this.newline();
            }
            throw this.unexpected("unterminated comment");
        }
        if (commentType == 47) {
            int start = this.pos;
            while (this.pos < this.data.length) {
                char c;
                if ((c = this.data[this.pos++]) != '\n') continue;
                this.newline();
                break;
            }
            return new String(this.data, start, this.pos - 1 - start);
        }
        throw this.unexpected("unexpected '/'");
    }

    private String cleanUpDocumentation(String comment) {
        StringBuilder result = new StringBuilder();
        boolean beginningOfLine = true;
        for (int i = 0; i < comment.length(); ++i) {
            char c = comment.charAt(i);
            if (!beginningOfLine || c != ' ' && c != '\t' && c != '*') {
                result.append(c);
                beginningOfLine = false;
            }
            if (c != '\n') continue;
            beginningOfLine = true;
        }
        return result.toString().trim();
    }

    private void skipWhitespace(boolean skipComments) {
        while (this.pos < this.data.length) {
            char c = this.data[this.pos];
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                ++this.pos;
                if (c != '\n') continue;
                this.newline();
                continue;
            }
            if (!skipComments || c != '/') break;
            this.readComment();
        }
    }

    private void newline() {
        ++this.line;
        this.lineStart = this.pos;
    }

    private int column() {
        return this.pos - this.lineStart + 1;
    }

    private int line() {
        return this.line + 1;
    }

    private RuntimeException unexpected(String message) {
        throw new IllegalStateException(String.format("Syntax error in %s at %d:%d: %s", this.fileName, this.line(), this.column(), message));
    }

    static enum Context {
        FILE,
        MESSAGE,
        ENUM,
        RPC,
        EXTEND,
        SERVICE;


        public boolean permitsPackage() {
            return this == FILE;
        }

        public boolean permitsImport() {
            return this == FILE;
        }

        public boolean permitsField() {
            return this == MESSAGE || this == EXTEND;
        }

        public boolean permitsExtensions() {
            return this != FILE;
        }

        public boolean permitsRpc() {
            return this == SERVICE;
        }
    }
}

