/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.otto;

import com.squareup.otto.DeadEvent;
import com.squareup.otto.EventHandler;
import com.squareup.otto.EventProducer;
import com.squareup.otto.HandlerFinder;
import com.squareup.otto.ThreadEnforcer;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class Bus {
    public static final String DEFAULT_IDENTIFIER = "default";
    private final ConcurrentMap<Class<?>, Set<EventHandler>> handlersByType = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, EventProducer> producersByType = new ConcurrentHashMap();
    private final String identifier;
    private final ThreadEnforcer enforcer;
    private final HandlerFinder handlerFinder;
    private final ThreadLocal<ConcurrentLinkedQueue<EventWithHandler>> eventsToDispatch = new ThreadLocal<ConcurrentLinkedQueue<EventWithHandler>>(){

        @Override
        protected ConcurrentLinkedQueue<EventWithHandler> initialValue() {
            return new ConcurrentLinkedQueue<EventWithHandler>();
        }
    };
    private final ThreadLocal<Boolean> isDispatching = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final Map<Class<?>, Set<Class<?>>> flattenHierarchyCache = new HashMap();

    public Bus() {
        this(DEFAULT_IDENTIFIER);
    }

    public Bus(String identifier) {
        this(ThreadEnforcer.MAIN, identifier);
    }

    public Bus(ThreadEnforcer enforcer) {
        this(enforcer, DEFAULT_IDENTIFIER);
    }

    public Bus(ThreadEnforcer enforcer, String identifier) {
        this(enforcer, identifier, HandlerFinder.ANNOTATED);
    }

    Bus(ThreadEnforcer enforcer, String identifier, HandlerFinder handlerFinder) {
        this.enforcer = enforcer;
        this.identifier = identifier;
        this.handlerFinder = handlerFinder;
    }

    public String toString() {
        return "[Bus \"" + this.identifier + "\"]";
    }

    public void register(Object object) {
        this.enforcer.enforce(this);
        Map<Class<?>, EventProducer> foundProducers = this.handlerFinder.findAllProducers(object);
        for (Class<?> type : foundProducers.keySet()) {
            EventProducer eventProducer;
            EventProducer previousProducer = this.producersByType.putIfAbsent(type, eventProducer = foundProducers.get(type));
            if (previousProducer != null) {
                throw new IllegalArgumentException("Producer method for type " + type + " found on type " + eventProducer.target.getClass() + ", but already registered by type " + previousProducer.target.getClass() + ".");
            }
            Set handlers = (Set)this.handlersByType.get(type);
            if (handlers == null || handlers.isEmpty()) continue;
            for (EventHandler handler : handlers) {
                this.dispatchProducerResultToHandler(handler, eventProducer);
            }
        }
        Map<Class<?>, Set<EventHandler>> foundHandlersMap = this.handlerFinder.findAllSubscribers(object);
        for (Class<?> clazz : foundHandlersMap.keySet()) {
            CopyOnWriteArraySet<EventHandler> handlersCreation;
            CopyOnWriteArraySet<EventHandler> handlers = (CopyOnWriteArraySet<EventHandler>)this.handlersByType.get(clazz);
            if (handlers == null && (handlers = (Set)this.handlersByType.putIfAbsent(clazz, handlersCreation = new CopyOnWriteArraySet<EventHandler>())) == null) {
                handlers = handlersCreation;
            }
            Set<EventHandler> foundHandlers = foundHandlersMap.get(clazz);
            handlers.addAll(foundHandlers);
        }
        block3: for (Map.Entry entry : foundHandlersMap.entrySet()) {
            Class type = (Class)entry.getKey();
            EventProducer producer = (EventProducer)this.producersByType.get(type);
            if (producer == null || !producer.isValid()) continue;
            Set foundHandlers = (Set)entry.getValue();
            for (EventHandler foundHandler : foundHandlers) {
                if (!producer.isValid()) continue block3;
                if (!foundHandler.isValid()) continue;
                this.dispatchProducerResultToHandler(foundHandler, producer);
            }
        }
    }

    private void dispatchProducerResultToHandler(EventHandler handler, EventProducer producer) {
        Object event = null;
        try {
            event = producer.produceEvent();
        }
        catch (InvocationTargetException e) {
            Bus.throwRuntimeException("Producer " + producer + " threw an exception.", e);
        }
        if (event == null) {
            return;
        }
        this.dispatch(event, handler);
    }

    public void unregister(Object object) {
        this.enforcer.enforce(this);
        Map<Class<?>, EventProducer> producersInListener = this.handlerFinder.findAllProducers(object);
        for (Map.Entry<Class<?>, EventProducer> entry : producersInListener.entrySet()) {
            Class<?> key = entry.getKey();
            EventProducer producer = this.getProducerForEventType(key);
            EventProducer value = entry.getValue();
            if (value == null || !value.equals(producer)) {
                throw new IllegalArgumentException("Missing event producer for an annotated method. Is " + object.getClass() + " registered?");
            }
            ((EventProducer)this.producersByType.remove(key)).invalidate();
        }
        Map<Class<?>, Set<EventHandler>> handlersInListener = this.handlerFinder.findAllSubscribers(object);
        for (Map.Entry<Class<?>, Set<EventHandler>> entry : handlersInListener.entrySet()) {
            Set<EventHandler> currentHandlers = this.getHandlersForEventType(entry.getKey());
            Collection eventMethodsInListener = entry.getValue();
            if (currentHandlers == null || !currentHandlers.containsAll(eventMethodsInListener)) {
                throw new IllegalArgumentException("Missing event handler for an annotated method. Is " + object.getClass() + " registered?");
            }
            for (EventHandler handler : currentHandlers) {
                if (!eventMethodsInListener.contains(handler)) continue;
                handler.invalidate();
            }
            currentHandlers.removeAll(eventMethodsInListener);
        }
    }

    public void post(Object event) {
        this.enforcer.enforce(this);
        Set<Class<?>> dispatchTypes = this.flattenHierarchy(event.getClass());
        boolean dispatched = false;
        for (Class<?> eventType : dispatchTypes) {
            Set<EventHandler> wrappers = this.getHandlersForEventType(eventType);
            if (wrappers == null || wrappers.isEmpty()) continue;
            dispatched = true;
            for (EventHandler wrapper : wrappers) {
                this.enqueueEvent(event, wrapper);
            }
        }
        if (!dispatched && !(event instanceof DeadEvent)) {
            this.post(new DeadEvent(this, event));
        }
        this.dispatchQueuedEvents();
    }

    protected void enqueueEvent(Object event, EventHandler handler) {
        this.eventsToDispatch.get().offer(new EventWithHandler(event, handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchQueuedEvents() {
        if (this.isDispatching.get().booleanValue()) {
            return;
        }
        this.isDispatching.set(true);
        try {
            EventWithHandler eventWithHandler;
            while ((eventWithHandler = this.eventsToDispatch.get().poll()) != null) {
                if (!eventWithHandler.handler.isValid()) continue;
                this.dispatch(eventWithHandler.event, eventWithHandler.handler);
            }
        }
        finally {
            this.isDispatching.set(false);
        }
    }

    protected void dispatch(Object event, EventHandler wrapper) {
        try {
            wrapper.handleEvent(event);
        }
        catch (InvocationTargetException e) {
            Bus.throwRuntimeException("Could not dispatch event: " + event.getClass() + " to handler " + wrapper, e);
        }
    }

    EventProducer getProducerForEventType(Class<?> type) {
        return (EventProducer)this.producersByType.get(type);
    }

    Set<EventHandler> getHandlersForEventType(Class<?> type) {
        return (Set)this.handlersByType.get(type);
    }

    Set<Class<?>> flattenHierarchy(Class<?> concreteClass) {
        Set<Class<?>> classes = this.flattenHierarchyCache.get(concreteClass);
        if (classes == null) {
            classes = this.getClassesFor(concreteClass);
            this.flattenHierarchyCache.put(concreteClass, classes);
        }
        return classes;
    }

    private Set<Class<?>> getClassesFor(Class<?> concreteClass) {
        LinkedList parents = new LinkedList();
        HashSet classes = new HashSet();
        parents.add(concreteClass);
        while (!parents.isEmpty()) {
            Class clazz = (Class)parents.remove(0);
            classes.add(clazz);
            Class parent = clazz.getSuperclass();
            if (parent == null) continue;
            parents.add(parent);
        }
        return classes;
    }

    private static void throwRuntimeException(String msg, InvocationTargetException e) {
        Throwable cause = e.getCause();
        if (cause != null) {
            throw new RuntimeException(msg, cause);
        }
        throw new RuntimeException(msg);
    }

    static class EventWithHandler {
        final Object event;
        final EventHandler handler;

        public EventWithHandler(Object event, EventHandler handler) {
            this.event = event;
            this.handler = handler;
        }
    }
}

