/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.otto;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class EventProducer {
    private final Object target;
    private final Method method;
    private final int hashCode;

    EventProducer(Object target, Method method) {
        if (target == null) {
            throw new NullPointerException("EventProducer target cannot be null.");
        }
        if (method == null) {
            throw new NullPointerException("EventProducer method cannot be null.");
        }
        this.target = target;
        this.method = method;
        method.setAccessible(true);
        int prime = 31;
        this.hashCode = (31 + method.hashCode()) * 31 + target.hashCode();
    }

    public Object produceEvent() throws InvocationTargetException {
        try {
            return this.method.invoke(this.target, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw e;
        }
    }

    public String toString() {
        return "[EventProducer " + this.method + "]";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventProducer other = (EventProducer)obj;
        return this.method.equals(other.method) && this.target == other.target;
    }
}

