/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.otto;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class EventHandler {
    private final Object target;
    private final Method method;
    private final int hashCode;

    EventHandler(Object target, Method method) {
        if (target == null) {
            throw new NullPointerException("EventHandler target cannot be null.");
        }
        if (method == null) {
            throw new NullPointerException("EventHandler method cannot be null.");
        }
        this.target = target;
        this.method = method;
        method.setAccessible(true);
        int prime = 31;
        this.hashCode = (31 + method.hashCode()) * 31 + target.hashCode();
    }

    public void handleEvent(Object event) throws InvocationTargetException {
        try {
            this.method.invoke(this.target, event);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw e;
        }
    }

    public String toString() {
        return "[EventHandler " + this.method + "]";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventHandler other = (EventHandler)obj;
        return this.method.equals(other.method) && this.target == other.target;
    }
}

