/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.duplex;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import junit.framework.TestCase;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public final class AsyncRequestBody
extends RequestBody {
    private final BlockingQueue<BufferedSink> requestBodySinks = new LinkedBlockingQueue<BufferedSink>();

    @Nullable
    public MediaType contentType() {
        return null;
    }

    public void writeTo(BufferedSink sink) {
        this.requestBodySinks.add(sink);
    }

    public boolean isDuplex() {
        return true;
    }

    public BufferedSink takeSink() throws InterruptedException {
        BufferedSink result = this.requestBodySinks.poll(5L, TimeUnit.SECONDS);
        if (result == null) {
            throw new AssertionError((Object)"no sink to take");
        }
        return result;
    }

    public void assertNoMoreSinks() {
        TestCase.assertTrue((boolean)this.requestBodySinks.isEmpty());
    }
}

