/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import okhttp3.ForwardingRequestBody;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public final class UppercaseRequestInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        return chain.proceed(this.uppercaseRequest(chain.request()));
    }

    private Request uppercaseRequest(Request request) {
        ForwardingRequestBody uppercaseBody = new ForwardingRequestBody(request.body()){

            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                this.delegate().writeTo(Okio.buffer((Sink)UppercaseRequestInterceptor.this.uppercaseSink((Sink)sink)));
            }
        };
        return request.newBuilder().method(request.method(), (RequestBody)uppercaseBody).build();
    }

    private Sink uppercaseSink(Sink sink) {
        return new ForwardingSink(sink){

            public void write(Buffer source, long byteCount) throws IOException {
                ByteString bytes = source.readByteString(byteCount);
                this.delegate().write(new Buffer().write(bytes.toAsciiUppercase()), byteCount);
            }
        };
    }
}

