/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.curl.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/curl/logging/OneLineLogFormat;", "Ljava/util/logging/Formatter;", "<init>", "()V", "d", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "offset", "Ljava/time/ZoneId;", "format", "", "record", "Ljava/util/logging/LogRecord;", "okcurl"})
public final class OneLineLogFormat
extends Formatter {
    private final DateTimeFormatter d = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 3, 3, true).toFormatter();
    private final ZoneId offset = ZoneOffset.systemDefault();

    @Override
    @NotNull
    public String format(@NotNull LogRecord record) {
        String string;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        String message = this.formatMessage(record);
        ZonedDateTime time = Instant.ofEpochMilli(record.getMillis()).atZone(this.offset);
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter(4096);
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            String string2 = "%s\t%s%n%s%n";
            Object[] objectArray = new Object[]{time.format(this.d), message, sw.toString()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            String string4 = "%s\t%s%n";
            Object[] objectArray = new Object[]{time.format(this.d), message};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        }
        return string;
    }
}

