/*
 * Decompiled with CFR 0.152.
 */
package mockwebserver3.internal;

import java.io.Closeable;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Handshake;
import okhttp3.internal.connection.BufferedSocket;
import okhttp3.internal.platform.Platform;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Socket;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020*J\u000e\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u00020*H\u0016J\b\u00100\u001a\u00020*H\u0016J\u0006\u00101\u001a\u00020*R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0013\u0010!\u001a\u0004\u0018\u00010\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u00062"}, d2={"Lmockwebserver3/internal/MockWebServerSocket;", "Ljava/io/Closeable;", "Lokhttp3/internal/connection/BufferedSocket;", "javaNetSocket", "Ljava/net/Socket;", "<init>", "(Ljava/net/Socket;)V", "getJavaNetSocket", "()Ljava/net/Socket;", "delegate", "Lokio/Socket;", "closedLatch", "Ljava/util/concurrent/CountDownLatch;", "source", "Lokio/BufferedSource;", "getSource", "()Lokio/BufferedSource;", "sink", "Lokio/BufferedSink;", "getSink", "()Lokio/BufferedSink;", "localAddress", "Ljava/net/InetAddress;", "getLocalAddress", "()Ljava/net/InetAddress;", "localPort", "", "getLocalPort", "()I", "scheme", "", "getScheme", "()Ljava/lang/String;", "handshake", "Lokhttp3/Handshake;", "getHandshake", "()Lokhttp3/Handshake;", "handshakeServerNames", "", "getHandshakeServerNames", "()Ljava/util/List;", "shutdownInput", "", "shutdownOutput", "sleepWhileOpen", "nanos", "", "cancel", "close", "awaitClosed", "mockwebserver3"})
@SourceDebugExtension(value={"SMAP\nMockWebServerSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockWebServerSocket.kt\nmockwebserver3/internal/MockWebServerSocket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class MockWebServerSocket
implements Closeable,
BufferedSocket {
    @NotNull
    private final java.net.Socket javaNetSocket;
    @NotNull
    private final Socket delegate;
    @NotNull
    private final CountDownLatch closedLatch;
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final BufferedSink sink;

    public MockWebServerSocket(@NotNull java.net.Socket javaNetSocket) {
        Intrinsics.checkNotNullParameter((Object)javaNetSocket, (String)"javaNetSocket");
        this.javaNetSocket = javaNetSocket;
        this.delegate = Okio.socket((java.net.Socket)this.javaNetSocket);
        this.closedLatch = new CountDownLatch(2);
        Source source2 = this.delegate.getSource();
        this.source = Okio.buffer((Source)((Source)new ForwardingSource(this, source2){
            private boolean closed;
            final /* synthetic */ MockWebServerSocket this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                if (this.closed) {
                    return;
                }
                try {
                    super.close();
                }
                finally {
                    MockWebServerSocket.access$getClosedLatch$p(this.this$0).countDown();
                }
            }
        }));
        source2 = this.delegate.getSink();
        this.sink = Okio.buffer((Sink)((Sink)new ForwardingSink(this, (Sink)source2){
            private boolean closed;
            final /* synthetic */ MockWebServerSocket this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                if (this.closed) {
                    return;
                }
                try {
                    super.close();
                }
                finally {
                    MockWebServerSocket.access$getClosedLatch$p(this.this$0).countDown();
                }
            }
        }));
    }

    @NotNull
    public final java.net.Socket getJavaNetSocket() {
        return this.javaNetSocket;
    }

    @NotNull
    public BufferedSource getSource() {
        return this.source;
    }

    @NotNull
    public BufferedSink getSink() {
        return this.sink;
    }

    @NotNull
    public final InetAddress getLocalAddress() {
        InetAddress inetAddress = this.javaNetSocket.getLocalAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getLocalAddress(...)");
        return inetAddress;
    }

    public final int getLocalPort() {
        return this.javaNetSocket.getLocalPort();
    }

    @NotNull
    public final String getScheme() {
        return this.javaNetSocket instanceof SSLSocket ? "https" : "http";
    }

    @Nullable
    public final Handshake getHandshake() {
        java.net.Socket socket = this.javaNetSocket;
        Object object = socket instanceof SSLSocket ? (SSLSocket)socket : null;
        return object != null && (object = ((SSLSocket)object).getSession()) != null ? Handshake.Companion.get((SSLSession)object) : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final List<String> getHandshakeServerNames() {
        Object object;
        SSLSocket sSLSocket;
        Object object2 = this.javaNetSocket;
        SSLSocket sSLSocket2 = sSLSocket = object2 instanceof SSLSocket ? (SSLSocket)object2 : null;
        if (sSLSocket != null) {
            SSLSocket it = sSLSocket;
            boolean bl = false;
            object2 = Platform.Companion.get().getHandshakeServerNames(it);
            if (object2 != null) {
                object = object2;
                return object;
            }
        }
        object = CollectionsKt.emptyList();
        return object;
    }

    public final void shutdownInput() {
        this.javaNetSocket.shutdownInput();
    }

    public final void shutdownOutput() {
        this.javaNetSocket.shutdownOutput();
    }

    public final void sleepWhileOpen(long nanos) {
        long ms;
        long ns = nanos - ms * 1000000L;
        for (ms = nanos / 1000000L; ms > 100L; ms -= 100L) {
            Thread.sleep(100L);
            if (!this.javaNetSocket.isClosed()) continue;
            throw new InterruptedIOException("socket closed");
        }
        if (ms > 0L || ns > 0L) {
            Thread.sleep(ms, (int)ns);
        }
    }

    public void cancel() {
        this.delegate.cancel();
    }

    @Override
    public void close() {
        this.javaNetSocket.close();
    }

    public final void awaitClosed() {
        this.closedLatch.await();
    }

    public static final /* synthetic */ CountDownLatch access$getClosedLatch$p(MockWebServerSocket $this) {
        return $this.closedLatch;
    }
}

