/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.widget.ScrollView;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.android.widget.AbstractFrameLayoutAssert;

public class ScrollViewAssert
extends AbstractFrameLayoutAssert<ScrollViewAssert, ScrollView> {
    public ScrollViewAssert(ScrollView actual) {
        super(actual, ScrollViewAssert.class);
    }

    public ScrollViewAssert hasMaxScrollAmount(int amount) {
        this.isNotNull();
        int actualAmount = ((ScrollView)this.actual).getMaxScrollAmount();
        ((IntegerAssert)Assertions.assertThat((int)actualAmount).overridingErrorMessage("Expected maximum scroll amount <%s> but was <%s>.", new Object[]{amount, actualAmount})).isEqualTo(amount);
        return this;
    }

    public ScrollViewAssert isFillingViewport() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ScrollView)this.actual).isFillViewport()).overridingErrorMessage("Expected to be filling viewport but was not.", new Object[0])).isTrue();
        return this;
    }

    public ScrollViewAssert isNotFillingViewport() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ScrollView)this.actual).isFillViewport()).overridingErrorMessage("Expected to not be filling viewport but was.", new Object[0])).isFalse();
        return this;
    }

    public ScrollViewAssert hasSmoothScrollEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ScrollView)this.actual).isSmoothScrollingEnabled()).overridingErrorMessage("Expected smooth scroll to be enabled but was disabled.", new Object[0])).isTrue();
        return this;
    }

    public ScrollViewAssert hasSmoothScrollDisabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ScrollView)this.actual).isSmoothScrollingEnabled()).overridingErrorMessage("Expected smooth scroll to be disabled but was enabled.", new Object[0])).isFalse();
        return this;
    }
}

