/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.graphics.drawable.Drawable;
import android.view.animation.Interpolator;
import android.widget.ProgressBar;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.view.AbstractViewAssert;

public abstract class AbstractProgressBarAssert<S extends AbstractProgressBarAssert<S, A>, A extends ProgressBar>
extends AbstractViewAssert<S, A> {
    protected AbstractProgressBarAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasIndeterminateDrawable(Drawable drawable) {
        this.isNotNull();
        Drawable actualDrawable = ((ProgressBar)this.actual).getIndeterminateDrawable();
        ((ObjectAssert)Assertions.assertThat((Object)actualDrawable).overridingErrorMessage("Expected indeterminate drawable <%s> but was <%s>.", new Object[]{drawable, actualDrawable})).isSameAs((Object)drawable);
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }

    public S hasInterpolator(Interpolator interpolator) {
        this.isNotNull();
        Interpolator actualInterpolator = ((ProgressBar)this.actual).getInterpolator();
        ((ObjectAssert)Assertions.assertThat((Object)actualInterpolator).overridingErrorMessage("Expected interpolator <%s> but was <%s>.", new Object[]{interpolator, actualInterpolator})).isSameAs((Object)interpolator);
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }

    public S hasMaximum(int maximum) {
        this.isNotNull();
        int actualMaximum = ((ProgressBar)this.actual).getMax();
        ((IntegerAssert)Assertions.assertThat((int)actualMaximum).overridingErrorMessage("Expected maximum <%s> but was <%s>.", new Object[]{maximum, actualMaximum})).isEqualTo(maximum);
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }

    public S hasProgress(int progress) {
        this.isNotNull();
        int actualProgress = ((ProgressBar)this.actual).getProgress();
        ((IntegerAssert)Assertions.assertThat((int)actualProgress).overridingErrorMessage("Expected progress <%s> but was <%s>.", new Object[]{progress, actualProgress})).isEqualTo(progress);
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }

    public S hasProgressDrawable(Drawable drawable) {
        this.isNotNull();
        Drawable actualDrawable = ((ProgressBar)this.actual).getProgressDrawable();
        ((ObjectAssert)Assertions.assertThat((Object)actualDrawable).overridingErrorMessage("Expected progress drawable <%s> but was <%s>.", new Object[]{drawable, actualDrawable})).isSameAs((Object)drawable);
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }

    public S hasSecondaryProgress(int progress) {
        this.isNotNull();
        int actualProgress = ((ProgressBar)this.actual).getSecondaryProgress();
        ((IntegerAssert)Assertions.assertThat((int)actualProgress).overridingErrorMessage("Expected secondary progress <%s> but was <%s>.", new Object[]{progress, actualProgress})).isEqualTo(progress);
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }

    public S isIndeterminate() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ProgressBar)this.actual).isIndeterminate()).overridingErrorMessage("Expected to be indeterminate but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }

    public S isNotIndeterminate() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((ProgressBar)this.actual).isIndeterminate()).overridingErrorMessage("Expected to not be indeterminate but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractProgressBarAssert)this.myself));
    }
}

