/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.graphics.drawable.Drawable;
import android.widget.ListView;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.widget.AbstractAbsListViewAssert;

public abstract class AbstractListViewAssert<S extends AbstractListViewAssert<S, A>, A extends ListView>
extends AbstractAbsListViewAssert<S, A> {
    protected AbstractListViewAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasDivider(Drawable divider) {
        this.isNotNull();
        Drawable actualDivider = ((ListView)this.actual).getDivider();
        ((ObjectAssert)Assertions.assertThat((Object)actualDivider).overridingErrorMessage("Expected divider <%s> but was <%s>.", new Object[]{divider, actualDivider})).isSameAs((Object)divider);
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }

    public S hasDividerHeight(int height) {
        this.isNotNull();
        int actualHeight = ((ListView)this.actual).getDividerHeight();
        ((IntegerAssert)Assertions.assertThat((int)actualHeight).overridingErrorMessage("Expected divider height <%s> but was <%s>.", new Object[]{height, actualHeight})).isEqualTo(height);
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }

    public S hasFooterViewsCount(int count) {
        this.isNotNull();
        int actualCount = ((ListView)this.actual).getFooterViewsCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected footer views count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }

    public S hasHeaderViewsCount(int count) {
        this.isNotNull();
        int actualCount = ((ListView)this.actual).getHeaderViewsCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected header views count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }

    public S hasOverscrollFooter(Drawable footer) {
        this.isNotNull();
        Drawable actualFooter = ((ListView)this.actual).getOverscrollFooter();
        ((ObjectAssert)Assertions.assertThat((Object)actualFooter).overridingErrorMessage("Expected overscroll footer <%s> but was <%s>.", new Object[]{footer, actualFooter})).isSameAs((Object)footer);
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }

    public S hasOverscrollHeader(Drawable header) {
        this.isNotNull();
        Drawable actualHeader = ((ListView)this.actual).getOverscrollHeader();
        ((ObjectAssert)Assertions.assertThat((Object)actualHeader).overridingErrorMessage("Expected overscroll header <%s> but was <%s>.", new Object[]{header, actualHeader})).isSameAs((Object)header);
        return (S)((Object)((AbstractListViewAssert)this.myself));
    }
}

