/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.widget;

import android.graphics.drawable.Drawable;
import android.widget.FrameLayout;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;
import org.fest.assertions.api.android.view.AbstractViewGroupAssert;

public abstract class AbstractFrameLayoutAssert<S extends AbstractFrameLayoutAssert<S, A>, A extends FrameLayout>
extends AbstractViewGroupAssert<S, A> {
    protected AbstractFrameLayoutAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasForeground(Drawable drawable) {
        this.isNotNull();
        Drawable actualDrawable = ((FrameLayout)this.actual).getForeground();
        ((ObjectAssert)Assertions.assertThat((Object)actualDrawable).overridingErrorMessage("Expected foreground drawable <%s> but was <%s>", new Object[]{drawable, actualDrawable})).isSameAs((Object)drawable);
        return (S)((Object)((AbstractFrameLayoutAssert)this.myself));
    }

    public S hasForegroundGravity(int gravity) {
        this.isNotNull();
        int actualGravity = ((FrameLayout)this.actual).getForegroundGravity();
        ((IntegerAssert)Assertions.assertThat((int)actualGravity).overridingErrorMessage("Expected foreground gravity <%s> but was <%s>.", new Object[]{gravity, actualGravity})).isEqualTo(gravity);
        return (S)((Object)((AbstractFrameLayoutAssert)this.myself));
    }

    public S isMeasuringAllChildren() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((FrameLayout)this.actual).getMeasureAllChildren()).overridingErrorMessage("Expected to be measuring all children but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractFrameLayoutAssert)this.myself));
    }

    public S isNotMeasuringAllChildren() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((FrameLayout)this.actual).getMeasureAllChildren()).overridingErrorMessage("Expected to not be measuring all children but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractFrameLayoutAssert)this.myself));
    }

    public S isDelayingChildPressedState() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((FrameLayout)this.actual).shouldDelayChildPressedState()).overridingErrorMessage("Epxected to be delaying child pressed state but was not.", new Object[0])).isTrue();
        return (S)((Object)((AbstractFrameLayoutAssert)this.myself));
    }

    public S isNotDelayingChildPressedState() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((FrameLayout)this.actual).shouldDelayChildPressedState()).overridingErrorMessage("Expected to not be delaying child pressed state but was.", new Object[0])).isFalse();
        return (S)((Object)((AbstractFrameLayoutAssert)this.myself));
    }
}

