/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view.animation;

import android.graphics.Matrix;
import android.view.animation.Transformation;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.FloatAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ObjectAssert;

public class TransformationAssert
extends AbstractAssert<TransformationAssert, Transformation> {
    public TransformationAssert(Transformation actual) {
        super((Object)actual, TransformationAssert.class);
    }

    public TransformationAssert hasAlpha(float alpha) {
        this.isNotNull();
        float actualAlpha = ((Transformation)this.actual).getAlpha();
        ((FloatAssert)Assertions.assertThat((float)actualAlpha).overridingErrorMessage("Expected alpha <%s> but was <%s>.", new Object[]{Float.valueOf(alpha), Float.valueOf(actualAlpha)})).isEqualTo(alpha);
        return this;
    }

    public TransformationAssert hasMatrix(Matrix matrix) {
        this.isNotNull();
        Matrix actualMatrix = ((Transformation)this.actual).getMatrix();
        ((ObjectAssert)Assertions.assertThat((Object)actualMatrix).overridingErrorMessage("Expected matrix <%s> but was <%s>.", new Object[]{matrix, actualMatrix})).isEqualTo((Object)matrix);
        return this;
    }

    public TransformationAssert hasTransformationType(int type) {
        this.isNotNull();
        int actualType = ((Transformation)this.actual).getTransformationType();
        ((IntegerAssert)Assertions.assertThat((int)actualType).overridingErrorMessage("Expected transformation type <%s> but was <%s>.", new Object[]{TransformationAssert.transformationTypeToString(type), TransformationAssert.transformationTypeToString(actualType)})).isEqualTo(type);
        return this;
    }

    private static String transformationTypeToString(int type) {
        if (type == Transformation.TYPE_ALPHA) {
            return "alpha";
        }
        if (type == Transformation.TYPE_BOTH) {
            return "both";
        }
        if (type == Transformation.TYPE_IDENTITY) {
            return "identity";
        }
        if (type == Transformation.TYPE_MATRIX) {
            return "matrix";
        }
        throw new IllegalArgumentException("Unknown transformation type: " + type);
    }
}

