/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api.android.view.accessibility;

import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityRecord;
import java.util.List;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.BooleanAssert;
import org.fest.assertions.api.IntegerAssert;
import org.fest.assertions.api.ListAssert;
import org.fest.assertions.api.ObjectAssert;

public abstract class AbstractAccessibilityRecordAssert<S extends AbstractAccessibilityRecordAssert<S, A>, A extends AccessibilityRecord>
extends AbstractAssert<S, A> {
    protected AbstractAccessibilityRecordAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public AbstractAccessibilityRecordAssert hasAddedCount(int count) {
        this.isNotNull();
        int actualCount = ((AccessibilityRecord)this.actual).getAddedCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected added count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasBeforeText(CharSequence text) {
        this.isNotNull();
        CharSequence actualText = ((AccessibilityRecord)this.actual).getBeforeText();
        ((ObjectAssert)Assertions.assertThat((Object)actualText).overridingErrorMessage("Expected before text <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo((Object)text);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasClassName(CharSequence name) {
        this.isNotNull();
        CharSequence actualName = ((AccessibilityRecord)this.actual).getClassName();
        ((ObjectAssert)Assertions.assertThat((Object)actualName).overridingErrorMessage("Expected class name <%s> but was <%s>.", new Object[]{name, actualName})).isEqualTo((Object)name);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasContentDescription(CharSequence description) {
        this.isNotNull();
        CharSequence actualDescription = ((AccessibilityRecord)this.actual).getContentDescription();
        ((ObjectAssert)Assertions.assertThat((Object)actualDescription).overridingErrorMessage("Expected content description <%s> but was <%s>.", new Object[]{description, actualDescription})).isEqualTo((Object)description);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasCurrentItemIndex(int index) {
        this.isNotNull();
        int actualIndex = ((AccessibilityRecord)this.actual).getCurrentItemIndex();
        ((IntegerAssert)Assertions.assertThat((int)actualIndex).overridingErrorMessage("Expected current item index <%s> but was <%s>.", new Object[]{index, actualIndex})).isEqualTo(index);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasFromIndex(int index) {
        this.isNotNull();
        int actualIndex = ((AccessibilityRecord)this.actual).getFromIndex();
        ((IntegerAssert)Assertions.assertThat((int)actualIndex).overridingErrorMessage("Expected from index <%s> but was <%s>.", new Object[]{index, actualIndex})).isEqualTo(index);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasItemCount(int count) {
        this.isNotNull();
        int actualCount = ((AccessibilityRecord)this.actual).getItemCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected item count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasMaximumScrollX(int scroll) {
        this.isNotNull();
        int actualScroll = ((AccessibilityRecord)this.actual).getMaxScrollX();
        ((IntegerAssert)Assertions.assertThat((int)actualScroll).overridingErrorMessage("Expected maximum X scroll <%s> but was <%s>.", new Object[]{scroll, actualScroll})).isEqualTo(scroll);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasMaximumScrollY(int scroll) {
        this.isNotNull();
        int actualScroll = ((AccessibilityRecord)this.actual).getMaxScrollY();
        ((IntegerAssert)Assertions.assertThat((int)actualScroll).overridingErrorMessage("Expected maximum Y scroll <%s> but was <%s>.", new Object[]{scroll, actualScroll})).isEqualTo(scroll);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasRemovedCount(int count) {
        this.isNotNull();
        int actualCount = ((AccessibilityRecord)this.actual).getRemovedCount();
        ((IntegerAssert)Assertions.assertThat((int)actualCount).overridingErrorMessage("Expected remove count <%s> but was <%s>.", new Object[]{count, actualCount})).isEqualTo(count);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasScrollX(int scroll) {
        this.isNotNull();
        int actualScroll = ((AccessibilityRecord)this.actual).getScrollX();
        ((IntegerAssert)Assertions.assertThat((int)actualScroll).overridingErrorMessage("Expected X scroll <%s> but was <%s>.", new Object[]{scroll, actualScroll})).isEqualTo(scroll);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasScrollY(int scroll) {
        this.isNotNull();
        int actualScroll = ((AccessibilityRecord)this.actual).getScrollY();
        ((IntegerAssert)Assertions.assertThat((int)actualScroll).overridingErrorMessage("Expected maximum Y scroll <%s> but was <%s>.", new Object[]{scroll, actualScroll})).isEqualTo(scroll);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasSource(AccessibilityNodeInfo info) {
        this.isNotNull();
        AccessibilityNodeInfo actualInfo = ((AccessibilityRecord)this.actual).getSource();
        ((ObjectAssert)Assertions.assertThat((Object)actualInfo).overridingErrorMessage("Expected source <%s> but was <%s>.", new Object[]{info, actualInfo})).isSameAs((Object)info);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasText(List<CharSequence> text) {
        this.isNotNull();
        List actualText = ((AccessibilityRecord)this.actual).getText();
        ((ListAssert)Assertions.assertThat((List)actualText).overridingErrorMessage("Expected text <%s> but was <%s>.", new Object[]{text, actualText})).isEqualTo(text);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasToIndex(int index) {
        this.isNotNull();
        int actualIndex = ((AccessibilityRecord)this.actual).getToIndex();
        ((IntegerAssert)Assertions.assertThat((int)actualIndex).overridingErrorMessage("Expected to index <%s> but was <%s>.", new Object[]{index, actualIndex})).isEqualTo(index);
        return this;
    }

    public AbstractAccessibilityRecordAssert hasWindowId(int id) {
        this.isNotNull();
        int actualId = ((AccessibilityRecord)this.actual).getWindowId();
        ((IntegerAssert)Assertions.assertThat((int)actualId).overridingErrorMessage("Expected window ID <%s> but was <%s>.", new Object[]{id, actualId})).isEqualTo(id);
        return this;
    }

    public AbstractAccessibilityRecordAssert isChecked() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isChecked()).overridingErrorMessage("Expected to be checked but was not.", new Object[0])).isTrue();
        return this;
    }

    public AbstractAccessibilityRecordAssert isNotChecked() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isChecked()).overridingErrorMessage("Expected to not be checked but was.", new Object[0])).isFalse();
        return this;
    }

    public AbstractAccessibilityRecordAssert isEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isEnabled()).overridingErrorMessage("Expected to be enabled but was not.", new Object[0])).isTrue();
        return this;
    }

    public AbstractAccessibilityRecordAssert isNotEnabled() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isEnabled()).overridingErrorMessage("Expected to not be enabled but was.", new Object[0])).isFalse();
        return this;
    }

    public AbstractAccessibilityRecordAssert isFullScreen() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isFullScreen()).overridingErrorMessage("Expected to be full screen but was not.", new Object[0])).isTrue();
        return this;
    }

    public AbstractAccessibilityRecordAssert isNotFullScreen() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isFullScreen()).overridingErrorMessage("Expected to not be full screen but was.", new Object[0])).isFalse();
        return this;
    }

    public AbstractAccessibilityRecordAssert isPassword() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isPassword()).overridingErrorMessage("Expected to be password but was not.", new Object[0])).isTrue();
        return this;
    }

    public AbstractAccessibilityRecordAssert isNotPassword() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isPassword()).overridingErrorMessage("Expected to not be password but was.", new Object[0])).isFalse();
        return this;
    }

    public AbstractAccessibilityRecordAssert isScrollable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isScrollable()).overridingErrorMessage("Expected to be scrollable but was not.", new Object[0])).isTrue();
        return this;
    }

    public AbstractAccessibilityRecordAssert isNotScrollable() {
        this.isNotNull();
        ((BooleanAssert)Assertions.assertThat((boolean)((AccessibilityRecord)this.actual).isScrollable()).overridingErrorMessage("Expected to not be scrollable but was.", new Object[0])).isFalse();
        return this;
    }
}

